/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Mat33;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.Vec3;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.pooling.IWorldPool;

public class RevoluteJoint
extends Joint {
    protected final Vec2 m_localAnchorA = new Vec2();
    protected final Vec2 m_localAnchorB = new Vec2();
    private final Vec3 m_impulse = new Vec3();
    private float m_motorImpulse;
    private boolean m_enableMotor;
    private float m_maxMotorTorque;
    private float m_motorSpeed;
    private boolean m_enableLimit;
    protected float m_referenceAngle;
    private float m_lowerAngle;
    private float m_upperAngle;
    private int m_indexA;
    private int m_indexB;
    private final Vec2 m_rA = new Vec2();
    private final Vec2 m_rB = new Vec2();
    private final Vec2 m_localCenterA = new Vec2();
    private final Vec2 m_localCenterB = new Vec2();
    private float m_invMassA;
    private float m_invMassB;
    private float m_invIA;
    private float m_invIB;
    private final Mat33 m_mass = new Mat33();
    private float m_motorMass;
    private LimitState m_limitState;

    protected RevoluteJoint(IWorldPool iWorldPool, RevoluteJointDef revoluteJointDef) {
        super(iWorldPool, revoluteJointDef);
        this.m_localAnchorA.set(revoluteJointDef.localAnchorA);
        this.m_localAnchorB.set(revoluteJointDef.localAnchorB);
        this.m_referenceAngle = revoluteJointDef.referenceAngle;
        this.m_motorImpulse = 0.0f;
        this.m_lowerAngle = revoluteJointDef.lowerAngle;
        this.m_upperAngle = revoluteJointDef.upperAngle;
        this.m_maxMotorTorque = revoluteJointDef.maxMotorTorque;
        this.m_motorSpeed = revoluteJointDef.motorSpeed;
        this.m_enableLimit = revoluteJointDef.enableLimit;
        this.m_enableMotor = revoluteJointDef.enableMotor;
        this.m_limitState = LimitState.INACTIVE;
    }

    @Override
    public void initVelocityConstraints(SolverData solverData) {
        this.m_indexA = this.m_bodyA.m_islandIndex;
        this.m_indexB = this.m_bodyB.m_islandIndex;
        this.m_localCenterA.set(this.m_bodyA.m_sweep.localCenter);
        this.m_localCenterB.set(this.m_bodyB.m_sweep.localCenter);
        this.m_invMassA = this.m_bodyA.m_invMass;
        this.m_invMassB = this.m_bodyB.m_invMass;
        this.m_invIA = this.m_bodyA.m_invI;
        this.m_invIB = this.m_bodyB.m_invI;
        float f = solverData.positions[this.m_indexA].a;
        Vec2 vec2 = solverData.velocities[this.m_indexA].v;
        float f2 = solverData.velocities[this.m_indexA].w;
        float f3 = solverData.positions[this.m_indexB].a;
        Vec2 vec22 = solverData.velocities[this.m_indexB].v;
        float f4 = solverData.velocities[this.m_indexB].w;
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Vec2 vec23 = this.pool.popVec2();
        rot.set(f);
        rot2.set(f3);
        Rot.mulToOutUnsafe(rot, vec23.set(this.m_localAnchorA).subLocal(this.m_localCenterA), this.m_rA);
        Rot.mulToOutUnsafe(rot2, vec23.set(this.m_localAnchorB).subLocal(this.m_localCenterB), this.m_rB);
        float f5 = this.m_invMassA;
        float f6 = this.m_invMassB;
        float f7 = this.m_invIA;
        float f8 = this.m_invIB;
        boolean bl = f7 + f8 == 0.0f;
        this.m_mass.ex.x = f5 + f6 + this.m_rA.y * this.m_rA.y * f7 + this.m_rB.y * this.m_rB.y * f8;
        this.m_mass.ey.x = -this.m_rA.y * this.m_rA.x * f7 - this.m_rB.y * this.m_rB.x * f8;
        this.m_mass.ez.x = -this.m_rA.y * f7 - this.m_rB.y * f8;
        this.m_mass.ex.y = this.m_mass.ey.x;
        this.m_mass.ey.y = f5 + f6 + this.m_rA.x * this.m_rA.x * f7 + this.m_rB.x * this.m_rB.x * f8;
        this.m_mass.ez.y = this.m_rA.x * f7 + this.m_rB.x * f8;
        this.m_mass.ex.z = this.m_mass.ez.x;
        this.m_mass.ey.z = this.m_mass.ez.y;
        this.m_mass.ez.z = f7 + f8;
        this.m_motorMass = f7 + f8;
        if (this.m_motorMass > 0.0f) {
            this.m_motorMass = 1.0f / this.m_motorMass;
        }
        if (!this.m_enableMotor || bl) {
            this.m_motorImpulse = 0.0f;
        }
        if (this.m_enableLimit && !bl) {
            float f9 = f3 - f - this.m_referenceAngle;
            if (MathUtils.abs(this.m_upperAngle - this.m_lowerAngle) < 2.0f * Settings.angularSlop) {
                this.m_limitState = LimitState.EQUAL;
            } else if (f9 <= this.m_lowerAngle) {
                if (this.m_limitState != LimitState.AT_LOWER) {
                    this.m_impulse.z = 0.0f;
                }
                this.m_limitState = LimitState.AT_LOWER;
            } else if (f9 >= this.m_upperAngle) {
                if (this.m_limitState != LimitState.AT_UPPER) {
                    this.m_impulse.z = 0.0f;
                }
                this.m_limitState = LimitState.AT_UPPER;
            } else {
                this.m_limitState = LimitState.INACTIVE;
                this.m_impulse.z = 0.0f;
            }
        } else {
            this.m_limitState = LimitState.INACTIVE;
        }
        if (solverData.step.warmStarting) {
            Vec2 vec24 = this.pool.popVec2();
            this.m_impulse.x *= solverData.step.dtRatio;
            this.m_impulse.y *= solverData.step.dtRatio;
            this.m_motorImpulse *= solverData.step.dtRatio;
            vec24.x = this.m_impulse.x;
            vec24.y = this.m_impulse.y;
            vec2.x -= f5 * vec24.x;
            vec2.y -= f5 * vec24.y;
            f2 -= f7 * (Vec2.cross(this.m_rA, vec24) + this.m_motorImpulse + this.m_impulse.z);
            vec22.x += f6 * vec24.x;
            vec22.y += f6 * vec24.y;
            f4 += f8 * (Vec2.cross(this.m_rB, vec24) + this.m_motorImpulse + this.m_impulse.z);
            this.pool.pushVec2(1);
        } else {
            this.m_impulse.setZero();
            this.m_motorImpulse = 0.0f;
        }
        solverData.velocities[this.m_indexA].w = f2;
        solverData.velocities[this.m_indexB].w = f4;
        this.pool.pushVec2(1);
        this.pool.pushRot(2);
    }

    @Override
    public void solveVelocityConstraints(SolverData solverData) {
        float f;
        boolean bl;
        Vec2 vec2 = solverData.velocities[this.m_indexA].v;
        float f2 = solverData.velocities[this.m_indexA].w;
        Vec2 vec22 = solverData.velocities[this.m_indexB].v;
        float f3 = solverData.velocities[this.m_indexB].w;
        float f4 = this.m_invMassA;
        float f5 = this.m_invMassB;
        float f6 = this.m_invIA;
        float f7 = this.m_invIB;
        boolean bl2 = bl = f6 + f7 == 0.0f;
        if (this.m_enableMotor && this.m_limitState != LimitState.EQUAL && !bl) {
            float f8 = f3 - f2 - this.m_motorSpeed;
            float f9 = -this.m_motorMass * f8;
            float f10 = this.m_motorImpulse;
            f = solverData.step.dt * this.m_maxMotorTorque;
            this.m_motorImpulse = MathUtils.clamp(this.m_motorImpulse + f9, -f, f);
            f9 = this.m_motorImpulse - f10;
            f2 -= f6 * f9;
            f3 += f7 * f9;
        }
        Vec2 vec23 = this.pool.popVec2();
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE && !bl) {
            Vec2 vec24 = this.pool.popVec2();
            Vec3 vec3 = this.pool.popVec3();
            Vec2.crossToOutUnsafe(f2, this.m_rA, vec23);
            Vec2.crossToOutUnsafe(f3, this.m_rB, vec24);
            vec24.addLocal(vec22).subLocal(vec2).subLocal(vec23);
            f = f3 - f2;
            vec3.set(vec24.x, vec24.y, f);
            Vec3 vec32 = this.pool.popVec3();
            this.m_mass.solve33ToOut(vec3, vec32);
            vec32.negateLocal();
            if (this.m_limitState == LimitState.EQUAL) {
                this.m_impulse.addLocal(vec32);
            } else if (this.m_limitState == LimitState.AT_LOWER) {
                var16_21 = this.m_impulse.z + vec32.z;
                if (var16_21 < 0.0f) {
                    Vec2 vec25 = this.pool.popVec2();
                    vec25.set(this.m_mass.ez.x, this.m_mass.ez.y).mulLocal(this.m_impulse.z).subLocal(vec24);
                    this.m_mass.solve22ToOut(vec25, vec23);
                    vec32.x = vec23.x;
                    vec32.y = vec23.y;
                    vec32.z = -this.m_impulse.z;
                    this.m_impulse.x += vec23.x;
                    this.m_impulse.y += vec23.y;
                    this.m_impulse.z = 0.0f;
                    this.pool.pushVec2(1);
                } else {
                    this.m_impulse.addLocal(vec32);
                }
            } else if (this.m_limitState == LimitState.AT_UPPER) {
                var16_21 = this.m_impulse.z + vec32.z;
                if (var16_21 > 0.0f) {
                    Vec2 vec26 = this.pool.popVec2();
                    vec26.set(this.m_mass.ez.x, this.m_mass.ez.y).mulLocal(this.m_impulse.z).subLocal(vec24);
                    this.m_mass.solve22ToOut(vec26, vec23);
                    vec32.x = vec23.x;
                    vec32.y = vec23.y;
                    vec32.z = -this.m_impulse.z;
                    this.m_impulse.x += vec23.x;
                    this.m_impulse.y += vec23.y;
                    this.m_impulse.z = 0.0f;
                    this.pool.pushVec2(1);
                } else {
                    this.m_impulse.addLocal(vec32);
                }
            }
            Vec2 vec27 = this.pool.popVec2();
            vec27.set(vec32.x, vec32.y);
            vec2.x -= f4 * vec27.x;
            vec2.y -= f4 * vec27.y;
            f2 -= f6 * (Vec2.cross(this.m_rA, vec27) + vec32.z);
            vec22.x += f5 * vec27.x;
            vec22.y += f5 * vec27.y;
            f3 += f7 * (Vec2.cross(this.m_rB, vec27) + vec32.z);
            this.pool.pushVec2(2);
            this.pool.pushVec3(2);
        } else {
            Vec2 vec28 = this.pool.popVec2();
            Vec2 vec29 = this.pool.popVec2();
            Vec2.crossToOutUnsafe(f2, this.m_rA, vec23);
            Vec2.crossToOutUnsafe(f3, this.m_rB, vec28);
            vec28.addLocal(vec22).subLocal(vec2).subLocal(vec23);
            this.m_mass.solve22ToOut(vec28.negateLocal(), vec29);
            this.m_impulse.x += vec29.x;
            this.m_impulse.y += vec29.y;
            vec2.x -= f4 * vec29.x;
            vec2.y -= f4 * vec29.y;
            f2 -= f6 * Vec2.cross(this.m_rA, vec29);
            vec22.x += f5 * vec29.x;
            vec22.y += f5 * vec29.y;
            f3 += f7 * Vec2.cross(this.m_rB, vec29);
            this.pool.pushVec2(2);
        }
        solverData.velocities[this.m_indexA].w = f2;
        solverData.velocities[this.m_indexB].w = f3;
        this.pool.pushVec2(1);
    }

    @Override
    public boolean solvePositionConstraints(SolverData solverData) {
        boolean bl;
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Vec2 vec2 = solverData.positions[this.m_indexA].c;
        float f = solverData.positions[this.m_indexA].a;
        Vec2 vec22 = solverData.positions[this.m_indexB].c;
        float f2 = solverData.positions[this.m_indexB].a;
        rot.set(f);
        rot2.set(f2);
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl2 = bl = this.m_invIA + this.m_invIB == 0.0f;
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE && !bl) {
            float f5 = f2 - f - this.m_referenceAngle;
            float f6 = 0.0f;
            if (this.m_limitState == LimitState.EQUAL) {
                var13_15 = MathUtils.clamp(f5 - this.m_lowerAngle, -Settings.maxAngularCorrection, Settings.maxAngularCorrection);
                f6 = -this.m_motorMass * var13_15;
                f3 = MathUtils.abs(var13_15);
            } else if (this.m_limitState == LimitState.AT_LOWER) {
                var13_15 = f5 - this.m_lowerAngle;
                f3 = -var13_15;
                var13_15 = MathUtils.clamp(var13_15 + Settings.angularSlop, -Settings.maxAngularCorrection, 0.0f);
                f6 = -this.m_motorMass * var13_15;
            } else if (this.m_limitState == LimitState.AT_UPPER) {
                f3 = var13_15 = f5 - this.m_upperAngle;
                var13_15 = MathUtils.clamp(var13_15 - Settings.angularSlop, 0.0f, Settings.maxAngularCorrection);
                f6 = -this.m_motorMass * var13_15;
            }
            f -= this.m_invIA * f6;
            f2 += this.m_invIB * f6;
        }
        rot.set(f);
        rot2.set(f2);
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2 vec25 = this.pool.popVec2();
        Vec2 vec26 = this.pool.popVec2();
        Rot.mulToOutUnsafe(rot, vec25.set(this.m_localAnchorA).subLocal(this.m_localCenterA), vec23);
        Rot.mulToOutUnsafe(rot2, vec25.set(this.m_localAnchorB).subLocal(this.m_localCenterB), vec24);
        vec25.set(vec22).addLocal(vec24).subLocal(vec2).subLocal(vec23);
        f4 = vec25.length();
        float f7 = this.m_invMassA;
        float f8 = this.m_invMassB;
        float f9 = this.m_invIA;
        float f10 = this.m_invIB;
        Mat22 mat22 = this.pool.popMat22();
        mat22.ex.x = f7 + f8 + f9 * vec23.y * vec23.y + f10 * vec24.y * vec24.y;
        mat22.ey.x = mat22.ex.y = -f9 * vec23.x * vec23.y - f10 * vec24.x * vec24.y;
        mat22.ey.y = f7 + f8 + f9 * vec23.x * vec23.x + f10 * vec24.x * vec24.x;
        mat22.solveToOut(vec25, vec26);
        vec26.negateLocal();
        vec2.x -= f7 * vec26.x;
        vec2.y -= f7 * vec26.y;
        vec22.x += f8 * vec26.x;
        vec22.y += f8 * vec26.y;
        this.pool.pushVec2(4);
        this.pool.pushMat22(1);
        solverData.positions[this.m_indexA].a = f -= f9 * Vec2.cross(vec23, vec26);
        solverData.positions[this.m_indexB].a = f2 += f10 * Vec2.cross(vec24, vec26);
        this.pool.pushRot(2);
        return f4 <= Settings.linearSlop && f3 <= Settings.angularSlop;
    }

    public Vec2 getLocalAnchorA() {
        return this.m_localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.m_localAnchorB;
    }

    public float getReferenceAngle() {
        return this.m_referenceAngle;
    }

    @Override
    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, vec2);
    }

    @Override
    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, vec2);
    }

    @Override
    public void getReactionForce(float f, Vec2 vec2) {
        vec2.set(this.m_impulse.x, this.m_impulse.y).mulLocal(f);
    }

    @Override
    public float getReactionTorque(float f) {
        return f * this.m_impulse.z;
    }

    public float getJointAngle() {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        return body2.m_sweep.a - body.m_sweep.a - this.m_referenceAngle;
    }

    public float getJointSpeed() {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        return body2.m_angularVelocity - body.m_angularVelocity;
    }

    public boolean isMotorEnabled() {
        return this.m_enableMotor;
    }

    public void enableMotor(boolean bl) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableMotor = bl;
    }

    public float getMotorTorque(float f) {
        return this.m_motorImpulse * f;
    }

    public void setMotorSpeed(float f) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_motorSpeed = f;
    }

    public void setMaxMotorTorque(float f) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_maxMotorTorque = f;
    }

    public float getMotorSpeed() {
        return this.m_motorSpeed;
    }

    public float getMaxMotorTorque() {
        return this.m_maxMotorTorque;
    }

    public boolean isLimitEnabled() {
        return this.m_enableLimit;
    }

    public void enableLimit(boolean bl) {
        if (bl != this.m_enableLimit) {
            this.m_bodyA.setAwake(true);
            this.m_bodyB.setAwake(true);
            this.m_enableLimit = bl;
            this.m_impulse.z = 0.0f;
        }
    }

    public float getLowerLimit() {
        return this.m_lowerAngle;
    }

    public float getUpperLimit() {
        return this.m_upperAngle;
    }

    public void setLimits(float f, float f2) {
        assert (f <= f2);
        if (f != this.m_lowerAngle || f2 != this.m_upperAngle) {
            this.m_bodyA.setAwake(true);
            this.m_bodyB.setAwake(true);
            this.m_impulse.z = 0.0f;
            this.m_lowerAngle = f;
            this.m_upperAngle = f2;
        }
    }
}

