/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.pooling.normal;

import org.jbox2d.pooling.IDynamicStack;

public abstract class MutableStack<E>
implements IDynamicStack<E> {
    private E[] stack = null;
    private int index = 0;
    private int size;

    public MutableStack(int n) {
        this.extendStack(n);
    }

    private void extendStack(int n) {
        E[] EArray = this.newArray(n);
        if (this.stack != null) {
            System.arraycopy(this.stack, 0, EArray, 0, this.size);
        }
        int n2 = 0;
        while (n2 < EArray.length) {
            EArray[n2] = this.newInstance();
            ++n2;
        }
        this.stack = EArray;
        this.size = EArray.length;
    }

    @Override
    public final E pop() {
        if (this.index >= this.size) {
            this.extendStack(this.size * 2);
        }
        return this.stack[this.index++];
    }

    @Override
    public final void push(E e) {
        assert (this.index > 0);
        this.stack[--this.index] = e;
    }

    protected abstract E newInstance();

    protected abstract E[] newArray(int var1);
}

