/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.collision.shapes.ByteBufferVertexData;
import com.bulletphysics.collision.shapes.IndexedMesh;
import com.bulletphysics.collision.shapes.ScalarType;
import com.bulletphysics.collision.shapes.StridingMeshInterface;
import com.bulletphysics.collision.shapes.VertexData;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class TriangleIndexVertexArray
extends StridingMeshInterface {
    protected ArrayList<IndexedMesh> indexedMeshes = new ArrayList();
    private ByteBufferVertexData data = new ByteBufferVertexData();

    public TriangleIndexVertexArray() {
    }

    public TriangleIndexVertexArray(int n, ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4) {
        IndexedMesh indexedMesh = new IndexedMesh();
        indexedMesh.numTriangles = n;
        indexedMesh.triangleIndexBase = byteBuffer;
        indexedMesh.triangleIndexStride = n2;
        indexedMesh.numVertices = n3;
        indexedMesh.vertexBase = byteBuffer2;
        indexedMesh.vertexStride = n4;
        this.addIndexedMesh(indexedMesh);
    }

    public void addIndexedMesh(IndexedMesh indexedMesh) {
        this.addIndexedMesh(indexedMesh, ScalarType.INTEGER);
    }

    public void addIndexedMesh(IndexedMesh indexedMesh, ScalarType scalarType) {
        this.indexedMeshes.add(indexedMesh);
        this.indexedMeshes.get((int)(this.indexedMeshes.size() - 1)).indexType = scalarType;
    }

    @Override
    public VertexData getLockedVertexIndexBase(int n) {
        assert (n < this.getNumSubParts());
        IndexedMesh indexedMesh = this.indexedMeshes.get(n);
        this.data.vertexCount = indexedMesh.numVertices;
        this.data.vertexData = indexedMesh.vertexBase;
        this.data.vertexType = ScalarType.FLOAT;
        this.data.vertexStride = indexedMesh.vertexStride;
        this.data.indexCount = indexedMesh.numTriangles * 3;
        this.data.indexData = indexedMesh.triangleIndexBase;
        this.data.indexStride = indexedMesh.triangleIndexStride / 3;
        this.data.indexType = indexedMesh.indexType;
        return this.data;
    }

    @Override
    public VertexData getLockedReadOnlyVertexIndexBase(int n) {
        return this.getLockedVertexIndexBase(n);
    }

    @Override
    public void unLockVertexBase(int n) {
        this.data.vertexData = null;
        this.data.indexData = null;
    }

    @Override
    public void unLockReadOnlyVertexBase(int n) {
        this.unLockVertexBase(n);
    }

    @Override
    public int getNumSubParts() {
        return this.indexedMeshes.size();
    }

    public ArrayList<IndexedMesh> getIndexedMeshArray() {
        return this.indexedMeshes;
    }

    @Override
    public void preallocateVertices(int n) {
    }

    @Override
    public void preallocateIndices(int n) {
    }
}

