/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.native_version;

import com.jme3.bullet.collision.shapes.Box2dShape;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.ConeCollisionShape;
import com.jme3.bullet.collision.shapes.CylinderCollisionShape;
import com.jme3.bullet.collision.shapes.HeightfieldCollisionShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.collision.shapes.SimplexCollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.math.Vector3f;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.util.matrix.IField;
import gama.extension.physics.common.IShapeConverter;
import gama.extension.physics.native_version.INativeBulletPhysicalEntity;
import java.util.EnumSet;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;

public class NativeBulletShapeConverter
implements IShapeConverter<CollisionShape, Vector3f>,
INativeBulletPhysicalEntity {
    EnumSet<IShape.Type> SPHERES = EnumSet.of(IShape.Type.SPHERE, IShape.Type.POINT, IShape.Type.CIRCLE, IShape.Type.LINECYLINDER);

    @Override
    public void computeTranslation(IAgent iAgent, IShape.Type type, float f, Vector3f vector3f, Vector3f vector3f2) {
        if (type == IShape.Type.LINECYLINDER) {
            vector3f.set(0.0f, 0.0f, 0.0f);
            vector3f2.set(0.0f, 0.0f, -f);
        } else if (this.SPHERES.contains(type)) {
            vector3f.set(0.0f, 0.0f, f);
            vector3f2.set(0.0f, 0.0f, -f);
        } else {
            vector3f.set(0.0f, 0.0f, f / 2.0f);
            vector3f2.set(0.0f, 0.0f, -f / 2.0f);
        }
    }

    @Override
    public CollisionShape convertShape(IShape iShape, IShape.Type type, float f) {
        switch (type) {
            case BOX: 
            case SQUARE: 
            case PLAN: {
                if (f == 0.0f) {
                    return new Box2dShape(iShape.getWidth().floatValue() / 2.0f, iShape.getHeight().floatValue() / 2.0f);
                }
                return new BoxCollisionShape(new Vector3f(iShape.getWidth().floatValue() / 2.0f, iShape.getHeight().floatValue() / 2.0f, f / 2.0f));
            }
            case CONE: {
                return new ConeCollisionShape(iShape.getWidth().floatValue() / 2.0f, f, 2);
            }
            case LINECYLINDER: {
                LineString lineString = (LineString)iShape.getInnerGeometry();
                LineSegment lineSegment = new LineSegment(lineString.getCoordinateN(0), lineString.getCoordinateN(1));
                if (lineSegment.isVertical()) {
                    return new CylinderCollisionShape(new Vector3f(f, (float)lineSegment.getLength() / 2.0f, f), 1);
                }
                return new CylinderCollisionShape(new Vector3f((float)lineSegment.getLength() / 2.0f, f, f), 0);
            }
            case CYLINDER: {
                return new CylinderCollisionShape(new Vector3f(iShape.getWidth().floatValue(), iShape.getHeight().floatValue(), f / 2.0f), 2);
            }
            case PYRAMID: {
                break;
            }
            case CIRCLE: 
            case POINT: 
            case SPHERE: {
                return new SphereCollisionShape(f);
            }
            case CUBE: {
                return new BoxCollisionShape(f / 2.0f);
            }
            default: {
                GamaPoint[] gamaPointArray = GeometryUtils.getPointsOf((IShape)iShape);
                switch (gamaPointArray.length) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return this.convertShape(iShape, IShape.Type.POINT, f);
                    }
                    case 2: {
                        return new SimplexCollisionShape(this.toVector(gamaPointArray[0]), this.toVector(gamaPointArray[1]));
                    }
                    case 3: {
                        return new SimplexCollisionShape(this.toVector(gamaPointArray[0]), this.toVector(gamaPointArray[1]), this.toVector(gamaPointArray[2]));
                    }
                    case 4: {
                        return new SimplexCollisionShape(this.toVector(gamaPointArray[0]), this.toVector(gamaPointArray[1]), this.toVector(gamaPointArray[2]), this.toVector(gamaPointArray[3]));
                    }
                }
                float[] fArray = new float[gamaPointArray.length * 3];
                int n = 0;
                GamaPoint[] gamaPointArray2 = gamaPointArray;
                int n2 = gamaPointArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    GamaPoint gamaPoint = gamaPointArray2[n3];
                    fArray[n++] = (float)gamaPoint.x;
                    fArray[n++] = (float)gamaPoint.y;
                    fArray[n++] = (float)gamaPoint.z;
                    ++n3;
                }
                return new HullCollisionShape(fArray);
            }
        }
        return null;
    }

    @Override
    public CollisionShape convertTerrain(IScope iScope, IField iField, Double d, Double d2, float f) {
        double[] dArray = iField.getMinMax();
        float f2 = (float)dArray[1];
        float f3 = (float)dArray[0];
        GamaPoint gamaPoint = iField.getDimensions();
        float[] fArray = this.toFloats(iField.getMatrix());
        int n = 0;
        while (n < fArray.length) {
            fArray[n] = fArray[n] - (f2 - f3) / 2.0f;
            ++n;
        }
        float f4 = f2 == f3 ? 1.0f : f / (f2 - f3);
        return new HeightfieldCollisionShape((int)gamaPoint.y, (int)gamaPoint.x, fArray, new Vector3f(d.floatValue() / (float)gamaPoint.x, d2.floatValue() / (float)gamaPoint.y, f4), 2, false, false, false, false);
    }
}

