/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.particle;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.jbox2d.callbacks.ParticleQueryCallback;
import org.jbox2d.callbacks.ParticleRaycastCallback;
import org.jbox2d.callbacks.QueryCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.BufferUtils;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.World;
import org.jbox2d.particle.ParticleBodyContact;
import org.jbox2d.particle.ParticleColor;
import org.jbox2d.particle.ParticleContact;
import org.jbox2d.particle.ParticleDef;
import org.jbox2d.particle.ParticleGroup;
import org.jbox2d.particle.ParticleGroupDef;
import org.jbox2d.particle.VoronoiDiagram;

public class ParticleSystem {
    private static final int k_pairFlags = 8;
    private static final int k_triadFlags = 16;
    private static final int k_noPressureFlags = 64;
    static final int xTruncBits = 12;
    static final int yTruncBits = 12;
    static final int tagBits = 31;
    static final long yOffset = 2048L;
    static final int yShift = 19;
    static final int xShift = 7;
    static final long xScale = 128L;
    static final long xOffset = 262144L;
    static final int xMask = 4095;
    static final int yMask = 4095;
    int m_timestamp;
    int m_allParticleFlags;
    int m_allGroupFlags;
    float m_density;
    float m_inverseDensity;
    float m_gravityScale;
    float m_particleDiameter;
    float m_inverseDiameter;
    float m_squaredDiameter;
    int m_count;
    int m_internalAllocatedCapacity;
    int m_maxCount;
    ParticleBufferInt m_flagsBuffer;
    ParticleBuffer<Vec2> m_positionBuffer;
    ParticleBuffer<Vec2> m_velocityBuffer;
    float[] m_accumulationBuffer;
    Vec2[] m_accumulation2Buffer;
    float[] m_depthBuffer;
    public ParticleBuffer<ParticleColor> m_colorBuffer;
    ParticleGroup[] m_groupBuffer;
    ParticleBuffer<Object> m_userDataBuffer;
    int m_proxyCount;
    int m_proxyCapacity;
    Proxy[] m_proxyBuffer;
    public int m_contactCount;
    int m_contactCapacity;
    public ParticleContact[] m_contactBuffer;
    public int m_bodyContactCount;
    int m_bodyContactCapacity;
    public ParticleBodyContact[] m_bodyContactBuffer;
    int m_pairCount;
    int m_pairCapacity;
    Pair[] m_pairBuffer;
    int m_triadCount;
    int m_triadCapacity;
    Triad[] m_triadBuffer;
    int m_groupCount;
    ParticleGroup m_groupList;
    float m_pressureStrength;
    float m_dampingStrength;
    float m_elasticStrength;
    float m_springStrength;
    float m_viscousStrength;
    float m_surfaceTensionStrengthA;
    float m_surfaceTensionStrengthB;
    float m_powderStrength;
    float m_ejectionStrength;
    float m_colorMixingStrength;
    World m_world;
    private final AABB temp = new AABB();
    private final DestroyParticlesInShapeCallback dpcallback = new DestroyParticlesInShapeCallback();
    private final AABB temp2 = new AABB();
    private final Vec2 tempVec = new Vec2();
    private final Transform tempTransform = new Transform();
    private final Transform tempTransform2 = new Transform();
    private final CreateParticleGroupCallback createParticleGroupCallback = new CreateParticleGroupCallback();
    private final ParticleDef tempParticleDef = new ParticleDef();
    private final UpdateBodyContactsCallback ubccallback = new UpdateBodyContactsCallback();
    private final SolveCollisionCallback sccallback = new SolveCollisionCallback();
    private final Vec2 tempVec2 = new Vec2();
    private final Rot tempRot = new Rot();
    private final Transform tempXf = new Transform();
    private final Transform tempXf2 = new Transform();
    private final NewIndices newIndices = new NewIndices();

    static long computeTag(float f, float f2) {
        return ((long)(f2 + 2048.0f) << 19) + (long)(128.0f * f) + 262144L;
    }

    static long computeRelativeTag(long l, int n, int n2) {
        return l + (long)(n2 << 19) + (long)(n << 7);
    }

    static int limitCapacity(int n, int n2) {
        return n2 != 0 && n > n2 ? n2 : n;
    }

    public ParticleSystem(World world) {
        this.m_world = world;
        this.m_timestamp = 0;
        this.m_allParticleFlags = 0;
        this.m_allGroupFlags = 0;
        this.m_density = 1.0f;
        this.m_inverseDensity = 1.0f;
        this.m_gravityScale = 1.0f;
        this.m_particleDiameter = 1.0f;
        this.m_inverseDiameter = 1.0f;
        this.m_squaredDiameter = 1.0f;
        this.m_count = 0;
        this.m_internalAllocatedCapacity = 0;
        this.m_maxCount = 0;
        this.m_proxyCount = 0;
        this.m_proxyCapacity = 0;
        this.m_contactCount = 0;
        this.m_contactCapacity = 0;
        this.m_bodyContactCount = 0;
        this.m_bodyContactCapacity = 0;
        this.m_pairCount = 0;
        this.m_pairCapacity = 0;
        this.m_triadCount = 0;
        this.m_triadCapacity = 0;
        this.m_groupCount = 0;
        this.m_pressureStrength = 0.05f;
        this.m_dampingStrength = 1.0f;
        this.m_elasticStrength = 0.25f;
        this.m_springStrength = 0.25f;
        this.m_viscousStrength = 0.25f;
        this.m_surfaceTensionStrengthA = 0.1f;
        this.m_surfaceTensionStrengthB = 0.2f;
        this.m_powderStrength = 0.5f;
        this.m_ejectionStrength = 0.5f;
        this.m_colorMixingStrength = 0.5f;
        this.m_flagsBuffer = new ParticleBufferInt();
        this.m_positionBuffer = new ParticleBuffer<Vec2>(Vec2.class);
        this.m_velocityBuffer = new ParticleBuffer<Vec2>(Vec2.class);
        this.m_colorBuffer = new ParticleBuffer<ParticleColor>(ParticleColor.class);
        this.m_userDataBuffer = new ParticleBuffer<Object>(Object.class);
    }

    public int createParticle(ParticleDef particleDef) {
        int n;
        if (this.m_count >= this.m_internalAllocatedCapacity) {
            n = this.m_count != 0 ? 2 * this.m_count : 256;
            n = ParticleSystem.limitCapacity(n, this.m_maxCount);
            n = ParticleSystem.limitCapacity(n, this.m_flagsBuffer.userSuppliedCapacity);
            n = ParticleSystem.limitCapacity(n, this.m_positionBuffer.userSuppliedCapacity);
            n = ParticleSystem.limitCapacity(n, this.m_velocityBuffer.userSuppliedCapacity);
            n = ParticleSystem.limitCapacity(n, this.m_colorBuffer.userSuppliedCapacity);
            if (this.m_internalAllocatedCapacity < (n = ParticleSystem.limitCapacity(n, this.m_userDataBuffer.userSuppliedCapacity))) {
                this.m_flagsBuffer.data = ParticleSystem.reallocateBuffer(this.m_flagsBuffer, this.m_internalAllocatedCapacity, n, false);
                this.m_positionBuffer.data = ParticleSystem.reallocateBuffer(this.m_positionBuffer, this.m_internalAllocatedCapacity, n, false);
                this.m_velocityBuffer.data = ParticleSystem.reallocateBuffer(this.m_velocityBuffer, this.m_internalAllocatedCapacity, n, false);
                this.m_accumulationBuffer = BufferUtils.reallocateBuffer(this.m_accumulationBuffer, 0, this.m_internalAllocatedCapacity, n, false);
                this.m_accumulation2Buffer = BufferUtils.reallocateBuffer(Vec2.class, this.m_accumulation2Buffer, 0, this.m_internalAllocatedCapacity, n, true);
                this.m_depthBuffer = BufferUtils.reallocateBuffer(this.m_depthBuffer, 0, this.m_internalAllocatedCapacity, n, true);
                this.m_colorBuffer.data = ParticleSystem.reallocateBuffer(this.m_colorBuffer, this.m_internalAllocatedCapacity, n, true);
                this.m_groupBuffer = BufferUtils.reallocateBuffer(ParticleGroup.class, this.m_groupBuffer, 0, this.m_internalAllocatedCapacity, n, false);
                this.m_userDataBuffer.data = ParticleSystem.reallocateBuffer(this.m_userDataBuffer, this.m_internalAllocatedCapacity, n, true);
                this.m_internalAllocatedCapacity = n;
            }
        }
        if (this.m_count >= this.m_internalAllocatedCapacity) {
            return -1;
        }
        n = this.m_count++;
        this.m_flagsBuffer.data[n] = particleDef.flags;
        ((Vec2[])this.m_positionBuffer.data)[n].set(particleDef.position);
        ((Vec2[])this.m_velocityBuffer.data)[n].set(particleDef.velocity);
        this.m_groupBuffer[n] = null;
        if (this.m_depthBuffer != null) {
            this.m_depthBuffer[n] = 0.0f;
        }
        if (this.m_colorBuffer.data != null || particleDef.color != null) {
            this.m_colorBuffer.data = this.requestParticleBuffer(this.m_colorBuffer.dataClass, (ParticleColor[])this.m_colorBuffer.data);
            ((ParticleColor[])this.m_colorBuffer.data)[n].set(particleDef.color);
        }
        if (this.m_userDataBuffer.data != null || particleDef.userData != null) {
            this.m_userDataBuffer.data = this.requestParticleBuffer(this.m_userDataBuffer.dataClass, this.m_userDataBuffer.data);
            this.m_userDataBuffer.data[n] = particleDef.userData;
        }
        if (this.m_proxyCount >= this.m_proxyCapacity) {
            int n2 = this.m_proxyCapacity;
            int n3 = this.m_proxyCount != 0 ? 2 * this.m_proxyCount : 256;
            this.m_proxyBuffer = BufferUtils.reallocateBuffer(Proxy.class, this.m_proxyBuffer, n2, n3);
            this.m_proxyCapacity = n3;
        }
        ++this.m_proxyCount;
        this.m_proxyBuffer[this.m_proxyCount].index = n;
        return n;
    }

    public void destroyParticle(int n, boolean bl) {
        int n2 = 2;
        if (bl) {
            n2 |= 0x200;
        }
        int n3 = n;
        this.m_flagsBuffer.data[n3] = this.m_flagsBuffer.data[n3] | n2;
    }

    public int destroyParticlesInShape(Shape shape, Transform transform, boolean bl) {
        this.dpcallback.init(this, shape, transform, bl);
        shape.computeAABB(this.temp, transform, 0);
        this.m_world.queryAABB(this.dpcallback, this.temp);
        return this.dpcallback.destroyed;
    }

    public void destroyParticlesInGroup(ParticleGroup particleGroup, boolean bl) {
        int n = particleGroup.m_firstIndex;
        while (n < particleGroup.m_lastIndex) {
            this.destroyParticle(n, bl);
            ++n;
        }
    }

    public ParticleGroup createParticleGroup(ParticleGroupDef particleGroupDef) {
        int n;
        Object object;
        float f = this.getParticleStride();
        Transform transform = this.tempTransform;
        transform.setIdentity();
        Transform transform2 = this.tempTransform2;
        transform2.setIdentity();
        int n2 = this.m_count;
        if (particleGroupDef.shape != null) {
            ParticleDef particleDef = this.tempParticleDef;
            particleDef.flags = particleGroupDef.flags;
            particleDef.color = particleGroupDef.color;
            particleDef.userData = particleGroupDef.userData;
            object = particleGroupDef.shape;
            transform2.set(particleGroupDef.position, particleGroupDef.angle);
            AABB aABB = this.temp;
            n = ((Shape)object).getChildCount();
            int n3 = 0;
            while (n3 < n) {
                if (n3 == 0) {
                    ((Shape)object).computeAABB(aABB, transform, n3);
                } else {
                    AABB aABB2 = this.temp2;
                    ((Shape)object).computeAABB(aABB2, transform, n3);
                    aABB.combine(aABB2);
                }
                ++n3;
            }
            float f2 = aABB.upperBound.y;
            float f3 = aABB.upperBound.x;
            float f4 = (float)MathUtils.floor(aABB.lowerBound.y / f) * f;
            while (f4 < f2) {
                float f5 = (float)MathUtils.floor(aABB.lowerBound.x / f) * f;
                while (f5 < f3) {
                    Vec2 vec2 = this.tempVec;
                    vec2.x = f5;
                    vec2.y = f4;
                    if (((Shape)object).testPoint(transform, vec2)) {
                        Transform.mulToOut(transform2, vec2, vec2);
                        particleDef.position.x = vec2.x;
                        particleDef.position.y = vec2.y;
                        vec2.subLocal(particleGroupDef.position);
                        Vec2.crossToOutUnsafe(particleGroupDef.angularVelocity, vec2, particleDef.velocity);
                        particleDef.velocity.addLocal(particleGroupDef.linearVelocity);
                        this.createParticle(particleDef);
                    }
                    f5 += f;
                }
                f4 += f;
            }
        }
        int n4 = this.m_count;
        object = new ParticleGroup();
        ((ParticleGroup)object).m_system = this;
        ((ParticleGroup)object).m_firstIndex = n2;
        ((ParticleGroup)object).m_lastIndex = n4;
        ((ParticleGroup)object).m_groupFlags = particleGroupDef.groupFlags;
        ((ParticleGroup)object).m_strength = particleGroupDef.strength;
        ((ParticleGroup)object).m_userData = particleGroupDef.userData;
        ((ParticleGroup)object).m_transform.set(transform2);
        ((ParticleGroup)object).m_destroyAutomatically = particleGroupDef.destroyAutomatically;
        ((ParticleGroup)object).m_prev = null;
        ((ParticleGroup)object).m_next = this.m_groupList;
        if (this.m_groupList != null) {
            this.m_groupList.m_prev = object;
        }
        this.m_groupList = object;
        ++this.m_groupCount;
        int n5 = n2;
        while (n5 < n4) {
            this.m_groupBuffer[n5] = object;
            ++n5;
        }
        this.updateContacts(true);
        if ((particleGroupDef.flags & 8) != 0) {
            n5 = 0;
            while (n5 < this.m_contactCount) {
                ParticleContact particleContact = this.m_contactBuffer[n5];
                int n6 = particleContact.indexA;
                int n7 = particleContact.indexB;
                if (n6 > n7) {
                    int n8 = n6;
                    n6 = n7;
                    n7 = n8;
                }
                if (n2 <= n6 && n7 < n4) {
                    if (this.m_pairCount >= this.m_pairCapacity) {
                        int n9 = this.m_pairCapacity;
                        int n10 = this.m_pairCount != 0 ? 2 * this.m_pairCount : 256;
                        this.m_pairBuffer = BufferUtils.reallocateBuffer(Pair.class, this.m_pairBuffer, n9, n10);
                        this.m_pairCapacity = n10;
                    }
                    Pair pair = this.m_pairBuffer[this.m_pairCount];
                    pair.indexA = n6;
                    pair.indexB = n7;
                    pair.flags = particleContact.flags;
                    pair.strength = particleGroupDef.strength;
                    pair.distance = MathUtils.distance(((Vec2[])this.m_positionBuffer.data)[n6], ((Vec2[])this.m_positionBuffer.data)[n7]);
                    ++this.m_pairCount;
                }
                ++n5;
            }
        }
        if ((particleGroupDef.flags & 0x10) != 0) {
            VoronoiDiagram voronoiDiagram = new VoronoiDiagram(n4 - n2);
            n = n2;
            while (n < n4) {
                voronoiDiagram.addGenerator(((Vec2[])this.m_positionBuffer.data)[n], n);
                ++n;
            }
            voronoiDiagram.generate(f / 2.0f);
            this.createParticleGroupCallback.system = this;
            this.createParticleGroupCallback.def = particleGroupDef;
            this.createParticleGroupCallback.firstIndex = n2;
            voronoiDiagram.getNodes(this.createParticleGroupCallback);
        }
        if ((particleGroupDef.groupFlags & 1) != 0) {
            this.computeDepthForGroup((ParticleGroup)object);
        }
        return object;
    }

    public void joinParticleGroups(ParticleGroup particleGroup, ParticleGroup particleGroup2) {
        Object object;
        assert (particleGroup != particleGroup2);
        this.RotateBuffer(particleGroup2.m_firstIndex, particleGroup2.m_lastIndex, this.m_count);
        assert (particleGroup2.m_lastIndex == this.m_count);
        this.RotateBuffer(particleGroup.m_firstIndex, particleGroup.m_lastIndex, particleGroup2.m_firstIndex);
        assert (particleGroup.m_lastIndex == particleGroup2.m_firstIndex);
        int n = 0;
        int n2 = particleGroup.m_firstIndex;
        while (n2 < particleGroup2.m_lastIndex) {
            n |= this.m_flagsBuffer.data[n2];
            ++n2;
        }
        this.updateContacts(true);
        if ((n & 8) != 0) {
            n2 = 0;
            while (n2 < this.m_contactCount) {
                int n3;
                object = this.m_contactBuffer[n2];
                int n4 = ((ParticleContact)object).indexA;
                int n5 = ((ParticleContact)object).indexB;
                if (n4 > n5) {
                    n3 = n4;
                    n4 = n5;
                    n5 = n3;
                }
                if (particleGroup.m_firstIndex <= n4 && n4 < particleGroup.m_lastIndex && particleGroup2.m_firstIndex <= n5 && n5 < particleGroup2.m_lastIndex) {
                    if (this.m_pairCount >= this.m_pairCapacity) {
                        n3 = this.m_pairCapacity;
                        int n6 = this.m_pairCount != 0 ? 2 * this.m_pairCount : 256;
                        this.m_pairBuffer = BufferUtils.reallocateBuffer(Pair.class, this.m_pairBuffer, n3, n6);
                        this.m_pairCapacity = n6;
                    }
                    Pair pair = this.m_pairBuffer[this.m_pairCount];
                    pair.indexA = n4;
                    pair.indexB = n5;
                    pair.flags = ((ParticleContact)object).flags;
                    pair.strength = MathUtils.min(particleGroup.m_strength, particleGroup2.m_strength);
                    pair.distance = MathUtils.distance(((Vec2[])this.m_positionBuffer.data)[n4], ((Vec2[])this.m_positionBuffer.data)[n5]);
                    ++this.m_pairCount;
                }
                ++n2;
            }
        }
        if ((n & 0x10) != 0) {
            VoronoiDiagram voronoiDiagram = new VoronoiDiagram(particleGroup2.m_lastIndex - particleGroup.m_firstIndex);
            int n7 = particleGroup.m_firstIndex;
            while (n7 < particleGroup2.m_lastIndex) {
                if ((this.m_flagsBuffer.data[n7] & 2) == 0) {
                    voronoiDiagram.addGenerator(((Vec2[])this.m_positionBuffer.data)[n7], n7);
                }
                ++n7;
            }
            voronoiDiagram.generate(this.getParticleStride() / 2.0f);
            object = new JoinParticleGroupsCallback();
            ((JoinParticleGroupsCallback)object).system = this;
            ((JoinParticleGroupsCallback)object).groupA = particleGroup;
            ((JoinParticleGroupsCallback)object).groupB = particleGroup2;
            voronoiDiagram.getNodes((VoronoiDiagram.VoronoiDiagramCallback)object);
        }
        int n8 = particleGroup2.m_firstIndex;
        while (n8 < particleGroup2.m_lastIndex) {
            this.m_groupBuffer[n8] = particleGroup;
            ++n8;
        }
        particleGroup.m_groupFlags = n8 = particleGroup.m_groupFlags | particleGroup2.m_groupFlags;
        particleGroup.m_lastIndex = particleGroup2.m_lastIndex;
        particleGroup2.m_firstIndex = particleGroup2.m_lastIndex;
        this.destroyParticleGroup(particleGroup2);
        if ((n8 & 1) != 0) {
            this.computeDepthForGroup(particleGroup);
        }
    }

    void destroyParticleGroup(ParticleGroup particleGroup) {
        assert (this.m_groupCount > 0);
        assert (particleGroup != null);
        if (this.m_world.getParticleDestructionListener() != null) {
            this.m_world.getParticleDestructionListener().sayGoodbye(particleGroup);
        }
        int n = particleGroup.m_firstIndex;
        while (n < particleGroup.m_lastIndex) {
            this.m_groupBuffer[n] = null;
            ++n;
        }
        if (particleGroup.m_prev != null) {
            particleGroup.m_prev.m_next = particleGroup.m_next;
        }
        if (particleGroup.m_next != null) {
            particleGroup.m_next.m_prev = particleGroup.m_prev;
        }
        if (particleGroup == this.m_groupList) {
            this.m_groupList = particleGroup.m_next;
        }
        --this.m_groupCount;
    }

    public void computeDepthForGroup(ParticleGroup particleGroup) {
        int n;
        int n2;
        int n3 = particleGroup.m_firstIndex;
        while (n3 < particleGroup.m_lastIndex) {
            this.m_accumulationBuffer[n3] = 0.0f;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.m_contactCount) {
            ParticleContact particleContact = this.m_contactBuffer[n3];
            n2 = particleContact.indexA;
            n = particleContact.indexB;
            if (n2 >= particleGroup.m_firstIndex && n2 < particleGroup.m_lastIndex && n >= particleGroup.m_firstIndex && n < particleGroup.m_lastIndex) {
                float f = particleContact.weight;
                int n4 = n2;
                this.m_accumulationBuffer[n4] = this.m_accumulationBuffer[n4] + f;
                int n5 = n;
                this.m_accumulationBuffer[n5] = this.m_accumulationBuffer[n5] + f;
            }
            ++n3;
        }
        this.m_depthBuffer = this.requestParticleBuffer(this.m_depthBuffer);
        n3 = particleGroup.m_firstIndex;
        while (n3 < particleGroup.m_lastIndex) {
            float f = this.m_accumulationBuffer[n3];
            this.m_depthBuffer[n3] = f < 0.8f ? 0.0f : Float.MAX_VALUE;
            ++n3;
        }
        n3 = particleGroup.getParticleCount();
        int n6 = 0;
        while (n6 < n3) {
            n2 = 0;
            n = 0;
            while (n < this.m_contactCount) {
                ParticleContact particleContact = this.m_contactBuffer[n];
                int n7 = particleContact.indexA;
                int n8 = particleContact.indexB;
                if (n7 >= particleGroup.m_firstIndex && n7 < particleGroup.m_lastIndex && n8 >= particleGroup.m_firstIndex && n8 < particleGroup.m_lastIndex) {
                    float f = 1.0f - particleContact.weight;
                    float f2 = this.m_depthBuffer[n7];
                    float f3 = this.m_depthBuffer[n8];
                    float f4 = f3 + f;
                    float f5 = f2 + f;
                    if (f2 > f4) {
                        this.m_depthBuffer[n7] = f4;
                        n2 = 1;
                    }
                    if (f3 > f5) {
                        this.m_depthBuffer[n8] = f5;
                        n2 = 1;
                    }
                }
                ++n;
            }
            if (n2 == 0) break;
            ++n6;
        }
        n6 = particleGroup.m_firstIndex;
        while (n6 < particleGroup.m_lastIndex) {
            float f = this.m_depthBuffer[n6];
            if (f < Float.MAX_VALUE) {
                int n9 = n6;
                this.m_depthBuffer[n9] = this.m_depthBuffer[n9] * this.m_particleDiameter;
            } else {
                this.m_depthBuffer[n6] = 0.0f;
            }
            ++n6;
        }
    }

    public void addContact(int n, int n2) {
        assert (n != n2);
        Vec2 vec2 = ((Vec2[])this.m_positionBuffer.data)[n];
        Vec2 vec22 = ((Vec2[])this.m_positionBuffer.data)[n2];
        float f = vec22.x - vec2.x;
        float f2 = vec22.y - vec2.y;
        float f3 = f * f + f2 * f2;
        if (f3 < this.m_squaredDiameter) {
            if (this.m_contactCount >= this.m_contactCapacity) {
                int n3 = this.m_contactCapacity;
                int n4 = this.m_contactCount != 0 ? 2 * this.m_contactCount : 256;
                this.m_contactBuffer = BufferUtils.reallocateBuffer(ParticleContact.class, this.m_contactBuffer, n3, n4);
                this.m_contactCapacity = n4;
            }
            float f4 = f3 != 0.0f ? MathUtils.sqrt(1.0f / f3) : Float.MAX_VALUE;
            ParticleContact particleContact = this.m_contactBuffer[this.m_contactCount];
            particleContact.indexA = n;
            particleContact.indexB = n2;
            particleContact.flags = this.m_flagsBuffer.data[n] | this.m_flagsBuffer.data[n2];
            particleContact.weight = 1.0f - f3 * f4 * this.m_inverseDiameter;
            particleContact.normal.x = f4 * f;
            particleContact.normal.y = f4 * f2;
            ++this.m_contactCount;
        }
    }

    public void updateContacts(boolean bl) {
        Object object;
        int n;
        int n2 = 0;
        while (n2 < this.m_proxyCount) {
            Proxy proxy = this.m_proxyBuffer[n2];
            n = proxy.index;
            object = ((Vec2[])this.m_positionBuffer.data)[n];
            proxy.tag = ParticleSystem.computeTag(this.m_inverseDiameter * ((Vec2)object).x, this.m_inverseDiameter * ((Vec2)object).y);
            ++n2;
        }
        Arrays.sort(this.m_proxyBuffer, 0, this.m_proxyCount);
        this.m_contactCount = 0;
        n2 = 0;
        int n3 = 0;
        while (n3 < this.m_proxyCount) {
            Proxy proxy = this.m_proxyBuffer[n3];
            long l = ParticleSystem.computeRelativeTag(proxy.tag, 1, 0);
            int n4 = n3 + 1;
            while (n4 < this.m_proxyCount) {
                Proxy proxy2 = this.m_proxyBuffer[n4];
                if (l < proxy2.tag) break;
                this.addContact(proxy.index, proxy2.index);
                ++n4;
            }
            long l2 = ParticleSystem.computeRelativeTag(proxy.tag, -1, 1);
            while (n2 < this.m_proxyCount) {
                Proxy proxy3 = this.m_proxyBuffer[n2];
                if (l2 <= proxy3.tag) break;
                ++n2;
            }
            long l3 = ParticleSystem.computeRelativeTag(proxy.tag, 1, 1);
            int n5 = n2;
            while (n5 < this.m_proxyCount) {
                Proxy proxy4 = this.m_proxyBuffer[n5];
                if (l3 < proxy4.tag) break;
                this.addContact(proxy.index, proxy4.index);
                ++n5;
            }
            ++n3;
        }
        if (bl) {
            n3 = this.m_contactCount;
            n = 0;
            while (n < n3) {
                if ((this.m_contactBuffer[n].flags & 2) != 0) {
                    object = this.m_contactBuffer[--n3];
                    this.m_contactBuffer[n3] = this.m_contactBuffer[n];
                    this.m_contactBuffer[n] = object;
                    --n;
                }
                ++n;
            }
            this.m_contactCount = n3;
        }
    }

    public void updateBodyContacts() {
        AABB aABB = this.temp;
        aABB.lowerBound.x = Float.MAX_VALUE;
        aABB.lowerBound.y = Float.MAX_VALUE;
        aABB.upperBound.x = -3.4028235E38f;
        aABB.upperBound.y = -3.4028235E38f;
        int n = 0;
        while (n < this.m_count) {
            Vec2 vec2 = ((Vec2[])this.m_positionBuffer.data)[n];
            Vec2.minToOut(aABB.lowerBound, vec2, aABB.lowerBound);
            Vec2.maxToOut(aABB.upperBound, vec2, aABB.upperBound);
            ++n;
        }
        aABB.lowerBound.x -= this.m_particleDiameter;
        aABB.lowerBound.y -= this.m_particleDiameter;
        aABB.upperBound.x += this.m_particleDiameter;
        aABB.upperBound.y += this.m_particleDiameter;
        this.m_bodyContactCount = 0;
        this.ubccallback.system = this;
        this.m_world.queryAABB(this.ubccallback, aABB);
    }

    public void solveCollision(TimeStep timeStep) {
        AABB aABB = this.temp;
        Vec2 vec2 = aABB.lowerBound;
        Vec2 vec22 = aABB.upperBound;
        vec2.x = Float.MAX_VALUE;
        vec2.y = Float.MAX_VALUE;
        vec22.x = -3.4028235E38f;
        vec22.y = -3.4028235E38f;
        int n = 0;
        while (n < this.m_count) {
            Vec2 vec23 = ((Vec2[])this.m_velocityBuffer.data)[n];
            Vec2 vec24 = ((Vec2[])this.m_positionBuffer.data)[n];
            float f = vec24.x;
            float f2 = vec24.y;
            float f3 = f + timeStep.dt * vec23.x;
            float f4 = f2 + timeStep.dt * vec23.y;
            float f5 = f < f3 ? f : f3;
            float f6 = f2 < f4 ? f2 : f4;
            vec2.x = vec2.x < f5 ? vec2.x : f5;
            vec2.y = vec2.y < f6 ? vec2.y : f6;
            float f7 = f > f3 ? f : f3;
            float f8 = f2 > f4 ? f2 : f4;
            vec22.x = vec22.x > f7 ? vec22.x : f7;
            vec22.y = vec22.y > f8 ? vec22.y : f8;
            ++n;
        }
        this.sccallback.step = timeStep;
        this.sccallback.system = this;
        this.m_world.queryAABB(this.sccallback, aABB);
    }

    public void solve(TimeStep timeStep) {
        Vec2 vec2;
        ++this.m_timestamp;
        if (this.m_count == 0) {
            return;
        }
        this.m_allParticleFlags = 0;
        int n = 0;
        while (n < this.m_count) {
            this.m_allParticleFlags |= this.m_flagsBuffer.data[n];
            ++n;
        }
        if ((this.m_allParticleFlags & 2) != 0) {
            this.solveZombie();
        }
        if (this.m_count == 0) {
            return;
        }
        this.m_allGroupFlags = 0;
        ParticleGroup particleGroup = this.m_groupList;
        while (particleGroup != null) {
            this.m_allGroupFlags |= particleGroup.m_groupFlags;
            particleGroup = particleGroup.getNext();
        }
        float f = timeStep.dt * this.m_gravityScale * this.m_world.getGravity().x;
        float f2 = timeStep.dt * this.m_gravityScale * this.m_world.getGravity().y;
        float f3 = this.getCriticalVelocitySquared(timeStep);
        int n2 = 0;
        while (n2 < this.m_count) {
            vec2 = ((Vec2[])this.m_velocityBuffer.data)[n2];
            vec2.x += f;
            vec2.y += f2;
            float f4 = vec2.x * vec2.x + vec2.y * vec2.y;
            if (f4 > f3) {
                float f5 = f4 == 0.0f ? Float.MAX_VALUE : MathUtils.sqrt(f3 / f4);
                vec2.x *= f5;
                vec2.y *= f5;
            }
            ++n2;
        }
        this.solveCollision(timeStep);
        if ((this.m_allGroupFlags & 2) != 0) {
            this.solveRigid(timeStep);
        }
        if ((this.m_allParticleFlags & 4) != 0) {
            this.solveWall(timeStep);
        }
        n2 = 0;
        while (n2 < this.m_count) {
            vec2 = ((Vec2[])this.m_positionBuffer.data)[n2];
            Vec2 vec22 = ((Vec2[])this.m_velocityBuffer.data)[n2];
            vec2.x += timeStep.dt * vec22.x;
            vec2.y += timeStep.dt * vec22.y;
            ++n2;
        }
        this.updateBodyContacts();
        this.updateContacts(false);
        if ((this.m_allParticleFlags & 0x20) != 0) {
            this.solveViscous(timeStep);
        }
        if ((this.m_allParticleFlags & 0x40) != 0) {
            this.solvePowder(timeStep);
        }
        if ((this.m_allParticleFlags & 0x80) != 0) {
            this.solveTensile(timeStep);
        }
        if ((this.m_allParticleFlags & 0x10) != 0) {
            this.solveElastic(timeStep);
        }
        if ((this.m_allParticleFlags & 8) != 0) {
            this.solveSpring(timeStep);
        }
        if ((this.m_allGroupFlags & 1) != 0) {
            this.solveSolid(timeStep);
        }
        if ((this.m_allParticleFlags & 0x100) != 0) {
            this.solveColorMixing(timeStep);
        }
        this.solvePressure(timeStep);
        this.solveDamping(timeStep);
    }

    void solvePressure(TimeStep timeStep) {
        Vec2 vec2;
        float f;
        float f2;
        float f3;
        int n;
        Object object;
        int n2 = 0;
        while (n2 < this.m_count) {
            this.m_accumulationBuffer[n2] = 0.0f;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.m_bodyContactCount) {
            object = this.m_bodyContactBuffer[n2];
            n = ((ParticleBodyContact)object).index;
            f3 = ((ParticleBodyContact)object).weight;
            int n3 = n;
            this.m_accumulationBuffer[n3] = this.m_accumulationBuffer[n3] + f3;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.m_contactCount) {
            object = this.m_contactBuffer[n2];
            n = ((ParticleContact)object).indexA;
            int n4 = ((ParticleContact)object).indexB;
            float f4 = ((ParticleContact)object).weight;
            int n5 = n;
            this.m_accumulationBuffer[n5] = this.m_accumulationBuffer[n5] + f4;
            int n6 = n4;
            this.m_accumulationBuffer[n6] = this.m_accumulationBuffer[n6] + f4;
            ++n2;
        }
        if ((this.m_allParticleFlags & 0x40) != 0) {
            n2 = 0;
            while (n2 < this.m_count) {
                if ((this.m_flagsBuffer.data[n2] & 0x40) != 0) {
                    this.m_accumulationBuffer[n2] = 0.0f;
                }
                ++n2;
            }
        }
        float f5 = this.m_pressureStrength * this.getCriticalPressure(timeStep);
        int n7 = 0;
        while (n7 < this.m_count) {
            float f6 = this.m_accumulationBuffer[n7];
            this.m_accumulationBuffer[n7] = f3 = f5 * MathUtils.max(0.0f, MathUtils.min(f6, 5.0f) - 1.0f);
            ++n7;
        }
        float f7 = timeStep.dt / (this.m_density * this.m_particleDiameter);
        int n8 = 0;
        while (n8 < this.m_bodyContactCount) {
            ParticleBodyContact particleBodyContact = this.m_bodyContactBuffer[n8];
            int n9 = particleBodyContact.index;
            Body body = particleBodyContact.body;
            f2 = particleBodyContact.weight;
            float f8 = particleBodyContact.mass;
            Vec2 vec22 = particleBodyContact.normal;
            Vec2 vec23 = ((Vec2[])this.m_positionBuffer.data)[n9];
            f = this.m_accumulationBuffer[n9] + f5 * f2;
            vec2 = this.tempVec;
            float f9 = f7 * f2 * f8 * f;
            vec2.x = f9 * vec22.x;
            vec2.y = f9 * vec22.y;
            Vec2 vec24 = ((Vec2[])this.m_velocityBuffer.data)[n9];
            float f10 = this.getParticleInvMass();
            vec24.x -= f10 * vec2.x;
            vec24.y -= f10 * vec2.y;
            body.applyLinearImpulse(vec2, vec23, true);
            ++n8;
        }
        n8 = 0;
        while (n8 < this.m_contactCount) {
            ParticleContact particleContact = this.m_contactBuffer[n8];
            int n10 = particleContact.indexA;
            int n11 = particleContact.indexB;
            f2 = particleContact.weight;
            Vec2 vec25 = particleContact.normal;
            float f11 = this.m_accumulationBuffer[n10] + this.m_accumulationBuffer[n11];
            float f12 = f7 * f2 * f11 * vec25.x;
            f = f7 * f2 * f11 * vec25.y;
            vec2 = ((Vec2[])this.m_velocityBuffer.data)[n10];
            Vec2 vec26 = ((Vec2[])this.m_velocityBuffer.data)[n11];
            vec2.x -= f12;
            vec2.y -= f;
            vec26.x += f12;
            vec26.y += f;
            ++n8;
        }
    }

    void solveDamping(TimeStep timeStep) {
        float f;
        float f2;
        float f3;
        float f4;
        Vec2 vec2;
        Vec2 vec22;
        float f5;
        int n;
        Object object;
        float f6 = this.m_dampingStrength;
        int n2 = 0;
        while (n2 < this.m_bodyContactCount) {
            object = this.m_bodyContactBuffer[n2];
            n = ((ParticleBodyContact)object).index;
            Body body = ((ParticleBodyContact)object).body;
            f5 = ((ParticleBodyContact)object).weight;
            float f7 = ((ParticleBodyContact)object).mass;
            vec22 = ((ParticleBodyContact)object).normal;
            vec2 = ((Vec2[])this.m_positionBuffer.data)[n];
            f4 = vec2.x - body.m_sweep.c.x;
            f3 = vec2.y - body.m_sweep.c.y;
            Vec2 vec23 = ((Vec2[])this.m_velocityBuffer.data)[n];
            f2 = -body.m_angularVelocity * f3 + body.m_linearVelocity.x - vec23.x;
            f = body.m_angularVelocity * f4 + body.m_linearVelocity.y - vec23.y;
            float f8 = f2 * vec22.x + f * vec22.y;
            if (f8 < 0.0f) {
                Vec2 vec24 = this.tempVec;
                vec24.x = f6 * f5 * f7 * f8 * vec22.x;
                vec24.y = f6 * f5 * f7 * f8 * vec22.y;
                float f9 = this.getParticleInvMass();
                vec23.x += f9 * vec24.x;
                vec23.y += f9 * vec24.y;
                vec24.x = -vec24.x;
                vec24.y = -vec24.y;
                body.applyLinearImpulse(vec24, vec2, true);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.m_contactCount) {
            object = this.m_contactBuffer[n2];
            n = ((ParticleContact)object).indexA;
            int n3 = ((ParticleContact)object).indexB;
            f5 = ((ParticleContact)object).weight;
            Vec2 vec25 = ((ParticleContact)object).normal;
            vec22 = ((Vec2[])this.m_velocityBuffer.data)[n];
            vec2 = ((Vec2[])this.m_velocityBuffer.data)[n3];
            f4 = vec2.x - vec22.x;
            f3 = vec2.y - vec22.y;
            float f10 = f4 * vec25.x + f3 * vec25.y;
            if (f10 < 0.0f) {
                f2 = f6 * f5 * f10 * vec25.x;
                f = f6 * f5 * f10 * vec25.y;
                vec22.x += f2;
                vec22.y += f;
                vec2.x -= f2;
                vec2.y -= f;
            }
            ++n2;
        }
    }

    public void solveWall(TimeStep timeStep) {
        int n = 0;
        while (n < this.m_count) {
            if ((this.m_flagsBuffer.data[n] & 4) != 0) {
                Vec2 vec2 = ((Vec2[])this.m_velocityBuffer.data)[n];
                vec2.x = 0.0f;
                vec2.y = 0.0f;
            }
            ++n;
        }
    }

    void solveRigid(TimeStep timeStep) {
        ParticleGroup particleGroup = this.m_groupList;
        while (particleGroup != null) {
            if ((particleGroup.m_groupFlags & 2) != 0) {
                particleGroup.updateStatistics();
                Vec2 vec2 = this.tempVec;
                Vec2 vec22 = this.tempVec2;
                Rot rot = this.tempRot;
                rot.set(timeStep.dt * particleGroup.m_angularVelocity);
                Rot.mulToOutUnsafe(rot, particleGroup.m_center, vec22);
                vec2.set(particleGroup.m_linearVelocity).mulLocal(timeStep.dt).addLocal(particleGroup.m_center).subLocal(vec22);
                this.tempXf.p.set(vec2);
                this.tempXf.q.set(rot);
                Transform.mulToOut(this.tempXf, particleGroup.m_transform, particleGroup.m_transform);
                Transform transform = this.tempXf2;
                transform.p.x = timeStep.inv_dt * this.tempXf.p.x;
                transform.p.y = timeStep.inv_dt * this.tempXf.p.y;
                transform.q.s = timeStep.inv_dt * this.tempXf.q.s;
                transform.q.c = timeStep.inv_dt * (this.tempXf.q.c - 1.0f);
                int n = particleGroup.m_firstIndex;
                while (n < particleGroup.m_lastIndex) {
                    Transform.mulToOutUnsafe(transform, ((Vec2[])this.m_positionBuffer.data)[n], ((Vec2[])this.m_velocityBuffer.data)[n]);
                    ++n;
                }
            }
            particleGroup = particleGroup.getNext();
        }
    }

    void solveElastic(TimeStep timeStep) {
        float f = timeStep.inv_dt * this.m_elasticStrength;
        int n = 0;
        while (n < this.m_triadCount) {
            Triad triad = this.m_triadBuffer[n];
            if ((triad.flags & 0x10) != 0) {
                float f2;
                int n2 = triad.indexA;
                int n3 = triad.indexB;
                int n4 = triad.indexC;
                Vec2 vec2 = triad.pa;
                Vec2 vec22 = triad.pb;
                Vec2 vec23 = triad.pc;
                Vec2 vec24 = ((Vec2[])this.m_positionBuffer.data)[n2];
                Vec2 vec25 = ((Vec2[])this.m_positionBuffer.data)[n3];
                Vec2 vec26 = ((Vec2[])this.m_positionBuffer.data)[n4];
                float f3 = 0.33333334f * (vec24.x + vec25.x + vec26.x);
                float f4 = 0.33333334f * (vec24.y + vec25.y + vec26.y);
                float f5 = Vec2.cross(vec2, vec24) + Vec2.cross(vec22, vec25) + Vec2.cross(vec23, vec26);
                float f6 = f5 * f5 + (f2 = Vec2.dot(vec2, vec24) + Vec2.dot(vec22, vec25) + Vec2.dot(vec23, vec26)) * f2;
                float f7 = f6 == 0.0f ? Float.MAX_VALUE : MathUtils.sqrt(1.0f / f6);
                float f8 = f * triad.strength;
                float f9 = (f2 *= f7) * vec2.x - (f5 *= f7) * vec2.y;
                float f10 = f5 * vec2.x + f2 * vec2.y;
                float f11 = f2 * vec22.x - f5 * vec22.y;
                float f12 = f5 * vec22.x + f2 * vec22.y;
                float f13 = f2 * vec23.x - f5 * vec23.y;
                float f14 = f5 * vec23.x + f2 * vec23.y;
                Vec2 vec27 = ((Vec2[])this.m_velocityBuffer.data)[n2];
                Vec2 vec28 = ((Vec2[])this.m_velocityBuffer.data)[n3];
                Vec2 vec29 = ((Vec2[])this.m_velocityBuffer.data)[n4];
                vec27.x += f8 * (f9 - (vec24.x - f3));
                vec27.y += f8 * (f10 - (vec24.y - f4));
                vec28.x += f8 * (f11 - (vec25.x - f3));
                vec28.y += f8 * (f12 - (vec25.y - f4));
                vec29.x += f8 * (f13 - (vec26.x - f3));
                vec29.y += f8 * (f14 - (vec26.y - f4));
            }
            ++n;
        }
    }

    void solveSpring(TimeStep timeStep) {
        float f = timeStep.inv_dt * this.m_springStrength;
        int n = 0;
        while (n < this.m_pairCount) {
            Pair pair = this.m_pairBuffer[n];
            if ((pair.flags & 8) != 0) {
                int n2 = pair.indexA;
                int n3 = pair.indexB;
                Vec2 vec2 = ((Vec2[])this.m_positionBuffer.data)[n2];
                Vec2 vec22 = ((Vec2[])this.m_positionBuffer.data)[n3];
                float f2 = vec22.x - vec2.x;
                float f3 = vec22.y - vec2.y;
                float f4 = pair.distance;
                float f5 = MathUtils.sqrt(f2 * f2 + f3 * f3);
                if (f5 == 0.0f) {
                    f5 = Float.MAX_VALUE;
                }
                float f6 = f * pair.strength;
                float f7 = f6 * (f4 - f5) / f5 * f2;
                float f8 = f6 * (f4 - f5) / f5 * f3;
                Vec2 vec23 = ((Vec2[])this.m_velocityBuffer.data)[n2];
                Vec2 vec24 = ((Vec2[])this.m_velocityBuffer.data)[n3];
                vec23.x -= f7;
                vec23.y -= f8;
                vec24.x += f7;
                vec24.y += f8;
            }
            ++n;
        }
    }

    void solveTensile(TimeStep timeStep) {
        Vec2 vec2;
        int n;
        this.m_accumulation2Buffer = this.requestParticleBuffer(Vec2.class, this.m_accumulation2Buffer);
        int n2 = 0;
        while (n2 < this.m_count) {
            this.m_accumulationBuffer[n2] = 0.0f;
            this.m_accumulation2Buffer[n2].setZero();
            ++n2;
        }
        n2 = 0;
        while (n2 < this.m_contactCount) {
            ParticleContact particleContact = this.m_contactBuffer[n2];
            if ((particleContact.flags & 0x80) != 0) {
                n = particleContact.indexA;
                int n3 = particleContact.indexB;
                float f = particleContact.weight;
                Vec2 vec22 = particleContact.normal;
                int n4 = n;
                this.m_accumulationBuffer[n4] = this.m_accumulationBuffer[n4] + f;
                int n5 = n3;
                this.m_accumulationBuffer[n5] = this.m_accumulationBuffer[n5] + f;
                Vec2 vec23 = this.m_accumulation2Buffer[n];
                vec2 = this.m_accumulation2Buffer[n3];
                float f2 = (1.0f - f) * f;
                vec23.x -= f2 * vec22.x;
                vec23.y -= f2 * vec22.y;
                vec2.x += f2 * vec22.x;
                vec2.y += f2 * vec22.y;
            }
            ++n2;
        }
        float f = this.m_surfaceTensionStrengthA * this.getCriticalVelocity(timeStep);
        float f3 = this.m_surfaceTensionStrengthB * this.getCriticalVelocity(timeStep);
        n = 0;
        while (n < this.m_contactCount) {
            ParticleContact particleContact = this.m_contactBuffer[n];
            if ((particleContact.flags & 0x80) != 0) {
                int n6 = particleContact.indexA;
                int n7 = particleContact.indexB;
                float f4 = particleContact.weight;
                vec2 = particleContact.normal;
                Vec2 vec24 = this.m_accumulation2Buffer[n6];
                Vec2 vec25 = this.m_accumulation2Buffer[n7];
                float f5 = this.m_accumulationBuffer[n6] + this.m_accumulationBuffer[n7];
                float f6 = vec25.x - vec24.x;
                float f7 = vec25.y - vec24.y;
                float f8 = (f * (f5 - 2.0f) + f3 * (f6 * vec2.x + f7 * vec2.y)) * f4;
                float f9 = f8 * vec2.x;
                float f10 = f8 * vec2.y;
                Vec2 vec26 = ((Vec2[])this.m_velocityBuffer.data)[n6];
                Vec2 vec27 = ((Vec2[])this.m_velocityBuffer.data)[n7];
                vec26.x -= f9;
                vec26.y -= f10;
                vec27.x += f9;
                vec27.y += f10;
            }
            ++n;
        }
    }

    void solveViscous(TimeStep timeStep) {
        float f;
        float f2;
        float f3;
        Vec2 vec2;
        float f4;
        int n;
        Object object;
        float f5 = this.m_viscousStrength;
        int n2 = 0;
        while (n2 < this.m_bodyContactCount) {
            object = this.m_bodyContactBuffer[n2];
            n = ((ParticleBodyContact)object).index;
            if ((this.m_flagsBuffer.data[n] & 0x20) != 0) {
                Body body = ((ParticleBodyContact)object).body;
                f4 = ((ParticleBodyContact)object).weight;
                float f6 = ((ParticleBodyContact)object).mass;
                vec2 = ((Vec2[])this.m_positionBuffer.data)[n];
                Vec2 vec22 = ((Vec2[])this.m_velocityBuffer.data)[n];
                f3 = vec2.x - body.m_sweep.c.x;
                f2 = vec2.y - body.m_sweep.c.y;
                f = -body.m_angularVelocity * f2 + body.m_linearVelocity.x - vec22.x;
                float f7 = body.m_angularVelocity * f3 + body.m_linearVelocity.y - vec22.y;
                Vec2 vec23 = this.tempVec;
                float f8 = this.getParticleInvMass();
                vec23.x = f5 * f6 * f4 * f;
                vec23.y = f5 * f6 * f4 * f7;
                vec22.x += f8 * vec23.x;
                vec22.y += f8 * vec23.y;
                vec23.x = -vec23.x;
                vec23.y = -vec23.y;
                body.applyLinearImpulse(vec23, vec2, true);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.m_contactCount) {
            object = this.m_contactBuffer[n2];
            if ((((ParticleContact)object).flags & 0x20) != 0) {
                n = ((ParticleContact)object).indexA;
                int n3 = ((ParticleContact)object).indexB;
                f4 = ((ParticleContact)object).weight;
                Vec2 vec24 = ((Vec2[])this.m_velocityBuffer.data)[n];
                vec2 = ((Vec2[])this.m_velocityBuffer.data)[n3];
                float f9 = vec2.x - vec24.x;
                f3 = vec2.y - vec24.y;
                f2 = f5 * f4 * f9;
                f = f5 * f4 * f3;
                vec24.x += f2;
                vec24.y += f;
                vec2.x -= f2;
                vec2.y -= f;
            }
            ++n2;
        }
    }

    void solvePowder(TimeStep timeStep) {
        float f;
        Vec2 vec2;
        Vec2 vec22;
        Object object;
        float f2 = this.m_powderStrength * this.getCriticalVelocity(timeStep);
        float f3 = 0.25f;
        int n = 0;
        while (n < this.m_bodyContactCount) {
            float f4;
            object = this.m_bodyContactBuffer[n];
            int n2 = ((ParticleBodyContact)object).index;
            if ((this.m_flagsBuffer.data[n2] & 0x40) != 0 && (f4 = ((ParticleBodyContact)object).weight) > f3) {
                Body body = ((ParticleBodyContact)object).body;
                float f5 = ((ParticleBodyContact)object).mass;
                vec22 = ((Vec2[])this.m_positionBuffer.data)[n2];
                vec2 = ((ParticleBodyContact)object).normal;
                Vec2 vec23 = this.tempVec;
                Vec2 vec24 = ((Vec2[])this.m_velocityBuffer.data)[n2];
                f = f2 * f5 * (f4 - f3);
                float f6 = this.getParticleInvMass();
                vec23.x = f * vec2.x;
                vec23.y = f * vec2.y;
                vec24.x -= f6 * vec23.x;
                vec24.y -= f6 * vec23.y;
                body.applyLinearImpulse(vec23, vec22, true);
            }
            ++n;
        }
        n = 0;
        while (n < this.m_contactCount) {
            float f7;
            object = this.m_contactBuffer[n];
            if ((((ParticleContact)object).flags & 0x40) != 0 && (f7 = ((ParticleContact)object).weight) > f3) {
                int n3 = ((ParticleContact)object).indexA;
                int n4 = ((ParticleContact)object).indexB;
                Vec2 vec25 = ((ParticleContact)object).normal;
                vec22 = ((Vec2[])this.m_velocityBuffer.data)[n3];
                vec2 = ((Vec2[])this.m_velocityBuffer.data)[n4];
                float f8 = f2 * (f7 - f3);
                float f9 = f8 * vec25.x;
                f = f8 * vec25.y;
                vec22.x -= f9;
                vec22.y -= f;
                vec2.x += f9;
                vec2.y += f;
            }
            ++n;
        }
    }

    void solveSolid(TimeStep timeStep) {
        this.m_depthBuffer = this.requestParticleBuffer(this.m_depthBuffer);
        float f = timeStep.inv_dt * this.m_ejectionStrength;
        int n = 0;
        while (n < this.m_contactCount) {
            ParticleContact particleContact = this.m_contactBuffer[n];
            int n2 = particleContact.indexA;
            int n3 = particleContact.indexB;
            if (this.m_groupBuffer[n2] != this.m_groupBuffer[n3]) {
                float f2 = particleContact.weight;
                Vec2 vec2 = particleContact.normal;
                float f3 = this.m_depthBuffer[n2] + this.m_depthBuffer[n3];
                Vec2 vec22 = ((Vec2[])this.m_velocityBuffer.data)[n2];
                Vec2 vec23 = ((Vec2[])this.m_velocityBuffer.data)[n3];
                float f4 = f * f3 * f2;
                float f5 = f4 * vec2.x;
                float f6 = f4 * vec2.y;
                vec22.x -= f5;
                vec22.y -= f6;
                vec23.x += f5;
                vec23.y += f6;
            }
            ++n;
        }
    }

    void solveColorMixing(TimeStep timeStep) {
        this.m_colorBuffer.data = this.requestParticleBuffer(ParticleColor.class, (ParticleColor[])this.m_colorBuffer.data);
        int n = (int)(256.0f * this.m_colorMixingStrength);
        int n2 = 0;
        while (n2 < this.m_contactCount) {
            ParticleContact particleContact = this.m_contactBuffer[n2];
            int n3 = particleContact.indexA;
            int n4 = particleContact.indexB;
            if ((this.m_flagsBuffer.data[n3] & this.m_flagsBuffer.data[n4] & 0x100) != 0) {
                ParticleColor particleColor = ((ParticleColor[])this.m_colorBuffer.data)[n3];
                ParticleColor particleColor2 = ((ParticleColor[])this.m_colorBuffer.data)[n4];
                int n5 = n * ((particleColor2.r & 0xFF) - (particleColor.r & 0xFF)) >> 8;
                int n6 = n * ((particleColor2.g & 0xFF) - (particleColor.g & 0xFF)) >> 8;
                int n7 = n * ((particleColor2.b & 0xFF) - (particleColor.b & 0xFF)) >> 8;
                int n8 = n * ((particleColor2.a & 0xFF) - (particleColor.a & 0xFF)) >> 8;
                particleColor.r = (byte)(particleColor.r + n5);
                particleColor.g = (byte)(particleColor.g + n6);
                particleColor.b = (byte)(particleColor.b + n7);
                particleColor.a = (byte)(particleColor.a + n8);
                particleColor2.r = (byte)(particleColor2.r - n5);
                particleColor2.g = (byte)(particleColor2.g - n6);
                particleColor2.b = (byte)(particleColor2.b - n7);
                particleColor2.a = (byte)(particleColor2.a - n8);
            }
            ++n2;
        }
    }

    void solveZombie() {
        Object object;
        int n;
        int n2 = 0;
        int[] nArray = new int[this.m_count];
        int n3 = 0;
        while (n3 < this.m_count) {
            n = this.m_flagsBuffer.data[n3];
            if ((n & 2) != 0) {
                object = this.m_world.getParticleDestructionListener();
                if ((n & 0x200) != 0 && object != null) {
                    object.sayGoodbye(n3);
                }
                nArray[n3] = -1;
            } else {
                nArray[n3] = n2;
                if (n3 != n2) {
                    this.m_flagsBuffer.data[n2] = this.m_flagsBuffer.data[n3];
                    ((Vec2[])this.m_positionBuffer.data)[n2].set(((Vec2[])this.m_positionBuffer.data)[n3]);
                    ((Vec2[])this.m_velocityBuffer.data)[n2].set(((Vec2[])this.m_velocityBuffer.data)[n3]);
                    this.m_groupBuffer[n2] = this.m_groupBuffer[n3];
                    if (this.m_depthBuffer != null) {
                        this.m_depthBuffer[n2] = this.m_depthBuffer[n3];
                    }
                    if (this.m_colorBuffer.data != null) {
                        ((ParticleColor[])this.m_colorBuffer.data)[n2].set(((ParticleColor[])this.m_colorBuffer.data)[n3]);
                    }
                    if (this.m_userDataBuffer.data != null) {
                        this.m_userDataBuffer.data[n2] = this.m_userDataBuffer.data[n3];
                    }
                }
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.m_proxyCount) {
            Proxy proxy = this.m_proxyBuffer[n3];
            proxy.index = nArray[proxy.index];
            ++n3;
        }
        n3 = this.m_proxyCount;
        n = 0;
        while (n < n3) {
            if (Test.IsProxyInvalid(this.m_proxyBuffer[n])) {
                object = this.m_proxyBuffer[--n3];
                this.m_proxyBuffer[n3] = this.m_proxyBuffer[n];
                this.m_proxyBuffer[n] = object;
                --n;
            }
            ++n;
        }
        this.m_proxyCount = n3;
        n = 0;
        while (n < this.m_contactCount) {
            object = this.m_contactBuffer[n];
            ((ParticleContact)object).indexA = nArray[((ParticleContact)object).indexA];
            ((ParticleContact)object).indexB = nArray[((ParticleContact)object).indexB];
            ++n;
        }
        n3 = this.m_contactCount;
        n = 0;
        while (n < n3) {
            if (Test.IsContactInvalid(this.m_contactBuffer[n])) {
                object = this.m_contactBuffer[--n3];
                this.m_contactBuffer[n3] = this.m_contactBuffer[n];
                this.m_contactBuffer[n] = object;
                --n;
            }
            ++n;
        }
        this.m_contactCount = n3;
        n = 0;
        while (n < this.m_bodyContactCount) {
            object = this.m_bodyContactBuffer[n];
            ((ParticleBodyContact)object).index = nArray[((ParticleBodyContact)object).index];
            ++n;
        }
        n3 = this.m_bodyContactCount;
        n = 0;
        while (n < n3) {
            if (Test.IsBodyContactInvalid(this.m_bodyContactBuffer[n])) {
                object = this.m_bodyContactBuffer[--n3];
                this.m_bodyContactBuffer[n3] = this.m_bodyContactBuffer[n];
                this.m_bodyContactBuffer[n] = object;
                --n;
            }
            ++n;
        }
        this.m_bodyContactCount = n3;
        n = 0;
        while (n < this.m_pairCount) {
            object = this.m_pairBuffer[n];
            ((Pair)object).indexA = nArray[((Pair)object).indexA];
            ((Pair)object).indexB = nArray[((Pair)object).indexB];
            ++n;
        }
        n3 = this.m_pairCount;
        n = 0;
        while (n < n3) {
            if (Test.IsPairInvalid(this.m_pairBuffer[n])) {
                object = this.m_pairBuffer[--n3];
                this.m_pairBuffer[n3] = this.m_pairBuffer[n];
                this.m_pairBuffer[n] = object;
                --n;
            }
            ++n;
        }
        this.m_pairCount = n3;
        n = 0;
        while (n < this.m_triadCount) {
            object = this.m_triadBuffer[n];
            ((Triad)object).indexA = nArray[((Triad)object).indexA];
            ((Triad)object).indexB = nArray[((Triad)object).indexB];
            ((Triad)object).indexC = nArray[((Triad)object).indexC];
            ++n;
        }
        n3 = this.m_triadCount;
        n = 0;
        while (n < n3) {
            if (Test.IsTriadInvalid(this.m_triadBuffer[n])) {
                object = this.m_triadBuffer[--n3];
                this.m_triadBuffer[n3] = this.m_triadBuffer[n];
                this.m_triadBuffer[n] = object;
                --n;
            }
            ++n;
        }
        this.m_triadCount = n3;
        ParticleGroup particleGroup = this.m_groupList;
        while (particleGroup != null) {
            int n4 = n2;
            int n5 = 0;
            boolean bl = false;
            int n6 = particleGroup.m_firstIndex;
            while (n6 < particleGroup.m_lastIndex) {
                n3 = nArray[n6];
                if (n3 >= 0) {
                    n4 = MathUtils.min(n4, n3);
                    n5 = MathUtils.max(n5, n3 + 1);
                } else {
                    bl = true;
                }
                ++n6;
            }
            if (n4 < n5) {
                particleGroup.m_firstIndex = n4;
                particleGroup.m_lastIndex = n5;
                if (bl && (particleGroup.m_groupFlags & 2) != 0) {
                    particleGroup.m_toBeSplit = true;
                }
            } else {
                particleGroup.m_firstIndex = 0;
                particleGroup.m_lastIndex = 0;
                if (particleGroup.m_destroyAutomatically) {
                    particleGroup.m_toBeDestroyed = true;
                }
            }
            particleGroup = particleGroup.getNext();
        }
        this.m_count = n2;
        particleGroup = this.m_groupList;
        while (particleGroup != null) {
            ParticleGroup particleGroup2 = particleGroup.getNext();
            if (particleGroup.m_toBeDestroyed) {
                this.destroyParticleGroup(particleGroup);
            } else {
                boolean cfr_ignored_0 = particleGroup.m_toBeSplit;
            }
            particleGroup = particleGroup2;
        }
    }

    void RotateBuffer(int n, int n2, int n3) {
        Object object;
        if (n == n2 || n2 == n3) {
            return;
        }
        this.newIndices.start = n;
        this.newIndices.mid = n2;
        this.newIndices.end = n3;
        BufferUtils.rotate(this.m_flagsBuffer.data, n, n2, n3);
        BufferUtils.rotate((Vec2[])this.m_positionBuffer.data, n, n2, n3);
        BufferUtils.rotate((Vec2[])this.m_velocityBuffer.data, n, n2, n3);
        BufferUtils.rotate(this.m_groupBuffer, n, n2, n3);
        if (this.m_depthBuffer != null) {
            BufferUtils.rotate(this.m_depthBuffer, n, n2, n3);
        }
        if (this.m_colorBuffer.data != null) {
            BufferUtils.rotate((ParticleColor[])this.m_colorBuffer.data, n, n2, n3);
        }
        if (this.m_userDataBuffer.data != null) {
            BufferUtils.rotate(this.m_userDataBuffer.data, n, n2, n3);
        }
        int n4 = 0;
        while (n4 < this.m_proxyCount) {
            object = this.m_proxyBuffer[n4];
            ((Proxy)object).index = this.newIndices.getIndex(((Proxy)object).index);
            ++n4;
        }
        n4 = 0;
        while (n4 < this.m_contactCount) {
            object = this.m_contactBuffer[n4];
            ((ParticleContact)object).indexA = this.newIndices.getIndex(((ParticleContact)object).indexA);
            ((ParticleContact)object).indexB = this.newIndices.getIndex(((ParticleContact)object).indexB);
            ++n4;
        }
        n4 = 0;
        while (n4 < this.m_bodyContactCount) {
            object = this.m_bodyContactBuffer[n4];
            ((ParticleBodyContact)object).index = this.newIndices.getIndex(((ParticleBodyContact)object).index);
            ++n4;
        }
        n4 = 0;
        while (n4 < this.m_pairCount) {
            object = this.m_pairBuffer[n4];
            ((Pair)object).indexA = this.newIndices.getIndex(((Pair)object).indexA);
            ((Pair)object).indexB = this.newIndices.getIndex(((Pair)object).indexB);
            ++n4;
        }
        n4 = 0;
        while (n4 < this.m_triadCount) {
            object = this.m_triadBuffer[n4];
            ((Triad)object).indexA = this.newIndices.getIndex(((Triad)object).indexA);
            ((Triad)object).indexB = this.newIndices.getIndex(((Triad)object).indexB);
            ((Triad)object).indexC = this.newIndices.getIndex(((Triad)object).indexC);
            ++n4;
        }
        ParticleGroup particleGroup = this.m_groupList;
        while (particleGroup != null) {
            particleGroup.m_firstIndex = this.newIndices.getIndex(particleGroup.m_firstIndex);
            particleGroup.m_lastIndex = this.newIndices.getIndex(particleGroup.m_lastIndex - 1) + 1;
            particleGroup = particleGroup.getNext();
        }
    }

    public void setParticleRadius(float f) {
        this.m_particleDiameter = 2.0f * f;
        this.m_squaredDiameter = this.m_particleDiameter * this.m_particleDiameter;
        this.m_inverseDiameter = 1.0f / this.m_particleDiameter;
    }

    public void setParticleDensity(float f) {
        this.m_density = f;
        this.m_inverseDensity = 1.0f / this.m_density;
    }

    public float getParticleDensity() {
        return this.m_density;
    }

    public void setParticleGravityScale(float f) {
        this.m_gravityScale = f;
    }

    public float getParticleGravityScale() {
        return this.m_gravityScale;
    }

    public void setParticleDamping(float f) {
        this.m_dampingStrength = f;
    }

    public float getParticleDamping() {
        return this.m_dampingStrength;
    }

    public float getParticleRadius() {
        return this.m_particleDiameter / 2.0f;
    }

    float getCriticalVelocity(TimeStep timeStep) {
        return this.m_particleDiameter * timeStep.inv_dt;
    }

    float getCriticalVelocitySquared(TimeStep timeStep) {
        float f = this.getCriticalVelocity(timeStep);
        return f * f;
    }

    float getCriticalPressure(TimeStep timeStep) {
        return this.m_density * this.getCriticalVelocitySquared(timeStep);
    }

    float getParticleStride() {
        return 0.75f * this.m_particleDiameter;
    }

    float getParticleMass() {
        float f = this.getParticleStride();
        return this.m_density * f * f;
    }

    float getParticleInvMass() {
        return 1.777777f * this.m_inverseDensity * this.m_inverseDiameter * this.m_inverseDiameter;
    }

    public int[] getParticleFlagsBuffer() {
        return this.m_flagsBuffer.data;
    }

    public Vec2[] getParticlePositionBuffer() {
        return (Vec2[])this.m_positionBuffer.data;
    }

    public Vec2[] getParticleVelocityBuffer() {
        return (Vec2[])this.m_velocityBuffer.data;
    }

    public ParticleColor[] getParticleColorBuffer() {
        this.m_colorBuffer.data = this.requestParticleBuffer(ParticleColor.class, (ParticleColor[])this.m_colorBuffer.data);
        return (ParticleColor[])this.m_colorBuffer.data;
    }

    public Object[] getParticleUserDataBuffer() {
        this.m_userDataBuffer.data = this.requestParticleBuffer(Object.class, this.m_userDataBuffer.data);
        return this.m_userDataBuffer.data;
    }

    public int getParticleMaxCount() {
        return this.m_maxCount;
    }

    public void setParticleMaxCount(int n) {
        assert (this.m_count <= n);
        this.m_maxCount = n;
    }

    void setParticleBuffer(ParticleBufferInt particleBufferInt, int[] nArray, int n) {
        assert (nArray != null == (n != 0));
        int cfr_ignored_0 = particleBufferInt.userSuppliedCapacity;
        particleBufferInt.data = nArray;
        particleBufferInt.userSuppliedCapacity = n;
    }

    <T> void setParticleBuffer(ParticleBuffer<T> particleBuffer, T[] TArray, int n) {
        assert (TArray != null == (n != 0));
        int cfr_ignored_0 = particleBuffer.userSuppliedCapacity;
        particleBuffer.data = TArray;
        particleBuffer.userSuppliedCapacity = n;
    }

    public void setParticleFlagsBuffer(int[] nArray, int n) {
        this.setParticleBuffer(this.m_flagsBuffer, nArray, n);
    }

    public void setParticlePositionBuffer(Vec2[] vec2Array, int n) {
        this.setParticleBuffer(this.m_positionBuffer, vec2Array, n);
    }

    public void setParticleVelocityBuffer(Vec2[] vec2Array, int n) {
        this.setParticleBuffer(this.m_velocityBuffer, vec2Array, n);
    }

    public void setParticleColorBuffer(ParticleColor[] particleColorArray, int n) {
        this.setParticleBuffer(this.m_colorBuffer, particleColorArray, n);
    }

    public ParticleGroup[] getParticleGroupBuffer() {
        return this.m_groupBuffer;
    }

    public int getParticleGroupCount() {
        return this.m_groupCount;
    }

    public ParticleGroup[] getParticleGroupList() {
        return this.m_groupBuffer;
    }

    public int getParticleCount() {
        return this.m_count;
    }

    public void setParticleUserDataBuffer(Object[] objectArray, int n) {
        this.setParticleBuffer(this.m_userDataBuffer, objectArray, n);
    }

    private static final int lowerBound(Proxy[] proxyArray, int n, long l) {
        int n2 = 0;
        while (n > 0) {
            int n3 = n / 2;
            int n4 = n2 + n3;
            if (proxyArray[n4].tag < l) {
                n2 = n4 + 1;
                n -= n3 + 1;
                continue;
            }
            n = n3;
        }
        return n2;
    }

    private static final int upperBound(Proxy[] proxyArray, int n, long l) {
        int n2 = 0;
        while (n > 0) {
            int n3 = n / 2;
            int n4 = n2 + n3;
            if (proxyArray[n4].tag <= l) {
                n2 = n4 + 1;
                n -= n3 + 1;
                continue;
            }
            n = n3;
        }
        return n2;
    }

    public void queryAABB(ParticleQueryCallback particleQueryCallback, AABB aABB) {
        if (this.m_proxyCount == 0) {
            return;
        }
        float f = aABB.lowerBound.x;
        float f2 = aABB.lowerBound.y;
        float f3 = aABB.upperBound.x;
        float f4 = aABB.upperBound.y;
        int n = ParticleSystem.lowerBound(this.m_proxyBuffer, this.m_proxyCount, ParticleSystem.computeTag(this.m_inverseDiameter * f, this.m_inverseDiameter * f2));
        int n2 = ParticleSystem.upperBound(this.m_proxyBuffer, this.m_proxyCount, ParticleSystem.computeTag(this.m_inverseDiameter * f3, this.m_inverseDiameter * f4));
        int n3 = n;
        while (n3 < n2) {
            int n4 = this.m_proxyBuffer[n3].index;
            Vec2 vec2 = ((Vec2[])this.m_positionBuffer.data)[n4];
            if (f < vec2.x && vec2.x < f3 && f2 < vec2.y && vec2.y < f4 && !particleQueryCallback.reportParticle(n4)) break;
            ++n3;
        }
    }

    public void raycast(ParticleRaycastCallback particleRaycastCallback, Vec2 vec2, Vec2 vec22) {
        if (this.m_proxyCount == 0) {
            return;
        }
        int n = ParticleSystem.lowerBound(this.m_proxyBuffer, this.m_proxyCount, ParticleSystem.computeTag(this.m_inverseDiameter * MathUtils.min(vec2.x, vec22.x) - 1.0f, this.m_inverseDiameter * MathUtils.min(vec2.y, vec22.y) - 1.0f));
        int n2 = ParticleSystem.upperBound(this.m_proxyBuffer, this.m_proxyCount, ParticleSystem.computeTag(this.m_inverseDiameter * MathUtils.max(vec2.x, vec22.x) + 1.0f, this.m_inverseDiameter * MathUtils.max(vec2.y, vec22.y) + 1.0f));
        float f = 1.0f;
        float f2 = vec22.x - vec2.x;
        float f3 = vec22.y - vec2.y;
        float f4 = f2 * f2 + f3 * f3;
        if (f4 == 0.0f) {
            f4 = Float.MAX_VALUE;
        }
        int n3 = n;
        while (n3 < n2) {
            float f5;
            float f6;
            int n4 = this.m_proxyBuffer[n3].index;
            Vec2 vec23 = ((Vec2[])this.m_positionBuffer.data)[n4];
            float f7 = vec2.x - vec23.x;
            float f8 = vec2.y - vec23.y;
            float f9 = f7 * f2 + f8 * f3;
            float f10 = f7 * f7 + f8 * f8;
            float f11 = f9 * f9 - f4 * (f10 - this.m_squaredDiameter);
            if (!(!(f11 >= 0.0f) || (f6 = (-f9 - (f5 = MathUtils.sqrt(f11))) / f4) > f || f6 < 0.0f && ((f6 = (-f9 + f5) / f4) < 0.0f || f6 > f))) {
                Vec2 vec24 = this.tempVec;
                this.tempVec.x = f7 + f6 * f2;
                this.tempVec.y = f8 + f6 * f3;
                vec24.normalize();
                Vec2 vec25 = this.tempVec2;
                vec25.x = vec2.x + f6 * f2;
                vec25.y = vec2.y + f6 * f3;
                float f12 = particleRaycastCallback.reportParticle(n4, vec25, vec24, f6);
                f = MathUtils.min(f, f12);
                if (f <= 0.0f) break;
            }
            ++n3;
        }
    }

    public float computeParticleCollisionEnergy() {
        float f = 0.0f;
        int n = 0;
        while (n < this.m_contactCount) {
            ParticleContact particleContact = this.m_contactBuffer[n];
            int n2 = particleContact.indexA;
            int n3 = particleContact.indexB;
            Vec2 vec2 = particleContact.normal;
            Vec2 vec22 = ((Vec2[])this.m_velocityBuffer.data)[n2];
            Vec2 vec23 = ((Vec2[])this.m_velocityBuffer.data)[n3];
            float f2 = vec23.x - vec22.x;
            float f3 = vec23.y - vec22.y;
            float f4 = f2 * vec2.x + f3 * vec2.y;
            if (f4 < 0.0f) {
                f += f4 * f4;
            }
            ++n;
        }
        return 0.5f * this.getParticleMass() * f;
    }

    static <T> T[] reallocateBuffer(ParticleBuffer<T> particleBuffer, int n, int n2, boolean bl) {
        assert (n2 > n);
        return BufferUtils.reallocateBuffer(particleBuffer.dataClass, particleBuffer.data, particleBuffer.userSuppliedCapacity, n, n2, bl);
    }

    static int[] reallocateBuffer(ParticleBufferInt particleBufferInt, int n, int n2, boolean bl) {
        assert (n2 > n);
        return BufferUtils.reallocateBuffer(particleBufferInt.data, particleBufferInt.userSuppliedCapacity, n, n2, bl);
    }

    <T> T[] requestParticleBuffer(Class<T> clazz, T[] objectArray) {
        if (objectArray == null) {
            objectArray = (Object[])Array.newInstance(clazz, this.m_internalAllocatedCapacity);
            int n = 0;
            while (n < this.m_internalAllocatedCapacity) {
                try {
                    objectArray[n] = clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                ++n;
            }
        }
        return objectArray;
    }

    float[] requestParticleBuffer(float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.m_internalAllocatedCapacity];
        }
        return fArray;
    }

    static class CreateParticleGroupCallback
    implements VoronoiDiagram.VoronoiDiagramCallback {
        ParticleSystem system;
        ParticleGroupDef def;
        int firstIndex;

        CreateParticleGroupCallback() {
        }

        @Override
        public void callback(int n, int n2, int n3) {
            Vec2 vec2 = ((Vec2[])this.system.m_positionBuffer.data)[n];
            Vec2 vec22 = ((Vec2[])this.system.m_positionBuffer.data)[n2];
            Vec2 vec23 = ((Vec2[])this.system.m_positionBuffer.data)[n3];
            float f = vec2.x - vec22.x;
            float f2 = vec2.y - vec22.y;
            float f3 = vec22.x - vec23.x;
            float f4 = vec22.y - vec23.y;
            float f5 = vec23.x - vec2.x;
            float f6 = vec23.y - vec2.y;
            float f7 = 4.0f * this.system.m_squaredDiameter;
            if (f * f + f2 * f2 < f7 && f3 * f3 + f4 * f4 < f7 && f5 * f5 + f6 * f6 < f7) {
                if (this.system.m_triadCount >= this.system.m_triadCapacity) {
                    int n4 = this.system.m_triadCapacity;
                    int n5 = this.system.m_triadCount != 0 ? 2 * this.system.m_triadCount : 256;
                    this.system.m_triadBuffer = BufferUtils.reallocateBuffer(Triad.class, this.system.m_triadBuffer, n4, n5);
                    this.system.m_triadCapacity = n5;
                }
                Triad triad = this.system.m_triadBuffer[this.system.m_triadCount];
                triad.indexA = n;
                triad.indexB = n2;
                triad.indexC = n3;
                triad.flags = this.system.m_flagsBuffer.data[n] | this.system.m_flagsBuffer.data[n2] | this.system.m_flagsBuffer.data[n3];
                triad.strength = this.def.strength;
                float f8 = 0.33333334f * (vec2.x + vec22.x + vec23.x);
                float f9 = 0.33333334f * (vec2.y + vec22.y + vec23.y);
                triad.pa.x = vec2.x - f8;
                triad.pa.y = vec2.y - f9;
                triad.pb.x = vec22.x - f8;
                triad.pb.y = vec22.y - f9;
                triad.pc.x = vec23.x - f8;
                triad.pc.y = vec23.y - f9;
                triad.ka = -(f5 * f + f6 * f2);
                triad.kb = -(f * f3 + f2 * f4);
                triad.kc = -(f3 * f5 + f4 * f6);
                triad.s = Vec2.cross(vec2, vec22) + Vec2.cross(vec22, vec23) + Vec2.cross(vec23, vec2);
                ++this.system.m_triadCount;
            }
        }
    }

    static class DestroyParticlesInShapeCallback
    implements ParticleQueryCallback {
        ParticleSystem system;
        Shape shape;
        Transform xf;
        boolean callDestructionListener;
        int destroyed;

        public void init(ParticleSystem particleSystem, Shape shape, Transform transform, boolean bl) {
            this.system = particleSystem;
            this.shape = shape;
            this.xf = transform;
            this.destroyed = 0;
            this.callDestructionListener = bl;
        }

        @Override
        public boolean reportParticle(int n) {
            assert (n >= 0 && n < this.system.m_count);
            if (this.shape.testPoint(this.xf, ((Vec2[])this.system.m_positionBuffer.data)[n])) {
                this.system.destroyParticle(n, this.callDestructionListener);
                ++this.destroyed;
            }
            return true;
        }
    }

    static class JoinParticleGroupsCallback
    implements VoronoiDiagram.VoronoiDiagramCallback {
        ParticleSystem system;
        ParticleGroup groupA;
        ParticleGroup groupB;

        JoinParticleGroupsCallback() {
        }

        @Override
        public void callback(int n, int n2, int n3) {
            int n4;
            int n5;
            int n6;
            int n7 = (n < this.groupB.m_firstIndex ? 1 : 0) + (n2 < this.groupB.m_firstIndex ? 1 : 0) + (n3 < this.groupB.m_firstIndex ? 1 : 0);
            if (n7 > 0 && n7 < 3 && ((n6 = this.system.m_flagsBuffer.data[n]) & (n5 = this.system.m_flagsBuffer.data[n2]) & (n4 = this.system.m_flagsBuffer.data[n3]) & 0x10) != 0) {
                Vec2 vec2 = ((Vec2[])this.system.m_positionBuffer.data)[n];
                Vec2 vec22 = ((Vec2[])this.system.m_positionBuffer.data)[n2];
                Vec2 vec23 = ((Vec2[])this.system.m_positionBuffer.data)[n3];
                float f = vec2.x - vec22.x;
                float f2 = vec2.y - vec22.y;
                float f3 = vec22.x - vec23.x;
                float f4 = vec22.y - vec23.y;
                float f5 = vec23.x - vec2.x;
                float f6 = vec23.y - vec2.y;
                float f7 = 4.0f * this.system.m_squaredDiameter;
                if (f * f + f2 * f2 < f7 && f3 * f3 + f4 * f4 < f7 && f5 * f5 + f6 * f6 < f7) {
                    if (this.system.m_triadCount >= this.system.m_triadCapacity) {
                        int n8 = this.system.m_triadCapacity;
                        int n9 = this.system.m_triadCount != 0 ? 2 * this.system.m_triadCount : 256;
                        this.system.m_triadBuffer = BufferUtils.reallocateBuffer(Triad.class, this.system.m_triadBuffer, n8, n9);
                        this.system.m_triadCapacity = n9;
                    }
                    Triad triad = this.system.m_triadBuffer[this.system.m_triadCount];
                    triad.indexA = n;
                    triad.indexB = n2;
                    triad.indexC = n3;
                    triad.flags = n6 | n5 | n4;
                    triad.strength = MathUtils.min(this.groupA.m_strength, this.groupB.m_strength);
                    float f8 = 0.33333334f * (vec2.x + vec22.x + vec23.x);
                    float f9 = 0.33333334f * (vec2.y + vec22.y + vec23.y);
                    triad.pa.x = vec2.x - f8;
                    triad.pa.y = vec2.y - f9;
                    triad.pb.x = vec22.x - f8;
                    triad.pb.y = vec22.y - f9;
                    triad.pc.x = vec23.x - f8;
                    triad.pc.y = vec23.y - f9;
                    triad.ka = -(f5 * f + f6 * f2);
                    triad.kb = -(f * f3 + f2 * f4);
                    triad.kc = -(f3 * f5 + f4 * f6);
                    triad.s = Vec2.cross(vec2, vec22) + Vec2.cross(vec22, vec23) + Vec2.cross(vec23, vec2);
                    ++this.system.m_triadCount;
                }
            }
        }
    }

    private static class NewIndices {
        int start;
        int mid;
        int end;

        private NewIndices() {
        }

        final int getIndex(int n) {
            if (n < this.start) {
                return n;
            }
            if (n < this.mid) {
                return n + this.end - this.mid;
            }
            if (n < this.end) {
                return n + this.start - this.mid;
            }
            return n;
        }
    }

    public static class Pair {
        int indexA;
        int indexB;
        int flags;
        float strength;
        float distance;
    }

    public static class ParticleBuffer<T> {
        public T[] data;
        final Class<T> dataClass;
        int userSuppliedCapacity;

        public ParticleBuffer(Class<T> clazz) {
            this.dataClass = clazz;
        }
    }

    static class ParticleBufferInt {
        int[] data;
        int userSuppliedCapacity;

        ParticleBufferInt() {
        }
    }

    public static class Proxy
    implements Comparable<Proxy> {
        int index;
        long tag;

        @Override
        public int compareTo(Proxy proxy) {
            return this.tag - proxy.tag < 0L ? -1 : (proxy.tag == this.tag ? 0 : 1);
        }
    }

    static class SolveCollisionCallback
    implements QueryCallback {
        ParticleSystem system;
        TimeStep step;
        private final RayCastInput input = new RayCastInput();
        private final RayCastOutput output = new RayCastOutput();
        private final Vec2 tempVec = new Vec2();
        private final Vec2 tempVec2 = new Vec2();

        SolveCollisionCallback() {
        }

        @Override
        public boolean reportFixture(Fixture fixture) {
            if (fixture.isSensor()) {
                return true;
            }
            Shape shape = fixture.getShape();
            Body body = fixture.getBody();
            int n = shape.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                AABB aABB = fixture.getAABB(n2);
                float f = aABB.lowerBound.x - this.system.m_particleDiameter;
                float f2 = aABB.lowerBound.y - this.system.m_particleDiameter;
                float f3 = aABB.upperBound.x + this.system.m_particleDiameter;
                float f4 = aABB.upperBound.y + this.system.m_particleDiameter;
                int n3 = ParticleSystem.lowerBound(this.system.m_proxyBuffer, this.system.m_proxyCount, ParticleSystem.computeTag(this.system.m_inverseDiameter * f, this.system.m_inverseDiameter * f2));
                int n4 = ParticleSystem.upperBound(this.system.m_proxyBuffer, this.system.m_proxyCount, ParticleSystem.computeTag(this.system.m_inverseDiameter * f3, this.system.m_inverseDiameter * f4));
                int n5 = n3;
                while (n5 != n4) {
                    int n6 = this.system.m_proxyBuffer[n5].index;
                    Vec2 vec2 = ((Vec2[])this.system.m_positionBuffer.data)[n6];
                    if (f <= vec2.x && vec2.x <= f3 && f2 <= vec2.y && vec2.y <= f4) {
                        Vec2 vec22 = ((Vec2[])this.system.m_velocityBuffer.data)[n6];
                        Vec2 vec23 = this.tempVec;
                        Transform.mulTransToOutUnsafe(body.m_xf0, vec2, vec23);
                        Transform.mulToOutUnsafe(body.m_xf, vec23, this.input.p1);
                        this.input.p2.x = vec2.x + this.step.dt * vec22.x;
                        this.input.p2.y = vec2.y + this.step.dt * vec22.y;
                        this.input.maxFraction = 1.0f;
                        if (fixture.raycast(this.output, this.input, n2)) {
                            Vec2 vec24 = this.tempVec;
                            vec24.x = (1.0f - this.output.fraction) * this.input.p1.x + this.output.fraction * this.input.p2.x + Settings.linearSlop * this.output.normal.x;
                            vec24.y = (1.0f - this.output.fraction) * this.input.p1.y + this.output.fraction * this.input.p2.y + Settings.linearSlop * this.output.normal.y;
                            float f5 = this.step.inv_dt * (vec24.x - vec2.x);
                            float f6 = this.step.inv_dt * (vec24.y - vec2.y);
                            vec22.x = f5;
                            vec22.y = f6;
                            float f7 = this.system.getParticleMass();
                            float f8 = f7 * (vec22.x - f5);
                            float f9 = f7 * (vec22.y - f6);
                            Vec2 vec25 = this.output.normal;
                            float f10 = f8 * vec25.x + f9 * vec25.y;
                            Vec2 vec26 = this.tempVec2;
                            vec26.x = f10 * vec25.x;
                            vec26.y = f10 * vec25.y;
                            body.applyLinearImpulse(vec26, vec24, true);
                        }
                    }
                    ++n5;
                }
                ++n2;
            }
            return true;
        }
    }

    static class Test {
        Test() {
        }

        static boolean IsProxyInvalid(Proxy proxy) {
            return proxy.index < 0;
        }

        static boolean IsContactInvalid(ParticleContact particleContact) {
            return particleContact.indexA < 0 || particleContact.indexB < 0;
        }

        static boolean IsBodyContactInvalid(ParticleBodyContact particleBodyContact) {
            return particleBodyContact.index < 0;
        }

        static boolean IsPairInvalid(Pair pair) {
            return pair.indexA < 0 || pair.indexB < 0;
        }

        static boolean IsTriadInvalid(Triad triad) {
            return triad.indexA < 0 || triad.indexB < 0 || triad.indexC < 0;
        }
    }

    public static class Triad {
        int indexA;
        int indexB;
        int indexC;
        int flags;
        float strength;
        final Vec2 pa = new Vec2();
        final Vec2 pb = new Vec2();
        final Vec2 pc = new Vec2();
        float ka;
        float kb;
        float kc;
        float s;
    }

    static class UpdateBodyContactsCallback
    implements QueryCallback {
        ParticleSystem system;
        private final Vec2 tempVec = new Vec2();

        UpdateBodyContactsCallback() {
        }

        @Override
        public boolean reportFixture(Fixture fixture) {
            if (fixture.isSensor()) {
                return true;
            }
            Shape shape = fixture.getShape();
            Body body = fixture.getBody();
            Vec2 vec2 = body.getWorldCenter();
            float f = body.getMass();
            float f2 = body.getInertia() - f * body.getLocalCenter().lengthSquared();
            float f3 = f > 0.0f ? 1.0f / f : 0.0f;
            float f4 = f2 > 0.0f ? 1.0f / f2 : 0.0f;
            int n = shape.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                AABB aABB = fixture.getAABB(n2);
                float f5 = aABB.lowerBound.x - this.system.m_particleDiameter;
                float f6 = aABB.lowerBound.y - this.system.m_particleDiameter;
                float f7 = aABB.upperBound.x + this.system.m_particleDiameter;
                float f8 = aABB.upperBound.y + this.system.m_particleDiameter;
                int n3 = ParticleSystem.lowerBound(this.system.m_proxyBuffer, this.system.m_proxyCount, ParticleSystem.computeTag(this.system.m_inverseDiameter * f5, this.system.m_inverseDiameter * f6));
                int n4 = ParticleSystem.upperBound(this.system.m_proxyBuffer, this.system.m_proxyCount, ParticleSystem.computeTag(this.system.m_inverseDiameter * f7, this.system.m_inverseDiameter * f8));
                int n5 = n3;
                while (n5 != n4) {
                    Vec2 vec22;
                    float f9;
                    int n6 = this.system.m_proxyBuffer[n5].index;
                    Vec2 vec23 = ((Vec2[])this.system.m_positionBuffer.data)[n6];
                    if (f5 <= vec23.x && vec23.x <= f7 && f6 <= vec23.y && vec23.y <= f8 && (f9 = fixture.computeDistance(vec23, n2, vec22 = this.tempVec)) < this.system.m_particleDiameter) {
                        float f10 = (this.system.m_flagsBuffer.data[n6] & 4) != 0 ? 0.0f : this.system.getParticleInvMass();
                        float f11 = vec23.x - vec2.x;
                        float f12 = vec23.y - vec2.y;
                        float f13 = f11 * vec22.y - f12 * vec22.x;
                        if (this.system.m_bodyContactCount >= this.system.m_bodyContactCapacity) {
                            int n7 = this.system.m_bodyContactCapacity;
                            int n8 = this.system.m_bodyContactCount != 0 ? 2 * this.system.m_bodyContactCount : 256;
                            this.system.m_bodyContactBuffer = BufferUtils.reallocateBuffer(ParticleBodyContact.class, this.system.m_bodyContactBuffer, n7, n8);
                            this.system.m_bodyContactCapacity = n8;
                        }
                        ParticleBodyContact particleBodyContact = this.system.m_bodyContactBuffer[this.system.m_bodyContactCount];
                        particleBodyContact.index = n6;
                        particleBodyContact.body = body;
                        particleBodyContact.weight = 1.0f - f9 * this.system.m_inverseDiameter;
                        particleBodyContact.normal.x = -vec22.x;
                        particleBodyContact.normal.y = -vec22.y;
                        particleBodyContact.mass = 1.0f / (f10 + f3 + f4 * f13 * f13);
                        ++this.system.m_bodyContactCount;
                    }
                    ++n5;
                }
                ++n2;
            }
            return true;
        }
    }
}

