/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.broadphase;

import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.TreeCallback;
import org.jbox2d.callbacks.TreeRayCastCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.broadphase.BroadPhaseStrategy;
import org.jbox2d.common.BufferUtils;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;

public class DynamicTreeFlatNodes
implements BroadPhaseStrategy {
    public static final int MAX_STACK_SIZE = 64;
    public static final int NULL_NODE = -1;
    public static final int INITIAL_BUFFER_LENGTH = 16;
    public int m_root = -1;
    public AABB[] m_aabb;
    public Object[] m_userData;
    protected int[] m_parent;
    protected int[] m_child1;
    protected int[] m_child2;
    protected int[] m_height;
    private int m_nodeCount = 0;
    private int m_nodeCapacity = 16;
    private int m_freeList;
    private final Vec2[] drawVecs = new Vec2[4];
    private int[] nodeStack = new int[20];
    private int nodeStackIndex;
    private final Vec2 r = new Vec2();
    private final AABB aabb = new AABB();
    private final RayCastInput subInput = new RayCastInput();
    private final AABB combinedAABB = new AABB();
    private final Color3f color = new Color3f();
    private final Vec2 textVec = new Vec2();

    public DynamicTreeFlatNodes() {
        this.expandBuffers(0, this.m_nodeCapacity);
        int n = 0;
        while (n < this.drawVecs.length) {
            this.drawVecs[n] = new Vec2();
            ++n;
        }
    }

    private void expandBuffers(int n, int n2) {
        this.m_aabb = BufferUtils.reallocateBuffer(AABB.class, this.m_aabb, n, n2);
        this.m_userData = BufferUtils.reallocateBuffer(Object.class, this.m_userData, n, n2);
        this.m_parent = BufferUtils.reallocateBuffer(this.m_parent, n, n2);
        this.m_child1 = BufferUtils.reallocateBuffer(this.m_child1, n, n2);
        this.m_child2 = BufferUtils.reallocateBuffer(this.m_child2, n, n2);
        this.m_height = BufferUtils.reallocateBuffer(this.m_height, n, n2);
        int n3 = n;
        while (n3 < n2) {
            this.m_aabb[n3] = new AABB();
            this.m_parent[n3] = n3 == n2 - 1 ? -1 : n3 + 1;
            this.m_height[n3] = -1;
            this.m_child1[n3] = -1;
            this.m_child2[n3] = -1;
            ++n3;
        }
        this.m_freeList = n;
    }

    @Override
    public final int createProxy(AABB aABB, Object object) {
        int n = this.allocateNode();
        AABB aABB2 = this.m_aabb[n];
        aABB2.lowerBound.x = aABB.lowerBound.x - Settings.aabbExtension;
        aABB2.lowerBound.y = aABB.lowerBound.y - Settings.aabbExtension;
        aABB2.upperBound.x = aABB.upperBound.x + Settings.aabbExtension;
        aABB2.upperBound.y = aABB.upperBound.y + Settings.aabbExtension;
        this.m_userData[n] = object;
        this.insertLeaf(n);
        return n;
    }

    @Override
    public final void destroyProxy(int n) {
        assert (n >= 0 && n < this.m_nodeCapacity);
        assert (this.m_child1[n] == -1);
        this.removeLeaf(n);
        this.freeNode(n);
    }

    @Override
    public final boolean moveProxy(int n, AABB aABB, Vec2 vec2) {
        assert (n >= 0 && n < this.m_nodeCapacity);
        int n2 = n;
        assert (this.m_child1[n2] == -1);
        AABB aABB2 = this.m_aabb[n2];
        if (aABB2.lowerBound.x <= aABB.lowerBound.x && aABB2.lowerBound.y <= aABB.lowerBound.y && aABB.upperBound.x <= aABB2.upperBound.x && aABB.upperBound.y <= aABB2.upperBound.y) {
            return false;
        }
        this.removeLeaf(n2);
        Vec2 vec22 = aABB2.lowerBound;
        Vec2 vec23 = aABB2.upperBound;
        vec22.x = aABB.lowerBound.x - Settings.aabbExtension;
        vec22.y = aABB.lowerBound.y - Settings.aabbExtension;
        vec23.x = aABB.upperBound.x + Settings.aabbExtension;
        vec23.y = aABB.upperBound.y + Settings.aabbExtension;
        float f = vec2.x * Settings.aabbMultiplier;
        float f2 = vec2.y * Settings.aabbMultiplier;
        if (f < 0.0f) {
            vec22.x += f;
        } else {
            vec23.x += f;
        }
        if (f2 < 0.0f) {
            vec22.y += f2;
        } else {
            vec23.y += f2;
        }
        this.insertLeaf(n);
        return true;
    }

    @Override
    public final Object getUserData(int n) {
        assert (n >= 0 && n < this.m_nodeCount);
        return this.m_userData[n];
    }

    @Override
    public final AABB getFatAABB(int n) {
        assert (n >= 0 && n < this.m_nodeCount);
        return this.m_aabb[n];
    }

    @Override
    public final void query(TreeCallback treeCallback, AABB aABB) {
        this.nodeStackIndex = 0;
        this.nodeStack[this.nodeStackIndex++] = this.m_root;
        while (this.nodeStackIndex > 0) {
            int n;
            if ((n = this.nodeStack[--this.nodeStackIndex]) == -1 || !AABB.testOverlap(this.m_aabb[n], aABB)) continue;
            int n2 = this.m_child1[n];
            if (n2 == -1) {
                boolean bl = treeCallback.treeCallback(n);
                if (bl) continue;
                return;
            }
            if (this.nodeStack.length - this.nodeStackIndex - 2 <= 0) {
                this.nodeStack = BufferUtils.reallocateBuffer(this.nodeStack, this.nodeStack.length, this.nodeStack.length * 2);
            }
            this.nodeStack[this.nodeStackIndex++] = n2;
            this.nodeStack[this.nodeStackIndex++] = this.m_child2[n];
        }
    }

    @Override
    public void raycast(TreeRayCastCallback treeRayCastCallback, RayCastInput rayCastInput) {
        Vec2 vec2 = rayCastInput.p1;
        Vec2 vec22 = rayCastInput.p2;
        float f = vec2.x;
        float f2 = vec22.x;
        float f3 = vec2.y;
        float f4 = vec22.y;
        this.r.x = f2 - f;
        this.r.y = f4 - f3;
        assert (this.r.x * this.r.x + this.r.y * this.r.y > 0.0f);
        this.r.normalize();
        float f5 = this.r.x;
        float f6 = this.r.y;
        float f7 = -1.0f * f6;
        float f8 = 1.0f * f5;
        float f9 = MathUtils.abs(f7);
        float f10 = MathUtils.abs(f8);
        float f11 = rayCastInput.maxFraction;
        AABB aABB = this.aabb;
        float f12 = (f2 - f) * f11 + f;
        float f13 = (f4 - f3) * f11 + f3;
        aABB.lowerBound.x = f < f12 ? f : f12;
        aABB.lowerBound.y = f3 < f13 ? f3 : f13;
        aABB.upperBound.x = f > f12 ? f : f12;
        aABB.upperBound.y = f3 > f13 ? f3 : f13;
        this.nodeStackIndex = 0;
        this.nodeStack[this.nodeStackIndex++] = this.m_root;
        while (this.nodeStackIndex > 0) {
            AABB aABB2;
            this.nodeStack[--this.nodeStackIndex] = this.m_root;
            int n = this.nodeStack[--this.nodeStackIndex];
            if (n == -1 || !AABB.testOverlap(aABB2 = this.m_aabb[n], aABB)) continue;
            float f14 = (aABB2.lowerBound.x + aABB2.upperBound.x) * 0.5f;
            float f15 = (aABB2.lowerBound.y + aABB2.upperBound.y) * 0.5f;
            float f16 = (aABB2.upperBound.x - aABB2.lowerBound.x) * 0.5f;
            float f17 = (aABB2.upperBound.y - aABB2.lowerBound.y) * 0.5f;
            f12 = f - f14;
            f13 = f3 - f15;
            float f18 = MathUtils.abs(f7 * f12 + f8 * f13) - (f9 * f16 + f10 * f17);
            if (f18 > 0.0f) continue;
            int n2 = this.m_child1[n];
            if (n2 == -1) {
                this.subInput.p1.x = f;
                this.subInput.p1.y = f3;
                this.subInput.p2.x = f2;
                this.subInput.p2.y = f4;
                this.subInput.maxFraction = f11;
                float f19 = treeRayCastCallback.raycastCallback(this.subInput, n);
                if (f19 == 0.0f) {
                    return;
                }
                if (!(f19 > 0.0f)) continue;
                f11 = f19;
                f12 = (f2 - f) * f11 + f;
                f13 = (f4 - f3) * f11 + f3;
                aABB.lowerBound.x = f < f12 ? f : f12;
                aABB.lowerBound.y = f3 < f13 ? f3 : f13;
                aABB.upperBound.x = f > f12 ? f : f12;
                aABB.upperBound.y = f3 > f13 ? f3 : f13;
                continue;
            }
            this.nodeStack[this.nodeStackIndex++] = n2;
            this.nodeStack[this.nodeStackIndex++] = this.m_child2[n];
        }
    }

    @Override
    public final int computeHeight() {
        return this.computeHeight(this.m_root);
    }

    private final int computeHeight(int n) {
        assert (n >= 0 && n < this.m_nodeCapacity);
        if (this.m_child1[n] == -1) {
            return 0;
        }
        int n2 = this.computeHeight(this.m_child1[n]);
        int n3 = this.computeHeight(this.m_child2[n]);
        return 1 + MathUtils.max(n2, n3);
    }

    public void validate() {
        this.validateStructure(this.m_root);
        this.validateMetrics(this.m_root);
        int n = 0;
        int n2 = this.m_freeList;
        while (n2 != -1) {
            assert (n2 >= 0 && n2 < this.m_nodeCapacity);
            n2 = this.m_parent[n2];
            ++n;
        }
        assert (this.getHeight() == this.computeHeight());
        assert (this.m_nodeCount + n == this.m_nodeCapacity);
    }

    @Override
    public int getHeight() {
        if (this.m_root == -1) {
            return 0;
        }
        return this.m_height[this.m_root];
    }

    @Override
    public int getMaxBalance() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_nodeCapacity) {
            if (this.m_height[n2] > 1) {
                assert (this.m_child1[n2] != -1);
                int n3 = this.m_child1[n2];
                int n4 = this.m_child2[n2];
                int n5 = MathUtils.abs(this.m_height[n4] - this.m_height[n3]);
                n = MathUtils.max(n, n5);
            }
            ++n2;
        }
        return n;
    }

    @Override
    public float getAreaRatio() {
        if (this.m_root == -1) {
            return 0.0f;
        }
        int n = this.m_root;
        float f = this.m_aabb[n].getPerimeter();
        float f2 = 0.0f;
        int n2 = 0;
        while (n2 < this.m_nodeCapacity) {
            if (this.m_height[n2] >= 0) {
                f2 += this.m_aabb[n2].getPerimeter();
            }
            ++n2;
        }
        return f2 / f;
    }

    private final int allocateNode() {
        if (this.m_freeList == -1) {
            assert (this.m_nodeCount == this.m_nodeCapacity);
            this.m_nodeCapacity *= 2;
            this.expandBuffers(this.m_nodeCount, this.m_nodeCapacity);
        }
        assert (this.m_freeList != -1);
        int n = this.m_freeList;
        this.m_freeList = this.m_parent[n];
        this.m_parent[n] = -1;
        this.m_child1[n] = -1;
        this.m_height[n] = 0;
        ++this.m_nodeCount;
        return n;
    }

    private final void freeNode(int n) {
        assert (n != -1);
        assert (this.m_nodeCount > 0);
        this.m_parent[n] = this.m_freeList != -1 ? this.m_freeList : -1;
        this.m_height[n] = -1;
        this.m_freeList = n;
        --this.m_nodeCount;
    }

    private final void insertLeaf(int n) {
        int n2;
        int n3;
        int n4;
        if (this.m_root == -1) {
            this.m_root = n;
            this.m_parent[this.m_root] = -1;
            return;
        }
        AABB aABB = this.m_aabb[n];
        int n5 = this.m_root;
        while (this.m_child1[n5] != -1) {
            float f;
            float f2;
            n4 = n5;
            n3 = this.m_child1[n4];
            n2 = this.m_child2[n4];
            AABB aABB2 = this.m_aabb[n4];
            float f3 = aABB2.getPerimeter();
            this.combinedAABB.combine(aABB2, aABB);
            float f4 = this.combinedAABB.getPerimeter();
            float f5 = 2.0f * f4;
            float f6 = 2.0f * (f4 - f3);
            AABB aABB3 = this.m_aabb[n3];
            if (this.m_child1[n3] == -1) {
                this.combinedAABB.combine(aABB, aABB3);
                f2 = this.combinedAABB.getPerimeter() + f6;
            } else {
                this.combinedAABB.combine(aABB, aABB3);
                f = aABB3.getPerimeter();
                float f7 = this.combinedAABB.getPerimeter();
                f2 = f7 - f + f6;
            }
            AABB aABB4 = this.m_aabb[n2];
            if (this.m_child1[n2] == -1) {
                this.combinedAABB.combine(aABB, aABB4);
                f = this.combinedAABB.getPerimeter() + f6;
            } else {
                this.combinedAABB.combine(aABB, aABB4);
                float f8 = aABB4.getPerimeter();
                float f9 = this.combinedAABB.getPerimeter();
                f = f9 - f8 + f6;
            }
            if (f5 < f2 && f5 < f) break;
            n5 = f2 < f ? n3 : n2;
        }
        n4 = n5;
        n3 = this.m_parent[n4];
        n2 = this.allocateNode();
        this.m_parent[n2] = n3;
        this.m_userData[n2] = null;
        this.m_aabb[n2].combine(aABB, this.m_aabb[n4]);
        this.m_height[n2] = this.m_height[n4] + 1;
        if (n3 != -1) {
            if (this.m_child1[n3] == n4) {
                this.m_child1[n3] = n2;
            } else {
                this.m_child2[n3] = n2;
            }
            this.m_child1[n2] = n4;
            this.m_child2[n2] = n;
            this.m_parent[n4] = n2;
            this.m_parent[n] = n2;
        } else {
            this.m_child1[n2] = n4;
            this.m_child2[n2] = n;
            this.m_parent[n4] = n2;
            this.m_parent[n] = n2;
            this.m_root = n2;
        }
        n5 = this.m_parent[n];
        while (n5 != -1) {
            n5 = this.balance(n5);
            int n6 = this.m_child1[n5];
            int n7 = this.m_child2[n5];
            assert (n6 != -1);
            assert (n7 != -1);
            this.m_height[n5] = 1 + MathUtils.max(this.m_height[n6], this.m_height[n7]);
            this.m_aabb[n5].combine(this.m_aabb[n6], this.m_aabb[n7]);
            n5 = this.m_parent[n5];
        }
    }

    private final void removeLeaf(int n) {
        if (n == this.m_root) {
            this.m_root = -1;
            return;
        }
        int n2 = this.m_parent[n];
        int n3 = this.m_parent[n2];
        int n4 = this.m_child1[n2];
        int n5 = this.m_child2[n2];
        int n6 = n4 == n ? n5 : n4;
        if (n3 != -1) {
            if (this.m_child1[n3] == n2) {
                this.m_child1[n3] = n6;
            } else {
                this.m_child2[n3] = n6;
            }
            this.m_parent[n6] = n3;
            this.freeNode(n2);
            int n7 = n3;
            while (n7 != -1) {
                n7 = this.balance(n7);
                int n8 = this.m_child1[n7];
                int n9 = this.m_child2[n7];
                this.m_aabb[n7].combine(this.m_aabb[n8], this.m_aabb[n9]);
                this.m_height[n7] = 1 + MathUtils.max(this.m_height[n8], this.m_height[n9]);
                n7 = this.m_parent[n7];
            }
        } else {
            this.m_root = n6;
            this.m_parent[n6] = -1;
            this.freeNode(n2);
        }
    }

    private int balance(int n) {
        assert (n != -1);
        int n2 = n;
        if (this.m_child1[n2] == -1 || this.m_height[n2] < 2) {
            return n;
        }
        int n3 = this.m_child1[n2];
        int n4 = this.m_child2[n2];
        assert (n3 >= 0 && n3 < this.m_nodeCapacity);
        assert (n4 >= 0 && n4 < this.m_nodeCapacity);
        int n5 = n4;
        int n6 = n3;
        int n7 = this.m_height[n5] - this.m_height[n6];
        if (n7 > 1) {
            int n8 = this.m_child1[n5];
            int n9 = this.m_child2[n5];
            int n10 = n8;
            int n11 = n9;
            assert (n8 >= 0 && n8 < this.m_nodeCapacity);
            assert (n9 >= 0 && n9 < this.m_nodeCapacity);
            this.m_child1[n5] = n;
            int n12 = this.m_parent[n5] = this.m_parent[n2];
            this.m_parent[n2] = n4;
            if (n12 != -1) {
                if (this.m_child1[n12] == n) {
                    this.m_child1[n12] = n4;
                } else {
                    assert (this.m_child2[n12] == n);
                    this.m_child2[n12] = n4;
                }
            } else {
                this.m_root = n4;
            }
            if (this.m_height[n10] > this.m_height[n11]) {
                this.m_child2[n5] = n8;
                this.m_child2[n2] = n9;
                this.m_parent[n11] = n;
                this.m_aabb[n2].combine(this.m_aabb[n6], this.m_aabb[n11]);
                this.m_aabb[n5].combine(this.m_aabb[n2], this.m_aabb[n10]);
                this.m_height[n2] = 1 + MathUtils.max(this.m_height[n6], this.m_height[n11]);
                this.m_height[n5] = 1 + MathUtils.max(this.m_height[n2], this.m_height[n10]);
            } else {
                this.m_child2[n5] = n9;
                this.m_child2[n2] = n8;
                this.m_parent[n10] = n;
                this.m_aabb[n2].combine(this.m_aabb[n6], this.m_aabb[n10]);
                this.m_aabb[n5].combine(this.m_aabb[n2], this.m_aabb[n11]);
                this.m_height[n2] = 1 + MathUtils.max(this.m_height[n6], this.m_height[n10]);
                this.m_height[n5] = 1 + MathUtils.max(this.m_height[n2], this.m_height[n11]);
            }
            return n4;
        }
        if (n7 < -1) {
            int n13 = this.m_child1[n6];
            int n14 = this.m_child2[n6];
            int n15 = n13;
            int n16 = n14;
            assert (n13 >= 0 && n13 < this.m_nodeCapacity);
            assert (n14 >= 0 && n14 < this.m_nodeCapacity);
            this.m_child1[n6] = n;
            int n17 = this.m_parent[n6] = this.m_parent[n2];
            this.m_parent[n2] = n3;
            if (n17 != -1) {
                if (this.m_child1[n17] == n) {
                    this.m_child1[n17] = n3;
                } else {
                    assert (this.m_child2[n17] == n);
                    this.m_child2[n17] = n3;
                }
            } else {
                this.m_root = n3;
            }
            if (this.m_height[n15] > this.m_height[n16]) {
                this.m_child2[n6] = n13;
                this.m_child1[n2] = n14;
                this.m_parent[n16] = n;
                this.m_aabb[n2].combine(this.m_aabb[n5], this.m_aabb[n16]);
                this.m_aabb[n6].combine(this.m_aabb[n2], this.m_aabb[n15]);
                this.m_height[n2] = 1 + MathUtils.max(this.m_height[n5], this.m_height[n16]);
                this.m_height[n6] = 1 + MathUtils.max(this.m_height[n2], this.m_height[n15]);
            } else {
                this.m_child2[n6] = n14;
                this.m_child1[n2] = n13;
                this.m_parent[n15] = n;
                this.m_aabb[n2].combine(this.m_aabb[n5], this.m_aabb[n15]);
                this.m_aabb[n6].combine(this.m_aabb[n2], this.m_aabb[n16]);
                this.m_height[n2] = 1 + MathUtils.max(this.m_height[n5], this.m_height[n15]);
                this.m_height[n6] = 1 + MathUtils.max(this.m_height[n2], this.m_height[n16]);
            }
            return n3;
        }
        return n;
    }

    private void validateStructure(int n) {
        if (n == -1) {
            return;
        }
        if (n == this.m_root) assert (this.m_parent[n] == -1);
        int n2 = this.m_child1[n];
        int n3 = this.m_child2[n];
        if (n2 == -1) {
            assert (n2 == -1);
            assert (n3 == -1);
            assert (this.m_height[n] == 0);
            return;
        }
        assert (n2 != -1 && n2 >= 0 && n2 < this.m_nodeCapacity);
        assert (n3 != -1 && n3 >= 0 && n3 < this.m_nodeCapacity);
        assert (this.m_parent[n2] == n);
        assert (this.m_parent[n3] == n);
        this.validateStructure(n2);
        this.validateStructure(n3);
    }

    private void validateMetrics(int n) {
        if (n == -1) {
            return;
        }
        int n2 = this.m_child1[n];
        int n3 = this.m_child2[n];
        if (n2 == -1) {
            assert (n2 == -1);
            assert (n3 == -1);
            assert (this.m_height[n] == 0);
            return;
        }
        assert (n2 != -1 && n2 >= 0 && n2 < this.m_nodeCapacity);
        assert (n3 != n2 && n3 >= 0 && n3 < this.m_nodeCapacity);
        int n4 = this.m_height[n2];
        int n5 = this.m_height[n3];
        int n6 = 1 + MathUtils.max(n4, n5);
        assert (this.m_height[n] == n6);
        AABB aABB = new AABB();
        aABB.combine(this.m_aabb[n2], this.m_aabb[n3]);
        assert (aABB.lowerBound.equals(this.m_aabb[n].lowerBound));
        assert (aABB.upperBound.equals(this.m_aabb[n].upperBound));
        this.validateMetrics(n2);
        this.validateMetrics(n3);
    }

    @Override
    public void drawTree(DebugDraw debugDraw) {
        if (this.m_root == -1) {
            return;
        }
        int n = this.computeHeight();
        this.drawTree(debugDraw, this.m_root, 0, n);
    }

    public void drawTree(DebugDraw debugDraw, int n, int n2, int n3) {
        AABB aABB = this.m_aabb[n];
        aABB.getVertices(this.drawVecs);
        this.color.set(1.0f, (float)(n3 - n2) * 1.0f / (float)n3, (float)(n3 - n2) * 1.0f / (float)n3);
        debugDraw.drawPolygon(this.drawVecs, 4, this.color);
        debugDraw.getViewportTranform().getWorldToScreen(aABB.upperBound, this.textVec);
        debugDraw.drawString(this.textVec.x, this.textVec.y, n + "-" + (n2 + 1) + "/" + n3, this.color);
        int n4 = this.m_child1[n];
        int n5 = this.m_child2[n];
        if (n4 != -1) {
            this.drawTree(debugDraw, n4, n2 + 1, n3);
        }
        if (n5 != -1) {
            this.drawTree(debugDraw, n5, n2 + 1, n3);
        }
    }
}

