/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class ChainShape
extends Shape {
    public Vec2[] m_vertices = null;
    public int m_count;
    public final Vec2 m_prevVertex = new Vec2();
    public final Vec2 m_nextVertex = new Vec2();
    public boolean m_hasPrevVertex = false;
    public boolean m_hasNextVertex = false;
    private final EdgeShape pool0 = new EdgeShape();

    public ChainShape() {
        super(ShapeType.CHAIN);
        this.m_radius = Settings.polygonRadius;
        this.m_count = 0;
    }

    public void clear() {
        this.m_vertices = null;
        this.m_count = 0;
    }

    @Override
    public int getChildCount() {
        return this.m_count - 1;
    }

    public void getChildEdge(EdgeShape edgeShape, int n) {
        Vec2 vec2;
        assert (n >= 0 && n < this.m_count - 1);
        edgeShape.m_radius = this.m_radius;
        Vec2 vec22 = this.m_vertices[n + 0];
        Vec2 vec23 = this.m_vertices[n + 1];
        edgeShape.m_vertex1.x = vec22.x;
        edgeShape.m_vertex1.y = vec22.y;
        edgeShape.m_vertex2.x = vec23.x;
        edgeShape.m_vertex2.y = vec23.y;
        if (n > 0) {
            vec2 = this.m_vertices[n - 1];
            edgeShape.m_vertex0.x = vec2.x;
            edgeShape.m_vertex0.y = vec2.y;
            edgeShape.m_hasVertex0 = true;
        } else {
            edgeShape.m_vertex0.x = this.m_prevVertex.x;
            edgeShape.m_vertex0.y = this.m_prevVertex.y;
            edgeShape.m_hasVertex0 = this.m_hasPrevVertex;
        }
        if (n < this.m_count - 2) {
            vec2 = this.m_vertices[n + 2];
            edgeShape.m_vertex3.x = vec2.x;
            edgeShape.m_vertex3.y = vec2.y;
            edgeShape.m_hasVertex3 = true;
        } else {
            edgeShape.m_vertex3.x = this.m_nextVertex.x;
            edgeShape.m_vertex3.y = this.m_nextVertex.y;
            edgeShape.m_hasVertex3 = this.m_hasNextVertex;
        }
    }

    @Override
    public float computeDistanceToOut(Transform transform, Vec2 vec2, int n, Vec2 vec22) {
        EdgeShape edgeShape = this.pool0;
        this.getChildEdge(edgeShape, n);
        return edgeShape.computeDistanceToOut(transform, vec2, 0, vec22);
    }

    @Override
    public boolean testPoint(Transform transform, Vec2 vec2) {
        return false;
    }

    @Override
    public boolean raycast(RayCastOutput rayCastOutput, RayCastInput rayCastInput, Transform transform, int n) {
        assert (n < this.m_count);
        EdgeShape edgeShape = this.pool0;
        int n2 = n;
        int n3 = n + 1;
        if (n3 == this.m_count) {
            n3 = 0;
        }
        Vec2 vec2 = this.m_vertices[n2];
        edgeShape.m_vertex1.x = vec2.x;
        edgeShape.m_vertex1.y = vec2.y;
        Vec2 vec22 = this.m_vertices[n3];
        edgeShape.m_vertex2.x = vec22.x;
        edgeShape.m_vertex2.y = vec22.y;
        return edgeShape.raycast(rayCastOutput, rayCastInput, transform, 0);
    }

    @Override
    public void computeAABB(AABB aABB, Transform transform, int n) {
        assert (n < this.m_count);
        Vec2 vec2 = aABB.lowerBound;
        Vec2 vec22 = aABB.upperBound;
        int n2 = n;
        int n3 = n + 1;
        if (n3 == this.m_count) {
            n3 = 0;
        }
        Vec2 vec23 = this.m_vertices[n2];
        Vec2 vec24 = this.m_vertices[n3];
        Rot rot = transform.q;
        Vec2 vec25 = transform.p;
        float f = rot.c * vec23.x - rot.s * vec23.y + vec25.x;
        float f2 = rot.s * vec23.x + rot.c * vec23.y + vec25.y;
        float f3 = rot.c * vec24.x - rot.s * vec24.y + vec25.x;
        float f4 = rot.s * vec24.x + rot.c * vec24.y + vec25.y;
        vec2.x = f < f3 ? f : f3;
        vec2.y = f2 < f4 ? f2 : f4;
        vec22.x = f > f3 ? f : f3;
        vec22.y = f2 > f4 ? f2 : f4;
    }

    @Override
    public void computeMass(MassData massData, float f) {
        massData.mass = 0.0f;
        massData.center.setZero();
        massData.I = 0.0f;
    }

    @Override
    public Shape clone() {
        ChainShape chainShape = new ChainShape();
        chainShape.createChain(this.m_vertices, this.m_count);
        chainShape.m_prevVertex.set(this.m_prevVertex);
        chainShape.m_nextVertex.set(this.m_nextVertex);
        chainShape.m_hasPrevVertex = this.m_hasPrevVertex;
        chainShape.m_hasNextVertex = this.m_hasNextVertex;
        return chainShape;
    }

    public void createLoop(Vec2[] vec2Array, int n) {
        assert (this.m_vertices == null && this.m_count == 0);
        assert (n >= 3);
        this.m_count = n + 1;
        this.m_vertices = new Vec2[this.m_count];
        int n2 = 1;
        while (n2 < n) {
            Vec2 vec2 = vec2Array[n2 - 1];
            Vec2 vec22 = vec2Array[n2];
            if (MathUtils.distanceSquared(vec2, vec22) < Settings.linearSlop * Settings.linearSlop) {
                throw new RuntimeException("Vertices of chain shape are too close together");
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            this.m_vertices[n2] = new Vec2(vec2Array[n2]);
            ++n2;
        }
        this.m_vertices[n] = new Vec2(this.m_vertices[0]);
        this.m_prevVertex.set(this.m_vertices[this.m_count - 2]);
        this.m_nextVertex.set(this.m_vertices[1]);
        this.m_hasPrevVertex = true;
        this.m_hasNextVertex = true;
    }

    public void createChain(Vec2[] vec2Array, int n) {
        assert (this.m_vertices == null && this.m_count == 0);
        assert (n >= 2);
        this.m_count = n;
        this.m_vertices = new Vec2[this.m_count];
        int n2 = 1;
        while (n2 < this.m_count) {
            Vec2 vec2 = vec2Array[n2 - 1];
            Vec2 vec22 = vec2Array[n2];
            if (MathUtils.distanceSquared(vec2, vec22) < Settings.linearSlop * Settings.linearSlop) {
                throw new RuntimeException("Vertices of chain shape are too close together");
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.m_count) {
            this.m_vertices[n2] = new Vec2(vec2Array[n2]);
            ++n2;
        }
        this.m_hasPrevVertex = false;
        this.m_hasNextVertex = false;
        this.m_prevVertex.setZero();
        this.m_nextVertex.setZero();
    }

    public void setPrevVertex(Vec2 vec2) {
        this.m_prevVertex.set(vec2);
        this.m_hasPrevVertex = true;
    }

    public void setNextVertex(Vec2 vec2) {
        this.m_nextVertex.set(vec2);
        this.m_hasNextVertex = true;
    }
}

