/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.io.Serializable;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Vec2;

public class Transform
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Vec2 p;
    public final Rot q;
    private static Vec2 pool = new Vec2();

    public Transform() {
        this.p = new Vec2();
        this.q = new Rot();
    }

    public Transform(Transform transform) {
        this.p = transform.p.clone();
        this.q = transform.q.clone();
    }

    public Transform(Vec2 vec2, Rot rot) {
        this.p = vec2.clone();
        this.q = rot.clone();
    }

    public final Transform set(Transform transform) {
        this.p.set(transform.p);
        this.q.set(transform.q);
        return this;
    }

    public final void set(Vec2 vec2, float f) {
        this.p.set(vec2);
        this.q.set(f);
    }

    public final void setIdentity() {
        this.p.setZero();
        this.q.setIdentity();
    }

    public static final Vec2 mul(Transform transform, Vec2 vec2) {
        return new Vec2(transform.q.c * vec2.x - transform.q.s * vec2.y + transform.p.x, transform.q.s * vec2.x + transform.q.c * vec2.y + transform.p.y);
    }

    public static final void mulToOut(Transform transform, Vec2 vec2, Vec2 vec22) {
        float f = transform.q.s * vec2.x + transform.q.c * vec2.y + transform.p.y;
        vec22.x = transform.q.c * vec2.x - transform.q.s * vec2.y + transform.p.x;
        vec22.y = f;
    }

    public static final void mulToOutUnsafe(Transform transform, Vec2 vec2, Vec2 vec22) {
        assert (vec2 != vec22);
        vec22.x = transform.q.c * vec2.x - transform.q.s * vec2.y + transform.p.x;
        vec22.y = transform.q.s * vec2.x + transform.q.c * vec2.y + transform.p.y;
    }

    public static final Vec2 mulTrans(Transform transform, Vec2 vec2) {
        float f = vec2.x - transform.p.x;
        float f2 = vec2.y - transform.p.y;
        return new Vec2(transform.q.c * f + transform.q.s * f2, -transform.q.s * f + transform.q.c * f2);
    }

    public static final void mulTransToOut(Transform transform, Vec2 vec2, Vec2 vec22) {
        float f = vec2.x - transform.p.x;
        float f2 = vec2.y - transform.p.y;
        float f3 = -transform.q.s * f + transform.q.c * f2;
        vec22.x = transform.q.c * f + transform.q.s * f2;
        vec22.y = f3;
    }

    public static final void mulTransToOutUnsafe(Transform transform, Vec2 vec2, Vec2 vec22) {
        assert (vec2 != vec22);
        float f = vec2.x - transform.p.x;
        float f2 = vec2.y - transform.p.y;
        vec22.x = transform.q.c * f + transform.q.s * f2;
        vec22.y = -transform.q.s * f + transform.q.c * f2;
    }

    public static final Transform mul(Transform transform, Transform transform2) {
        Transform transform3 = new Transform();
        Rot.mulUnsafe(transform.q, transform2.q, transform3.q);
        Rot.mulToOutUnsafe(transform.q, transform2.p, transform3.p);
        transform3.p.addLocal(transform.p);
        return transform3;
    }

    public static final void mulToOut(Transform transform, Transform transform2, Transform transform3) {
        assert (transform3 != transform);
        Rot.mul(transform.q, transform2.q, transform3.q);
        Rot.mulToOut(transform.q, transform2.p, transform3.p);
        transform3.p.addLocal(transform.p);
    }

    public static final void mulToOutUnsafe(Transform transform, Transform transform2, Transform transform3) {
        assert (transform3 != transform2);
        assert (transform3 != transform);
        Rot.mulUnsafe(transform.q, transform2.q, transform3.q);
        Rot.mulToOutUnsafe(transform.q, transform2.p, transform3.p);
        transform3.p.addLocal(transform.p);
    }

    public static final Transform mulTrans(Transform transform, Transform transform2) {
        Transform transform3 = new Transform();
        Rot.mulTransUnsafe(transform.q, transform2.q, transform3.q);
        pool.set(transform2.p).subLocal(transform.p);
        Rot.mulTransUnsafe(transform.q, pool, transform3.p);
        return transform3;
    }

    public static final void mulTransToOut(Transform transform, Transform transform2, Transform transform3) {
        assert (transform3 != transform);
        Rot.mulTrans(transform.q, transform2.q, transform3.q);
        pool.set(transform2.p).subLocal(transform.p);
        Rot.mulTrans(transform.q, pool, transform3.p);
    }

    public static final void mulTransToOutUnsafe(Transform transform, Transform transform2, Transform transform3) {
        assert (transform3 != transform);
        assert (transform3 != transform2);
        Rot.mulTransUnsafe(transform.q, transform2.q, transform3.q);
        pool.set(transform2.p).subLocal(transform.p);
        Rot.mulTransUnsafe(transform.q, pool, transform3.p);
    }

    public final String toString() {
        Object object = "XForm:\n";
        object = (String)object + "Position: " + String.valueOf(this.p) + "\n";
        object = (String)object + "R: \n" + String.valueOf(this.q) + "\n";
        return object;
    }
}

