/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.JointType;

public class PulleyJointDef
extends JointDef {
    public Vec2 groundAnchorA = new Vec2(-1.0f, 1.0f);
    public Vec2 groundAnchorB = new Vec2(1.0f, 1.0f);
    public Vec2 localAnchorA = new Vec2(-1.0f, 0.0f);
    public Vec2 localAnchorB = new Vec2(1.0f, 0.0f);
    public float lengthA = 0.0f;
    public float lengthB = 0.0f;
    public float ratio = 1.0f;

    public PulleyJointDef() {
        super(JointType.PULLEY);
        this.collideConnected = true;
    }

    public void initialize(Body body, Body body2, Vec2 vec2, Vec2 vec22, Vec2 vec23, Vec2 vec24, float f) {
        this.bodyA = body;
        this.bodyB = body2;
        this.groundAnchorA = vec2;
        this.groundAnchorB = vec22;
        this.localAnchorA = this.bodyA.getLocalPoint(vec23);
        this.localAnchorB = this.bodyB.getLocalPoint(vec24);
        Vec2 vec25 = vec23.sub(vec2);
        this.lengthA = vec25.length();
        Vec2 vec26 = vec24.sub(vec22);
        this.lengthB = vec26.length();
        this.ratio = f;
        assert (this.ratio > 1.1920929E-7f);
    }
}

