/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.common;

import gama.core.metamodel.shape.GamaPoint;
import javax.vecmath.Vector3f;
import org.jbox2d.common.Vec2;

public class VectorUtils {
    static Vector3f newBulletVector() {
        return new Vector3f();
    }

    static com.jme3.math.Vector3f newNativeBulletVector() {
        return new com.jme3.math.Vector3f();
    }

    static Vec2 newBox2DVector() {
        return new Vec2();
    }

    public static Vector3f toBulletVector(GamaPoint gamaPoint) {
        return VectorUtils.toBulletVector(gamaPoint, VectorUtils.newBulletVector());
    }

    public static Vector3f toBulletVector(GamaPoint gamaPoint, Vector3f vector3f) {
        Vector3f vector3f2;
        Vector3f vector3f3 = vector3f2 = vector3f == null ? VectorUtils.newBulletVector() : vector3f;
        if (gamaPoint != null) {
            vector3f2.x = (float)gamaPoint.x;
            vector3f2.y = (float)gamaPoint.y;
            vector3f2.z = (float)gamaPoint.z;
        }
        return vector3f2;
    }

    public static com.jme3.math.Vector3f toNativeBulletVector(GamaPoint gamaPoint) {
        return VectorUtils.toNativeBulletVector(gamaPoint, new com.jme3.math.Vector3f());
    }

    public static com.jme3.math.Vector3f toNativeBulletVector(GamaPoint gamaPoint, com.jme3.math.Vector3f vector3f) {
        com.jme3.math.Vector3f vector3f2;
        com.jme3.math.Vector3f vector3f3 = vector3f2 = vector3f == null ? VectorUtils.newNativeBulletVector() : vector3f;
        if (gamaPoint != null) {
            vector3f2.x = (float)gamaPoint.x;
            vector3f2.y = (float)gamaPoint.y;
            vector3f2.z = (float)gamaPoint.z;
        }
        return vector3f2;
    }

    public static GamaPoint toGamaPoint(com.jme3.math.Vector3f vector3f) {
        return VectorUtils.toGamaPoint(vector3f, new GamaPoint());
    }

    public static GamaPoint toGamaPoint(com.jme3.math.Vector3f vector3f, GamaPoint gamaPoint) {
        GamaPoint gamaPoint2;
        GamaPoint gamaPoint3 = gamaPoint2 = gamaPoint == null ? new GamaPoint() : gamaPoint;
        if (vector3f != null) {
            gamaPoint2.x = vector3f.x;
            gamaPoint2.y = vector3f.y;
            gamaPoint2.z = vector3f.z;
        }
        return gamaPoint2;
    }

    public static GamaPoint toGamaPoint(Vector3f vector3f) {
        return VectorUtils.toGamaPoint(vector3f, new GamaPoint());
    }

    public static GamaPoint toGamaPoint(Vector3f vector3f, GamaPoint gamaPoint) {
        GamaPoint gamaPoint2;
        GamaPoint gamaPoint3 = gamaPoint2 = gamaPoint == null ? new GamaPoint() : gamaPoint;
        if (vector3f != null) {
            gamaPoint2.x = vector3f.x;
            gamaPoint2.y = vector3f.y;
            gamaPoint2.z = vector3f.z;
        }
        return gamaPoint2;
    }

    public static GamaPoint toGamaPoint(Vec2 vec2, float f) {
        return VectorUtils.toGamaPoint(vec2, new GamaPoint(), f);
    }

    public static GamaPoint toGamaPoint(Vec2 vec2, GamaPoint gamaPoint, float f) {
        GamaPoint gamaPoint2;
        GamaPoint gamaPoint3 = gamaPoint2 = gamaPoint == null ? new GamaPoint() : gamaPoint;
        if (vec2 != null) {
            gamaPoint2.x = (double)vec2.x / (double)f;
            gamaPoint2.y = (double)(-vec2.y) / (double)f;
        }
        return gamaPoint2;
    }

    public static Vec2 toBox2DVector(GamaPoint gamaPoint, float f) {
        return VectorUtils.toBox2DVector(gamaPoint, new Vec2(), f);
    }

    public static Vec2 toBox2DVector(GamaPoint gamaPoint, Vec2 vec2, float f) {
        Vec2 vec22;
        Vec2 vec23 = vec22 = vec2 == null ? VectorUtils.newBox2DVector() : vec2;
        if (gamaPoint != null) {
            vec22.x = (float)gamaPoint.x * f;
            vec22.y = (float)(-gamaPoint.y) * f;
        }
        return vec22;
    }
}

