/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.vehicle;

import com.bulletphysics.Pools;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.constraintsolver.ContactConstraint;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraintType;
import com.bulletphysics.dynamics.vehicle.VehicleRaycaster;
import com.bulletphysics.dynamics.vehicle.VehicleRaycasterResult;
import com.bulletphysics.dynamics.vehicle.VehicleTuning;
import com.bulletphysics.dynamics.vehicle.WheelInfo;
import com.bulletphysics.dynamics.vehicle.WheelInfoConstructionInfo;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.MiscUtil;
import com.bulletphysics.linearmath.QuaternionUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.util.ArrayPool;
import com.bulletphysics.util.FloatArrayList;
import java.util.ArrayList;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class RaycastVehicle
extends TypedConstraint {
    private final ArrayPool<float[]> floatArrays = ArrayPool.get(Float.TYPE);
    private static RigidBody s_fixedObject = new RigidBody(0.0f, null, null);
    private static final float sideFrictionStiffness2 = 1.0f;
    protected ArrayList<Vector3f> forwardWS = new ArrayList();
    protected ArrayList<Vector3f> axle = new ArrayList();
    protected FloatArrayList forwardImpulse = new FloatArrayList();
    protected FloatArrayList sideImpulse = new FloatArrayList();
    private float tau;
    private float damping;
    private final VehicleRaycaster vehicleRaycaster;
    private float pitchControl = 0.0f;
    private float steeringValue;
    private float currentVehicleSpeedKmHour;
    private final RigidBody chassisBody;
    private int indexRightAxis = 0;
    private int indexUpAxis = 2;
    private int indexForwardAxis = 1;
    public ArrayList<WheelInfo> wheelInfo = new ArrayList();

    public RaycastVehicle(VehicleTuning vehicleTuning, RigidBody rigidBody, VehicleRaycaster vehicleRaycaster) {
        super(TypedConstraintType.VEHICLE_CONSTRAINT_TYPE);
        this.vehicleRaycaster = vehicleRaycaster;
        this.chassisBody = rigidBody;
        this.defaultInit(vehicleTuning);
    }

    private void defaultInit(VehicleTuning vehicleTuning) {
        this.currentVehicleSpeedKmHour = 0.0f;
        this.steeringValue = 0.0f;
    }

    public WheelInfo addWheel(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, float f, float f2, VehicleTuning vehicleTuning, boolean bl) {
        WheelInfoConstructionInfo wheelInfoConstructionInfo = new WheelInfoConstructionInfo();
        wheelInfoConstructionInfo.chassisConnectionCS.set(vector3f);
        wheelInfoConstructionInfo.wheelDirectionCS.set(vector3f2);
        wheelInfoConstructionInfo.wheelAxleCS.set(vector3f3);
        wheelInfoConstructionInfo.suspensionRestLength = f;
        wheelInfoConstructionInfo.wheelRadius = f2;
        wheelInfoConstructionInfo.suspensionStiffness = vehicleTuning.suspensionStiffness;
        wheelInfoConstructionInfo.wheelsDampingCompression = vehicleTuning.suspensionCompression;
        wheelInfoConstructionInfo.wheelsDampingRelaxation = vehicleTuning.suspensionDamping;
        wheelInfoConstructionInfo.frictionSlip = vehicleTuning.frictionSlip;
        wheelInfoConstructionInfo.bIsFrontWheel = bl;
        wheelInfoConstructionInfo.maxSuspensionTravelCm = vehicleTuning.maxSuspensionTravelCm;
        this.wheelInfo.add(new WheelInfo(wheelInfoConstructionInfo));
        WheelInfo wheelInfo = this.wheelInfo.get(this.getNumWheels() - 1);
        this.updateWheelTransformsWS(wheelInfo, false);
        this.updateWheelTransform(this.getNumWheels() - 1, false);
        return wheelInfo;
    }

    public Transform getWheelTransformWS(int n, Transform transform) {
        assert (n < this.getNumWheels());
        WheelInfo wheelInfo = this.wheelInfo.get(n);
        transform.set(wheelInfo.worldTransform);
        return transform;
    }

    public void updateWheelTransform(int n) {
        this.updateWheelTransform(n, true);
    }

    public void updateWheelTransform(int n, boolean bl) {
        WheelInfo wheelInfo = this.wheelInfo.get(n);
        this.updateWheelTransformsWS(wheelInfo, bl);
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        vector3f.negate(wheelInfo.raycastInfo.wheelDirectionWS);
        Vector3f vector3f2 = wheelInfo.raycastInfo.wheelAxleWS;
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.cross(vector3f, vector3f2);
        vector3f3.normalize();
        float f = wheelInfo.steering;
        Quat4f quat4f = (Quat4f)Pools.QUATS.get();
        QuaternionUtil.setRotation(quat4f, vector3f, f);
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get();
        MatrixUtil.setRotation(matrix3f, quat4f);
        Quat4f quat4f2 = (Quat4f)Pools.QUATS.get();
        QuaternionUtil.setRotation(quat4f2, vector3f2, -wheelInfo.rotation);
        Matrix3f matrix3f2 = (Matrix3f)Pools.MATRICES.get();
        MatrixUtil.setRotation(matrix3f2, quat4f2);
        Matrix3f matrix3f3 = (Matrix3f)Pools.MATRICES.get();
        matrix3f3.setRow(0, vector3f2.x, vector3f3.x, vector3f.x);
        matrix3f3.setRow(1, vector3f2.y, vector3f3.y, vector3f.y);
        matrix3f3.setRow(2, vector3f2.z, vector3f3.z, vector3f.z);
        Matrix3f matrix3f4 = wheelInfo.worldTransform.basis;
        matrix3f4.mul(matrix3f, matrix3f2);
        matrix3f4.mul(matrix3f3);
        wheelInfo.worldTransform.origin.scaleAdd(wheelInfo.raycastInfo.suspensionLength, wheelInfo.raycastInfo.wheelDirectionWS, wheelInfo.raycastInfo.hardPointWS);
        Pools.QUATS.release((Object[])new Quat4f[]{quat4f2, quat4f});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f3});
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f3});
    }

    public void resetSuspension() {
        int n = 0;
        while (n < this.wheelInfo.size()) {
            WheelInfo wheelInfo = this.wheelInfo.get(n);
            wheelInfo.raycastInfo.suspensionLength = wheelInfo.getSuspensionRestLength();
            wheelInfo.suspensionRelativeVelocity = 0.0f;
            wheelInfo.raycastInfo.contactNormalWS.negate(wheelInfo.raycastInfo.wheelDirectionWS);
            wheelInfo.clippedInvContactDotSuspension = 1.0f;
            ++n;
        }
    }

    public void updateWheelTransformsWS(WheelInfo wheelInfo) {
        this.updateWheelTransformsWS(wheelInfo, true);
    }

    public void updateWheelTransformsWS(WheelInfo wheelInfo, boolean bl) {
        wheelInfo.raycastInfo.isInContact = false;
        Transform transform = this.getChassisWorldTransform((Transform)Pools.TRANSFORMS.get());
        if (bl && this.getRigidBody().getMotionState() != null) {
            this.getRigidBody().getMotionState().getWorldTransform(transform);
        }
        wheelInfo.raycastInfo.hardPointWS.set(wheelInfo.chassisConnectionPointCS);
        transform.transform(wheelInfo.raycastInfo.hardPointWS);
        wheelInfo.raycastInfo.wheelDirectionWS.set(wheelInfo.wheelDirectionCS);
        transform.basis.transform(wheelInfo.raycastInfo.wheelDirectionWS);
        wheelInfo.raycastInfo.wheelAxleWS.set(wheelInfo.wheelAxleCS);
        transform.basis.transform(wheelInfo.raycastInfo.wheelAxleWS);
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
    }

    public float rayCast(WheelInfo wheelInfo) {
        this.updateWheelTransformsWS(wheelInfo, false);
        float f = -1.0f;
        float f2 = wheelInfo.getSuspensionRestLength() + wheelInfo.wheelsRadius;
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        vector3f.scale(f2, wheelInfo.raycastInfo.wheelDirectionWS);
        Vector3f vector3f2 = wheelInfo.raycastInfo.hardPointWS;
        wheelInfo.raycastInfo.contactPointWS.add(vector3f2, vector3f);
        Vector3f vector3f3 = wheelInfo.raycastInfo.contactPointWS;
        float f3 = 0.0f;
        VehicleRaycasterResult vehicleRaycasterResult = new VehicleRaycasterResult();
        assert (this.vehicleRaycaster != null);
        Object object = this.vehicleRaycaster.castRay(vector3f2, vector3f3, vehicleRaycasterResult);
        wheelInfo.raycastInfo.groundObject = null;
        if (object != null) {
            f3 = vehicleRaycasterResult.distFraction;
            f = f2 * vehicleRaycasterResult.distFraction;
            wheelInfo.raycastInfo.contactNormalWS.set(vehicleRaycasterResult.hitNormalInWorld);
            wheelInfo.raycastInfo.isInContact = true;
            wheelInfo.raycastInfo.groundObject = s_fixedObject;
            float f4 = f3 * f2;
            wheelInfo.raycastInfo.suspensionLength = f4 - wheelInfo.wheelsRadius;
            float f5 = wheelInfo.getSuspensionRestLength() - wheelInfo.maxSuspensionTravelCm * 0.01f;
            float f6 = wheelInfo.getSuspensionRestLength() + wheelInfo.maxSuspensionTravelCm * 0.01f;
            if (wheelInfo.raycastInfo.suspensionLength < f5) {
                wheelInfo.raycastInfo.suspensionLength = f5;
            }
            if (wheelInfo.raycastInfo.suspensionLength > f6) {
                wheelInfo.raycastInfo.suspensionLength = f6;
            }
            wheelInfo.raycastInfo.contactPointWS.set(vehicleRaycasterResult.hitPointInWorld);
            float f7 = wheelInfo.raycastInfo.contactNormalWS.dot(wheelInfo.raycastInfo.wheelDirectionWS);
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
            vector3f5.sub(wheelInfo.raycastInfo.contactPointWS, this.getRigidBody().getCenterOfMassPosition((Vector3f)Pools.VECTORS.get()));
            this.getRigidBody().getVelocityInLocalPoint(vector3f5, vector3f4);
            float f8 = wheelInfo.raycastInfo.contactNormalWS.dot(vector3f4);
            if (f7 >= -0.1f) {
                wheelInfo.suspensionRelativeVelocity = 0.0f;
                wheelInfo.clippedInvContactDotSuspension = 10.0f;
            } else {
                float f9 = -1.0f / f7;
                wheelInfo.suspensionRelativeVelocity = f8 * f9;
                wheelInfo.clippedInvContactDotSuspension = f9;
            }
        } else {
            wheelInfo.raycastInfo.suspensionLength = wheelInfo.getSuspensionRestLength();
            wheelInfo.suspensionRelativeVelocity = 0.0f;
            wheelInfo.raycastInfo.contactNormalWS.negate(wheelInfo.raycastInfo.wheelDirectionWS);
            wheelInfo.clippedInvContactDotSuspension = 1.0f;
        }
        return f;
    }

    public Transform getChassisWorldTransform(Transform transform) {
        return this.getRigidBody().getCenterOfMassTransform(transform);
    }

    public void updateVehicle(float f) {
        Object object;
        Vector3f vector3f;
        WheelInfo wheelInfo;
        int n = 0;
        while (n < this.getNumWheels()) {
            this.updateWheelTransform(n, false);
            ++n;
        }
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        this.currentVehicleSpeedKmHour = 3.6f * this.getRigidBody().getLinearVelocity(vector3f2).length();
        Transform transform = this.getChassisWorldTransform((Transform)Pools.TRANSFORMS.get());
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.set(transform.basis.getElement(0, this.indexForwardAxis), transform.basis.getElement(1, this.indexForwardAxis), transform.basis.getElement(2, this.indexForwardAxis));
        if (vector3f3.dot(this.getRigidBody().getLinearVelocity(vector3f2)) < 0.0f) {
            this.currentVehicleSpeedKmHour *= -1.0f;
        }
        this.updateSuspension(f);
        int n2 = 0;
        while (n2 < this.wheelInfo.size()) {
            wheelInfo = this.wheelInfo.get(n2);
            float f2 = wheelInfo.wheelsSuspensionForce;
            if (f2 > wheelInfo.maxSuspensionForce) {
                f2 = wheelInfo.maxSuspensionForce;
            }
            vector3f = (Vector3f)Pools.VECTORS.get();
            vector3f.scale(f2 * f, wheelInfo.raycastInfo.contactNormalWS);
            object = (Vector3f)Pools.VECTORS.get();
            ((Tuple3f)object).sub(wheelInfo.raycastInfo.contactPointWS, this.getRigidBody().getCenterOfMassPosition(vector3f2));
            this.getRigidBody().applyImpulse(vector3f, (Vector3f)object);
            ++n2;
        }
        this.updateFriction(f);
        n2 = 0;
        while (n2 < this.wheelInfo.size()) {
            wheelInfo = this.wheelInfo.get(n2);
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
            vector3f4.sub(wheelInfo.raycastInfo.hardPointWS, this.getRigidBody().getCenterOfMassPosition(vector3f2));
            vector3f = this.getRigidBody().getVelocityInLocalPoint(vector3f4, (Vector3f)Pools.VECTORS.get());
            if (wheelInfo.raycastInfo.isInContact) {
                object = this.getChassisWorldTransform((Transform)Pools.TRANSFORMS.get());
                Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
                vector3f5.set(((Transform)object).basis.getElement(0, this.indexForwardAxis), ((Transform)object).basis.getElement(1, this.indexForwardAxis), ((Transform)object).basis.getElement(2, this.indexForwardAxis));
                float f3 = vector3f5.dot(wheelInfo.raycastInfo.contactNormalWS);
                vector3f2.scale(f3, wheelInfo.raycastInfo.contactNormalWS);
                vector3f5.sub(vector3f2);
                float f4 = vector3f5.dot(vector3f);
                wheelInfo.deltaRotation = f4 * f / wheelInfo.wheelsRadius;
                wheelInfo.rotation += wheelInfo.deltaRotation;
                Pools.TRANSFORMS.release((Object[])new Transform[]{object});
            } else {
                wheelInfo.rotation += wheelInfo.deltaRotation;
            }
            wheelInfo.deltaRotation *= 0.99f;
            ++n2;
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
    }

    public void setSteeringValue(float f, int n) {
        assert (n >= 0 && n < this.getNumWheels());
        WheelInfo wheelInfo = this.getWheelInfo(n);
        wheelInfo.steering = f;
    }

    public float getSteeringValue(int n) {
        return this.getWheelInfo((int)n).steering;
    }

    public void applyEngineForce(float f, int n) {
        assert (n >= 0 && n < this.getNumWheels());
        WheelInfo wheelInfo = this.getWheelInfo(n);
        wheelInfo.engineForce = f;
    }

    public WheelInfo getWheelInfo(int n) {
        assert (n >= 0 && n < this.getNumWheels());
        return this.wheelInfo.get(n);
    }

    public void setBrake(float f, int n) {
        assert (n >= 0 && n < this.getNumWheels());
        this.getWheelInfo((int)n).brake = f;
    }

    public void updateSuspension(float f) {
        float f2 = 1.0f / this.chassisBody.getInvMass();
        int n = 0;
        while (n < this.getNumWheels()) {
            WheelInfo wheelInfo = this.wheelInfo.get(n);
            if (wheelInfo.raycastInfo.isInContact) {
                float f3 = wheelInfo.getSuspensionRestLength();
                float f4 = wheelInfo.raycastInfo.suspensionLength;
                float f5 = f3 - f4;
                float f6 = wheelInfo.suspensionStiffness * f5 * wheelInfo.clippedInvContactDotSuspension;
                f3 = wheelInfo.suspensionRelativeVelocity;
                f4 = f3 < 0.0f ? wheelInfo.wheelsDampingCompression : wheelInfo.wheelsDampingRelaxation;
                wheelInfo.wheelsSuspensionForce = (f6 -= f4 * f3) * f2;
                if (wheelInfo.wheelsSuspensionForce < 0.0f) {
                    wheelInfo.wheelsSuspensionForce = 0.0f;
                }
            } else {
                wheelInfo.wheelsSuspensionForce = 0.0f;
            }
            ++n;
        }
    }

    private float calcRollingFriction(WheelContactPoint wheelContactPoint) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        float f = 0.0f;
        Vector3f vector3f2 = wheelContactPoint.frictionPositionWorld;
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.sub(vector3f2, wheelContactPoint.body0.getCenterOfMassPosition(vector3f));
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.sub(vector3f2, wheelContactPoint.body1.getCenterOfMassPosition(vector3f));
        float f2 = wheelContactPoint.maxImpulse;
        Vector3f vector3f5 = wheelContactPoint.body0.getVelocityInLocalPoint(vector3f3, (Vector3f)Pools.VECTORS.get());
        Vector3f vector3f6 = wheelContactPoint.body1.getVelocityInLocalPoint(vector3f4, (Vector3f)Pools.VECTORS.get());
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        vector3f7.sub(vector3f5, vector3f6);
        float f3 = wheelContactPoint.frictionDirectionWorld.dot(vector3f7);
        f = -f3 * wheelContactPoint.jacDiagABInv;
        f = Math.min(f, f2);
        f = Math.max(f, -f2);
        return f;
    }

    public void updateFriction(float f) {
        Object object;
        float f2;
        Object object2;
        Object object3;
        int n = this.getNumWheels();
        if (n == 0) {
            return;
        }
        MiscUtil.resize(this.forwardWS, n, Vector3f.class);
        MiscUtil.resize(this.axle, n, Vector3f.class);
        MiscUtil.resize(this.forwardImpulse, n, 0.0f);
        MiscUtil.resize(this.sideImpulse, n, 0.0f);
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        int n2 = 0;
        while (n2 < this.getNumWheels()) {
            this.sideImpulse.set(n2, 0.0f);
            this.forwardImpulse.set(n2, 0.0f);
            ++n2;
        }
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        int n3 = 0;
        while (n3 < this.getNumWheels()) {
            WheelInfo wheelInfo = this.wheelInfo.get(n3);
            RigidBody rigidBody = (RigidBody)wheelInfo.raycastInfo.groundObject;
            if (rigidBody != null) {
                this.getWheelTransformWS(n3, transform);
                object3 = (Matrix3f)Pools.MATRICES.get((Object)transform.basis);
                this.axle.get(n3).set(((Matrix3f)object3).getElement(0, this.indexRightAxis), ((Matrix3f)object3).getElement(1, this.indexRightAxis), ((Matrix3f)object3).getElement(2, this.indexRightAxis));
                object2 = wheelInfo.raycastInfo.contactNormalWS;
                f2 = this.axle.get(n3).dot((Vector3f)object2);
                vector3f.scale(f2, (Tuple3f)object2);
                this.axle.get(n3).sub(vector3f);
                this.axle.get(n3).normalize();
                this.forwardWS.get(n3).cross((Vector3f)object2, this.axle.get(n3));
                this.forwardWS.get(n3).normalize();
                object = this.floatArrays.getFixed(1);
                ContactConstraint.resolveSingleBilateral(this.chassisBody, wheelInfo.raycastInfo.contactPointWS, rigidBody, wheelInfo.raycastInfo.contactPointWS, 0.0f, this.axle.get(n3), (float[])object, f);
                this.sideImpulse.set(n3, (float)object[0]);
                this.floatArrays.release((float[])object);
                this.sideImpulse.set(n3, this.sideImpulse.get(n3) * 1.0f);
                Pools.VECTORS.release((Object[])new Vector3f[]{object2});
                Pools.MATRICES.release((Object[])new Matrix3f[]{object3});
            }
            ++n3;
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
        float f3 = 1.0f;
        float f4 = 0.5f;
        boolean bl = false;
        int n4 = 0;
        while (n4 < this.getNumWheels()) {
            float f5;
            object3 = this.wheelInfo.get(n4);
            object2 = (RigidBody)((WheelInfo)object3).raycastInfo.groundObject;
            f2 = 0.0f;
            if (object2 != null) {
                if (((WheelInfo)object3).engineForce != 0.0f) {
                    f2 = ((WheelInfo)object3).engineForce * f;
                } else {
                    float f6 = 0.0f;
                    f5 = ((WheelInfo)object3).brake != 0.0f ? ((WheelInfo)object3).brake : f6;
                    WheelContactPoint wheelContactPoint = new WheelContactPoint(this.chassisBody, (RigidBody)object2, ((WheelInfo)object3).raycastInfo.contactPointWS, this.forwardWS.get(n4), f5);
                    f2 = this.calcRollingFriction(wheelContactPoint);
                }
            }
            this.forwardImpulse.set(n4, 0.0f);
            this.wheelInfo.get((int)n4).skidInfo = 1.0f;
            if (object2 != null) {
                float f7;
                this.wheelInfo.get((int)n4).skidInfo = 1.0f;
                f5 = f7 = ((WheelInfo)object3).wheelsSuspensionForce * f * ((WheelInfo)object3).frictionSlip;
                float f8 = f7 * f5;
                this.forwardImpulse.set(n4, f2);
                float f9 = this.forwardImpulse.get(n4) * f4;
                float f10 = this.sideImpulse.get(n4) * f3;
                float f11 = f9 * f9 + f10 * f10;
                if (f11 > f8) {
                    bl = true;
                    float f12 = f7 / (float)Math.sqrt(f11);
                    this.wheelInfo.get((int)n4).skidInfo *= f12;
                }
            }
            ++n4;
        }
        if (bl) {
            n4 = 0;
            while (n4 < this.getNumWheels()) {
                if (this.sideImpulse.get(n4) != 0.0f && this.wheelInfo.get((int)n4).skidInfo < 1.0f) {
                    this.forwardImpulse.set(n4, this.forwardImpulse.get(n4) * this.wheelInfo.get((int)n4).skidInfo);
                    this.sideImpulse.set(n4, this.sideImpulse.get(n4) * this.wheelInfo.get((int)n4).skidInfo);
                }
                ++n4;
            }
        }
        n4 = 0;
        while (n4 < this.getNumWheels()) {
            object3 = this.wheelInfo.get(n4);
            object2 = (Vector3f)Pools.VECTORS.get();
            ((Tuple3f)object2).sub(((WheelInfo)object3).raycastInfo.contactPointWS, this.chassisBody.getCenterOfMassPosition(vector3f));
            if (this.forwardImpulse.get(n4) != 0.0f) {
                vector3f.scale(this.forwardImpulse.get(n4), this.forwardWS.get(n4));
                this.chassisBody.applyImpulse(vector3f, (Vector3f)object2);
            }
            if (this.sideImpulse.get(n4) != 0.0f) {
                RigidBody rigidBody = (RigidBody)this.wheelInfo.get((int)n4).raycastInfo.groundObject;
                object = (Vector3f)Pools.VECTORS.get();
                ((Tuple3f)object).sub(((WheelInfo)object3).raycastInfo.contactPointWS, rigidBody.getCenterOfMassPosition(vector3f));
                Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
                vector3f2.scale(this.sideImpulse.get(n4), this.axle.get(n4));
                ((Vector3f)object2).z *= ((WheelInfo)object3).rollInfluence;
                this.chassisBody.applyImpulse(vector3f2, (Vector3f)object2);
                vector3f.negate(vector3f2);
                rigidBody.applyImpulse(vector3f, (Vector3f)object);
            }
            ++n4;
        }
    }

    @Override
    public void buildJacobian() {
    }

    @Override
    public void solveConstraint(float f) {
    }

    public int getNumWheels() {
        return this.wheelInfo.size();
    }

    public void setPitchControl(float f) {
        this.pitchControl = f;
    }

    public RigidBody getRigidBody() {
        return this.chassisBody;
    }

    public int getRightAxis() {
        return this.indexRightAxis;
    }

    public int getUpAxis() {
        return this.indexUpAxis;
    }

    public int getForwardAxis() {
        return this.indexForwardAxis;
    }

    public Vector3f getForwardVector(Vector3f vector3f) {
        Transform transform = this.getChassisWorldTransform((Transform)Pools.TRANSFORMS.get());
        vector3f.set(transform.basis.getElement(0, this.indexForwardAxis), transform.basis.getElement(1, this.indexForwardAxis), transform.basis.getElement(2, this.indexForwardAxis));
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
        return vector3f;
    }

    public float getCurrentSpeedKmHour() {
        return this.currentVehicleSpeedKmHour;
    }

    public void setCoordinateSystem(int n, int n2, int n3) {
        this.indexRightAxis = n;
        this.indexUpAxis = n2;
        this.indexForwardAxis = n3;
    }

    private static class WheelContactPoint {
        public RigidBody body0;
        public RigidBody body1;
        public final Vector3f frictionPositionWorld = new Vector3f();
        public final Vector3f frictionDirectionWorld = new Vector3f();
        public float jacDiagABInv;
        public float maxImpulse;

        public WheelContactPoint(RigidBody rigidBody, RigidBody rigidBody2, Vector3f vector3f, Vector3f vector3f2, float f) {
            this.body0 = rigidBody;
            this.body1 = rigidBody2;
            this.frictionPositionWorld.set(vector3f);
            this.frictionDirectionWorld.set(vector3f2);
            this.maxImpulse = f;
            float f2 = rigidBody.computeImpulseDenominator(vector3f, vector3f2);
            float f3 = rigidBody2.computeImpulseDenominator(vector3f, vector3f2);
            float f4 = 1.0f;
            this.jacDiagABInv = f4 / (f2 + f3);
        }
    }
}

