/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.extras.gimpact.GImpactShapeInterface;
import com.bulletphysics.extras.gimpact.TetrahedronShapeEx;
import com.bulletphysics.extras.gimpact.TriangleShapeEx;

class GIM_ShapeRetriever {
    public GImpactShapeInterface gim_shape;
    public TriangleShapeEx trishape = new TriangleShapeEx();
    public TetrahedronShapeEx tetrashape = new TetrahedronShapeEx();
    public ChildShapeRetriever child_retriever = new ChildShapeRetriever();
    public TriangleShapeRetriever tri_retriever = new TriangleShapeRetriever();
    public TetraShapeRetriever tetra_retriever = new TetraShapeRetriever();
    public ChildShapeRetriever current_retriever;

    public GIM_ShapeRetriever(GImpactShapeInterface gImpactShapeInterface) {
        this.gim_shape = gImpactShapeInterface;
        this.current_retriever = gImpactShapeInterface.needsRetrieveTriangles() ? this.tri_retriever : (gImpactShapeInterface.needsRetrieveTetrahedrons() ? this.tetra_retriever : this.child_retriever);
        this.current_retriever.parent = this;
    }

    public CollisionShape getChildShape(int n) {
        return this.current_retriever.getChildShape(n);
    }

    public static class ChildShapeRetriever {
        public GIM_ShapeRetriever parent;

        public CollisionShape getChildShape(int n) {
            return this.parent.gim_shape.getChildShape(n);
        }
    }

    public static class TetraShapeRetriever
    extends ChildShapeRetriever {
        @Override
        public CollisionShape getChildShape(int n) {
            this.parent.gim_shape.getBulletTetrahedron(n, this.parent.tetrashape);
            return this.parent.tetrashape;
        }
    }

    public static class TriangleShapeRetriever
    extends ChildShapeRetriever {
        @Override
        public CollisionShape getChildShape(int n) {
            this.parent.gim_shape.getBulletTriangle(n, this.parent.trishape);
            return this.parent.trishape;
        }
    }
}

