/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.extras.gimpact.Pair;

class PairSet {
    private Pair[] array = new Pair[32];
    private int size = 0;

    public PairSet() {
        int n = 0;
        while (n < this.array.length) {
            this.array[n] = new Pair();
            ++n;
        }
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public Pair get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[n];
    }

    private void expand() {
        Pair[] pairArray = new Pair[this.array.length << 1];
        int n = this.array.length;
        while (n < pairArray.length) {
            pairArray[n] = new Pair();
            ++n;
        }
        System.arraycopy(this.array, 0, pairArray, 0, this.array.length);
        this.array = pairArray;
    }

    public void push_pair(int n, int n2) {
        if (this.size == this.array.length) {
            this.expand();
        }
        this.array[this.size].index1 = n;
        this.array[this.size].index2 = n2;
        ++this.size;
    }

    public void push_pair_inv(int n, int n2) {
        if (this.size == this.array.length) {
            this.expand();
        }
        this.array[this.size].index1 = n2;
        this.array[this.size].index2 = n;
        ++this.size;
    }
}

