/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class EdgeShape
extends Shape {
    public final Vec2 m_vertex1 = new Vec2();
    public final Vec2 m_vertex2 = new Vec2();
    public final Vec2 m_vertex0 = new Vec2();
    public final Vec2 m_vertex3 = new Vec2();
    public boolean m_hasVertex0 = false;
    public boolean m_hasVertex3 = false;
    private final Vec2 normal = new Vec2();

    public EdgeShape() {
        super(ShapeType.EDGE);
        this.m_radius = Settings.polygonRadius;
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    public void set(Vec2 vec2, Vec2 vec22) {
        this.m_vertex1.set(vec2);
        this.m_vertex2.set(vec22);
        this.m_hasVertex3 = false;
        this.m_hasVertex0 = false;
    }

    @Override
    public boolean testPoint(Transform transform, Vec2 vec2) {
        return false;
    }

    @Override
    public float computeDistanceToOut(Transform transform, Vec2 vec2, int n, Vec2 vec22) {
        float f;
        float f2 = transform.q.c;
        float f3 = transform.q.s;
        float f4 = transform.p.x;
        float f5 = f2 * this.m_vertex1.x - f3 * this.m_vertex1.y + f4;
        float f6 = vec2.x - f5;
        float f7 = f2 * this.m_vertex2.x - f3 * this.m_vertex2.y + f4;
        float f8 = f7 - f5;
        float f9 = transform.p.y;
        float f10 = f3 * this.m_vertex1.x + f2 * this.m_vertex1.y + f9;
        float f11 = vec2.y - f10;
        float f12 = f3 * this.m_vertex2.x + f2 * this.m_vertex2.y + f9;
        float f13 = f12 - f10;
        float f14 = f6 * f8 + f11 * f13;
        if (f14 > 0.0f) {
            f = f8 * f8 + f13 * f13;
            if (f14 > f) {
                f6 = vec2.x - f7;
                f11 = vec2.y - f12;
            } else {
                f6 -= f14 / f * f8;
                f11 -= f14 / f * f13;
            }
        }
        if ((f = MathUtils.sqrt(f6 * f6 + f11 * f11)) > 0.0f) {
            vec22.x = 1.0f / f * f6;
            vec22.y = 1.0f / f * f11;
        } else {
            vec22.x = 0.0f;
            vec22.y = 0.0f;
        }
        return f;
    }

    @Override
    public boolean raycast(RayCastOutput rayCastOutput, RayCastInput rayCastInput, Transform transform, int n) {
        Vec2 vec2 = this.m_vertex1;
        Vec2 vec22 = this.m_vertex2;
        Rot rot = transform.q;
        Vec2 vec23 = transform.p;
        float f = rayCastInput.p1.x - vec23.x;
        float f2 = rayCastInput.p1.y - vec23.y;
        float f3 = rot.c * f + rot.s * f2;
        float f4 = -rot.s * f + rot.c * f2;
        f = rayCastInput.p2.x - vec23.x;
        f2 = rayCastInput.p2.y - vec23.y;
        float f5 = rot.c * f + rot.s * f2;
        float f6 = -rot.s * f + rot.c * f2;
        float f7 = f5 - f3;
        float f8 = f6 - f4;
        this.normal.x = vec22.y - vec2.y;
        this.normal.y = vec2.x - vec22.x;
        this.normal.normalize();
        float f9 = this.normal.x;
        float f10 = this.normal.y;
        f = vec2.x - f3;
        f2 = vec2.y - f4;
        float f11 = f9 * f + f10 * f2;
        float f12 = f9 * f7 + f10 * f8;
        if (f12 == 0.0f) {
            return false;
        }
        float f13 = f11 / f12;
        if (f13 < 0.0f || 1.0f < f13) {
            return false;
        }
        float f14 = f3 + f13 * f7;
        float f15 = f4 + f13 * f8;
        float f16 = vec22.x - vec2.x;
        float f17 = vec22.y - vec2.y;
        float f18 = f16 * f16 + f17 * f17;
        if (f18 == 0.0f) {
            return false;
        }
        f = f14 - vec2.x;
        f2 = f15 - vec2.y;
        float f19 = (f * f16 + f2 * f17) / f18;
        if (f19 < 0.0f || 1.0f < f19) {
            return false;
        }
        rayCastOutput.fraction = f13;
        if (f11 > 0.0f) {
            rayCastOutput.normal.x = -rot.c * this.normal.x + rot.s * this.normal.y;
            rayCastOutput.normal.y = -rot.s * this.normal.x - rot.c * this.normal.y;
        } else {
            rayCastOutput.normal.x = rot.c * this.normal.x - rot.s * this.normal.y;
            rayCastOutput.normal.y = rot.s * this.normal.x + rot.c * this.normal.y;
        }
        return true;
    }

    @Override
    public void computeAABB(AABB aABB, Transform transform, int n) {
        Vec2 vec2 = aABB.lowerBound;
        Vec2 vec22 = aABB.upperBound;
        Rot rot = transform.q;
        float f = rot.c * this.m_vertex1.x - rot.s * this.m_vertex1.y + transform.p.x;
        float f2 = rot.s * this.m_vertex1.x + rot.c * this.m_vertex1.y + transform.p.y;
        float f3 = rot.c * this.m_vertex2.x - rot.s * this.m_vertex2.y + transform.p.x;
        float f4 = rot.s * this.m_vertex2.x + rot.c * this.m_vertex2.y + transform.p.y;
        vec2.x = f < f3 ? f : f3;
        vec2.y = f2 < f4 ? f2 : f4;
        vec22.x = f > f3 ? f : f3;
        vec22.y = f2 > f4 ? f2 : f4;
        vec2.x -= this.m_radius;
        vec2.y -= this.m_radius;
        vec22.x += this.m_radius;
        vec22.y += this.m_radius;
    }

    @Override
    public void computeMass(MassData massData, float f) {
        massData.mass = 0.0f;
        massData.center.set(this.m_vertex1).addLocal(this.m_vertex2).mulLocal(0.5f);
        massData.I = 0.0f;
    }

    @Override
    public Shape clone() {
        EdgeShape edgeShape = new EdgeShape();
        edgeShape.m_radius = this.m_radius;
        edgeShape.m_hasVertex0 = this.m_hasVertex0;
        edgeShape.m_hasVertex3 = this.m_hasVertex3;
        edgeShape.m_vertex0.set(this.m_vertex0);
        edgeShape.m_vertex1.set(this.m_vertex1);
        edgeShape.m_vertex2.set(this.m_vertex2);
        edgeShape.m_vertex3.set(this.m_vertex3);
        return edgeShape;
    }
}

