/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.linearmath.convexhull;

import com.bulletphysics.Pools;
import com.bulletphysics.linearmath.MiscUtil;
import com.bulletphysics.linearmath.VectorUtil;
import com.bulletphysics.linearmath.convexhull.HullDesc;
import com.bulletphysics.linearmath.convexhull.HullFlags;
import com.bulletphysics.linearmath.convexhull.HullResult;
import com.bulletphysics.linearmath.convexhull.Int3;
import com.bulletphysics.linearmath.convexhull.Int4;
import com.bulletphysics.linearmath.convexhull.PHullResult;
import com.bulletphysics.linearmath.convexhull.Tri;
import com.bulletphysics.util.IntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.vecmath.Vector3f;

public class HullLibrary {
    public final IntArrayList vertexIndexMapping = new IntArrayList();
    private final ArrayList<Tri> tris = new ArrayList();
    private static final float EPSILON = 1.0E-6f;

    public boolean createConvexHull(HullDesc hullDesc, HullResult hullResult) {
        boolean bl = false;
        PHullResult pHullResult = new PHullResult();
        int n = hullDesc.vcount;
        if (n < 8) {
            n = 8;
        }
        ArrayList<Vector3f> arrayList = new ArrayList<Vector3f>();
        MiscUtil.resize(arrayList, n, Vector3f.class);
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        int[] nArray = new int[1];
        boolean bl2 = this.cleanupVertices(hullDesc.vcount, hullDesc.vertices, hullDesc.vertexStride, nArray, arrayList, hullDesc.normalEpsilon, vector3f);
        if (bl2) {
            int n2 = 0;
            while (n2 < nArray[0]) {
                Vector3f vector3f2 = arrayList.get(n2);
                VectorUtil.mul(vector3f2, vector3f2, vector3f);
                ++n2;
            }
            bl2 = this.computeHull(nArray[0], arrayList, pHullResult, hullDesc.maxVertices);
            if (bl2) {
                ArrayList<Vector3f> arrayList2 = new ArrayList<Vector3f>();
                MiscUtil.resize(arrayList2, pHullResult.vcount, Vector3f.class);
                this.bringOutYourDead(pHullResult.vertices, pHullResult.vcount, arrayList2, nArray, pHullResult.indices, pHullResult.indexCount);
                bl = true;
                if (hullDesc.hasHullFlag(HullFlags.TRIANGLES)) {
                    hullResult.polygons = false;
                    hullResult.numOutputVertices = nArray[0];
                    MiscUtil.resize(hullResult.outputVertices, nArray[0], Vector3f.class);
                    hullResult.numFaces = pHullResult.faceCount;
                    hullResult.numIndices = pHullResult.indexCount;
                    MiscUtil.resize(hullResult.indices, pHullResult.indexCount, 0);
                    int n3 = 0;
                    while (n3 < nArray[0]) {
                        hullResult.outputVertices.get(n3).set(arrayList2.get(n3));
                        ++n3;
                    }
                    if (hullDesc.hasHullFlag(HullFlags.REVERSE_ORDER)) {
                        IntArrayList intArrayList = pHullResult.indices;
                        int n4 = 0;
                        IntArrayList intArrayList2 = hullResult.indices;
                        int n5 = 0;
                        int n6 = 0;
                        while (n6 < pHullResult.faceCount) {
                            intArrayList2.set(n5 + 0, intArrayList.get(n4 + 2));
                            intArrayList2.set(n5 + 1, intArrayList.get(n4 + 1));
                            intArrayList2.set(n5 + 2, intArrayList.get(n4 + 0));
                            n5 += 3;
                            n4 += 3;
                            ++n6;
                        }
                    } else {
                        n3 = 0;
                        while (n3 < pHullResult.indexCount) {
                            hullResult.indices.set(n3, pHullResult.indices.get(n3));
                            ++n3;
                        }
                    }
                } else {
                    hullResult.polygons = true;
                    hullResult.numOutputVertices = nArray[0];
                    MiscUtil.resize(hullResult.outputVertices, nArray[0], Vector3f.class);
                    hullResult.numFaces = pHullResult.faceCount;
                    hullResult.numIndices = pHullResult.indexCount + pHullResult.faceCount;
                    MiscUtil.resize(hullResult.indices, hullResult.numIndices, 0);
                    int n7 = 0;
                    while (n7 < nArray[0]) {
                        hullResult.outputVertices.get(n7).set(arrayList2.get(n7));
                        ++n7;
                    }
                    IntArrayList intArrayList = pHullResult.indices;
                    int n8 = 0;
                    IntArrayList intArrayList3 = hullResult.indices;
                    int n9 = 0;
                    int n10 = 0;
                    while (n10 < pHullResult.faceCount) {
                        intArrayList3.set(n9 + 0, 3);
                        if (hullDesc.hasHullFlag(HullFlags.REVERSE_ORDER)) {
                            intArrayList3.set(n9 + 1, intArrayList.get(n8 + 2));
                            intArrayList3.set(n9 + 2, intArrayList.get(n8 + 1));
                            intArrayList3.set(n9 + 3, intArrayList.get(n8 + 0));
                        } else {
                            intArrayList3.set(n9 + 1, intArrayList.get(n8 + 0));
                            intArrayList3.set(n9 + 2, intArrayList.get(n8 + 1));
                            intArrayList3.set(n9 + 3, intArrayList.get(n8 + 2));
                        }
                        n9 += 4;
                        n8 += 3;
                        ++n10;
                    }
                }
                HullLibrary.releaseHull(pHullResult);
            }
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        return bl;
    }

    public boolean releaseResult(HullResult hullResult) {
        if (hullResult.outputVertices.size() != 0) {
            hullResult.numOutputVertices = 0;
            hullResult.outputVertices.clear();
        }
        if (hullResult.indices.size() != 0) {
            hullResult.numIndices = 0;
            hullResult.indices.clear();
        }
        return true;
    }

    private boolean computeHull(int n, ArrayList<Vector3f> arrayList, PHullResult pHullResult, int n2) {
        int[] nArray = new int[1];
        int n3 = this.calchull(arrayList, n, pHullResult.indices, nArray, n2);
        if (n3 == 0) {
            return false;
        }
        pHullResult.indexCount = nArray[0] * 3;
        pHullResult.faceCount = nArray[0];
        pHullResult.vertices = arrayList;
        pHullResult.vcount = n;
        return true;
    }

    private Tri allocateTriangle(int n, int n2, int n3) {
        Tri tri = new Tri(n, n2, n3);
        tri.id = this.tris.size();
        this.tris.add(tri);
        return tri;
    }

    private void deAllocateTriangle(Tri tri) {
        assert (this.tris.get(tri.id) == tri);
        this.tris.set(tri.id, null);
    }

    private void b2bfix(Tri tri, Tri tri2) {
        int n = 0;
        while (n < 3) {
            int n2 = (n + 1) % 3;
            int n3 = (n + 2) % 3;
            int n4 = tri.getCoord(n2);
            int n5 = tri.getCoord(n3);
            assert (this.tris.get(tri.neib(n4, n5).get()).neib(n5, n4).get() == tri.id);
            assert (this.tris.get(tri2.neib(n4, n5).get()).neib(n5, n4).get() == tri2.id);
            this.tris.get(tri.neib(n4, n5).get()).neib(n5, n4).set(tri2.neib(n5, n4).get());
            this.tris.get(tri2.neib(n5, n4).get()).neib(n4, n5).set(tri.neib(n4, n5).get());
            ++n;
        }
    }

    private void removeb2b(Tri tri, Tri tri2) {
        this.b2bfix(tri, tri2);
        this.deAllocateTriangle(tri);
        this.deAllocateTriangle(tri2);
    }

    private void checkit(Tri tri) {
        assert (this.tris.get(tri.id) == tri);
        int n = 0;
        while (n < 3) {
            int n2 = (n + 1) % 3;
            int n3 = (n + 2) % 3;
            int n4 = tri.getCoord(n2);
            int n5 = tri.getCoord(n3);
            assert (n4 != n5);
            assert (this.tris.get(tri.n.getCoord(n)).neib(n5, n4).get() == tri.id);
            ++n;
        }
    }

    private Tri extrudable(float f) {
        Tri tri = null;
        for (Tri tri2 : this.tris) {
            if (tri != null && (tri2 == null || !(tri.rise < tri2.rise))) continue;
            tri = tri2;
        }
        return tri != null && tri.rise > f ? tri : null;
    }

    private int calchull(ArrayList<Vector3f> arrayList, int n, IntArrayList intArrayList, int[] nArray, int n2) {
        int n3 = this.calchullgen(arrayList, n, n2);
        if (n3 == 0) {
            return 0;
        }
        IntArrayList intArrayList2 = new IntArrayList();
        for (Tri tri : this.tris) {
            if (tri == null) continue;
            int n4 = 0;
            while (n4 < 3) {
                intArrayList2.add(tri.getCoord(n4));
                ++n4;
            }
            this.deAllocateTriangle(tri);
        }
        nArray[0] = intArrayList2.size() / 3;
        MiscUtil.resize(intArrayList, intArrayList2.size(), 0);
        int n5 = 0;
        while (n5 < intArrayList2.size()) {
            intArrayList.set(n5, intArrayList2.get(n5));
            ++n5;
        }
        MiscUtil.resize(this.tris, 0, Tri.class);
        return 1;
    }

    private int calchullgen(ArrayList<Vector3f> arrayList, int n, int n2) {
        Int4 int4;
        float f;
        IntArrayList intArrayList;
        IntArrayList intArrayList2;
        Vector3f vector3f;
        Vector3f vector3f2;
        Vector3f vector3f3;
        Vector3f vector3f4;
        Vector3f vector3f5;
        Vector3f vector3f6;
        Vector3f vector3f7;
        block20: {
            if (n < 4) {
                return 0;
            }
            vector3f7 = (Vector3f)Pools.VECTORS.get();
            vector3f6 = (Vector3f)Pools.VECTORS.get();
            vector3f5 = (Vector3f)Pools.VECTORS.get();
            if (n2 == 0) {
                n2 = 1000000000;
            }
            vector3f4 = (Vector3f)Pools.VECTORS.get((Object)arrayList.get(0));
            vector3f3 = (Vector3f)Pools.VECTORS.get((Object)arrayList.get(0));
            vector3f2 = (Vector3f)Pools.VECTORS.get();
            vector3f = (Vector3f)Pools.VECTORS.get();
            intArrayList2 = new IntArrayList();
            intArrayList = new IntArrayList();
            int n3 = 0;
            while (n3 < n) {
                intArrayList.add(1);
                intArrayList2.add(0);
                VectorUtil.setMin(vector3f4, arrayList.get(n3));
                VectorUtil.setMax(vector3f3, arrayList.get(n3));
                ++n3;
            }
            vector3f7.sub(vector3f3, vector3f4);
            f = vector3f7.length() * 0.001f;
            assert (f != 0.0f);
            int4 = this.findSimplex(arrayList, n, intArrayList, new Int4());
            if (int4.x != -1) break block20;
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f3, vector3f2, vector3f, vector3f7, vector3f6, vector3f5});
            return 0;
        }
        try {
            Tri tri;
            VectorUtil.add(vector3f2, arrayList.get(int4.getCoord(0)), arrayList.get(int4.getCoord(1)), arrayList.get(int4.getCoord(2)), arrayList.get(int4.getCoord(3)));
            vector3f2.scale(0.25f);
            Tri tri2 = this.allocateTriangle(int4.getCoord(2), int4.getCoord(3), int4.getCoord(1));
            tri2.n.set(2, 3, 1);
            Tri tri3 = this.allocateTriangle(int4.getCoord(3), int4.getCoord(2), int4.getCoord(0));
            tri3.n.set(3, 2, 0);
            Tri tri4 = this.allocateTriangle(int4.getCoord(0), int4.getCoord(1), int4.getCoord(3));
            tri4.n.set(0, 1, 3);
            Tri tri5 = this.allocateTriangle(int4.getCoord(1), int4.getCoord(0), int4.getCoord(2));
            tri5.n.set(1, 0, 2);
            intArrayList2.set(int4.getCoord(0), 1);
            intArrayList2.set(int4.getCoord(1), 1);
            intArrayList2.set(int4.getCoord(2), 1);
            intArrayList2.set(int4.getCoord(3), 1);
            this.checkit(tri2);
            this.checkit(tri3);
            this.checkit(tri4);
            this.checkit(tri5);
            Iterator<Tri> iterator = this.tris.iterator();
            while (iterator.hasNext()) {
                Tri tri6 = tri = iterator.next();
                assert (tri6 != null);
                assert (tri6.vmax < 0);
                HullLibrary.triNormal(arrayList.get(tri6.getCoord(0)), arrayList.get(tri6.getCoord(1)), arrayList.get(tri6.getCoord(2)), vector3f);
                tri6.vmax = HullLibrary.maxdirsterid(arrayList, n, vector3f, intArrayList);
                vector3f7.sub(arrayList.get(tri6.vmax), arrayList.get(tri6.getCoord(0)));
                tri6.rise = vector3f.dot(vector3f7);
            }
            n2 -= 4;
            while (n2 > 0 && (tri = this.extrudable(f)) != null) {
                Int3 int3;
                int n4 = tri.vmax;
                assert (n4 != -1);
                assert (intArrayList2.get(n4) == 0);
                intArrayList2.set(n4, 1);
                int n5 = this.tris.size();
                while (n5-- != 0) {
                    if (this.tris.get(n5) == null || !HullLibrary.above(arrayList, int3 = (Int3)this.tris.get(n5), arrayList.get(n4), 0.01f * f)) continue;
                    this.extrude(this.tris.get(n5), n4);
                }
                n5 = this.tris.size();
                while (n5-- != 0) {
                    if (this.tris.get(n5) == null) continue;
                    if (!HullLibrary.hasvert(this.tris.get(n5), n4)) break;
                    int3 = this.tris.get(n5);
                    vector3f6.sub(arrayList.get(int3.getCoord(1)), arrayList.get(int3.getCoord(0)));
                    vector3f5.sub(arrayList.get(int3.getCoord(2)), arrayList.get(int3.getCoord(1)));
                    vector3f7.cross(vector3f6, vector3f5);
                    if (!HullLibrary.above(arrayList, int3, vector3f2, 0.01f * f) && !(vector3f7.length() < f * f * 0.1f)) continue;
                    Tri tri7 = this.tris.get(this.tris.get((int)n5).n.getCoord(0));
                    assert (tri7 != null);
                    assert (!HullLibrary.hasvert(tri7, n4));
                    assert (tri7.id < n5);
                    this.extrude(tri7, n4);
                    n5 = this.tris.size();
                }
                n5 = this.tris.size();
                while (n5-- != 0) {
                    int3 = this.tris.get(n5);
                    if (int3 == null) continue;
                    if (((Tri)int3).vmax >= 0) break;
                    HullLibrary.triNormal(arrayList.get(int3.getCoord(0)), arrayList.get(int3.getCoord(1)), arrayList.get(int3.getCoord(2)), vector3f);
                    ((Tri)int3).vmax = HullLibrary.maxdirsterid(arrayList, n, vector3f, intArrayList);
                    if (intArrayList2.get(((Tri)int3).vmax) != 0) {
                        ((Tri)int3).vmax = -1;
                        continue;
                    }
                    vector3f7.sub(arrayList.get(((Tri)int3).vmax), arrayList.get(int3.getCoord(0)));
                    ((Tri)int3).rise = vector3f.dot(vector3f7);
                }
                --n2;
            }
        }
        catch (Throwable throwable) {
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f3, vector3f2, vector3f, vector3f7, vector3f6, vector3f5});
            throw throwable;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f3, vector3f2, vector3f, vector3f7, vector3f6, vector3f5});
        return 1;
    }

    private Int4 findSimplex(ArrayList<Vector3f> arrayList, int n, IntArrayList intArrayList, Int4 int4) {
        int n2;
        int n3;
        int n4;
        int n5;
        Vector3f[] vector3fArray;
        Vector3f vector3f;
        Vector3f vector3f2;
        Vector3f vector3f3;
        block12: {
            block11: {
                block10: {
                    Int4 int42;
                    vector3f3 = (Vector3f)Pools.VECTORS.get();
                    vector3f2 = (Vector3f)Pools.VECTORS.get();
                    vector3f = (Vector3f)Pools.VECTORS.get();
                    vector3fArray = new Vector3f[]{(Vector3f)Pools.VECTORS.get(), (Vector3f)Pools.VECTORS.get(), (Vector3f)Pools.VECTORS.get()};
                    try {
                        vector3fArray[0].set(0.01f, 0.02f, 1.0f);
                        n5 = HullLibrary.maxdirsterid(arrayList, n, vector3fArray[0], intArrayList);
                        vector3f3.negate(vector3fArray[0]);
                        n4 = HullLibrary.maxdirsterid(arrayList, n, vector3f3, intArrayList);
                        vector3fArray[0].sub(arrayList.get(n5), arrayList.get(n4));
                        if (n5 != n4 && (vector3fArray[0].x != 0.0f || vector3fArray[0].y != 0.0f || vector3fArray[0].z != 0.0f)) break block10;
                        int4.set(-1, -1, -1, -1);
                        int42 = int4;
                    }
                    catch (Throwable throwable) {
                        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f2, vector3f, vector3fArray[0], vector3fArray[1], vector3fArray[2]});
                        throw throwable;
                    }
                    Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f2, vector3f, vector3fArray[0], vector3fArray[1], vector3fArray[2]});
                    return int42;
                }
                vector3f3.set(1.0f, 0.02f, 0.0f);
                vector3fArray[1].cross(vector3f3, vector3fArray[0]);
                vector3f3.set(-0.02f, 1.0f, 0.0f);
                vector3fArray[2].cross(vector3f3, vector3fArray[0]);
                if (!(vector3fArray[1].length() > vector3fArray[2].length())) {
                    vector3fArray[1].set(vector3fArray[2]);
                }
                vector3fArray[1].normalize();
                n3 = HullLibrary.maxdirsterid(arrayList, n, vector3fArray[1], intArrayList);
                if (n3 == n5 || n3 == n4) {
                    vector3f3.negate(vector3fArray[1]);
                    n3 = HullLibrary.maxdirsterid(arrayList, n, vector3f3, intArrayList);
                }
                if (n3 != n5 && n3 != n4) break block11;
                int4.set(-1, -1, -1, -1);
                Int4 int43 = int4;
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f2, vector3f, vector3fArray[0], vector3fArray[1], vector3fArray[2]});
                return int43;
            }
            vector3fArray[1].sub(arrayList.get(n3), arrayList.get(n5));
            vector3fArray[2].cross(vector3fArray[1], vector3fArray[0]);
            vector3fArray[2].normalize();
            n2 = HullLibrary.maxdirsterid(arrayList, n, vector3fArray[2], intArrayList);
            if (n2 == n5 || n2 == n4 || n2 == n3) {
                vector3f3.negate(vector3fArray[2]);
                n2 = HullLibrary.maxdirsterid(arrayList, n, vector3f3, intArrayList);
            }
            if (n2 != n5 && n2 != n4 && n2 != n3) break block12;
            int4.set(-1, -1, -1, -1);
            Int4 int44 = int4;
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f2, vector3f, vector3fArray[0], vector3fArray[1], vector3fArray[2]});
            return int44;
        }
        assert (n5 != n4 && n5 != n3 && n5 != n2 && n4 != n3 && n4 != n2 && n3 != n2);
        vector3f2.sub(arrayList.get(n4), arrayList.get(n5));
        vector3f.sub(arrayList.get(n3), arrayList.get(n5));
        vector3f.cross(vector3f2, vector3f);
        vector3f2.sub(arrayList.get(n2), arrayList.get(n5));
        if (vector3f2.dot(vector3f) < 0.0f) {
            int n6 = n3;
            n3 = n2;
            n2 = n6;
        }
        int4.set(n5, n4, n3, n2);
        Int4 int45 = int4;
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f2, vector3f, vector3fArray[0], vector3fArray[1], vector3fArray[2]});
        return int45;
    }

    private void extrude(Tri tri, int n) {
        Int3 int3 = new Int3(tri);
        int n2 = this.tris.size();
        Tri tri2 = this.allocateTriangle(n, int3.getCoord(1), int3.getCoord(2));
        tri2.n.set(tri.n.getCoord(0), n2 + 1, n2 + 2);
        this.tris.get(tri.n.getCoord(0)).neib(int3.getCoord(1), int3.getCoord(2)).set(n2 + 0);
        Tri tri3 = this.allocateTriangle(n, int3.getCoord(2), int3.getCoord(0));
        tri3.n.set(tri.n.getCoord(1), n2 + 2, n2 + 0);
        this.tris.get(tri.n.getCoord(1)).neib(int3.getCoord(2), int3.getCoord(0)).set(n2 + 1);
        Tri tri4 = this.allocateTriangle(n, int3.getCoord(0), int3.getCoord(1));
        tri4.n.set(tri.n.getCoord(2), n2 + 0, n2 + 1);
        this.tris.get(tri.n.getCoord(2)).neib(int3.getCoord(0), int3.getCoord(1)).set(n2 + 2);
        this.checkit(tri2);
        this.checkit(tri3);
        this.checkit(tri4);
        if (HullLibrary.hasvert(this.tris.get(tri2.n.getCoord(0)), n)) {
            this.removeb2b(tri2, this.tris.get(tri2.n.getCoord(0)));
        }
        if (HullLibrary.hasvert(this.tris.get(tri3.n.getCoord(0)), n)) {
            this.removeb2b(tri3, this.tris.get(tri3.n.getCoord(0)));
        }
        if (HullLibrary.hasvert(this.tris.get(tri4.n.getCoord(0)), n)) {
            this.removeb2b(tri4, this.tris.get(tri4.n.getCoord(0)));
        }
        this.deAllocateTriangle(tri);
    }

    private void bringOutYourDead(ArrayList<Vector3f> arrayList, int n, ArrayList<Vector3f> arrayList2, int[] nArray, IntArrayList intArrayList, int n2) {
        IntArrayList intArrayList2 = new IntArrayList();
        int n3 = 0;
        while (n3 < this.vertexIndexMapping.size()) {
            intArrayList2.add(this.vertexIndexMapping.size());
            ++n3;
        }
        IntArrayList intArrayList3 = new IntArrayList();
        MiscUtil.resize(intArrayList3, n, 0);
        nArray[0] = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = intArrayList.get(n4);
            assert (n5 >= 0 && n5 < n);
            if (intArrayList3.get(n5) != 0) {
                intArrayList.set(n4, intArrayList3.get(n5) - 1);
            } else {
                intArrayList.set(n4, nArray[0]);
                arrayList2.get(nArray[0]).set(arrayList.get(n5));
                int n6 = 0;
                while (n6 < this.vertexIndexMapping.size()) {
                    if (intArrayList2.get(n6) == n5) {
                        this.vertexIndexMapping.set(n6, nArray[0]);
                    }
                    ++n6;
                }
                nArray[0] = nArray[0] + 1;
                assert (nArray[0] >= 0 && nArray[0] <= n);
                intArrayList3.set(n5, nArray[0]);
            }
            ++n4;
        }
    }

    private boolean cleanupVertices(int n, ArrayList<Vector3f> arrayList, int n2, int[] nArray, ArrayList<Vector3f> arrayList2, float f, Vector3f vector3f) {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        Vector3f vector3f2;
        if (n == 0) {
            return false;
        }
        this.vertexIndexMapping.clear();
        nArray[0] = 0;
        float[] fArray = new float[3];
        if (vector3f != null) {
            vector3f.set(1.0f, 1.0f, 1.0f);
        }
        float[] fArray2 = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE};
        float[] fArray3 = new float[]{-3.4028235E38f, -3.4028235E38f, -3.4028235E38f};
        ArrayList<Vector3f> arrayList3 = arrayList;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            Vector3f vector3f3 = arrayList3.get(n3);
            ++n3;
            int n5 = 0;
            while (n5 < 3) {
                if (VectorUtil.getCoord(vector3f3, n5) < fArray2[n5]) {
                    fArray2[n5] = VectorUtil.getCoord(vector3f3, n5);
                }
                if (VectorUtil.getCoord(vector3f3, n5) > fArray3[n5]) {
                    fArray3[n5] = VectorUtil.getCoord(vector3f3, n5);
                }
                ++n5;
            }
            ++n4;
        }
        float f7 = fArray3[0] - fArray2[0];
        float f8 = fArray3[1] - fArray2[1];
        float f9 = fArray3[2] - fArray2[2];
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.x = f7 * 0.5f + fArray2[0];
        vector3f4.y = f8 * 0.5f + fArray2[1];
        vector3f4.z = f9 * 0.5f + fArray2[2];
        if (f7 < 1.0E-6f || f8 < 1.0E-6f || f9 < 1.0E-6f || n < 3) {
            float f10 = Float.MAX_VALUE;
            if (f7 > 1.0E-6f && f7 < f10) {
                f10 = f7;
            }
            if (f8 > 1.0E-6f && f8 < f10) {
                f10 = f8;
            }
            if (f9 > 1.0E-6f && f9 < f10) {
                f10 = f9;
            }
            if (f10 == Float.MAX_VALUE) {
                f9 = 0.01f;
                f8 = 0.01f;
                f7 = 0.01f;
            } else {
                if (f7 < 1.0E-6f) {
                    f7 = f10 * 0.05f;
                }
                if (f8 < 1.0E-6f) {
                    f8 = f10 * 0.05f;
                }
                if (f9 < 1.0E-6f) {
                    f9 = f10 * 0.05f;
                }
            }
            float f11 = vector3f4.x - f7;
            float f12 = vector3f4.x + f7;
            float f13 = vector3f4.y - f8;
            float f14 = vector3f4.y + f8;
            float f15 = vector3f4.z - f9;
            float f16 = vector3f4.z + f9;
            HullLibrary.addPoint(nArray, arrayList2, f11, f13, f15);
            HullLibrary.addPoint(nArray, arrayList2, f12, f13, f15);
            HullLibrary.addPoint(nArray, arrayList2, f12, f14, f15);
            HullLibrary.addPoint(nArray, arrayList2, f11, f14, f15);
            HullLibrary.addPoint(nArray, arrayList2, f11, f13, f16);
            HullLibrary.addPoint(nArray, arrayList2, f12, f13, f16);
            HullLibrary.addPoint(nArray, arrayList2, f12, f14, f16);
            HullLibrary.addPoint(nArray, arrayList2, f11, f14, f16);
            return true;
        }
        if (vector3f != null) {
            vector3f.x = f7;
            vector3f.y = f8;
            vector3f.z = f9;
            fArray[0] = 1.0f / f7;
            fArray[1] = 1.0f / f8;
            fArray[2] = 1.0f / f9;
            vector3f4.x *= fArray[0];
            vector3f4.y *= fArray[1];
            vector3f4.z *= fArray[2];
        }
        arrayList3 = arrayList;
        n3 = 0;
        int n6 = 0;
        while (n6 < n) {
            Vector3f vector3f5;
            vector3f2 = arrayList3.get(n3);
            ++n3;
            float f17 = vector3f2.x;
            f6 = vector3f2.y;
            f5 = vector3f2.z;
            if (vector3f != null) {
                f17 *= fArray[0];
                f6 *= fArray[1];
                f5 *= fArray[2];
            }
            int n7 = 0;
            while (n7 < nArray[0]) {
                vector3f5 = arrayList2.get(n7);
                f4 = vector3f5.x;
                f3 = vector3f5.y;
                f2 = vector3f5.z;
                f7 = Math.abs(f4 - f17);
                f8 = Math.abs(f3 - f6);
                f9 = Math.abs(f2 - f5);
                if (f7 < f && f8 < f && f9 < f) {
                    float f18;
                    float f19 = HullLibrary.getDist(f17, f6, f5, vector3f4);
                    if (!(f19 > (f18 = HullLibrary.getDist(vector3f5.x, vector3f5.y, vector3f5.z, vector3f4)))) break;
                    vector3f5.x = f17;
                    vector3f5.y = f6;
                    vector3f5.z = f5;
                    break;
                }
                ++n7;
            }
            if (n7 == nArray[0]) {
                vector3f5 = arrayList2.get(nArray[0]);
                vector3f5.x = f17;
                vector3f5.y = f6;
                vector3f5.z = f5;
                nArray[0] = nArray[0] + 1;
            }
            this.vertexIndexMapping.add(n7);
            ++n6;
        }
        fArray2 = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE};
        fArray3 = new float[]{-3.4028235E38f, -3.4028235E38f, -3.4028235E38f};
        n6 = 0;
        while (n6 < nArray[0]) {
            vector3f2 = arrayList2.get(n6);
            int n8 = 0;
            while (n8 < 3) {
                if (VectorUtil.getCoord(vector3f2, n8) < fArray2[n8]) {
                    fArray2[n8] = VectorUtil.getCoord(vector3f2, n8);
                }
                if (VectorUtil.getCoord(vector3f2, n8) > fArray3[n8]) {
                    fArray3[n8] = VectorUtil.getCoord(vector3f2, n8);
                }
                ++n8;
            }
            ++n6;
        }
        f7 = fArray3[0] - fArray2[0];
        f8 = fArray3[1] - fArray2[1];
        f9 = fArray3[2] - fArray2[2];
        if (f7 < 1.0E-6f || f8 < 1.0E-6f || f9 < 1.0E-6f || nArray[0] < 3) {
            float f20 = f7 * 0.5f + fArray2[0];
            float f21 = f8 * 0.5f + fArray2[1];
            float f22 = f9 * 0.5f + fArray2[2];
            f6 = Float.MAX_VALUE;
            if (f7 >= 1.0E-6f && f7 < f6) {
                f6 = f7;
            }
            if (f8 >= 1.0E-6f && f8 < f6) {
                f6 = f8;
            }
            if (f9 >= 1.0E-6f && f9 < f6) {
                f6 = f9;
            }
            if (f6 == Float.MAX_VALUE) {
                f9 = 0.01f;
                f8 = 0.01f;
                f7 = 0.01f;
            } else {
                if (f7 < 1.0E-6f) {
                    f7 = f6 * 0.05f;
                }
                if (f8 < 1.0E-6f) {
                    f8 = f6 * 0.05f;
                }
                if (f9 < 1.0E-6f) {
                    f9 = f6 * 0.05f;
                }
            }
            f5 = f20 - f7;
            float f23 = f20 + f7;
            float f24 = f21 - f8;
            f4 = f21 + f8;
            f3 = f22 - f9;
            f2 = f22 + f9;
            nArray[0] = 0;
            HullLibrary.addPoint(nArray, arrayList2, f5, f24, f3);
            HullLibrary.addPoint(nArray, arrayList2, f23, f24, f3);
            HullLibrary.addPoint(nArray, arrayList2, f23, f4, f3);
            HullLibrary.addPoint(nArray, arrayList2, f5, f4, f3);
            HullLibrary.addPoint(nArray, arrayList2, f5, f24, f2);
            HullLibrary.addPoint(nArray, arrayList2, f23, f24, f2);
            HullLibrary.addPoint(nArray, arrayList2, f23, f4, f2);
            HullLibrary.addPoint(nArray, arrayList2, f5, f4, f2);
            return true;
        }
        return true;
    }

    private static boolean hasvert(Int3 int3, int n) {
        return int3.getCoord(0) == n || int3.getCoord(1) == n || int3.getCoord(2) == n;
    }

    private static Vector3f orth(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3;
        Vector3f vector3f4;
        block3: {
            Vector3f vector3f5;
            vector3f4 = (Vector3f)Pools.VECTORS.get();
            vector3f4.set(0.0f, 0.0f, 1.0f);
            vector3f4.cross(vector3f, vector3f4);
            vector3f3 = (Vector3f)Pools.VECTORS.get();
            vector3f3.set(0.0f, 1.0f, 0.0f);
            vector3f3.cross(vector3f, vector3f3);
            try {
                if (!(vector3f4.length() > vector3f3.length())) break block3;
                vector3f2.normalize(vector3f4);
                vector3f5 = vector3f2;
            }
            catch (Throwable throwable) {
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f3});
                throw throwable;
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f3});
            return vector3f5;
        }
        vector3f2.normalize(vector3f3);
        Vector3f vector3f6 = vector3f2;
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f3});
        return vector3f6;
    }

    private static int maxdirfiltered(ArrayList<Vector3f> arrayList, int n, Vector3f vector3f, IntArrayList intArrayList) {
        assert (n != 0);
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            if (intArrayList.get(n3) != 0 && (n2 == -1 || arrayList.get(n3).dot(vector3f) > arrayList.get(n2).dot(vector3f))) {
                n2 = n3;
            }
            ++n3;
        }
        assert (n2 != -1);
        return n2;
    }

    /*
     * Exception decompiling
     */
    private static int maxdirsterid(ArrayList<Vector3f> var0, int var1_1, Vector3f var2_2, IntArrayList var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Vector3f triNormal(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        float f;
        Vector3f vector3f5;
        Vector3f vector3f6;
        Vector3f vector3f7;
        block3: {
            Vector3f vector3f8;
            vector3f7 = (Vector3f)Pools.VECTORS.get();
            vector3f6 = (Vector3f)Pools.VECTORS.get();
            vector3f5 = (Vector3f)Pools.VECTORS.get();
            try {
                vector3f7.sub(vector3f2, vector3f);
                vector3f6.sub(vector3f3, vector3f2);
                vector3f5.cross(vector3f7, vector3f6);
                f = vector3f5.length();
                if (f != 0.0f) break block3;
                vector3f4.set(1.0f, 0.0f, 0.0f);
                vector3f8 = vector3f4;
            }
            catch (Throwable throwable) {
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6, vector3f5});
                throw throwable;
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6, vector3f5});
            return vector3f8;
        }
        vector3f4.scale(1.0f / f, vector3f5);
        Vector3f vector3f9 = vector3f4;
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6, vector3f5});
        return vector3f9;
    }

    private static boolean above(ArrayList<Vector3f> arrayList, Int3 int3, Vector3f vector3f, float f) {
        Vector3f vector3f2 = HullLibrary.triNormal(arrayList.get(int3.getCoord(0)), arrayList.get(int3.getCoord(1)), arrayList.get(int3.getCoord(2)), (Vector3f)Pools.VECTORS.get());
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.sub(vector3f, arrayList.get(int3.getCoord(0)));
        boolean bl = vector3f2.dot(vector3f3) > f;
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f2});
        return bl;
    }

    private static void releaseHull(PHullResult pHullResult) {
        if (pHullResult.indices.size() != 0) {
            pHullResult.indices.clear();
        }
        pHullResult.vcount = 0;
        pHullResult.indexCount = 0;
        pHullResult.vertices = null;
    }

    private static void addPoint(int[] nArray, ArrayList<Vector3f> arrayList, float f, float f2, float f3) {
        Vector3f vector3f = arrayList.get(nArray[0]);
        vector3f.x = f;
        vector3f.y = f2;
        vector3f.z = f3;
        nArray[0] = nArray[0] + 1;
    }

    private static float getDist(float f, float f2, float f3, Vector3f vector3f) {
        float f4 = f - vector3f.x;
        float f5 = f2 - vector3f.y;
        float f6 = f3 - vector3f.z;
        return f4 * f4 + f5 * f5 + f6 * f6;
    }
}

