/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import org.jbox2d.callbacks.ContactImpulse;
import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Sweep;
import org.jbox2d.common.Timer;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Profile;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactSolver;
import org.jbox2d.dynamics.contacts.ContactVelocityConstraint;
import org.jbox2d.dynamics.contacts.Position;
import org.jbox2d.dynamics.contacts.Velocity;
import org.jbox2d.dynamics.joints.Joint;

public class Island {
    public ContactListener m_listener;
    public Body[] m_bodies;
    public Contact[] m_contacts;
    public Joint[] m_joints;
    public Position[] m_positions;
    public Velocity[] m_velocities;
    public int m_bodyCount;
    public int m_jointCount;
    public int m_contactCount;
    public int m_bodyCapacity;
    public int m_contactCapacity;
    public int m_jointCapacity;
    private final ContactSolver contactSolver = new ContactSolver();
    private final Timer timer = new Timer();
    private final SolverData solverData = new SolverData();
    private final ContactSolver.ContactSolverDef solverDef = new ContactSolver.ContactSolverDef();
    private final ContactSolver toiContactSolver = new ContactSolver();
    private final ContactSolver.ContactSolverDef toiSolverDef = new ContactSolver.ContactSolverDef();
    private final ContactImpulse impulse = new ContactImpulse();

    public void init(int n, int n2, int n3, ContactListener contactListener) {
        int n4;
        Object[] objectArray;
        this.m_bodyCapacity = n;
        this.m_contactCapacity = n2;
        this.m_jointCapacity = n3;
        this.m_bodyCount = 0;
        this.m_contactCount = 0;
        this.m_jointCount = 0;
        this.m_listener = contactListener;
        if (this.m_bodies == null || this.m_bodyCapacity > this.m_bodies.length) {
            this.m_bodies = new Body[this.m_bodyCapacity];
        }
        if (this.m_joints == null || this.m_jointCapacity > this.m_joints.length) {
            this.m_joints = new Joint[this.m_jointCapacity];
        }
        if (this.m_contacts == null || this.m_contactCapacity > this.m_contacts.length) {
            this.m_contacts = new Contact[this.m_contactCapacity];
        }
        if (this.m_velocities == null || this.m_bodyCapacity > this.m_velocities.length) {
            objectArray = this.m_velocities == null ? new Velocity[]{} : this.m_velocities;
            this.m_velocities = new Velocity[this.m_bodyCapacity];
            System.arraycopy(objectArray, 0, this.m_velocities, 0, objectArray.length);
            n4 = objectArray.length;
            while (n4 < this.m_velocities.length) {
                this.m_velocities[n4] = new Velocity();
                ++n4;
            }
        }
        if (this.m_positions == null || this.m_bodyCapacity > this.m_positions.length) {
            objectArray = this.m_positions == null ? new Position[]{} : this.m_positions;
            this.m_positions = new Position[this.m_bodyCapacity];
            System.arraycopy(objectArray, 0, this.m_positions, 0, objectArray.length);
            n4 = objectArray.length;
            while (n4 < this.m_positions.length) {
                this.m_positions[n4] = new Position();
                ++n4;
            }
        }
    }

    public void clear() {
        this.m_bodyCount = 0;
        this.m_contactCount = 0;
        this.m_jointCount = 0;
    }

    public void solve(Profile profile, TimeStep timeStep, Vec2 vec2, boolean bl) {
        float f;
        float f2;
        Vec2 vec22;
        Object object;
        float f3 = timeStep.dt;
        int n = 0;
        while (n < this.m_bodyCount) {
            object = this.m_bodies[n];
            Sweep sweep = ((Body)object).m_sweep;
            vec22 = sweep.c;
            f2 = sweep.a;
            Vec2 vec23 = ((Body)object).m_linearVelocity;
            f = ((Body)object).m_angularVelocity;
            sweep.c0.set(sweep.c);
            sweep.a0 = sweep.a;
            if (((Body)object).m_type == BodyType.DYNAMIC) {
                vec23.x += f3 * (((Body)object).m_gravityScale * vec2.x + ((Body)object).m_invMass * ((Body)object).m_force.x);
                vec23.y += f3 * (((Body)object).m_gravityScale * vec2.y + ((Body)object).m_invMass * ((Body)object).m_force.y);
                f += f3 * ((Body)object).m_invI * ((Body)object).m_torque;
                vec23.x *= 1.0f / (1.0f + f3 * ((Body)object).m_linearDamping);
                vec23.y *= 1.0f / (1.0f + f3 * ((Body)object).m_linearDamping);
                f *= 1.0f / (1.0f + f3 * ((Body)object).m_angularDamping);
            }
            this.m_positions[n].c.x = vec22.x;
            this.m_positions[n].c.y = vec22.y;
            this.m_positions[n].a = f2;
            this.m_velocities[n].v.x = vec23.x;
            this.m_velocities[n].v.y = vec23.y;
            this.m_velocities[n].w = f;
            ++n;
        }
        this.timer.reset();
        this.solverData.step = timeStep;
        this.solverData.positions = this.m_positions;
        this.solverData.velocities = this.m_velocities;
        this.solverDef.step = timeStep;
        this.solverDef.contacts = this.m_contacts;
        this.solverDef.count = this.m_contactCount;
        this.solverDef.positions = this.m_positions;
        this.solverDef.velocities = this.m_velocities;
        this.contactSolver.init(this.solverDef);
        this.contactSolver.initializeVelocityConstraints();
        if (timeStep.warmStarting) {
            this.contactSolver.warmStart();
        }
        n = 0;
        while (n < this.m_jointCount) {
            this.m_joints[n].initVelocityConstraints(this.solverData);
            ++n;
        }
        profile.solveInit.accum(this.timer.getMilliseconds());
        this.timer.reset();
        n = 0;
        while (n < timeStep.velocityIterations) {
            int n2 = 0;
            while (n2 < this.m_jointCount) {
                this.m_joints[n2].solveVelocityConstraints(this.solverData);
                ++n2;
            }
            this.contactSolver.solveVelocityConstraints();
            ++n;
        }
        this.contactSolver.storeImpulses();
        profile.solveVelocity.accum(this.timer.getMilliseconds());
        n = 0;
        while (n < this.m_bodyCount) {
            float f4;
            object = this.m_positions[n].c;
            float f5 = this.m_positions[n].a;
            vec22 = this.m_velocities[n].v;
            f2 = this.m_velocities[n].w;
            float f6 = vec22.x * f3;
            f = vec22.y * f3;
            if (f6 * f6 + f * f > Settings.maxTranslationSquared) {
                f4 = Settings.maxTranslation / MathUtils.sqrt(f6 * f6 + f * f);
                vec22.x *= f4;
                vec22.y *= f4;
            }
            if ((f4 = f3 * f2) * f4 > Settings.maxRotationSquared) {
                float f7 = Settings.maxRotation / MathUtils.abs(f4);
                f2 *= f7;
            }
            ((Vec2)object).x += f3 * vec22.x;
            ((Vec2)object).y += f3 * vec22.y;
            this.m_positions[n].a = f5 += f3 * f2;
            this.m_velocities[n].w = f2;
            ++n;
        }
        this.timer.reset();
        n = 0;
        int n3 = 0;
        while (n3 < timeStep.positionIterations) {
            boolean bl2 = this.contactSolver.solvePositionConstraints();
            boolean bl3 = true;
            int n4 = 0;
            while (n4 < this.m_jointCount) {
                boolean bl4 = this.m_joints[n4].solvePositionConstraints(this.solverData);
                bl3 = bl3 && bl4;
                ++n4;
            }
            if (bl2 && bl3) {
                n = 1;
                break;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.m_bodyCount) {
            Body body = this.m_bodies[n3];
            body.m_sweep.c.x = this.m_positions[n3].c.x;
            body.m_sweep.c.y = this.m_positions[n3].c.y;
            body.m_sweep.a = this.m_positions[n3].a;
            body.m_linearVelocity.x = this.m_velocities[n3].v.x;
            body.m_linearVelocity.y = this.m_velocities[n3].v.y;
            body.m_angularVelocity = this.m_velocities[n3].w;
            body.synchronizeTransform();
            ++n3;
        }
        profile.solvePosition.accum(this.timer.getMilliseconds());
        this.report(this.contactSolver.m_velocityConstraints);
        if (bl) {
            float f8 = Float.MAX_VALUE;
            float f9 = Settings.linearSleepTolerance * Settings.linearSleepTolerance;
            float f10 = Settings.angularSleepTolerance * Settings.angularSleepTolerance;
            int n5 = 0;
            while (n5 < this.m_bodyCount) {
                Body body = this.m_bodies[n5];
                if (body.getType() != BodyType.STATIC) {
                    if ((body.m_flags & 4) == 0 || body.m_angularVelocity * body.m_angularVelocity > f10 || Vec2.dot(body.m_linearVelocity, body.m_linearVelocity) > f9) {
                        body.m_sleepTime = 0.0f;
                        f8 = 0.0f;
                    } else {
                        body.m_sleepTime += f3;
                        f8 = MathUtils.min(f8, body.m_sleepTime);
                    }
                }
                ++n5;
            }
            if (f8 >= Settings.timeToSleep && n != 0) {
                n5 = 0;
                while (n5 < this.m_bodyCount) {
                    Body body = this.m_bodies[n5];
                    body.setAwake(false);
                    ++n5;
                }
            }
        }
    }

    public void solveTOI(TimeStep timeStep, int n, int n2) {
        int n3;
        assert (n < this.m_bodyCount);
        assert (n2 < this.m_bodyCount);
        int n4 = 0;
        while (n4 < this.m_bodyCount) {
            this.m_positions[n4].c.x = this.m_bodies[n4].m_sweep.c.x;
            this.m_positions[n4].c.y = this.m_bodies[n4].m_sweep.c.y;
            this.m_positions[n4].a = this.m_bodies[n4].m_sweep.a;
            this.m_velocities[n4].v.x = this.m_bodies[n4].m_linearVelocity.x;
            this.m_velocities[n4].v.y = this.m_bodies[n4].m_linearVelocity.y;
            this.m_velocities[n4].w = this.m_bodies[n4].m_angularVelocity;
            ++n4;
        }
        this.toiSolverDef.contacts = this.m_contacts;
        this.toiSolverDef.count = this.m_contactCount;
        this.toiSolverDef.step = timeStep;
        this.toiSolverDef.positions = this.m_positions;
        this.toiSolverDef.velocities = this.m_velocities;
        this.toiContactSolver.init(this.toiSolverDef);
        n4 = 0;
        while (n4 < timeStep.positionIterations) {
            n3 = this.toiContactSolver.solveTOIPositionConstraints(n, n2);
            if (n3 != 0) break;
            ++n4;
        }
        this.m_bodies[n].m_sweep.c0.x = this.m_positions[n].c.x;
        this.m_bodies[n].m_sweep.c0.y = this.m_positions[n].c.y;
        this.m_bodies[n].m_sweep.a0 = this.m_positions[n].a;
        this.m_bodies[n2].m_sweep.c0.set(this.m_positions[n2].c);
        this.m_bodies[n2].m_sweep.a0 = this.m_positions[n2].a;
        this.toiContactSolver.initializeVelocityConstraints();
        n4 = 0;
        while (n4 < timeStep.velocityIterations) {
            this.toiContactSolver.solveVelocityConstraints();
            ++n4;
        }
        float f = timeStep.dt;
        n3 = 0;
        while (n3 < this.m_bodyCount) {
            float f2;
            Vec2 vec2 = this.m_positions[n3].c;
            float f3 = this.m_positions[n3].a;
            Vec2 vec22 = this.m_velocities[n3].v;
            float f4 = this.m_velocities[n3].w;
            float f5 = vec22.x * f;
            float f6 = vec22.y * f;
            if (f5 * f5 + f6 * f6 > Settings.maxTranslationSquared) {
                f2 = Settings.maxTranslation / MathUtils.sqrt(f5 * f5 + f6 * f6);
                vec22.mulLocal(f2);
            }
            if ((f2 = f * f4) * f2 > Settings.maxRotationSquared) {
                float f7 = Settings.maxRotation / MathUtils.abs(f2);
                f4 *= f7;
            }
            vec2.x += vec22.x * f;
            vec2.y += vec22.y * f;
            this.m_positions[n3].c.x = vec2.x;
            this.m_positions[n3].c.y = vec2.y;
            this.m_positions[n3].a = f3 += f * f4;
            this.m_velocities[n3].v.x = vec22.x;
            this.m_velocities[n3].v.y = vec22.y;
            this.m_velocities[n3].w = f4;
            Body body = this.m_bodies[n3];
            body.m_sweep.c.x = vec2.x;
            body.m_sweep.c.y = vec2.y;
            body.m_sweep.a = f3;
            body.m_linearVelocity.x = vec22.x;
            body.m_linearVelocity.y = vec22.y;
            body.m_angularVelocity = f4;
            body.synchronizeTransform();
            ++n3;
        }
        this.report(this.toiContactSolver.m_velocityConstraints);
    }

    public void add(Body body) {
        assert (this.m_bodyCount < this.m_bodyCapacity);
        body.m_islandIndex = this.m_bodyCount;
        this.m_bodies[this.m_bodyCount] = body;
        ++this.m_bodyCount;
    }

    public void add(Contact contact) {
        assert (this.m_contactCount < this.m_contactCapacity);
        this.m_contacts[this.m_contactCount++] = contact;
    }

    public void add(Joint joint) {
        assert (this.m_jointCount < this.m_jointCapacity);
        this.m_joints[this.m_jointCount++] = joint;
    }

    public void report(ContactVelocityConstraint[] contactVelocityConstraintArray) {
        if (this.m_listener == null) {
            return;
        }
        int n = 0;
        while (n < this.m_contactCount) {
            Contact contact = this.m_contacts[n];
            ContactVelocityConstraint contactVelocityConstraint = contactVelocityConstraintArray[n];
            int n2 = 0;
            while (n2 < contactVelocityConstraint.pointCount) {
                this.impulse.normalImpulses[n2] = contactVelocityConstraint.points[n2].normalImpulse;
                this.impulse.tangentImpulses[n2] = contactVelocityConstraint.points[n2].tangentImpulse;
                ++n2;
            }
            this.m_listener.postSolve(contact, this.impulse);
            ++n;
        }
    }
}

