/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.narrowphase;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.narrowphase.SimplexSolverInterface;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Vector3f;

public class VoronoiSimplexSolver
extends SimplexSolverInterface {
    private static final int VORONOI_SIMPLEX_MAX_VERTS = 5;
    private static final int VERTA = 0;
    private static final int VERTB = 1;
    private static final int VERTC = 2;
    private static final int VERTD = 3;
    public int numVertices;
    public final Vector3f[] simplexVectorW = new Vector3f[5];
    public final Vector3f[] simplexPointsP = new Vector3f[5];
    public final Vector3f[] simplexPointsQ = new Vector3f[5];
    public final Vector3f cachedP1 = new Vector3f();
    public final Vector3f cachedP2 = new Vector3f();
    public final Vector3f cachedV = new Vector3f();
    public final Vector3f lastW = new Vector3f();
    public boolean cachedValidClosest;
    public final SubSimplexClosestResult cachedBC = new SubSimplexClosestResult();
    public boolean needsUpdate;

    public VoronoiSimplexSolver() {
        int n = 0;
        while (n < 5) {
            this.simplexVectorW[n] = new Vector3f();
            this.simplexPointsP[n] = new Vector3f();
            this.simplexPointsQ[n] = new Vector3f();
            ++n;
        }
    }

    public void removeVertex(int n) {
        assert (this.numVertices > 0);
        --this.numVertices;
        this.simplexVectorW[n].set(this.simplexVectorW[this.numVertices]);
        this.simplexPointsP[n].set(this.simplexPointsP[this.numVertices]);
        this.simplexPointsQ[n].set(this.simplexPointsQ[this.numVertices]);
    }

    public void reduceVertices(UsageBitfield usageBitfield) {
        if (this.numVertices() >= 4 && !usageBitfield.usedVertexD) {
            this.removeVertex(3);
        }
        if (this.numVertices() >= 3 && !usageBitfield.usedVertexC) {
            this.removeVertex(2);
        }
        if (this.numVertices() >= 2 && !usageBitfield.usedVertexB) {
            this.removeVertex(1);
        }
        if (this.numVertices() >= 1 && !usageBitfield.usedVertexA) {
            this.removeVertex(0);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean updateClosestVectorAndPoints() {
        block14: {
            if (!this.needsUpdate) break block14;
            this.cachedBC.reset();
            this.needsUpdate = false;
            switch (this.numVertices()) {
                case 0: {
                    this.cachedValidClosest = false;
                    break;
                }
                case 1: {
                    this.cachedP1.set(this.simplexPointsP[0]);
                    this.cachedP2.set(this.simplexPointsQ[0]);
                    this.cachedV.sub(this.cachedP1, this.cachedP2);
                    this.cachedBC.reset();
                    this.cachedBC.setBarycentricCoordinates(1.0f, 0.0f, 0.0f, 0.0f);
                    this.cachedValidClosest = this.cachedBC.isValid();
                    break;
                }
                case 2: {
                    var1_1 = (Vector3f)Pools.VECTORS.get();
                    var2_4 = this.simplexVectorW[0];
                    var3_7 = this.simplexVectorW[1];
                    var4_10 = (Vector3f)Pools.VECTORS.get();
                    var5_13 = (Vector3f)Pools.VECTORS.get();
                    var5_13.set(0.0f, 0.0f, 0.0f);
                    var6_16 = (Vector3f)Pools.VECTORS.get();
                    var6_16.sub(var5_13, var2_4);
                    var7_19 = (Vector3f)Pools.VECTORS.get();
                    var7_19.sub(var3_7, var2_4);
                    var8_22 = var7_19.dot(var6_16);
                    if (var8_22 > 0.0f) {
                        var9_24 = var7_19.dot(var7_19);
                        if (var8_22 < var9_24) {
                            var1_1.scale(var8_22 /= var9_24, var7_19);
                            var6_16.sub(var1_1);
                            this.cachedBC.usedVertices.usedVertexA = true;
                            this.cachedBC.usedVertices.usedVertexB = true;
                        } else {
                            var8_22 = 1.0f;
                            var6_16.sub(var7_19);
                            this.cachedBC.usedVertices.usedVertexB = true;
                        }
                    } else {
                        var8_22 = 0.0f;
                        this.cachedBC.usedVertices.usedVertexA = true;
                    }
                    this.cachedBC.setBarycentricCoordinates(1.0f - var8_22, var8_22, 0.0f, 0.0f);
                    var1_1.scale(var8_22, var7_19);
                    var4_10.add(var2_4, var1_1);
                    var1_1.sub(this.simplexPointsP[1], this.simplexPointsP[0]);
                    var1_1.scale(var8_22);
                    this.cachedP1.add(this.simplexPointsP[0], var1_1);
                    var1_1.sub(this.simplexPointsQ[1], this.simplexPointsQ[0]);
                    var1_1.scale(var8_22);
                    this.cachedP2.add(this.simplexPointsQ[0], var1_1);
                    this.cachedV.sub(this.cachedP1, this.cachedP2);
                    this.reduceVertices(this.cachedBC.usedVertices);
                    this.cachedValidClosest = this.cachedBC.isValid();
                    Pools.VECTORS.release((Object[])new Vector3f[]{var1_1, var4_10, var5_13, var6_16, var7_19});
                    break;
                }
                case 3: {
                    var1_2 = (Vector3f)Pools.VECTORS.get();
                    var2_5 = (Vector3f)Pools.VECTORS.get();
                    var3_8 = (Vector3f)Pools.VECTORS.get();
                    var4_11 = (Vector3f)Pools.VECTORS.get();
                    var4_11.set(0.0f, 0.0f, 0.0f);
                    var5_14 = this.simplexVectorW[0];
                    var6_17 = this.simplexVectorW[1];
                    var7_20 = this.simplexVectorW[2];
                    this.closestPtPointTriangle(var4_11, var5_14, var6_17, var7_20, this.cachedBC);
                    var1_2.scale(this.cachedBC.barycentricCoords[0], this.simplexPointsP[0]);
                    var2_5.scale(this.cachedBC.barycentricCoords[1], this.simplexPointsP[1]);
                    var3_8.scale(this.cachedBC.barycentricCoords[2], this.simplexPointsP[2]);
                    VectorUtil.add(this.cachedP1, var1_2, var2_5, var3_8);
                    var1_2.scale(this.cachedBC.barycentricCoords[0], this.simplexPointsQ[0]);
                    var2_5.scale(this.cachedBC.barycentricCoords[1], this.simplexPointsQ[1]);
                    var3_8.scale(this.cachedBC.barycentricCoords[2], this.simplexPointsQ[2]);
                    VectorUtil.add(this.cachedP2, var1_2, var2_5, var3_8);
                    this.cachedV.sub(this.cachedP1, this.cachedP2);
                    this.reduceVertices(this.cachedBC.usedVertices);
                    this.cachedValidClosest = this.cachedBC.isValid();
                    Pools.VECTORS.release((Object[])new Vector3f[]{var1_2, var2_5, var3_8, var4_11});
                    break;
                }
                case 4: {
                    var1_3 = (Vector3f)Pools.VECTORS.get();
                    var2_6 = (Vector3f)Pools.VECTORS.get();
                    var3_9 = (Vector3f)Pools.VECTORS.get();
                    var4_12 = (Vector3f)Pools.VECTORS.get();
                    var5_15 = (Vector3f)Pools.VECTORS.get();
                    var5_15.set(0.0f, 0.0f, 0.0f);
                    var6_18 = this.simplexVectorW[0];
                    var7_21 = this.simplexVectorW[1];
                    var8_23 = this.simplexVectorW[2];
                    var9_25 = this.simplexVectorW[3];
                    var10_26 = this.closestPtPointTetrahedron(var5_15, var6_18, var7_21, var8_23, var9_25, this.cachedBC);
                    if (var10_26) ** GOTO lbl-1000
                    if (!this.cachedBC.degenerate) ** GOTO lbl97
                    this.cachedValidClosest = false;
                    ** GOTO lbl99
lbl97:
                    // 1 sources

                    this.cachedValidClosest = true;
                    this.cachedV.set(0.0f, 0.0f, 0.0f);
lbl99:
                    // 2 sources

                    Pools.VECTORS.release((Object[])new Vector3f[]{var1_3, var2_6, var3_9, var4_12, var5_15});
                    break;
lbl-1000:
                    // 1 sources

                    {
                        var1_3.scale(this.cachedBC.barycentricCoords[0], this.simplexPointsP[0]);
                        var2_6.scale(this.cachedBC.barycentricCoords[1], this.simplexPointsP[1]);
                        var3_9.scale(this.cachedBC.barycentricCoords[2], this.simplexPointsP[2]);
                        var4_12.scale(this.cachedBC.barycentricCoords[3], this.simplexPointsP[3]);
                        VectorUtil.add(this.cachedP1, var1_3, var2_6, var3_9, var4_12);
                        var1_3.scale(this.cachedBC.barycentricCoords[0], this.simplexPointsQ[0]);
                        var2_6.scale(this.cachedBC.barycentricCoords[1], this.simplexPointsQ[1]);
                        var3_9.scale(this.cachedBC.barycentricCoords[2], this.simplexPointsQ[2]);
                        var4_12.scale(this.cachedBC.barycentricCoords[3], this.simplexPointsQ[3]);
                        VectorUtil.add(this.cachedP2, var1_3, var2_6, var3_9, var4_12);
                        this.cachedV.sub(this.cachedP1, this.cachedP2);
                        this.reduceVertices(this.cachedBC.usedVertices);
                    }
                    try {
                        this.cachedValidClosest = this.cachedBC.isValid();
                    }
                    catch (Throwable var11_27) {
                        Pools.VECTORS.release((Object[])new Vector3f[]{var1_3, var2_6, var3_9, var4_12, var5_15});
                        throw var11_27;
                    }
                    Pools.VECTORS.release((Object[])new Vector3f[]{var1_3, var2_6, var3_9, var4_12, var5_15});
                    break;
                }
                default: {
                    this.cachedValidClosest = false;
                }
            }
        }
        return this.cachedValidClosest;
    }

    public boolean closestPtPointTriangle(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, SubSimplexClosestResult subSimplexClosestResult) {
        float f;
        float f2;
        float f3;
        Vector3f vector3f5;
        Vector3f vector3f6;
        block13: {
            float f4;
            float f5;
            float f6;
            float f7;
            block12: {
                float f8;
                float f9;
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                subSimplexClosestResult.usedVertices.reset();
                                vector3f6 = (Vector3f)Pools.VECTORS.get();
                                vector3f6.sub(vector3f3, vector3f2);
                                vector3f5 = (Vector3f)Pools.VECTORS.get();
                                vector3f5.sub(vector3f4, vector3f2);
                                try {
                                    Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
                                    vector3f7.sub(vector3f, vector3f2);
                                    f9 = vector3f6.dot(vector3f7);
                                    f8 = vector3f5.dot(vector3f7);
                                    Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7});
                                    if (!(f9 <= 0.0f) || !(f8 <= 0.0f)) break block8;
                                    subSimplexClosestResult.closestPointOnSimplex.set(vector3f2);
                                    subSimplexClosestResult.usedVertices.usedVertexA = true;
                                    subSimplexClosestResult.setBarycentricCoordinates(1.0f, 0.0f, 0.0f, 0.0f);
                                }
                                catch (Throwable throwable) {
                                    Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5});
                                    throw throwable;
                                }
                                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5});
                                return true;
                            }
                            Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
                            vector3f8.sub(vector3f, vector3f3);
                            f7 = vector3f6.dot(vector3f8);
                            f6 = vector3f5.dot(vector3f8);
                            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f8});
                            if (!(f7 >= 0.0f) || !(f6 <= f7)) break block9;
                            subSimplexClosestResult.closestPointOnSimplex.set(vector3f3);
                            subSimplexClosestResult.usedVertices.usedVertexB = true;
                            subSimplexClosestResult.setBarycentricCoordinates(0.0f, 1.0f, 0.0f, 0.0f);
                            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5});
                            return true;
                        }
                        f3 = f9 * f6 - f7 * f8;
                        if (!(f3 <= 0.0f) || !(f9 >= 0.0f) || !(f7 <= 0.0f)) break block10;
                        float f10 = f9 / (f9 - f7);
                        subSimplexClosestResult.closestPointOnSimplex.scaleAdd(f10, vector3f6, vector3f2);
                        subSimplexClosestResult.usedVertices.usedVertexA = true;
                        subSimplexClosestResult.usedVertices.usedVertexB = true;
                        subSimplexClosestResult.setBarycentricCoordinates(1.0f - f10, f10, 0.0f, 0.0f);
                        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5});
                        return true;
                    }
                    Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
                    vector3f9.sub(vector3f, vector3f4);
                    f5 = vector3f6.dot(vector3f9);
                    f4 = vector3f5.dot(vector3f9);
                    Pools.VECTORS.release((Object[])new Vector3f[]{vector3f9});
                    if (!(f4 >= 0.0f) || !(f5 <= f4)) break block11;
                    subSimplexClosestResult.closestPointOnSimplex.set(vector3f4);
                    subSimplexClosestResult.usedVertices.usedVertexC = true;
                    subSimplexClosestResult.setBarycentricCoordinates(0.0f, 0.0f, 1.0f, 0.0f);
                    Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5});
                    return true;
                }
                f2 = f5 * f8 - f9 * f4;
                if (!(f2 <= 0.0f) || !(f8 >= 0.0f) || !(f4 <= 0.0f)) break block12;
                float f11 = f8 / (f8 - f4);
                subSimplexClosestResult.closestPointOnSimplex.scaleAdd(f11, vector3f5, vector3f2);
                subSimplexClosestResult.usedVertices.usedVertexA = true;
                subSimplexClosestResult.usedVertices.usedVertexC = true;
                subSimplexClosestResult.setBarycentricCoordinates(1.0f - f11, 0.0f, f11, 0.0f);
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5});
                return true;
            }
            f = f7 * f4 - f5 * f6;
            if (!(f <= 0.0f) || !(f6 - f7 >= 0.0f) || !(f5 - f4 >= 0.0f)) break block13;
            float f12 = (f6 - f7) / (f6 - f7 + (f5 - f4));
            Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
            vector3f10.sub(vector3f4, vector3f3);
            subSimplexClosestResult.closestPointOnSimplex.scaleAdd(f12, vector3f10, vector3f3);
            subSimplexClosestResult.usedVertices.usedVertexB = true;
            subSimplexClosestResult.usedVertices.usedVertexC = true;
            subSimplexClosestResult.setBarycentricCoordinates(0.0f, 1.0f - f12, f12, 0.0f);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f10});
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5});
            return true;
        }
        float f13 = 1.0f / (f + f2 + f3);
        float f14 = f2 * f13;
        float f15 = f3 * f13;
        Vector3f vector3f11 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f12 = (Vector3f)Pools.VECTORS.get();
        vector3f11.scale(f14, vector3f6);
        vector3f12.scale(f15, vector3f5);
        VectorUtil.add(subSimplexClosestResult.closestPointOnSimplex, vector3f2, vector3f11, vector3f12);
        subSimplexClosestResult.usedVertices.usedVertexA = true;
        subSimplexClosestResult.usedVertices.usedVertexB = true;
        subSimplexClosestResult.usedVertices.usedVertexC = true;
        subSimplexClosestResult.setBarycentricCoordinates(1.0f - f14 - f15, f14, f15, 0.0f);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f11, vector3f12});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f5});
        return true;
    }

    public static int pointOutsideOfPlane(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5) {
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        vector3f7.sub(vector3f3, vector3f2);
        vector3f6.sub(vector3f4, vector3f2);
        vector3f7.cross(vector3f7, vector3f6);
        vector3f6.sub(vector3f, vector3f2);
        float f = vector3f6.dot(vector3f7);
        vector3f6.sub(vector3f5, vector3f2);
        float f2 = vector3f6.dot(vector3f7);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f7});
        if (f2 * f2 < 9.999999E-9f) {
            return -1;
        }
        return f * f2 < 0.0f ? 1 : 0;
    }

    public boolean closestPtPointTetrahedron(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5, SubSimplexClosestResult subSimplexClosestResult) {
        Vector3f vector3f6;
        Vector3f vector3f7;
        SubSimplexClosestResult subSimplexClosestResult2;
        block14: {
            float f;
            int n;
            int n2;
            int n3;
            int n4;
            block13: {
                block12: {
                    subSimplexClosestResult2 = (SubSimplexClosestResult)Pools.SUB_SIMPLEX.get();
                    subSimplexClosestResult2.reset();
                    vector3f7 = (Vector3f)Pools.VECTORS.get();
                    vector3f6 = (Vector3f)Pools.VECTORS.get();
                    try {
                        subSimplexClosestResult.closestPointOnSimplex.set(vector3f);
                        subSimplexClosestResult.usedVertices.reset();
                        subSimplexClosestResult.usedVertices.usedVertexA = true;
                        subSimplexClosestResult.usedVertices.usedVertexB = true;
                        subSimplexClosestResult.usedVertices.usedVertexC = true;
                        subSimplexClosestResult.usedVertices.usedVertexD = true;
                        n4 = VoronoiSimplexSolver.pointOutsideOfPlane(vector3f, vector3f2, vector3f3, vector3f4, vector3f5);
                        n3 = VoronoiSimplexSolver.pointOutsideOfPlane(vector3f, vector3f2, vector3f4, vector3f5, vector3f3);
                        n2 = VoronoiSimplexSolver.pointOutsideOfPlane(vector3f, vector3f2, vector3f5, vector3f3, vector3f4);
                        n = VoronoiSimplexSolver.pointOutsideOfPlane(vector3f, vector3f3, vector3f5, vector3f4, vector3f2);
                        if (n4 >= 0 && n3 >= 0 && n2 >= 0 && n >= 0) break block12;
                        subSimplexClosestResult.degenerate = true;
                    }
                    catch (Throwable throwable) {
                        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6});
                        Pools.SUB_SIMPLEX.release((Object[])new SubSimplexClosestResult[]{subSimplexClosestResult2});
                        throw throwable;
                    }
                    Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6});
                    Pools.SUB_SIMPLEX.release((Object[])new SubSimplexClosestResult[]{subSimplexClosestResult2});
                    return false;
                }
                if (n4 != 0 || n3 != 0 || n2 != 0 || n != 0) break block13;
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6});
                Pools.SUB_SIMPLEX.release((Object[])new SubSimplexClosestResult[]{subSimplexClosestResult2});
                return false;
            }
            float f2 = Float.MAX_VALUE;
            if (n4 != 0) {
                this.closestPtPointTriangle(vector3f, vector3f2, vector3f3, vector3f4, subSimplexClosestResult2);
                vector3f6.set(subSimplexClosestResult2.closestPointOnSimplex);
                vector3f7.sub(vector3f6, vector3f);
                f = vector3f7.dot(vector3f7);
                if (f < f2) {
                    f2 = f;
                    subSimplexClosestResult.closestPointOnSimplex.set(vector3f6);
                    subSimplexClosestResult.usedVertices.reset();
                    subSimplexClosestResult.usedVertices.usedVertexA = subSimplexClosestResult2.usedVertices.usedVertexA;
                    subSimplexClosestResult.usedVertices.usedVertexB = subSimplexClosestResult2.usedVertices.usedVertexB;
                    subSimplexClosestResult.usedVertices.usedVertexC = subSimplexClosestResult2.usedVertices.usedVertexC;
                    subSimplexClosestResult.setBarycentricCoordinates(subSimplexClosestResult2.barycentricCoords[0], subSimplexClosestResult2.barycentricCoords[1], subSimplexClosestResult2.barycentricCoords[2], 0.0f);
                }
            }
            if (n3 != 0) {
                this.closestPtPointTriangle(vector3f, vector3f2, vector3f4, vector3f5, subSimplexClosestResult2);
                vector3f6.set(subSimplexClosestResult2.closestPointOnSimplex);
                vector3f7.sub(vector3f6, vector3f);
                f = vector3f7.dot(vector3f7);
                if (f < f2) {
                    f2 = f;
                    subSimplexClosestResult.closestPointOnSimplex.set(vector3f6);
                    subSimplexClosestResult.usedVertices.reset();
                    subSimplexClosestResult.usedVertices.usedVertexA = subSimplexClosestResult2.usedVertices.usedVertexA;
                    subSimplexClosestResult.usedVertices.usedVertexC = subSimplexClosestResult2.usedVertices.usedVertexB;
                    subSimplexClosestResult.usedVertices.usedVertexD = subSimplexClosestResult2.usedVertices.usedVertexC;
                    subSimplexClosestResult.setBarycentricCoordinates(subSimplexClosestResult2.barycentricCoords[0], 0.0f, subSimplexClosestResult2.barycentricCoords[1], subSimplexClosestResult2.barycentricCoords[2]);
                }
            }
            if (n2 != 0) {
                this.closestPtPointTriangle(vector3f, vector3f2, vector3f5, vector3f3, subSimplexClosestResult2);
                vector3f6.set(subSimplexClosestResult2.closestPointOnSimplex);
                vector3f7.sub(vector3f6, vector3f);
                f = vector3f7.dot(vector3f7);
                if (f < f2) {
                    f2 = f;
                    subSimplexClosestResult.closestPointOnSimplex.set(vector3f6);
                    subSimplexClosestResult.usedVertices.reset();
                    subSimplexClosestResult.usedVertices.usedVertexA = subSimplexClosestResult2.usedVertices.usedVertexA;
                    subSimplexClosestResult.usedVertices.usedVertexB = subSimplexClosestResult2.usedVertices.usedVertexC;
                    subSimplexClosestResult.usedVertices.usedVertexD = subSimplexClosestResult2.usedVertices.usedVertexB;
                    subSimplexClosestResult.setBarycentricCoordinates(subSimplexClosestResult2.barycentricCoords[0], subSimplexClosestResult2.barycentricCoords[2], 0.0f, subSimplexClosestResult2.barycentricCoords[1]);
                }
            }
            if (n != 0) {
                this.closestPtPointTriangle(vector3f, vector3f3, vector3f5, vector3f4, subSimplexClosestResult2);
                vector3f6.set(subSimplexClosestResult2.closestPointOnSimplex);
                vector3f7.sub(vector3f6, vector3f);
                f = vector3f7.dot(vector3f7);
                if (f < f2) {
                    f2 = f;
                    subSimplexClosestResult.closestPointOnSimplex.set(vector3f6);
                    subSimplexClosestResult.usedVertices.reset();
                    subSimplexClosestResult.usedVertices.usedVertexB = subSimplexClosestResult2.usedVertices.usedVertexA;
                    subSimplexClosestResult.usedVertices.usedVertexC = subSimplexClosestResult2.usedVertices.usedVertexC;
                    subSimplexClosestResult.usedVertices.usedVertexD = subSimplexClosestResult2.usedVertices.usedVertexB;
                    subSimplexClosestResult.setBarycentricCoordinates(0.0f, subSimplexClosestResult2.barycentricCoords[0], subSimplexClosestResult2.barycentricCoords[2], subSimplexClosestResult2.barycentricCoords[1]);
                }
            }
            if (!subSimplexClosestResult.usedVertices.usedVertexA || !subSimplexClosestResult.usedVertices.usedVertexB || !subSimplexClosestResult.usedVertices.usedVertexC || !subSimplexClosestResult.usedVertices.usedVertexD) break block14;
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6});
            Pools.SUB_SIMPLEX.release((Object[])new SubSimplexClosestResult[]{subSimplexClosestResult2});
            return true;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6});
        Pools.SUB_SIMPLEX.release((Object[])new SubSimplexClosestResult[]{subSimplexClosestResult2});
        return true;
    }

    @Override
    public void reset() {
        this.cachedValidClosest = false;
        this.numVertices = 0;
        this.needsUpdate = true;
        this.lastW.set(1.0E30f, 1.0E30f, 1.0E30f);
        this.cachedBC.reset();
    }

    @Override
    public void addVertex(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        this.lastW.set(vector3f);
        this.needsUpdate = true;
        this.simplexVectorW[this.numVertices].set(vector3f);
        this.simplexPointsP[this.numVertices].set(vector3f2);
        this.simplexPointsQ[this.numVertices].set(vector3f3);
        ++this.numVertices;
    }

    @Override
    public boolean closest(Vector3f vector3f) {
        boolean bl = this.updateClosestVectorAndPoints();
        vector3f.set(this.cachedV);
        return bl;
    }

    @Override
    public float maxVertex() {
        int n = this.numVertices();
        float f = 0.0f;
        int n2 = 0;
        while (n2 < n) {
            float f2 = this.simplexVectorW[n2].lengthSquared();
            if (f < f2) {
                f = f2;
            }
            ++n2;
        }
        return f;
    }

    @Override
    public boolean fullSimplex() {
        return this.numVertices == 4;
    }

    @Override
    public int getSimplex(Vector3f[] vector3fArray, Vector3f[] vector3fArray2, Vector3f[] vector3fArray3) {
        int n = 0;
        while (n < this.numVertices()) {
            vector3fArray3[n].set(this.simplexVectorW[n]);
            vector3fArray[n].set(this.simplexPointsP[n]);
            vector3fArray2[n].set(this.simplexPointsQ[n]);
            ++n;
        }
        return this.numVertices();
    }

    @Override
    public boolean inSimplex(Vector3f vector3f) {
        boolean bl = false;
        int n = this.numVertices();
        int n2 = 0;
        while (n2 < n) {
            if (this.simplexVectorW[n2].equals(vector3f)) {
                bl = true;
            }
            ++n2;
        }
        if (vector3f.equals(this.lastW)) {
            return true;
        }
        return bl;
    }

    @Override
    public void backup_closest(Vector3f vector3f) {
        vector3f.set(this.cachedV);
    }

    @Override
    public boolean emptySimplex() {
        return this.numVertices() == 0;
    }

    @Override
    public void compute_points(Vector3f vector3f, Vector3f vector3f2) {
        this.updateClosestVectorAndPoints();
        vector3f.set(this.cachedP1);
        vector3f2.set(this.cachedP2);
    }

    @Override
    public int numVertices() {
        return this.numVertices;
    }

    public static class SubSimplexClosestResult {
        public final Vector3f closestPointOnSimplex = new Vector3f();
        public final UsageBitfield usedVertices = new UsageBitfield();
        public final float[] barycentricCoords = new float[4];
        public boolean degenerate;

        public void reset() {
            this.degenerate = false;
            this.setBarycentricCoordinates(0.0f, 0.0f, 0.0f, 0.0f);
            this.usedVertices.reset();
        }

        public boolean isValid() {
            boolean bl = this.barycentricCoords[0] >= 0.0f && this.barycentricCoords[1] >= 0.0f && this.barycentricCoords[2] >= 0.0f && this.barycentricCoords[3] >= 0.0f;
            return bl;
        }

        public void setBarycentricCoordinates(float f, float f2, float f3, float f4) {
            this.barycentricCoords[0] = f;
            this.barycentricCoords[1] = f2;
            this.barycentricCoords[2] = f3;
            this.barycentricCoords[3] = f4;
        }
    }

    public static class UsageBitfield {
        public boolean usedVertexA;
        public boolean usedVertexB;
        public boolean usedVertexC;
        public boolean usedVertexD;

        public void reset() {
            this.usedVertexA = false;
            this.usedVertexB = false;
            this.usedVertexC = false;
            this.usedVertexD = false;
        }
    }
}

