/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.ConvexInternalShape;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Vector3f;

public class SphereShape
extends ConvexInternalShape {
    public SphereShape(float f) {
        this.implicitShapeDimensions.x = f;
        this.collisionMargin = f;
    }

    @Override
    public Vector3f localGetSupportingVertexWithoutMargin(Vector3f vector3f, Vector3f vector3f2) {
        vector3f2.set(0.0f, 0.0f, 0.0f);
        return vector3f2;
    }

    @Override
    public void batchedUnitVectorGetSupportingVertexWithoutMargin(Vector3f[] vector3fArray, Vector3f[] vector3fArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            vector3fArray2[n2].set(0.0f, 0.0f, 0.0f);
            ++n2;
        }
    }

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = transform.origin;
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.set(this.getMargin(), this.getMargin(), this.getMargin());
        vector3f.sub(vector3f3, vector3f4);
        vector3f2.add(vector3f3, vector3f4);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4});
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.SPHERE_SHAPE_PROXYTYPE;
    }

    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
        float f2 = 0.4f * f * this.getMargin() * this.getMargin();
        vector3f.set(f2, f2, f2);
    }

    @Override
    public String getName() {
        return "SPHERE";
    }

    public float getRadius() {
        return this.implicitShapeDimensions.x * this.localScaling.x;
    }

    @Override
    public void setMargin(float f) {
        super.setMargin(f);
    }

    @Override
    public float getMargin() {
        return this.getRadius();
    }
}

