/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.ConcaveShape;
import com.bulletphysics.collision.shapes.TriangleCallback;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.TransformUtil;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Vector3f;

public class StaticPlaneShape
extends ConcaveShape {
    protected final Vector3f localAabbMin = new Vector3f();
    protected final Vector3f localAabbMax = new Vector3f();
    protected final Vector3f planeNormal = new Vector3f();
    protected float planeConstant;
    protected final Vector3f localScaling = new Vector3f(0.0f, 0.0f, 0.0f);

    public StaticPlaneShape(Vector3f vector3f, float f) {
        this.planeNormal.normalize(vector3f);
        this.planeConstant = f;
    }

    public Vector3f getPlaneNormal(Vector3f vector3f) {
        vector3f.set(this.planeNormal);
        return vector3f;
    }

    public float getPlaneConstant() {
        return this.planeConstant;
    }

    @Override
    public void processAllTriangles(TriangleCallback triangleCallback, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
        Vector3f[] vector3fArray = new Vector3f[]{(Vector3f)Pools.VECTORS.get(), (Vector3f)Pools.VECTORS.get(), (Vector3f)Pools.VECTORS.get()};
        try {
            vector3f7.sub(vector3f2, vector3f);
            vector3f7.scale(0.5f);
            float f = vector3f7.length();
            vector3f6.add(vector3f2, vector3f);
            vector3f6.scale(0.5f);
            TransformUtil.planeSpace1(this.planeNormal, vector3f8, vector3f9);
            vector3f3.scale(this.planeNormal.dot(vector3f6) - this.planeConstant, this.planeNormal);
            vector3f10.sub(vector3f6, vector3f3);
            vector3f4.scale(f, vector3f8);
            vector3f5.scale(f, vector3f9);
            VectorUtil.add(vector3fArray[0], vector3f10, vector3f4, vector3f5);
            vector3f4.scale(f, vector3f8);
            vector3f5.scale(f, vector3f9);
            vector3f3.sub(vector3f4, vector3f5);
            VectorUtil.add(vector3fArray[1], vector3f10, vector3f3);
            vector3f4.scale(f, vector3f8);
            vector3f5.scale(f, vector3f9);
            vector3f3.sub(vector3f4, vector3f5);
            vector3fArray[2].sub(vector3f10, vector3f3);
            triangleCallback.processTriangle(vector3fArray, 0, 0);
            vector3f4.scale(f, vector3f8);
            vector3f5.scale(f, vector3f9);
            vector3f3.sub(vector3f4, vector3f5);
            vector3fArray[0].sub(vector3f10, vector3f3);
            vector3f4.scale(f, vector3f8);
            vector3f5.scale(f, vector3f9);
            vector3f3.add(vector3f4, vector3f5);
            vector3fArray[1].sub(vector3f10, vector3f3);
            vector3f4.scale(f, vector3f8);
            vector3f5.scale(f, vector3f9);
            VectorUtil.add(vector3fArray[2], vector3f10, vector3f4, vector3f5);
            triangleCallback.processTriangle(vector3fArray, 0, 1);
        }
        catch (Throwable throwable) {
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3fArray[0], vector3fArray[1], vector3fArray[2], vector3f10, vector3f8, vector3f9, vector3f7, vector3f6, vector3f5, vector3f4, vector3f3});
            throw throwable;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3fArray[0], vector3fArray[1], vector3fArray[2], vector3f10, vector3f8, vector3f9, vector3f7, vector3f6, vector3f5, vector3f4, vector3f3});
    }

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        vector3f.set(-1.0E30f, -1.0E30f, -1.0E30f);
        vector3f2.set(1.0E30f, 1.0E30f, 1.0E30f);
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.STATIC_PLANE_PROXYTYPE;
    }

    @Override
    public void setLocalScaling(Vector3f vector3f) {
        this.localScaling.set(vector3f);
    }

    @Override
    public Vector3f getLocalScaling(Vector3f vector3f) {
        vector3f.set(this.localScaling);
        return vector3f;
    }

    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
        vector3f.set(0.0f, 0.0f, 0.0f);
    }

    @Override
    public String getName() {
        return "STATICPLANE";
    }
}

