/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Vector3f;

public abstract class ConvexInternalShape
implements ConvexShape {
    protected final Vector3f localScaling = new Vector3f(1.0f, 1.0f, 1.0f);
    protected final Vector3f implicitShapeDimensions = new Vector3f();
    protected float collisionMargin = 0.04f;

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        this.getAabbSlow(transform, vector3f, vector3f2);
    }

    @Override
    public void getAabbSlow(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        float f = this.getMargin();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        int n = 0;
        while (n < 3) {
            vector3f3.set(0.0f, 0.0f, 0.0f);
            VectorUtil.setCoord(vector3f3, n, 1.0f);
            MatrixUtil.transposeTransform(vector3f4, vector3f3, transform.basis);
            this.localGetSupportingVertex(vector3f4, vector3f5);
            transform.transform(vector3f5);
            VectorUtil.setCoord(vector3f2, n, VectorUtil.getCoord(vector3f5, n) + f);
            VectorUtil.setCoord(vector3f3, n, -1.0f);
            MatrixUtil.transposeTransform(vector3f4, vector3f3, transform.basis);
            this.localGetSupportingVertex(vector3f4, vector3f5);
            transform.transform(vector3f5);
            VectorUtil.setCoord(vector3f, n, VectorUtil.getCoord(vector3f5, n) - f);
            ++n;
        }
    }

    @Override
    public Vector3f localGetSupportingVertex(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = this.localGetSupportingVertexWithoutMargin(vector3f, vector3f2);
        if (this.getMargin() != 0.0f) {
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
            if (vector3f4.lengthSquared() < 1.4210855E-14f) {
                vector3f4.set(-1.0f, -1.0f, -1.0f);
            }
            vector3f4.normalize();
            vector3f3.scaleAdd(this.getMargin(), vector3f4, vector3f3);
        }
        return vector3f2;
    }

    @Override
    public void setLocalScaling(Vector3f vector3f) {
        this.localScaling.absolute(vector3f);
    }

    @Override
    public Vector3f getLocalScaling(Vector3f vector3f) {
        vector3f.set(this.localScaling);
        return vector3f;
    }

    @Override
    public float getMargin() {
        return this.collisionMargin;
    }

    @Override
    public void setMargin(float f) {
        this.collisionMargin = f;
    }

    @Override
    public int getNumPreferredPenetrationDirections() {
        return 0;
    }

    @Override
    public void getPreferredPenetrationDirection(int n, Vector3f vector3f) {
        throw new InternalError();
    }
}

