/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.shapes.InternalTriangleIndexCallback;
import com.bulletphysics.collision.shapes.VertexData;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Vector3f;

public abstract class StridingMeshInterface {
    protected final Vector3f scaling = new Vector3f(1.0f, 1.0f, 1.0f);

    public void internalProcessAllTriangles(InternalTriangleIndexCallback internalTriangleIndexCallback, Vector3f vector3f, Vector3f vector3f2) {
        int n = this.getNumSubParts();
        Vector3f[] vector3fArray = new Vector3f[]{(Vector3f)Pools.VECTORS.get(), (Vector3f)Pools.VECTORS.get(), (Vector3f)Pools.VECTORS.get()};
        Vector3f vector3f3 = this.getScaling((Vector3f)Pools.VECTORS.get());
        int n2 = 0;
        while (n2 < n) {
            VertexData vertexData = this.getLockedReadOnlyVertexIndexBase(n2);
            int n3 = 0;
            int n4 = vertexData.getIndexCount() / 3;
            while (n3 < n4) {
                vertexData.getTriangle(n3 * 3, vector3f3, vector3fArray);
                internalTriangleIndexCallback.internalProcessTriangleIndex(vector3fArray, n2, n3);
                ++n3;
            }
            this.unLockReadOnlyVertexBase(n2);
            ++n2;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3fArray[0], vector3fArray[1], vector3fArray[2], vector3f3});
    }

    public void calculateAabbBruteForce(Vector3f vector3f, Vector3f vector3f2) {
        AabbCalculationCallback aabbCalculationCallback = new AabbCalculationCallback();
        vector3f.set(-1.0E30f, -1.0E30f, -1.0E30f);
        vector3f2.set(1.0E30f, 1.0E30f, 1.0E30f);
        this.internalProcessAllTriangles(aabbCalculationCallback, vector3f, vector3f2);
        vector3f.set(aabbCalculationCallback.aabbMin);
        vector3f2.set(aabbCalculationCallback.aabbMax);
    }

    public abstract VertexData getLockedVertexIndexBase(int var1);

    public abstract VertexData getLockedReadOnlyVertexIndexBase(int var1);

    public abstract void unLockVertexBase(int var1);

    public abstract void unLockReadOnlyVertexBase(int var1);

    public abstract int getNumSubParts();

    public abstract void preallocateVertices(int var1);

    public abstract void preallocateIndices(int var1);

    public Vector3f getScaling(Vector3f vector3f) {
        vector3f.set(this.scaling);
        return vector3f;
    }

    public void setScaling(Vector3f vector3f) {
        this.scaling.set(vector3f);
    }

    private static class AabbCalculationCallback
    implements InternalTriangleIndexCallback {
        public final Vector3f aabbMin = new Vector3f(1.0E30f, 1.0E30f, 1.0E30f);
        public final Vector3f aabbMax = new Vector3f(-1.0E30f, -1.0E30f, -1.0E30f);

        private AabbCalculationCallback() {
        }

        @Override
        public void internalProcessTriangleIndex(Vector3f[] vector3fArray, int n, int n2) {
            VectorUtil.setMin(this.aabbMin, vector3fArray[0]);
            VectorUtil.setMax(this.aabbMax, vector3fArray[0]);
            VectorUtil.setMin(this.aabbMin, vector3fArray[1]);
            VectorUtil.setMax(this.aabbMax, vector3fArray[1]);
            VectorUtil.setMin(this.aabbMin, vector3fArray[2]);
            VectorUtil.setMax(this.aabbMax, vector3fArray[2]);
        }
    }
}

