/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.constraintsolver;

import com.bulletphysics.Pools;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.constraintsolver.JacobianEntry;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraintType;
import com.bulletphysics.linearmath.QuaternionUtil;
import com.bulletphysics.linearmath.ScalarUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.TransformUtil;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class ConeTwistConstraint
extends TypedConstraint {
    private final JacobianEntry[] jac = new JacobianEntry[]{new JacobianEntry(), new JacobianEntry(), new JacobianEntry()};
    private final Transform rbAFrame = new Transform();
    private final Transform rbBFrame = new Transform();
    private float limitSoftness;
    private float biasFactor;
    private float relaxationFactor;
    private float swingSpan1;
    private float swingSpan2;
    private float twistSpan;
    private final Vector3f swingAxis = new Vector3f();
    private final Vector3f twistAxis = new Vector3f();
    private float kSwing;
    private float kTwist;
    private float twistLimitSign;
    private float swingCorrection;
    private float twistCorrection;
    private float accSwingLimitImpulse;
    private float accTwistLimitImpulse;
    private boolean angularOnly = false;
    private boolean solveTwistLimit;
    private boolean solveSwingLimit;

    public ConeTwistConstraint() {
        super(TypedConstraintType.CONETWIST_CONSTRAINT_TYPE);
    }

    public ConeTwistConstraint(RigidBody rigidBody, RigidBody rigidBody2, Transform transform, Transform transform2) {
        super(TypedConstraintType.CONETWIST_CONSTRAINT_TYPE, rigidBody, rigidBody2);
        this.rbAFrame.set(transform);
        this.rbBFrame.set(transform2);
        this.swingSpan1 = 1.0E30f;
        this.swingSpan2 = 1.0E30f;
        this.twistSpan = 1.0E30f;
        this.biasFactor = 0.3f;
        this.relaxationFactor = 1.0f;
        this.solveTwistLimit = false;
        this.solveSwingLimit = false;
    }

    public ConeTwistConstraint(RigidBody rigidBody, Transform transform) {
        super(TypedConstraintType.CONETWIST_CONSTRAINT_TYPE, rigidBody);
        this.rbAFrame.set(transform);
        this.rbBFrame.set(this.rbAFrame);
        this.swingSpan1 = 1.0E30f;
        this.swingSpan2 = 1.0E30f;
        this.twistSpan = 1.0E30f;
        this.biasFactor = 0.3f;
        this.relaxationFactor = 1.0f;
        this.solveTwistLimit = false;
        this.solveSwingLimit = false;
    }

    @Override
    public void buildJacobian() {
        float f;
        Vector3f[] vector3fArray;
        Vector3f vector3f;
        Vector3f vector3f2;
        Vector3f vector3f3;
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        this.appliedImpulse = 0.0f;
        this.swingCorrection = 0.0f;
        this.twistLimitSign = 0.0f;
        this.solveTwistLimit = false;
        this.solveSwingLimit = false;
        this.accTwistLimitImpulse = 0.0f;
        this.accSwingLimitImpulse = 0.0f;
        if (!this.angularOnly) {
            vector3f3 = (Vector3f)Pools.VECTORS.get((Object)this.rbAFrame.origin);
            this.rbA.getCenterOfMassTransform(transform).transform(vector3f3);
            vector3f2 = (Vector3f)Pools.VECTORS.get((Object)this.rbBFrame.origin);
            this.rbB.getCenterOfMassTransform(transform).transform(vector3f2);
            vector3f = (Vector3f)Pools.VECTORS.get();
            vector3f.sub(vector3f2, vector3f3);
            vector3fArray = new Vector3f[]{(Vector3f)Pools.VECTORS.get(), (Vector3f)Pools.VECTORS.get(), (Vector3f)Pools.VECTORS.get()};
            if (vector3f.lengthSquared() > 1.1920929E-7f) {
                vector3fArray[0].normalize(vector3f);
            } else {
                vector3fArray[0].set(1.0f, 0.0f, 0.0f);
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
            TransformUtil.planeSpace1(vector3fArray[0], vector3fArray[1], vector3fArray[2]);
            int n = 0;
            while (n < 3) {
                Matrix3f matrix3f = this.rbA.getCenterOfMassTransform((Transform)((Transform)Pools.TRANSFORMS.get())).basis;
                matrix3f.transpose();
                Matrix3f matrix3f2 = this.rbB.getCenterOfMassTransform((Transform)((Transform)Pools.TRANSFORMS.get())).basis;
                matrix3f2.transpose();
                vector3f5.sub(vector3f3, this.rbA.getCenterOfMassPosition(vector3f4));
                vector3f6.sub(vector3f2, this.rbB.getCenterOfMassPosition(vector3f4));
                Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
                Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
                this.jac[n].init(matrix3f, matrix3f2, vector3f5, vector3f6, vector3fArray[n], this.rbA.getInvInertiaDiagLocal(vector3f7), this.rbA.getInvMass(), this.rbB.getInvInertiaDiagLocal(vector3f8), this.rbB.getInvMass());
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f8});
                ++n;
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f2, vector3fArray[0], vector3fArray[1], vector3fArray[2]});
        }
        vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f = (Vector3f)Pools.VECTORS.get();
        vector3fArray = (Vector3f[])Pools.VECTORS.get();
        Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
        this.rbAFrame.basis.getColumn(0, vector3f3);
        this.getRigidBodyA().getCenterOfMassTransform((Transform)transform).basis.transform(vector3f3);
        this.rbBFrame.basis.getColumn(0, (Vector3f)vector3fArray);
        this.getRigidBodyB().getCenterOfMassTransform((Transform)transform).basis.transform((Tuple3f)vector3fArray);
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 10.0f;
        if (this.swingSpan1 >= 0.05f) {
            this.rbAFrame.basis.getColumn(1, vector3f2);
            this.getRigidBodyA().getCenterOfMassTransform((Transform)transform).basis.transform(vector3f2);
            f4 = vector3fArray.dot(vector3f3);
            f5 = vector3fArray.dot(vector3f2);
            f2 = ScalarUtil.atan2Fast(f5, f4);
            f = (f5 * f5 + f4 * f4) * f6 * f6;
            f /= f + 1.0f;
            f2 *= f;
        }
        if (this.swingSpan2 >= 0.05f) {
            this.rbAFrame.basis.getColumn(2, vector3f);
            this.getRigidBodyA().getCenterOfMassTransform((Transform)transform).basis.transform(vector3f);
            f4 = vector3fArray.dot(vector3f3);
            f5 = vector3fArray.dot(vector3f);
            f3 = ScalarUtil.atan2Fast(f5, f4);
            f = (f5 * f5 + f4 * f4) * f6 * f6;
            f /= f + 1.0f;
            f3 *= f;
        }
        float f7 = 1.0f / (this.swingSpan1 * this.swingSpan1);
        float f8 = 1.0f / (this.swingSpan2 * this.swingSpan2);
        float f9 = Math.abs(f2 * f2) * f7 + Math.abs(f3 * f3) * f8;
        if (f9 > 1.0f) {
            this.swingCorrection = f9 - 1.0f;
            this.solveSwingLimit = true;
            vector3f5.scale(vector3fArray.dot(vector3f2), vector3f2);
            vector3f6.scale(vector3fArray.dot(vector3f), vector3f);
            vector3f4.add(vector3f5, vector3f6);
            this.swingAxis.cross((Vector3f)vector3fArray, vector3f4);
            this.swingAxis.normalize();
            float f10 = vector3fArray.dot(vector3f3) >= 0.0f ? 1.0f : -1.0f;
            this.swingAxis.scale(f10);
            this.kSwing = 1.0f / (this.getRigidBodyA().computeAngularImpulseDenominator(this.swingAxis) + this.getRigidBodyB().computeAngularImpulseDenominator(this.swingAxis));
        }
        if (this.twistSpan >= 0.0f) {
            float f11;
            this.rbBFrame.basis.getColumn(1, vector3f9);
            this.getRigidBodyB().getCenterOfMassTransform((Transform)transform).basis.transform(vector3f9);
            Quat4f quat4f = QuaternionUtil.shortestArcQuat((Vector3f)vector3fArray, vector3f3, (Quat4f)Pools.QUATS.get());
            Vector3f vector3f10 = QuaternionUtil.quatRotate(quat4f, vector3f9, (Vector3f)Pools.VECTORS.get());
            float f12 = ScalarUtil.atan2Fast(vector3f10.dot(vector3f), vector3f10.dot(vector3f2));
            Pools.QUATS.release((Object[])new Quat4f[]{quat4f});
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f10});
            float f13 = f11 = this.twistSpan > 0.05f ? this.limitSoftness : 0.0f;
            if (f12 <= -this.twistSpan * f11) {
                this.twistCorrection = -(f12 + this.twistSpan);
                this.solveTwistLimit = true;
                this.twistAxis.add((Tuple3f)vector3fArray, vector3f3);
                this.twistAxis.scale(0.5f);
                this.twistAxis.normalize();
                this.twistAxis.scale(-1.0f);
                this.kTwist = 1.0f / (this.getRigidBodyA().computeAngularImpulseDenominator(this.twistAxis) + this.getRigidBodyB().computeAngularImpulseDenominator(this.twistAxis));
            } else if (f12 > this.twistSpan * f11) {
                this.twistCorrection = f12 - this.twistSpan;
                this.solveTwistLimit = true;
                this.twistAxis.add((Tuple3f)vector3fArray, vector3f3);
                this.twistAxis.scale(0.5f);
                this.twistAxis.normalize();
                this.kTwist = 1.0f / (this.getRigidBodyA().computeAngularImpulseDenominator(this.twistAxis) + this.getRigidBodyB().computeAngularImpulseDenominator(this.twistAxis));
            }
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f2, vector3f, vector3fArray, vector3f9, vector3f4, vector3f5, vector3f6});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
    }

    @Override
    public void solveConstraint(float f) {
        Vector3f vector3f;
        Vector3f vector3f2;
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get((Object)this.rbAFrame.origin);
        this.rbA.getCenterOfMassTransform(transform).transform(vector3f6);
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get((Object)this.rbBFrame.origin);
        this.rbB.getCenterOfMassTransform(transform).transform(vector3f7);
        float f2 = 0.3f;
        if (!this.angularOnly) {
            vector3f2 = (Vector3f)Pools.VECTORS.get();
            vector3f2.sub(vector3f6, this.rbA.getCenterOfMassPosition(vector3f5));
            vector3f = (Vector3f)Pools.VECTORS.get();
            vector3f.sub(vector3f7, this.rbB.getCenterOfMassPosition(vector3f5));
            Vector3f vector3f8 = this.rbA.getVelocityInLocalPoint(vector3f2, (Vector3f)Pools.VECTORS.get());
            Vector3f vector3f9 = this.rbB.getVelocityInLocalPoint(vector3f, (Vector3f)Pools.VECTORS.get());
            Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
            vector3f10.sub(vector3f8, vector3f9);
            int n = 0;
            while (n < 3) {
                Vector3f vector3f11 = this.jac[n].linearJointAxis;
                float f3 = 1.0f / this.jac[n].getDiagonal();
                float f4 = vector3f11.dot(vector3f10);
                vector3f3.sub(vector3f6, vector3f7);
                float f5 = -vector3f3.dot(vector3f11);
                float f6 = f5 * f2 / f * f3 - f4 * f3;
                this.appliedImpulse += f6;
                Vector3f vector3f12 = (Vector3f)Pools.VECTORS.get();
                vector3f12.scale(f6, vector3f11);
                vector3f3.sub(vector3f6, this.rbA.getCenterOfMassPosition(vector3f5));
                this.rbA.applyImpulse(vector3f12, vector3f3);
                vector3f3.negate(vector3f12);
                vector3f4.sub(vector3f7, this.rbB.getCenterOfMassPosition(vector3f5));
                this.rbB.applyImpulse(vector3f3, vector3f4);
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f12});
                ++n;
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f10, vector3f8, vector3f9, vector3f, vector3f2});
        }
        vector3f2 = this.getRigidBodyA().getAngularVelocity((Vector3f)Pools.VECTORS.get());
        vector3f = this.getRigidBodyB().getAngularVelocity((Vector3f)Pools.VECTORS.get());
        if (this.solveSwingLimit) {
            vector3f3.sub(vector3f, vector3f2);
            float f7 = vector3f3.dot(this.swingAxis) * this.relaxationFactor * this.relaxationFactor + this.swingCorrection * (1.0f / f) * this.biasFactor;
            float f8 = f7 * this.kSwing;
            float f9 = this.accSwingLimitImpulse;
            this.accSwingLimitImpulse = Math.max(this.accSwingLimitImpulse + f8, 0.0f);
            f8 = this.accSwingLimitImpulse - f9;
            Vector3f vector3f13 = (Vector3f)Pools.VECTORS.get();
            vector3f13.scale(f8, this.swingAxis);
            this.rbA.applyTorqueImpulse(vector3f13);
            vector3f3.negate(vector3f13);
            this.rbB.applyTorqueImpulse(vector3f3);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f13});
        }
        if (this.solveTwistLimit) {
            vector3f3.sub(vector3f, vector3f2);
            float f10 = vector3f3.dot(this.twistAxis) * this.relaxationFactor * this.relaxationFactor + this.twistCorrection * (1.0f / f) * this.biasFactor;
            float f11 = f10 * this.kTwist;
            float f12 = this.accTwistLimitImpulse;
            this.accTwistLimitImpulse = Math.max(this.accTwistLimitImpulse + f11, 0.0f);
            f11 = this.accTwistLimitImpulse - f12;
            Vector3f vector3f14 = (Vector3f)Pools.VECTORS.get();
            vector3f14.scale(f11, this.twistAxis);
            this.rbA.applyTorqueImpulse(vector3f14);
            vector3f3.negate(vector3f14);
            this.rbB.applyTorqueImpulse(vector3f3);
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6, vector3f7, vector3f5, vector3f3, vector3f4});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
    }

    public void updateRHS(float f) {
    }

    public void setAngularOnly(boolean bl) {
        this.angularOnly = bl;
    }

    public void setLimit(float f, float f2, float f3) {
        this.setLimit(f, f2, f3, 0.8f, 0.3f, 1.0f);
    }

    public void setLimit(float f, float f2, float f3, float f4, float f5, float f6) {
        this.swingSpan1 = f;
        this.swingSpan2 = f2;
        this.twistSpan = f3;
        this.limitSoftness = f4;
        this.biasFactor = f5;
        this.relaxationFactor = f6;
    }

    public Transform getAFrame(Transform transform) {
        transform.set(this.rbAFrame);
        return transform;
    }

    public Transform getBFrame(Transform transform) {
        transform.set(this.rbBFrame);
        return transform;
    }

    public boolean getSolveTwistLimit() {
        return this.solveTwistLimit;
    }

    public boolean getSolveSwingLimit() {
        return this.solveTwistLimit;
    }

    public float getTwistLimitSign() {
        return this.twistLimitSign;
    }
}

