/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.character;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphasePair;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.CollisionWorld;
import com.bulletphysics.collision.dispatch.PairCachingGhostObject;
import com.bulletphysics.collision.narrowphase.ManifoldPoint;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.dynamics.ActionInterface;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.util.ObjectArrayList;
import java.util.ArrayList;
import javax.vecmath.Vector3f;

public class KinematicCharacterController
extends ActionInterface {
    private static Vector3f[] upAxisDirection = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
    protected float halfHeight;
    protected PairCachingGhostObject ghostObject;
    protected ConvexShape convexShape;
    protected float verticalVelocity;
    protected float verticalOffset;
    protected float fallSpeed;
    protected float jumpSpeed;
    protected float maxJumpHeight;
    protected float maxSlopeRadians;
    protected float maxSlopeCosine;
    protected float gravity;
    protected float turnAngle;
    protected float stepHeight;
    protected float addedMargin;
    protected Vector3f walkDirection = new Vector3f();
    protected Vector3f normalizedDirection = new Vector3f();
    protected Vector3f currentPosition = new Vector3f();
    protected float currentStepOffset;
    protected Vector3f targetPosition = new Vector3f();
    ArrayList<PersistentManifold> manifoldArray = new ArrayList();
    protected boolean touchingContact;
    protected Vector3f touchingNormal = new Vector3f();
    protected boolean wasOnGround;
    protected boolean wasJumping;
    protected boolean useGhostObjectSweepTest;
    protected boolean useWalkDirection;
    protected float velocityTimeInterval;
    protected int upAxis;
    protected CollisionObject me;

    public KinematicCharacterController(PairCachingGhostObject pairCachingGhostObject, ConvexShape convexShape, float f) {
        this(pairCachingGhostObject, convexShape, f, 1);
    }

    public KinematicCharacterController(PairCachingGhostObject pairCachingGhostObject, ConvexShape convexShape, float f, int n) {
        this.upAxis = n;
        this.addedMargin = 0.02f;
        this.walkDirection.set(0.0f, 0.0f, 0.0f);
        this.useGhostObjectSweepTest = true;
        this.ghostObject = pairCachingGhostObject;
        this.stepHeight = f;
        this.turnAngle = 0.0f;
        this.convexShape = convexShape;
        this.useWalkDirection = true;
        this.velocityTimeInterval = 0.0f;
        this.verticalVelocity = 0.0f;
        this.verticalOffset = 0.0f;
        this.gravity = 29.400002f;
        this.fallSpeed = 55.0f;
        this.jumpSpeed = 10.0f;
        this.wasOnGround = false;
        this.wasJumping = false;
        this.setMaxSlope(0.7853982f);
    }

    private PairCachingGhostObject getGhostObject() {
        return this.ghostObject;
    }

    @Override
    public void updateAction(CollisionWorld collisionWorld, float f) {
        this.preStep(collisionWorld);
        this.playerStep(collisionWorld, f);
    }

    public void setUpAxis(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 2) {
            n = 2;
        }
        this.upAxis = n;
    }

    public void setWalkDirection(Vector3f vector3f) {
        this.useWalkDirection = true;
        this.walkDirection.set(vector3f);
        this.normalizedDirection.set(KinematicCharacterController.getNormalizedVector(vector3f, (Vector3f)Pools.VECTORS.get()));
    }

    public void setVelocityForTimeInterval(Vector3f vector3f, float f) {
        this.useWalkDirection = false;
        this.walkDirection.set(vector3f);
        this.normalizedDirection.set(KinematicCharacterController.getNormalizedVector(this.walkDirection, (Vector3f)Pools.VECTORS.get()));
        this.velocityTimeInterval = f;
    }

    public void reset() {
    }

    public void warp(Vector3f vector3f) {
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        transform.setIdentity();
        transform.origin.set(vector3f);
        this.ghostObject.setWorldTransform(transform);
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
    }

    public void preStep(CollisionWorld collisionWorld) {
        int n = 0;
        this.touchingContact = false;
        while (this.recoverFromPenetration(collisionWorld)) {
            this.touchingContact = true;
            if (++n > 4) break;
        }
        Transform transform = this.ghostObject.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        this.currentPosition.set(transform.origin);
        this.targetPosition.set(this.currentPosition);
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
    }

    public void playerStep(CollisionWorld collisionWorld, float f) {
        if (!this.useWalkDirection && this.velocityTimeInterval <= 0.0f) {
            return;
        }
        this.wasOnGround = this.onGround();
        this.verticalVelocity -= this.gravity * f;
        if ((double)this.verticalVelocity > 0.0 && this.verticalVelocity > this.jumpSpeed) {
            this.verticalVelocity = this.jumpSpeed;
        }
        if ((double)this.verticalVelocity < 0.0 && Math.abs(this.verticalVelocity) > Math.abs(this.fallSpeed)) {
            this.verticalVelocity = -Math.abs(this.fallSpeed);
        }
        this.verticalOffset = this.verticalVelocity * f;
        Transform transform = this.ghostObject.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        this.stepUp(collisionWorld);
        if (this.useWalkDirection) {
            this.stepForwardAndStrafe(collisionWorld, this.walkDirection);
        } else {
            System.out.println("playerStep 4");
            float f2 = f < this.velocityTimeInterval ? f : this.velocityTimeInterval;
            this.velocityTimeInterval -= f;
            Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
            vector3f.scale(f2, this.walkDirection);
            this.stepForwardAndStrafe(collisionWorld, vector3f);
        }
        this.stepDown(collisionWorld, f);
        transform.origin.set(this.currentPosition);
        this.ghostObject.setWorldTransform(transform);
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
    }

    public void setFallSpeed(float f) {
        this.fallSpeed = f;
    }

    public void setJumpSpeed(float f) {
        this.jumpSpeed = f;
    }

    public void setMaxJumpHeight(float f) {
        this.maxJumpHeight = f;
    }

    public boolean canJump() {
        return this.onGround();
    }

    public void jump() {
        if (!this.canJump()) {
            return;
        }
        this.verticalVelocity = this.jumpSpeed;
        this.wasJumping = true;
    }

    public void setGravity(float f) {
        this.gravity = f;
    }

    public float getGravity() {
        return this.gravity;
    }

    public void setMaxSlope(float f) {
        this.maxSlopeRadians = f;
        this.maxSlopeCosine = (float)Math.cos(f);
    }

    public float getMaxSlope() {
        return this.maxSlopeRadians;
    }

    public boolean onGround() {
        return this.verticalVelocity == 0.0f && this.verticalOffset == 0.0f;
    }

    private static Vector3f getNormalizedVector(Vector3f vector3f, Vector3f vector3f2) {
        vector3f2.set(vector3f);
        vector3f2.normalize();
        if (vector3f2.length() < 1.1920929E-7f) {
            vector3f2.set(0.0f, 0.0f, 0.0f);
        }
        return vector3f2;
    }

    protected Vector3f computeReflectionDirection(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        vector3f3.set(vector3f2);
        vector3f3.scale(-2.0f * vector3f.dot(vector3f2));
        vector3f3.add(vector3f);
        return vector3f3;
    }

    protected Vector3f parallelComponent(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        vector3f3.set(vector3f2);
        vector3f3.scale(vector3f.dot(vector3f2));
        return vector3f3;
    }

    protected Vector3f perpindicularComponent(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        Vector3f vector3f4 = this.parallelComponent(vector3f, vector3f2, vector3f3);
        vector3f4.scale(-1.0f);
        vector3f4.add(vector3f);
        return vector3f4;
    }

    protected boolean recoverFromPenetration(CollisionWorld collisionWorld) {
        boolean bl = false;
        collisionWorld.getDispatcher().dispatchAllCollisionPairs(this.ghostObject.getOverlappingPairCache(), collisionWorld.getDispatchInfo(), collisionWorld.getDispatcher());
        Transform transform = this.ghostObject.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        this.currentPosition.set(transform.origin);
        float f = 0.0f;
        int n = 0;
        while (n < this.ghostObject.getOverlappingPairCache().getNumOverlappingPairs()) {
            this.manifoldArray.clear();
            BroadphasePair broadphasePair = (BroadphasePair)((ObjectArrayList)this.ghostObject.getOverlappingPairCache().getOverlappingPairArray()).get(n);
            if (((CollisionObject)broadphasePair.pProxy0.clientObject).hasContactResponse() && ((CollisionObject)broadphasePair.pProxy1.clientObject).hasContactResponse()) {
                if (broadphasePair.algorithm != null) {
                    broadphasePair.algorithm.getAllContactManifolds(this.manifoldArray);
                }
                for (PersistentManifold persistentManifold : this.manifoldArray) {
                    float f2 = persistentManifold.getBody0() == this.ghostObject ? -1.0f : 1.0f;
                    int n2 = 0;
                    while (n2 < persistentManifold.getNumContacts()) {
                        ManifoldPoint manifoldPoint = persistentManifold.getContactPoint(n2);
                        float f3 = manifoldPoint.getDistance();
                        if (f3 < 0.0f) {
                            if (f3 < f) {
                                f = f3;
                                this.touchingNormal.set(manifoldPoint.normalWorldOnB);
                                this.touchingNormal.scale(f2);
                            }
                            this.currentPosition.scaleAdd(f2 * f3 * 0.2f, manifoldPoint.normalWorldOnB, this.currentPosition);
                            bl = true;
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        Transform transform2 = this.ghostObject.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        transform2.origin.set(this.currentPosition);
        this.ghostObject.setWorldTransform(transform2);
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
        return bl;
    }

    protected void stepUp(CollisionWorld collisionWorld) {
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        Transform transform2 = (Transform)Pools.TRANSFORMS.get();
        this.targetPosition.scaleAdd(this.stepHeight + ((double)this.verticalOffset > 0.0 ? this.verticalOffset : 0.0f), upAxisDirection[this.upAxis], this.currentPosition);
        transform.setIdentity();
        transform2.setIdentity();
        transform.origin.scaleAdd(this.convexShape.getMargin() + this.addedMargin, upAxisDirection[this.upAxis], this.currentPosition);
        transform2.origin.set(this.targetPosition);
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        vector3f.scale(-1.0f, upAxisDirection[this.upAxis]);
        KinematicClosestNotMeConvexResultCallback kinematicClosestNotMeConvexResultCallback = new KinematicClosestNotMeConvexResultCallback(this.ghostObject, vector3f, 0.7071f);
        kinematicClosestNotMeConvexResultCallback.collisionFilterGroup = this.getGhostObject().getBroadphaseHandle().collisionFilterGroup;
        kinematicClosestNotMeConvexResultCallback.collisionFilterMask = this.getGhostObject().getBroadphaseHandle().collisionFilterMask;
        if (this.useGhostObjectSweepTest) {
            this.ghostObject.convexSweepTest(this.convexShape, transform, transform2, kinematicClosestNotMeConvexResultCallback, collisionWorld.getDispatchInfo().allowedCcdPenetration);
        } else {
            collisionWorld.convexSweepTest(this.convexShape, transform, transform2, kinematicClosestNotMeConvexResultCallback);
        }
        if (kinematicClosestNotMeConvexResultCallback.hasHit()) {
            if ((double)kinematicClosestNotMeConvexResultCallback.hitNormalWorld.dot(upAxisDirection[this.upAxis]) > 0.0) {
                this.currentStepOffset = this.stepHeight * kinematicClosestNotMeConvexResultCallback.closestHitFraction;
                this.currentPosition.interpolate(this.currentPosition, this.targetPosition, kinematicClosestNotMeConvexResultCallback.closestHitFraction);
                this.verticalVelocity = 0.0f;
                this.verticalOffset = 0.0f;
            }
        } else {
            this.currentStepOffset = this.stepHeight;
            this.currentPosition.set(this.targetPosition);
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
    }

    protected void updateTargetPositionBasedOnCollision(Vector3f vector3f) {
        this.updateTargetPositionBasedOnCollision(vector3f, 0.0f, 1.0f);
    }

    protected void updateTargetPositionBasedOnCollision(Vector3f vector3f, float f, float f2) {
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.sub(this.targetPosition, this.currentPosition);
        float f3 = vector3f2.length();
        if (f3 > 1.1920929E-7f) {
            vector3f2.normalize();
            Vector3f vector3f3 = this.computeReflectionDirection(vector3f2, vector3f, (Vector3f)Pools.VECTORS.get());
            vector3f3.normalize();
            Vector3f vector3f4 = this.parallelComponent(vector3f3, vector3f, (Vector3f)Pools.VECTORS.get());
            Vector3f vector3f5 = this.perpindicularComponent(vector3f3, vector3f, (Vector3f)Pools.VECTORS.get());
            this.targetPosition.set(this.currentPosition);
            if (f2 != 0.0f) {
                Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
                vector3f6.scale(f2 * f3, vector3f5);
                this.targetPosition.add(vector3f6);
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f6});
            }
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2});
    }

    protected void stepForwardAndStrafe(CollisionWorld collisionWorld, Vector3f vector3f) {
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        Transform transform2 = (Transform)Pools.TRANSFORMS.get();
        this.targetPosition.add(this.currentPosition, vector3f);
        transform.setIdentity();
        transform2.setIdentity();
        float f = 1.0f;
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.sub(this.currentPosition, this.targetPosition);
        float f2 = vector3f2.lengthSquared();
        if (this.touchingContact && this.normalizedDirection.dot(this.touchingNormal) > 0.0f) {
            this.updateTargetPositionBasedOnCollision(this.touchingNormal);
        }
        int n = 10;
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        while (f > 0.01f && n-- > 0) {
            transform.origin.set(this.currentPosition);
            transform2.origin.set(this.targetPosition);
            Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
            vector3f5.sub(this.currentPosition, this.targetPosition);
            KinematicClosestNotMeConvexResultCallback kinematicClosestNotMeConvexResultCallback = new KinematicClosestNotMeConvexResultCallback(this.ghostObject, vector3f5, -1.0f);
            kinematicClosestNotMeConvexResultCallback.collisionFilterGroup = this.getGhostObject().getBroadphaseHandle().collisionFilterGroup;
            kinematicClosestNotMeConvexResultCallback.collisionFilterMask = this.getGhostObject().getBroadphaseHandle().collisionFilterMask;
            float f3 = this.convexShape.getMargin();
            this.convexShape.setMargin(f3 + this.addedMargin);
            if (this.useGhostObjectSweepTest) {
                this.ghostObject.convexSweepTest(this.convexShape, transform, transform2, kinematicClosestNotMeConvexResultCallback, collisionWorld.getDispatchInfo().allowedCcdPenetration);
            } else {
                collisionWorld.convexSweepTest(this.convexShape, transform, transform2, kinematicClosestNotMeConvexResultCallback);
            }
            this.convexShape.setMargin(f3);
            f -= kinematicClosestNotMeConvexResultCallback.closestHitFraction;
            if (kinematicClosestNotMeConvexResultCallback.hasHit()) {
                vector3f3.sub(kinematicClosestNotMeConvexResultCallback.hitPointWorld, this.currentPosition);
                this.updateTargetPositionBasedOnCollision(kinematicClosestNotMeConvexResultCallback.hitNormalWorld);
                vector3f4.sub(this.targetPosition, this.currentPosition);
                f2 = vector3f4.lengthSquared();
                if (!(f2 > 1.1920929E-7f)) break;
                vector3f4.normalize();
                if (!(vector3f4.dot(this.normalizedDirection) <= 0.0f)) continue;
                break;
            }
            this.currentPosition.set(this.targetPosition);
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f3});
    }

    protected void stepDown(CollisionWorld collisionWorld, float f) {
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        Transform transform2 = (Transform)Pools.TRANSFORMS.get();
        float f2 = (this.verticalVelocity < 0.0f ? -this.verticalVelocity : 0.0f) * f;
        if ((double)f2 > 0.0 && f2 < this.stepHeight && (this.wasOnGround || !this.wasJumping)) {
            f2 = this.stepHeight;
        }
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        vector3f.scale(this.currentStepOffset + f2, upAxisDirection[this.upAxis]);
        this.targetPosition.sub(vector3f);
        transform.setIdentity();
        transform2.setIdentity();
        transform.origin.set(this.currentPosition);
        transform2.origin.set(this.targetPosition);
        KinematicClosestNotMeConvexResultCallback kinematicClosestNotMeConvexResultCallback = new KinematicClosestNotMeConvexResultCallback(this.ghostObject, upAxisDirection[this.upAxis], this.maxSlopeCosine);
        kinematicClosestNotMeConvexResultCallback.collisionFilterGroup = this.getGhostObject().getBroadphaseHandle().collisionFilterGroup;
        kinematicClosestNotMeConvexResultCallback.collisionFilterMask = this.getGhostObject().getBroadphaseHandle().collisionFilterMask;
        if (this.useGhostObjectSweepTest) {
            this.ghostObject.convexSweepTest(this.convexShape, transform, transform2, kinematicClosestNotMeConvexResultCallback, collisionWorld.getDispatchInfo().allowedCcdPenetration);
        } else {
            collisionWorld.convexSweepTest(this.convexShape, transform, transform2, kinematicClosestNotMeConvexResultCallback);
        }
        if (kinematicClosestNotMeConvexResultCallback.hasHit()) {
            this.currentPosition.interpolate(this.currentPosition, this.targetPosition, kinematicClosestNotMeConvexResultCallback.closestHitFraction);
            this.verticalVelocity = 0.0f;
            this.verticalOffset = 0.0f;
            this.wasJumping = false;
        } else {
            this.currentPosition.set(this.targetPosition);
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
    }

    private static class KinematicClosestNotMeConvexResultCallback
    extends CollisionWorld.ClosestConvexResultCallback {
        protected CollisionObject me;
        protected final Vector3f up;
        protected float minSlopeDot;

        public KinematicClosestNotMeConvexResultCallback(CollisionObject collisionObject, Vector3f vector3f, float f) {
            super(new Vector3f(), new Vector3f());
            this.me = collisionObject;
            this.up = vector3f;
            this.minSlopeDot = f;
        }

        @Override
        public float addSingleResult(CollisionWorld.LocalConvexResult localConvexResult, boolean bl) {
            float f;
            if (!localConvexResult.hitCollisionObject.hasContactResponse()) {
                return 1.0f;
            }
            if (localConvexResult.hitCollisionObject == this.me) {
                return 1.0f;
            }
            if (bl) {
                Vector3f vector3f = localConvexResult.hitNormalLocal;
                f = this.up.dot(vector3f);
            } else {
                Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
                Transform transform = localConvexResult.hitCollisionObject.getWorldTransform((Transform)Pools.TRANSFORMS.get());
                transform.basis.transform(localConvexResult.hitNormalLocal, vector3f);
                f = this.up.dot(vector3f);
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
                Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
            }
            if (f < this.minSlopeDot) {
                return 1.0f;
            }
            return super.addSingleResult(localConvexResult, bl);
        }
    }
}

