/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.linearmath;

import com.bulletphysics.Pools;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.QuaternionUtil;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class TransformUtil {
    public static final float SIMDSQRT12 = 0.70710677f;
    public static final float ANGULAR_MOTION_THRESHOLD = 0.7853982f;

    public static float recipSqrt(float f) {
        return 1.0f / (float)Math.sqrt(f);
    }

    public static void planeSpace1(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        if (Math.abs(vector3f.z) > 0.70710677f) {
            float f = vector3f.y * vector3f.y + vector3f.z * vector3f.z;
            float f2 = TransformUtil.recipSqrt(f);
            vector3f2.set(0.0f, -vector3f.z * f2, vector3f.y * f2);
            vector3f3.set(f * f2, -vector3f.x * vector3f2.z, vector3f.x * vector3f2.y);
        } else {
            float f = vector3f.x * vector3f.x + vector3f.y * vector3f.y;
            float f3 = TransformUtil.recipSqrt(f);
            vector3f2.set(-vector3f.y * f3, vector3f.x * f3, 0.0f);
            vector3f3.set(-vector3f.z * vector3f2.y, vector3f.z * vector3f2.x, f * f3);
        }
    }

    public static void integrateTransform(Transform transform, Vector3f vector3f, Vector3f vector3f2, float f, Transform transform2) {
        transform2.origin.scaleAdd(f, vector3f, transform.origin);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        float f2 = vector3f2.length();
        if (f2 * f > 0.7853982f) {
            f2 = 0.7853982f / f;
        }
        if (f2 < 0.001f) {
            vector3f3.scale(0.5f * f - f * f * f * 0.020833334f * f2 * f2, vector3f2);
        } else {
            vector3f3.scale((float)Math.sin(0.5f * f2 * f) / f2, vector3f2);
        }
        Quat4f quat4f = (Quat4f)Pools.QUATS.get();
        quat4f.set(vector3f3.x, vector3f3.y, vector3f3.z, (float)Math.cos(f2 * f * 0.5f));
        Quat4f quat4f2 = transform.getRotation((Quat4f)Pools.QUATS.get());
        Quat4f quat4f3 = (Quat4f)Pools.QUATS.get();
        quat4f3.mul(quat4f, quat4f2);
        quat4f3.normalize();
        transform2.setRotation(quat4f3);
        Pools.QUATS.release((Object[])new Quat4f[]{quat4f, quat4f2, quat4f3});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
    }

    public static void calculateVelocity(Transform transform, Transform transform2, float f, Vector3f vector3f, Vector3f vector3f2) {
        vector3f.sub(transform2.origin, transform.origin);
        vector3f.scale(1.0f / f);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        float[] fArray = new float[1];
        TransformUtil.calculateDiffAxisAngle(transform, transform2, vector3f3, fArray);
        vector3f2.scale(fArray[0] / f, vector3f3);
    }

    public static void calculateDiffAxisAngle(Transform transform, Transform transform2, Vector3f vector3f, float[] fArray) {
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get();
        matrix3f.set(transform.basis);
        MatrixUtil.invert(matrix3f);
        Matrix3f matrix3f2 = (Matrix3f)Pools.MATRICES.get();
        matrix3f2.mul(transform2.basis, matrix3f);
        Quat4f quat4f = (Quat4f)Pools.QUATS.get();
        MatrixUtil.getRotation(matrix3f2, quat4f);
        quat4f.normalize();
        fArray[0] = QuaternionUtil.getAngle(quat4f);
        vector3f.set(quat4f.x, quat4f.y, quat4f.z);
        float f = vector3f.lengthSquared();
        if (f < 1.4210855E-14f) {
            vector3f.set(1.0f, 0.0f, 0.0f);
        } else {
            vector3f.scale(1.0f / (float)Math.sqrt(f));
        }
        Pools.QUATS.release((Object[])new Quat4f[]{quat4f});
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f, matrix3f2});
    }
}

