/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;

public class Manifold {
    public final ManifoldPoint[] points = new ManifoldPoint[Settings.maxManifoldPoints];
    public final Vec2 localNormal;
    public final Vec2 localPoint;
    public ManifoldType type;
    public int pointCount;

    public Manifold() {
        int n = 0;
        while (n < Settings.maxManifoldPoints) {
            this.points[n] = new ManifoldPoint();
            ++n;
        }
        this.localNormal = new Vec2();
        this.localPoint = new Vec2();
        this.pointCount = 0;
    }

    public Manifold(Manifold manifold) {
        this.localNormal = manifold.localNormal.clone();
        this.localPoint = manifold.localPoint.clone();
        this.pointCount = manifold.pointCount;
        this.type = manifold.type;
        int n = 0;
        while (n < Settings.maxManifoldPoints) {
            this.points[n] = new ManifoldPoint(manifold.points[n]);
            ++n;
        }
    }

    public void set(Manifold manifold) {
        int n = 0;
        while (n < manifold.pointCount) {
            this.points[n].set(manifold.points[n]);
            ++n;
        }
        this.type = manifold.type;
        this.localNormal.set(manifold.localNormal);
        this.localPoint.set(manifold.localPoint);
        this.pointCount = manifold.pointCount;
    }

    public static enum ManifoldType {
        CIRCLES,
        FACE_A,
        FACE_B;

    }
}

