/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.broadphase.BroadPhase;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Filter;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.FixtureProxy;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactEdge;

public class Fixture {
    public float m_density;
    public Fixture m_next = null;
    public Body m_body = null;
    public Shape m_shape = null;
    public float m_friction;
    public float m_restitution;
    public FixtureProxy[] m_proxies = null;
    public int m_proxyCount = 0;
    public final Filter m_filter;
    public boolean m_isSensor;
    public Object m_userData = null;
    private final AABB pool1 = new AABB();
    private final AABB pool2 = new AABB();
    private final Vec2 displacement = new Vec2();

    public Fixture() {
        this.m_filter = new Filter();
    }

    public ShapeType getType() {
        return this.m_shape.getType();
    }

    public Shape getShape() {
        return this.m_shape;
    }

    public boolean isSensor() {
        return this.m_isSensor;
    }

    public void setSensor(boolean bl) {
        if (bl != this.m_isSensor) {
            this.m_body.setAwake(true);
            this.m_isSensor = bl;
        }
    }

    public void setFilterData(Filter filter) {
        this.m_filter.set(filter);
        this.refilter();
    }

    public Filter getFilterData() {
        return this.m_filter;
    }

    public void refilter() {
        Object object;
        Object object2;
        if (this.m_body == null) {
            return;
        }
        ContactEdge contactEdge = this.m_body.getContactList();
        while (contactEdge != null) {
            object2 = contactEdge.contact;
            object = ((Contact)object2).getFixtureA();
            Fixture fixture = ((Contact)object2).getFixtureB();
            if (object == this || fixture == this) {
                ((Contact)object2).flagForFiltering();
            }
            contactEdge = contactEdge.next;
        }
        object2 = this.m_body.getWorld();
        if (object2 == null) {
            return;
        }
        object = ((World)object2).m_contactManager.m_broadPhase;
        int n = 0;
        while (n < this.m_proxyCount) {
            object.touchProxy(this.m_proxies[n].proxyId);
            ++n;
        }
    }

    public Body getBody() {
        return this.m_body;
    }

    public Fixture getNext() {
        return this.m_next;
    }

    public void setDensity(float f) {
        assert (f >= 0.0f);
        this.m_density = f;
    }

    public float getDensity() {
        return this.m_density;
    }

    public Object getUserData() {
        return this.m_userData;
    }

    public void setUserData(Object object) {
        this.m_userData = object;
    }

    public boolean testPoint(Vec2 vec2) {
        return this.m_shape.testPoint(this.m_body.m_xf, vec2);
    }

    public boolean raycast(RayCastOutput rayCastOutput, RayCastInput rayCastInput, int n) {
        return this.m_shape.raycast(rayCastOutput, rayCastInput, this.m_body.m_xf, n);
    }

    public void getMassData(MassData massData) {
        this.m_shape.computeMass(massData, this.m_density);
    }

    public float getFriction() {
        return this.m_friction;
    }

    public void setFriction(float f) {
        this.m_friction = f;
    }

    public float getRestitution() {
        return this.m_restitution;
    }

    public void setRestitution(float f) {
        this.m_restitution = f;
    }

    public AABB getAABB(int n) {
        assert (n >= 0 && n < this.m_proxyCount);
        return this.m_proxies[n].aabb;
    }

    public float computeDistance(Vec2 vec2, int n, Vec2 vec22) {
        return this.m_shape.computeDistanceToOut(this.m_body.getTransform(), vec2, n, vec22);
    }

    public void create(Body body, FixtureDef fixtureDef) {
        this.m_userData = fixtureDef.userData;
        this.m_friction = fixtureDef.friction;
        this.m_restitution = fixtureDef.restitution;
        this.m_body = body;
        this.m_next = null;
        this.m_filter.set(fixtureDef.filter);
        this.m_isSensor = fixtureDef.isSensor;
        this.m_shape = fixtureDef.shape.clone();
        int n = this.m_shape.getChildCount();
        if (this.m_proxies == null) {
            this.m_proxies = new FixtureProxy[n];
            int n2 = 0;
            while (n2 < n) {
                this.m_proxies[n2] = new FixtureProxy();
                this.m_proxies[n2].fixture = null;
                this.m_proxies[n2].proxyId = -1;
                ++n2;
            }
        }
        if (this.m_proxies.length < n) {
            FixtureProxy[] fixtureProxyArray = this.m_proxies;
            int n3 = MathUtils.max(fixtureProxyArray.length * 2, n);
            this.m_proxies = new FixtureProxy[n3];
            System.arraycopy(fixtureProxyArray, 0, this.m_proxies, 0, fixtureProxyArray.length);
            int n4 = 0;
            while (n4 < n3) {
                if (n4 >= fixtureProxyArray.length) {
                    this.m_proxies[n4] = new FixtureProxy();
                }
                this.m_proxies[n4].fixture = null;
                this.m_proxies[n4].proxyId = -1;
                ++n4;
            }
        }
        this.m_proxyCount = 0;
        this.m_density = fixtureDef.density;
    }

    public void destroy() {
        assert (this.m_proxyCount == 0);
        this.m_shape = null;
        this.m_proxies = null;
        this.m_next = null;
    }

    public void createProxies(BroadPhase broadPhase, Transform transform) {
        assert (this.m_proxyCount == 0);
        this.m_proxyCount = this.m_shape.getChildCount();
        int n = 0;
        while (n < this.m_proxyCount) {
            FixtureProxy fixtureProxy = this.m_proxies[n];
            this.m_shape.computeAABB(fixtureProxy.aabb, transform, n);
            fixtureProxy.proxyId = broadPhase.createProxy(fixtureProxy.aabb, fixtureProxy);
            fixtureProxy.fixture = this;
            fixtureProxy.childIndex = n++;
        }
    }

    public void destroyProxies(BroadPhase broadPhase) {
        int n = 0;
        while (n < this.m_proxyCount) {
            FixtureProxy fixtureProxy = this.m_proxies[n];
            broadPhase.destroyProxy(fixtureProxy.proxyId);
            fixtureProxy.proxyId = -1;
            ++n;
        }
        this.m_proxyCount = 0;
    }

    protected void synchronize(BroadPhase broadPhase, Transform transform, Transform transform2) {
        if (this.m_proxyCount == 0) {
            return;
        }
        int n = 0;
        while (n < this.m_proxyCount) {
            FixtureProxy fixtureProxy = this.m_proxies[n];
            AABB aABB = this.pool1;
            AABB aABB2 = this.pool2;
            this.m_shape.computeAABB(aABB, transform, fixtureProxy.childIndex);
            this.m_shape.computeAABB(aABB2, transform2, fixtureProxy.childIndex);
            fixtureProxy.aabb.lowerBound.x = aABB.lowerBound.x < aABB2.lowerBound.x ? aABB.lowerBound.x : aABB2.lowerBound.x;
            fixtureProxy.aabb.lowerBound.y = aABB.lowerBound.y < aABB2.lowerBound.y ? aABB.lowerBound.y : aABB2.lowerBound.y;
            fixtureProxy.aabb.upperBound.x = aABB.upperBound.x > aABB2.upperBound.x ? aABB.upperBound.x : aABB2.upperBound.x;
            fixtureProxy.aabb.upperBound.y = aABB.upperBound.y > aABB2.upperBound.y ? aABB.upperBound.y : aABB2.upperBound.y;
            this.displacement.x = transform2.p.x - transform.p.x;
            this.displacement.y = transform2.p.y - transform.p.y;
            broadPhase.moveProxy(fixtureProxy.proxyId, fixtureProxy.aabb, this.displacement);
            ++n;
        }
    }
}

