/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.util;

public class IntArrayList {
    private int[] array = new int[16];
    private int size;

    public void add(int n) {
        if (this.size == this.array.length) {
            this.expand();
        }
        this.array[this.size++] = n;
    }

    private void expand() {
        int[] nArray = new int[this.array.length << 1];
        System.arraycopy(this.array, 0, nArray, 0, this.array.length);
        this.array = nArray;
    }

    public int remove(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.array[n];
        System.arraycopy(this.array, n + 1, this.array, n, this.size - n - 1);
        --this.size;
        return n2;
    }

    public int get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[n];
    }

    public void set(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.array[n] = n2;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }
}

