/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.linearmath.MiscUtil;
import com.bulletphysics.linearmath.convexhull.HullDesc;
import com.bulletphysics.linearmath.convexhull.HullFlags;
import com.bulletphysics.linearmath.convexhull.HullLibrary;
import com.bulletphysics.linearmath.convexhull.HullResult;
import com.bulletphysics.util.IntArrayList;
import java.util.ArrayList;
import javax.vecmath.Vector3f;

public class ShapeHull {
    protected ArrayList<Vector3f> vertices = new ArrayList();
    protected IntArrayList indices = new IntArrayList();
    protected int numIndices;
    protected ConvexShape shape;
    protected ArrayList<Vector3f> unitSpherePoints = new ArrayList();
    private static int NUM_UNITSPHERE_POINTS = 42;
    private static ArrayList<Vector3f> constUnitSpherePoints = new ArrayList();

    static {
        constUnitSpherePoints.add(new Vector3f(0.0f, -0.0f, -1.0f));
        constUnitSpherePoints.add(new Vector3f(0.723608f, -0.525725f, -0.447219f));
        constUnitSpherePoints.add(new Vector3f(-0.276388f, -0.850649f, -0.447219f));
        constUnitSpherePoints.add(new Vector3f(-0.894426f, -0.0f, -0.447216f));
        constUnitSpherePoints.add(new Vector3f(-0.276388f, 0.850649f, -0.44722f));
        constUnitSpherePoints.add(new Vector3f(0.723608f, 0.525725f, -0.447219f));
        constUnitSpherePoints.add(new Vector3f(0.276388f, -0.850649f, 0.44722f));
        constUnitSpherePoints.add(new Vector3f(-0.723608f, -0.525725f, 0.447219f));
        constUnitSpherePoints.add(new Vector3f(-0.723608f, 0.525725f, 0.447219f));
        constUnitSpherePoints.add(new Vector3f(0.276388f, 0.850649f, 0.447219f));
        constUnitSpherePoints.add(new Vector3f(0.894426f, 0.0f, 0.447216f));
        constUnitSpherePoints.add(new Vector3f(-0.0f, 0.0f, 1.0f));
        constUnitSpherePoints.add(new Vector3f(0.425323f, -0.309011f, -0.850654f));
        constUnitSpherePoints.add(new Vector3f(-0.162456f, -0.499995f, -0.850654f));
        constUnitSpherePoints.add(new Vector3f(0.262869f, -0.809012f, -0.525738f));
        constUnitSpherePoints.add(new Vector3f(0.425323f, 0.309011f, -0.850654f));
        constUnitSpherePoints.add(new Vector3f(0.850648f, -0.0f, -0.525736f));
        constUnitSpherePoints.add(new Vector3f(-0.52573f, -0.0f, -0.850652f));
        constUnitSpherePoints.add(new Vector3f(-0.68819f, -0.499997f, -0.525736f));
        constUnitSpherePoints.add(new Vector3f(-0.162456f, 0.499995f, -0.850654f));
        constUnitSpherePoints.add(new Vector3f(-0.68819f, 0.499997f, -0.525736f));
        constUnitSpherePoints.add(new Vector3f(0.262869f, 0.809012f, -0.525738f));
        constUnitSpherePoints.add(new Vector3f(0.951058f, 0.309013f, 0.0f));
        constUnitSpherePoints.add(new Vector3f(0.951058f, -0.309013f, 0.0f));
        constUnitSpherePoints.add(new Vector3f(0.587786f, -0.809017f, 0.0f));
        constUnitSpherePoints.add(new Vector3f(0.0f, -1.0f, 0.0f));
        constUnitSpherePoints.add(new Vector3f(-0.587786f, -0.809017f, 0.0f));
        constUnitSpherePoints.add(new Vector3f(-0.951058f, -0.309013f, -0.0f));
        constUnitSpherePoints.add(new Vector3f(-0.951058f, 0.309013f, -0.0f));
        constUnitSpherePoints.add(new Vector3f(-0.587786f, 0.809017f, -0.0f));
        constUnitSpherePoints.add(new Vector3f(-0.0f, 1.0f, -0.0f));
        constUnitSpherePoints.add(new Vector3f(0.587786f, 0.809017f, -0.0f));
        constUnitSpherePoints.add(new Vector3f(0.68819f, -0.499997f, 0.525736f));
        constUnitSpherePoints.add(new Vector3f(-0.262869f, -0.809012f, 0.525738f));
        constUnitSpherePoints.add(new Vector3f(-0.850648f, 0.0f, 0.525736f));
        constUnitSpherePoints.add(new Vector3f(-0.262869f, 0.809012f, 0.525738f));
        constUnitSpherePoints.add(new Vector3f(0.68819f, 0.499997f, 0.525736f));
        constUnitSpherePoints.add(new Vector3f(0.52573f, 0.0f, 0.850652f));
        constUnitSpherePoints.add(new Vector3f(0.162456f, -0.499995f, 0.850654f));
        constUnitSpherePoints.add(new Vector3f(-0.425323f, -0.309011f, 0.850654f));
        constUnitSpherePoints.add(new Vector3f(-0.425323f, 0.309011f, 0.850654f));
        constUnitSpherePoints.add(new Vector3f(0.162456f, 0.499995f, 0.850654f));
    }

    public ShapeHull(ConvexShape convexShape) {
        this.shape = convexShape;
        this.vertices.clear();
        this.indices.clear();
        this.numIndices = 0;
        MiscUtil.resize(this.unitSpherePoints, NUM_UNITSPHERE_POINTS + 20, Vector3f.class);
        int n = 0;
        while (n < constUnitSpherePoints.size()) {
            this.unitSpherePoints.get(n).set(constUnitSpherePoints.get(n));
            ++n;
        }
    }

    public boolean buildHull(float f) {
        int n;
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        int n2 = NUM_UNITSPHERE_POINTS;
        int n3 = this.shape.getNumPreferredPenetrationDirections();
        if (n3 != 0) {
            n = 0;
            while (n < n3) {
                this.shape.getPreferredPenetrationDirection(n, vector3f);
                this.unitSpherePoints.get(n2).set(vector3f);
                ++n2;
                ++n;
            }
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        ArrayList arrayList = new ArrayList();
        MiscUtil.resize(arrayList, NUM_UNITSPHERE_POINTS + 20, Vector3f.class);
        n = 0;
        while (n < n2) {
            this.shape.localGetSupportingVertex(this.unitSpherePoints.get(n), (Vector3f)arrayList.get(n));
            ++n;
        }
        HullDesc hullDesc = new HullDesc();
        hullDesc.flags = HullFlags.TRIANGLES;
        hullDesc.vcount = n2;
        hullDesc.vertices = arrayList;
        HullLibrary hullLibrary = new HullLibrary();
        HullResult hullResult = new HullResult();
        if (!hullLibrary.createConvexHull(hullDesc, hullResult)) {
            return false;
        }
        MiscUtil.resize(this.vertices, hullResult.numOutputVertices, Vector3f.class);
        int n4 = 0;
        while (n4 < hullResult.numOutputVertices) {
            this.vertices.get(n4).set(hullResult.outputVertices.get(n4));
            ++n4;
        }
        this.numIndices = hullResult.numIndices;
        MiscUtil.resize(this.indices, this.numIndices, 0);
        n4 = 0;
        while (n4 < this.numIndices) {
            this.indices.set(n4, hullResult.indices.get(n4));
            ++n4;
        }
        hullLibrary.releaseResult(hullResult);
        return true;
    }

    public int numTriangles() {
        return this.numIndices / 3;
    }

    public int numVertices() {
        return this.vertices.size();
    }

    public int numIndices() {
        return this.numIndices;
    }

    public ArrayList<Vector3f> getVertexPointer() {
        return this.vertices;
    }

    public IntArrayList getIndexPointer() {
        return this.indices;
    }
}

