/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.box2d_version;

import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.util.GamaPair;
import gama.dev.DEBUG;
import gama.extension.physics.box2d_version.Box2DPhysicalWorld;
import gama.extension.physics.box2d_version.IBox2DPhysicalEntity;
import gama.extension.physics.common.AbstractBodyWrapper;
import gama.extension.physics.common.IBody;
import gama.extension.physics.gaml.PhysicalSimulationAgent;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.locationtech.jts.geom.Coordinate;

public class Box2DBodyWrapper
extends AbstractBodyWrapper<World, Body, Shape, Vec2>
implements IBox2DPhysicalEntity {
    static double TOLERANCE;
    BodyDef def;
    FixtureDef fixtureDef;
    MassData ms;
    private final float scale;

    static {
        DEBUG.OFF();
        TOLERANCE = 1.0E-7;
    }

    public Box2DBodyWrapper(IAgent iAgent, Box2DPhysicalWorld box2DPhysicalWorld) {
        super(iAgent, box2DPhysicalWorld);
        this.scale = box2DPhysicalWorld.getScale();
        if (iAgent instanceof PhysicalSimulationAgent) {
            ((Body)this.body).setAwake(false);
            ((Body)this.body).setActive(false);
        }
        this.setLocation(iAgent.getLocation());
    }

    @Override
    public Body createAndInitializeBody(Shape shape, World world) {
        Object object;
        this.def = new BodyDef();
        this.fixtureDef = new FixtureDef();
        IBody iBody = (IBody)this.agent.getAttribute("%%rigid_body%%");
        if (iBody != null) {
            object = new GamaPoint();
            this.def.type = this.isStatic ? BodyType.STATIC : BodyType.DYNAMIC;
            this.def.angularDamping = iBody.getAngularDamping();
            this.def.angularVelocity = this.toBox2D(iBody.getAngularVelocity((GamaPoint)object).norm());
            this.def.linearDamping = iBody.getLinearDamping();
            this.toVector(iBody.getLinearVelocity((GamaPoint)object), this.def.linearVelocity);
            this.def.allowSleep = false;
            this.def.userData = this;
            this.def.bullet = true;
        }
        object = world.createBody(this.def);
        if (iBody != null) {
            this.fixtureDef.setDensity(1.0f);
            this.fixtureDef.setFriction(iBody.getFriction());
            this.fixtureDef.setRestitution(iBody.getRestitution());
            this.fixtureDef.setShape(shape);
            this.fixtureDef.setSensor(false);
        }
        ((Body)object).createFixture(this.fixtureDef);
        this.ms = new MassData();
        if (iBody != null) {
            this.ms.mass = iBody.getMass();
        }
        ((Body)object).setMassData(this.ms);
        return object;
    }

    @Override
    public float getMass() {
        return ((Body)this.body).m_mass;
    }

    @Override
    public float getFriction() {
        return ((Body)this.body).getFixtureList().getFriction();
    }

    @Override
    public float getRestitution() {
        return ((Body)this.body).getFixtureList().getRestitution();
    }

    @Override
    public float getLinearDamping() {
        return ((Body)this.body).m_linearDamping;
    }

    @Override
    public float getAngularDamping() {
        return ((Body)this.body).m_angularDamping;
    }

    @Override
    public float getContactDamping() {
        return 0.0f;
    }

    @Override
    public GamaPoint getAngularVelocity(GamaPoint gamaPoint) {
        gamaPoint.setLocation(0.0, 0.0, (double)((Body)this.body).getAngularVelocity());
        return gamaPoint;
    }

    @Override
    public GamaPoint getLinearVelocity(GamaPoint gamaPoint) {
        return this.toGamaPoint(((Body)this.body).getLinearVelocity(), gamaPoint);
    }

    @Override
    public IShape getAABB() {
        AABB aABB = ((Body)this.body).getFixtureList().getAABB(0);
        Vec2 vec2 = aABB.getExtents();
        return GamaGeometryType.buildRectangle((double)this.toGama(vec2.x * 2.0f), (double)this.toGama(vec2.y * 2.0f), (GamaPoint)this.toGamaPoint(((Body)this.body).getPosition()));
    }

    @Override
    public void setMass(Double d) {
        this.ms.mass = d.floatValue();
        ((Body)this.body).setMassData(this.ms);
    }

    @Override
    public void setCCD(boolean bl) {
        ((Body)this.body).setBullet(bl);
    }

    @Override
    public void setFriction(Double d) {
        ((Body)this.body).getFixtureList().setFriction(d.floatValue());
    }

    @Override
    public void setRestitution(Double d) {
        DEBUG.OUT((Object)("Restitution of " + this.agent.getName() + " " + String.valueOf(d)));
        ((Body)this.body).getFixtureList().setRestitution(d.floatValue());
    }

    @Override
    public void setDamping(Double d) {
        ((Body)this.body).setLinearDamping(d.floatValue());
    }

    @Override
    public void setAngularDamping(Double d) {
        ((Body)this.body).setAngularDamping(d.floatValue());
    }

    @Override
    public void setContactDamping(Double d) {
    }

    @Override
    public void setAngularVelocity(GamaPoint gamaPoint) {
        ((Body)this.body).setAngularVelocity(this.toBox2D(gamaPoint.z));
    }

    @Override
    public void setLinearVelocity(GamaPoint gamaPoint) {
        GamaPoint gamaPoint2 = new GamaPoint();
        this.getLinearVelocity(gamaPoint2);
        if (!gamaPoint.equals2D((Coordinate)gamaPoint2, TOLERANCE)) {
            ((Body)this.body).setLinearVelocity((Vec2)this.toVector(gamaPoint));
        }
    }

    @Override
    public void setLocation(GamaPoint gamaPoint) {
        ((Body)this.body).setTransform((Vec2)this.toVector(gamaPoint), ((Body)this.body).getAngle());
    }

    @Override
    public void clearForces() {
        ((Body)this.body).setLinearVelocity(new Vec2(0.0f, 0.0f));
        ((Body)this.body).setAngularVelocity(0.0f);
    }

    @Override
    public void applyImpulse(GamaPoint gamaPoint) {
        ((Body)this.body).applyLinearImpulse((Vec2)this.toVector(gamaPoint), ((Body)this.body).getLocalCenter(), true);
    }

    @Override
    public void applyTorque(GamaPoint gamaPoint) {
        ((Body)this.body).applyTorque(this.toBox2D(gamaPoint.norm()));
    }

    @Override
    public void applyForce(GamaPoint gamaPoint) {
        ((Body)this.body).applyForceToCenter((Vec2)this.toVector(gamaPoint));
    }

    @Override
    public void transferLocationAndRotationToAgent() {
        Vec2 vec2 = ((Body)this.body).getPosition();
        this.agent.setLocation(this.toGamaPoint(vec2));
        Rot rot = ((Body)this.body).getTransform().q;
        GamaPair gamaPair = (GamaPair)this.agent.getAttribute("rotation");
        if (gamaPair == null) {
            gamaPair = new GamaPair((Object)0.0, (Object)new GamaPoint(0.0, 0.0, 1.0), (IType)Types.FLOAT, (IType)Types.POINT);
            this.agent.setAttribute("rotation", (Object)gamaPair);
        }
        gamaPair.key = Math.toDegrees(rot.getAngle());
    }

    @Override
    public float getScale() {
        return this.scale;
    }
}

