/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.Position;
import org.jbox2d.dynamics.contacts.Velocity;
import org.jbox2d.dynamics.joints.ConstantVolumeJointDef;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.Joint;

public class ConstantVolumeJoint
extends Joint {
    private final Body[] bodies;
    private float[] targetLengths;
    private float targetVolume;
    private Vec2[] normals;
    private float m_impulse = 0.0f;
    private World world;
    private DistanceJoint[] distanceJoints;

    public Body[] getBodies() {
        return this.bodies;
    }

    public DistanceJoint[] getJoints() {
        return this.distanceJoints;
    }

    public void inflate(float f) {
        this.targetVolume *= f;
    }

    public ConstantVolumeJoint(World world, ConstantVolumeJointDef constantVolumeJointDef) {
        super(world.getPool(), constantVolumeJointDef);
        int n;
        this.world = world;
        if (constantVolumeJointDef.bodies.size() <= 2) {
            throw new IllegalArgumentException("You cannot create a constant volume joint with less than three bodies.");
        }
        this.bodies = constantVolumeJointDef.bodies.toArray(new Body[0]);
        this.targetLengths = new float[this.bodies.length];
        int n2 = 0;
        while (n2 < this.targetLengths.length) {
            float f;
            n = n2 == this.targetLengths.length - 1 ? 0 : n2 + 1;
            this.targetLengths[n2] = f = this.bodies[n2].getWorldCenter().sub(this.bodies[n].getWorldCenter()).length();
            ++n2;
        }
        this.targetVolume = this.getBodyArea();
        if (constantVolumeJointDef.joints != null && constantVolumeJointDef.joints.size() != constantVolumeJointDef.bodies.size()) {
            throw new IllegalArgumentException("Incorrect joint definition.  Joints have to correspond to the bodies");
        }
        if (constantVolumeJointDef.joints == null) {
            DistanceJointDef distanceJointDef = new DistanceJointDef();
            this.distanceJoints = new DistanceJoint[this.bodies.length];
            n = 0;
            while (n < this.targetLengths.length) {
                int n3 = n == this.targetLengths.length - 1 ? 0 : n + 1;
                distanceJointDef.frequencyHz = constantVolumeJointDef.frequencyHz;
                distanceJointDef.dampingRatio = constantVolumeJointDef.dampingRatio;
                distanceJointDef.collideConnected = constantVolumeJointDef.collideConnected;
                distanceJointDef.initialize(this.bodies[n], this.bodies[n3], this.bodies[n].getWorldCenter(), this.bodies[n3].getWorldCenter());
                this.distanceJoints[n] = (DistanceJoint)this.world.createJoint(distanceJointDef);
                ++n;
            }
        } else {
            this.distanceJoints = constantVolumeJointDef.joints.toArray(new DistanceJoint[0]);
        }
        this.normals = new Vec2[this.bodies.length];
        int n4 = 0;
        while (n4 < this.normals.length) {
            this.normals[n4] = new Vec2();
            ++n4;
        }
    }

    @Override
    public void destructor() {
        int n = 0;
        while (n < this.distanceJoints.length) {
            this.world.destroyJoint(this.distanceJoints[n]);
            ++n;
        }
    }

    private float getBodyArea() {
        float f = 0.0f;
        int n = 0;
        while (n < this.bodies.length) {
            int n2 = n == this.bodies.length - 1 ? 0 : n + 1;
            f += this.bodies[n].getWorldCenter().x * this.bodies[n2].getWorldCenter().y - this.bodies[n2].getWorldCenter().x * this.bodies[n].getWorldCenter().y;
            ++n;
        }
        return f *= 0.5f;
    }

    private float getSolverArea(Position[] positionArray) {
        float f = 0.0f;
        int n = 0;
        while (n < this.bodies.length) {
            int n2 = n == this.bodies.length - 1 ? 0 : n + 1;
            f += positionArray[this.bodies[n].m_islandIndex].c.x * positionArray[this.bodies[n2].m_islandIndex].c.y - positionArray[this.bodies[n2].m_islandIndex].c.x * positionArray[this.bodies[n].m_islandIndex].c.y;
            ++n;
        }
        return f *= 0.5f;
    }

    private boolean constrainEdges(Position[] positionArray) {
        float f;
        float f2 = 0.0f;
        int n = 0;
        while (n < this.bodies.length) {
            int n2 = n == this.bodies.length - 1 ? 0 : n + 1;
            f = positionArray[this.bodies[n2].m_islandIndex].c.x - positionArray[this.bodies[n].m_islandIndex].c.x;
            float f3 = positionArray[this.bodies[n2].m_islandIndex].c.y - positionArray[this.bodies[n].m_islandIndex].c.y;
            float f4 = MathUtils.sqrt(f * f + f3 * f3);
            if (f4 < 1.1920929E-7f) {
                f4 = 1.0f;
            }
            this.normals[n].x = f3 / f4;
            this.normals[n].y = -f / f4;
            f2 += f4;
            ++n;
        }
        Vec2 vec2 = this.pool.popVec2();
        float f5 = this.targetVolume - this.getSolverArea(positionArray);
        f = 0.5f * f5 / f2;
        boolean bl = true;
        int n3 = 0;
        while (n3 < this.bodies.length) {
            int n4 = n3 == this.bodies.length - 1 ? 0 : n3 + 1;
            vec2.set(f * (this.normals[n3].x + this.normals[n4].x), f * (this.normals[n3].y + this.normals[n4].y));
            float f6 = vec2.lengthSquared();
            if (f6 > Settings.maxLinearCorrection * Settings.maxLinearCorrection) {
                vec2.mulLocal(Settings.maxLinearCorrection / MathUtils.sqrt(f6));
            }
            if (f6 > Settings.linearSlop * Settings.linearSlop) {
                bl = false;
            }
            positionArray[this.bodies[n4].m_islandIndex].c.x += vec2.x;
            positionArray[this.bodies[n4].m_islandIndex].c.y += vec2.y;
            ++n3;
        }
        this.pool.pushVec2(1);
        return bl;
    }

    @Override
    public void initVelocityConstraints(SolverData solverData) {
        Velocity[] velocityArray = solverData.velocities;
        Position[] positionArray = solverData.positions;
        Vec2[] vec2Array = this.pool.getVec2Array(this.bodies.length);
        int n = 0;
        while (n < this.bodies.length) {
            int n2 = n == 0 ? this.bodies.length - 1 : n - 1;
            int n3 = n == this.bodies.length - 1 ? 0 : n + 1;
            vec2Array[n].set(positionArray[this.bodies[n3].m_islandIndex].c);
            vec2Array[n].subLocal(positionArray[this.bodies[n2].m_islandIndex].c);
            ++n;
        }
        if (solverData.step.warmStarting) {
            this.m_impulse *= solverData.step.dtRatio;
            n = 0;
            while (n < this.bodies.length) {
                velocityArray[this.bodies[n].m_islandIndex].v.x += this.bodies[n].m_invMass * vec2Array[n].y * 0.5f * this.m_impulse;
                velocityArray[this.bodies[n].m_islandIndex].v.y += this.bodies[n].m_invMass * -vec2Array[n].x * 0.5f * this.m_impulse;
                ++n;
            }
        } else {
            this.m_impulse = 0.0f;
        }
    }

    @Override
    public boolean solvePositionConstraints(SolverData solverData) {
        return this.constrainEdges(solverData.positions);
    }

    @Override
    public void solveVelocityConstraints(SolverData solverData) {
        int n;
        float f = 0.0f;
        float f2 = 0.0f;
        Velocity[] velocityArray = solverData.velocities;
        Position[] positionArray = solverData.positions;
        Vec2[] vec2Array = this.pool.getVec2Array(this.bodies.length);
        int n2 = 0;
        while (n2 < this.bodies.length) {
            n = n2 == 0 ? this.bodies.length - 1 : n2 - 1;
            int n3 = n2 == this.bodies.length - 1 ? 0 : n2 + 1;
            vec2Array[n2].set(positionArray[this.bodies[n3].m_islandIndex].c);
            vec2Array[n2].subLocal(positionArray[this.bodies[n].m_islandIndex].c);
            f2 += vec2Array[n2].lengthSquared() / this.bodies[n2].getMass();
            f += Vec2.cross(velocityArray[this.bodies[n2].m_islandIndex].v, vec2Array[n2]);
            ++n2;
        }
        float f3 = -2.0f * f / f2;
        this.m_impulse += f3;
        n = 0;
        while (n < this.bodies.length) {
            velocityArray[this.bodies[n].m_islandIndex].v.x += this.bodies[n].m_invMass * vec2Array[n].y * 0.5f * f3;
            velocityArray[this.bodies[n].m_islandIndex].v.y += this.bodies[n].m_invMass * -vec2Array[n].x * 0.5f * f3;
            ++n;
        }
    }

    @Override
    public void getAnchorA(Vec2 vec2) {
    }

    @Override
    public void getAnchorB(Vec2 vec2) {
    }

    @Override
    public void getReactionForce(float f, Vec2 vec2) {
    }

    @Override
    public float getReactionTorque(float f) {
        return 0.0f;
    }
}

