/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.narrowphase;

import javax.vecmath.Vector3f;

public class ManifoldPoint {
    public final Vector3f localPointA = new Vector3f();
    public final Vector3f localPointB = new Vector3f();
    public final Vector3f positionWorldOnB = new Vector3f();
    public final Vector3f positionWorldOnA = new Vector3f();
    public final Vector3f normalWorldOnB = new Vector3f();
    public float distance1;
    public float combinedFriction;
    public float combinedRestitution;
    public int partId0;
    public int partId1;
    public int index0;
    public int index1;
    public Object userPersistentData;
    public float appliedImpulse;
    public boolean lateralFrictionInitialized;
    public float appliedImpulseLateral1;
    public float appliedImpulseLateral2;
    public int lifeTime;
    public final Vector3f lateralFrictionDir1 = new Vector3f();
    public final Vector3f lateralFrictionDir2 = new Vector3f();

    public ManifoldPoint() {
        this.userPersistentData = null;
        this.appliedImpulse = 0.0f;
        this.lateralFrictionInitialized = false;
        this.lifeTime = 0;
    }

    public ManifoldPoint(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, float f) {
        this.init(vector3f, vector3f2, vector3f3, f);
    }

    public void init(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, float f) {
        this.localPointA.set(vector3f);
        this.localPointB.set(vector3f2);
        this.normalWorldOnB.set(vector3f3);
        this.distance1 = f;
        this.combinedFriction = 0.0f;
        this.combinedRestitution = 0.0f;
        this.userPersistentData = null;
        this.appliedImpulse = 0.0f;
        this.lateralFrictionInitialized = false;
        this.appliedImpulseLateral1 = 0.0f;
        this.appliedImpulseLateral2 = 0.0f;
        this.lifeTime = 0;
    }

    public float getDistance() {
        return this.distance1;
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public void set(ManifoldPoint manifoldPoint) {
        this.localPointA.set(manifoldPoint.localPointA);
        this.localPointB.set(manifoldPoint.localPointB);
        this.positionWorldOnA.set(manifoldPoint.positionWorldOnA);
        this.positionWorldOnB.set(manifoldPoint.positionWorldOnB);
        this.normalWorldOnB.set(manifoldPoint.normalWorldOnB);
        this.distance1 = manifoldPoint.distance1;
        this.combinedFriction = manifoldPoint.combinedFriction;
        this.combinedRestitution = manifoldPoint.combinedRestitution;
        this.partId0 = manifoldPoint.partId0;
        this.partId1 = manifoldPoint.partId1;
        this.index0 = manifoldPoint.index0;
        this.index1 = manifoldPoint.index1;
        this.userPersistentData = manifoldPoint.userPersistentData;
        this.appliedImpulse = manifoldPoint.appliedImpulse;
        this.lateralFrictionInitialized = manifoldPoint.lateralFrictionInitialized;
        this.appliedImpulseLateral1 = manifoldPoint.appliedImpulseLateral1;
        this.appliedImpulseLateral2 = manifoldPoint.appliedImpulseLateral2;
        this.lifeTime = manifoldPoint.lifeTime;
        this.lateralFrictionDir1.set(manifoldPoint.lateralFrictionDir1);
        this.lateralFrictionDir2.set(manifoldPoint.lateralFrictionDir2);
    }

    public Vector3f getPositionWorldOnA(Vector3f vector3f) {
        vector3f.set(this.positionWorldOnA);
        return vector3f;
    }

    public Vector3f getPositionWorldOnB(Vector3f vector3f) {
        vector3f.set(this.positionWorldOnB);
        return vector3f;
    }

    public void setDistance(float f) {
        this.distance1 = f;
    }
}

