/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.ConvexInternalShape;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Vector3f;

public class MinkowskiSumShape
extends ConvexInternalShape {
    private final Transform transA = new Transform();
    private final Transform transB = new Transform();
    private final ConvexShape shapeA;
    private final ConvexShape shapeB;

    public MinkowskiSumShape(ConvexShape convexShape, ConvexShape convexShape2) {
        this.shapeA = convexShape;
        this.shapeB = convexShape2;
        this.transA.setIdentity();
        this.transB.setIdentity();
    }

    @Override
    public Vector3f localGetSupportingVertexWithoutMargin(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f3.negate(vector3f);
        MatrixUtil.transposeTransform(vector3f3, vector3f3, this.transA.basis);
        this.shapeA.localGetSupportingVertexWithoutMargin(vector3f3, vector3f4);
        this.transA.transform(vector3f4);
        MatrixUtil.transposeTransform(vector3f3, vector3f, this.transB.basis);
        this.shapeB.localGetSupportingVertexWithoutMargin(vector3f3, vector3f5);
        this.transB.transform(vector3f5);
        vector3f2.sub(vector3f4, vector3f5);
        return vector3f2;
    }

    @Override
    public void batchedUnitVectorGetSupportingVertexWithoutMargin(Vector3f[] vector3fArray, Vector3f[] vector3fArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            this.localGetSupportingVertexWithoutMargin(vector3fArray[n2], vector3fArray2[n2]);
            ++n2;
        }
    }

    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.MINKOWSKI_SUM_SHAPE_PROXYTYPE;
    }

    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
        assert (false);
        vector3f.set(0.0f, 0.0f, 0.0f);
    }

    @Override
    public String getName() {
        return "MinkowskiSum";
    }

    @Override
    public float getMargin() {
        return this.shapeA.getMargin() + this.shapeB.getMargin();
    }

    public void setTransformA(Transform transform) {
        this.transA.set(transform);
    }

    public void setTransformB(Transform transform) {
        this.transB.set(transform);
    }

    public void getTransformA(Transform transform) {
        transform.set(this.transA);
    }

    public void getTransformB(Transform transform) {
        transform.set(this.transB);
    }
}

