/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.constraintsolver;

import com.bulletphysics.Pools;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public class JacobianEntry {
    public final Vector3f linearJointAxis = new Vector3f();
    public final Vector3f aJ = new Vector3f();
    public final Vector3f bJ = new Vector3f();
    public final Vector3f m_0MinvJt = new Vector3f();
    public final Vector3f m_1MinvJt = new Vector3f();
    public float Adiag;

    public void init(Matrix3f matrix3f, Matrix3f matrix3f2, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, float f, Vector3f vector3f5, float f2) {
        this.linearJointAxis.set(vector3f3);
        this.aJ.cross(vector3f, this.linearJointAxis);
        matrix3f.transform(this.aJ);
        this.bJ.set(this.linearJointAxis);
        this.bJ.negate();
        this.bJ.cross(vector3f2, this.bJ);
        matrix3f2.transform(this.bJ);
        VectorUtil.mul(this.m_0MinvJt, vector3f4, this.aJ);
        VectorUtil.mul(this.m_1MinvJt, vector3f5, this.bJ);
        this.Adiag = f + this.m_0MinvJt.dot(this.aJ) + f2 + this.m_1MinvJt.dot(this.bJ);
        assert (this.Adiag > 0.0f);
    }

    public void init(Vector3f vector3f, Matrix3f matrix3f, Matrix3f matrix3f2, Vector3f vector3f2, Vector3f vector3f3) {
        this.linearJointAxis.set(0.0f, 0.0f, 0.0f);
        this.aJ.set(vector3f);
        matrix3f.transform(this.aJ);
        this.bJ.set(vector3f);
        this.bJ.negate();
        matrix3f2.transform(this.bJ);
        VectorUtil.mul(this.m_0MinvJt, vector3f2, this.aJ);
        VectorUtil.mul(this.m_1MinvJt, vector3f3, this.bJ);
        this.Adiag = this.m_0MinvJt.dot(this.aJ) + this.m_1MinvJt.dot(this.bJ);
        assert (this.Adiag > 0.0f);
    }

    public void init(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        this.linearJointAxis.set(0.0f, 0.0f, 0.0f);
        this.aJ.set(vector3f);
        this.bJ.set(vector3f2);
        this.bJ.negate();
        VectorUtil.mul(this.m_0MinvJt, vector3f3, this.aJ);
        VectorUtil.mul(this.m_1MinvJt, vector3f4, this.bJ);
        this.Adiag = this.m_0MinvJt.dot(this.aJ) + this.m_1MinvJt.dot(this.bJ);
        assert (this.Adiag > 0.0f);
    }

    public void init(Matrix3f matrix3f, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, float f) {
        this.linearJointAxis.set(vector3f3);
        this.aJ.cross(vector3f, vector3f3);
        matrix3f.transform(this.aJ);
        this.bJ.set(vector3f3);
        this.bJ.negate();
        this.bJ.cross(vector3f2, this.bJ);
        matrix3f.transform(this.bJ);
        VectorUtil.mul(this.m_0MinvJt, vector3f4, this.aJ);
        this.m_1MinvJt.set(0.0f, 0.0f, 0.0f);
        this.Adiag = f + this.m_0MinvJt.dot(this.aJ);
        assert (this.Adiag > 0.0f);
    }

    public float getDiagonal() {
        return this.Adiag;
    }

    public float getNonDiagonal(JacobianEntry jacobianEntry, float f) {
        JacobianEntry jacobianEntry2 = this;
        float f2 = f * jacobianEntry2.linearJointAxis.dot(jacobianEntry.linearJointAxis);
        float f3 = jacobianEntry2.m_0MinvJt.dot(jacobianEntry.aJ);
        return f2 + f3;
    }

    public float getNonDiagonal(JacobianEntry jacobianEntry, float f, float f2) {
        JacobianEntry jacobianEntry2 = this;
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        VectorUtil.mul(vector3f, jacobianEntry2.linearJointAxis, jacobianEntry.linearJointAxis);
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        VectorUtil.mul(vector3f2, jacobianEntry2.m_0MinvJt, jacobianEntry.aJ);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        VectorUtil.mul(vector3f3, jacobianEntry2.m_1MinvJt, jacobianEntry.bJ);
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.scale(f, vector3f);
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f5.scale(f2, vector3f);
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        VectorUtil.add(vector3f6, vector3f2, vector3f3, vector3f4, vector3f5);
        return vector3f6.x + vector3f6.y + vector3f6.z;
    }

    public float getRelativeVelocity(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f5.sub(vector3f, vector3f3);
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        VectorUtil.mul(vector3f6, vector3f2, this.aJ);
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        VectorUtil.mul(vector3f7, vector3f4, this.bJ);
        VectorUtil.mul(vector3f5, vector3f5, this.linearJointAxis);
        vector3f6.add(vector3f7);
        vector3f6.add(vector3f5);
        float f = vector3f6.x + vector3f6.y + vector3f6.z;
        return f + 1.1920929E-7f;
    }
}

