/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.arrays.IntArray;
import org.jbox2d.pooling.arrays.Vec2Array;

public class PolygonShape
extends Shape {
    private static final boolean m_debug = false;
    public final Vec2 m_centroid = new Vec2();
    public final Vec2[] m_vertices;
    public final Vec2[] m_normals;
    public int m_count = 0;
    private final Vec2 pool1 = new Vec2();
    private final Vec2 pool2 = new Vec2();
    private final Vec2 pool3 = new Vec2();
    private final Vec2 pool4 = new Vec2();
    private Transform poolt1 = new Transform();

    public PolygonShape() {
        super(ShapeType.POLYGON);
        this.m_vertices = new Vec2[Settings.maxPolygonVertices];
        int n = 0;
        while (n < this.m_vertices.length) {
            this.m_vertices[n] = new Vec2();
            ++n;
        }
        this.m_normals = new Vec2[Settings.maxPolygonVertices];
        n = 0;
        while (n < this.m_normals.length) {
            this.m_normals[n] = new Vec2();
            ++n;
        }
        this.setRadius(Settings.polygonRadius);
        this.m_centroid.setZero();
    }

    @Override
    public final Shape clone() {
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.m_centroid.set(this.m_centroid);
        int n = 0;
        while (n < polygonShape.m_normals.length) {
            polygonShape.m_normals[n].set(this.m_normals[n]);
            polygonShape.m_vertices[n].set(this.m_vertices[n]);
            ++n;
        }
        polygonShape.setRadius(this.getRadius());
        polygonShape.m_count = this.m_count;
        return polygonShape;
    }

    public final void set(Vec2[] vec2Array, int n) {
        this.set(vec2Array, n, null, null);
    }

    public final void set(Vec2[] vec2Array, int n, Vec2Array vec2Array2, IntArray intArray) {
        int n2;
        int n3;
        int n4;
        assert (3 <= n && n <= Settings.maxPolygonVertices);
        int n5 = MathUtils.min(n, Settings.maxPolygonVertices);
        Vec2[] vec2Array3 = vec2Array2 != null ? vec2Array2.get(Settings.maxPolygonVertices) : new Vec2[Settings.maxPolygonVertices];
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            Vec2 vec2 = vec2Array[n7];
            n4 = 1;
            int n8 = 0;
            while (n8 < n6) {
                if (MathUtils.distanceSquared(vec2, vec2Array3[n8]) < 0.5f * Settings.linearSlop) {
                    n4 = 0;
                    break;
                }
                ++n8;
            }
            if (n4 != 0) {
                vec2Array3[n6++] = vec2;
            }
            ++n7;
        }
        n5 = n6;
        if (n5 < 3) {
            assert (false);
            this.setAsBox(1.0f, 1.0f);
            return;
        }
        n7 = 0;
        float f = vec2Array3[0].x;
        n4 = 1;
        while (n4 < n5) {
            float f2 = vec2Array3[n4].x;
            if (f2 > f || f2 == f && vec2Array3[n4].y < vec2Array3[n7].y) {
                n7 = n4;
                f = f2;
            }
            ++n4;
        }
        int[] nArray = intArray != null ? intArray.get(Settings.maxPolygonVertices) : new int[Settings.maxPolygonVertices];
        int n9 = 0;
        int n10 = n7;
        do {
            nArray[n9] = n10;
            n3 = 0;
            n2 = 1;
            while (n2 < n5) {
                if (n3 == n10) {
                    n3 = n2;
                } else {
                    Vec2 vec2;
                    Vec2 vec22 = this.pool1.set(vec2Array3[n3]).subLocal(vec2Array3[nArray[n9]]);
                    float f3 = Vec2.cross(vec22, vec2 = this.pool2.set(vec2Array3[n2]).subLocal(vec2Array3[nArray[n9]]));
                    if (f3 < 0.0f) {
                        n3 = n2;
                    }
                    if (f3 == 0.0f && vec2.lengthSquared() > vec22.lengthSquared()) {
                        n3 = n2;
                    }
                }
                ++n2;
            }
            ++n9;
            n10 = n3;
        } while (n3 != n7);
        this.m_count = n9;
        n3 = 0;
        while (n3 < this.m_count) {
            if (this.m_vertices[n3] == null) {
                this.m_vertices[n3] = new Vec2();
            }
            this.m_vertices[n3].set(vec2Array3[nArray[n3]]);
            ++n3;
        }
        Vec2 vec2 = this.pool1;
        n2 = 0;
        while (n2 < this.m_count) {
            int n11 = n2;
            int n12 = n2 + 1 < this.m_count ? n2 + 1 : 0;
            vec2.set(this.m_vertices[n12]).subLocal(this.m_vertices[n11]);
            assert (vec2.lengthSquared() > 1.4210855E-14f);
            Vec2.crossToOutUnsafe(vec2, 1.0f, this.m_normals[n2]);
            this.m_normals[n2].normalize();
            ++n2;
        }
        this.computeCentroidToOut(this.m_vertices, this.m_count, this.m_centroid);
    }

    public final void setAsBox(float f, float f2) {
        this.m_count = 4;
        this.m_vertices[0].set(-f, -f2);
        this.m_vertices[1].set(f, -f2);
        this.m_vertices[2].set(f, f2);
        this.m_vertices[3].set(-f, f2);
        this.m_normals[0].set(0.0f, -1.0f);
        this.m_normals[1].set(1.0f, 0.0f);
        this.m_normals[2].set(0.0f, 1.0f);
        this.m_normals[3].set(-1.0f, 0.0f);
        this.m_centroid.setZero();
    }

    public final void setAsBox(float f, float f2, Vec2 vec2, float f3) {
        this.m_count = 4;
        this.m_vertices[0].set(-f, -f2);
        this.m_vertices[1].set(f, -f2);
        this.m_vertices[2].set(f, f2);
        this.m_vertices[3].set(-f, f2);
        this.m_normals[0].set(0.0f, -1.0f);
        this.m_normals[1].set(1.0f, 0.0f);
        this.m_normals[2].set(0.0f, 1.0f);
        this.m_normals[3].set(-1.0f, 0.0f);
        this.m_centroid.set(vec2);
        Transform transform = this.poolt1;
        transform.p.set(vec2);
        transform.q.set(f3);
        int n = 0;
        while (n < this.m_count) {
            Transform.mulToOut(transform, this.m_vertices[n], this.m_vertices[n]);
            Rot.mulToOut(transform.q, this.m_normals[n], this.m_normals[n]);
            ++n;
        }
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public final boolean testPoint(Transform transform, Vec2 vec2) {
        Rot rot = transform.q;
        float f = vec2.x - transform.p.x;
        float f2 = vec2.y - transform.p.y;
        float f3 = rot.c * f + rot.s * f2;
        float f4 = -rot.s * f + rot.c * f2;
        int n = 0;
        while (n < this.m_count) {
            Vec2 vec22 = this.m_vertices[n];
            Vec2 vec23 = this.m_normals[n];
            f = f3 - vec22.x;
            f2 = f4 - vec22.y;
            float f5 = vec23.x * f + vec23.y * f2;
            if (f5 > 0.0f) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public final void computeAABB(AABB aABB, Transform transform, int n) {
        Vec2 vec2 = aABB.lowerBound;
        Vec2 vec22 = aABB.upperBound;
        Vec2 vec23 = this.m_vertices[0];
        float f = transform.q.c;
        float f2 = transform.q.s;
        float f3 = transform.p.x;
        float f4 = transform.p.y;
        vec2.x = f * vec23.x - f2 * vec23.y + f3;
        vec2.y = f2 * vec23.x + f * vec23.y + f4;
        vec22.x = vec2.x;
        vec22.y = vec2.y;
        int n2 = 1;
        while (n2 < this.m_count) {
            Vec2 vec24 = this.m_vertices[n2];
            float f5 = f * vec24.x - f2 * vec24.y + f3;
            float f6 = f2 * vec24.x + f * vec24.y + f4;
            vec2.x = vec2.x < f5 ? vec2.x : f5;
            vec2.y = vec2.y < f6 ? vec2.y : f6;
            vec22.x = vec22.x > f5 ? vec22.x : f5;
            vec22.y = vec22.y > f6 ? vec22.y : f6;
            ++n2;
        }
        vec2.x -= this.m_radius;
        vec2.y -= this.m_radius;
        vec22.x += this.m_radius;
        vec22.y += this.m_radius;
    }

    public final int getVertexCount() {
        return this.m_count;
    }

    public final Vec2 getVertex(int n) {
        assert (n >= 0 && n < this.m_count);
        return this.m_vertices[n];
    }

    @Override
    public float computeDistanceToOut(Transform transform, Vec2 vec2, int n, Vec2 vec22) {
        float f;
        float f2;
        float f3 = transform.q.c;
        float f4 = transform.q.s;
        float f5 = vec2.x - transform.p.x;
        float f6 = vec2.y - transform.p.y;
        float f7 = f3 * f5 + f4 * f6;
        float f8 = -f4 * f5 + f3 * f6;
        float f9 = -3.4028235E38f;
        float f10 = f7;
        float f11 = f8;
        int n2 = 0;
        while (n2 < this.m_count) {
            Vec2 vec23 = this.m_vertices[n2];
            Vec2 vec24 = this.m_normals[n2];
            f5 = f7 - vec23.x;
            f6 = f8 - vec23.y;
            f2 = vec24.x * f5 + vec24.y * f6;
            if (f2 > f9) {
                f9 = f2;
                f10 = vec24.x;
                f11 = vec24.y;
            }
            ++n2;
        }
        if (f9 > 0.0f) {
            float f12 = f10;
            float f13 = f11;
            f2 = f9 * f9;
            int n3 = 0;
            while (n3 < this.m_count) {
                Vec2 vec25 = this.m_vertices[n3];
                float f14 = f7 - vec25.x;
                float f15 = f8 - vec25.y;
                float f16 = f14 * f14 + f15 * f15;
                if (f2 > f16) {
                    f12 = f14;
                    f13 = f15;
                    f2 = f16;
                }
                ++n3;
            }
            f = MathUtils.sqrt(f2);
            vec22.x = f3 * f12 - f4 * f13;
            vec22.y = f4 * f12 + f3 * f13;
            vec22.normalize();
        } else {
            f = f9;
            vec22.x = f3 * f10 - f4 * f11;
            vec22.y = f4 * f10 + f3 * f11;
        }
        return f;
    }

    @Override
    public final boolean raycast(RayCastOutput rayCastOutput, RayCastInput rayCastInput, Transform transform, int n) {
        Vec2 vec2;
        float f = transform.q.c;
        float f2 = transform.q.s;
        Vec2 vec22 = transform.p;
        float f3 = rayCastInput.p1.x - vec22.x;
        float f4 = rayCastInput.p1.y - vec22.y;
        float f5 = f * f3 + f2 * f4;
        float f6 = -f2 * f3 + f * f4;
        f3 = rayCastInput.p2.x - vec22.x;
        f4 = rayCastInput.p2.y - vec22.y;
        float f7 = f * f3 + f2 * f4;
        float f8 = -f2 * f3 + f * f4;
        float f9 = f7 - f5;
        float f10 = f8 - f6;
        float f11 = 0.0f;
        float f12 = rayCastInput.maxFraction;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.m_count) {
            vec2 = this.m_normals[n3];
            Vec2 vec23 = this.m_vertices[n3];
            float f13 = vec23.x - f5;
            float f14 = vec23.y - f6;
            float f15 = vec2.x * f13 + vec2.y * f14;
            float f16 = vec2.x * f9 + vec2.y * f10;
            if (f16 == 0.0f) {
                if (f15 < 0.0f) {
                    return false;
                }
            } else if (f16 < 0.0f && f15 < f11 * f16) {
                f11 = f15 / f16;
                n2 = n3;
            } else if (f16 > 0.0f && f15 < f12 * f16) {
                f12 = f15 / f16;
            }
            if (f12 < f11) {
                return false;
            }
            ++n3;
        }
        assert (0.0f <= f11 && f11 <= rayCastInput.maxFraction);
        if (n2 >= 0) {
            rayCastOutput.fraction = f11;
            Vec2 vec24 = this.m_normals[n2];
            vec2 = rayCastOutput.normal;
            vec2.x = f * vec24.x - f2 * vec24.y;
            vec2.y = f2 * vec24.x + f * vec24.y;
            return true;
        }
        return false;
    }

    public final void computeCentroidToOut(Vec2[] vec2Array, int n, Vec2 vec2) {
        assert (n >= 3);
        vec2.set(0.0f, 0.0f);
        float f = 0.0f;
        Vec2 vec22 = this.pool1;
        vec22.setZero();
        Vec2 vec23 = this.pool2;
        Vec2 vec24 = this.pool3;
        int n2 = 0;
        while (n2 < n) {
            Vec2 vec25 = vec22;
            Vec2 vec26 = vec2Array[n2];
            Vec2 vec27 = n2 + 1 < n ? vec2Array[n2 + 1] : vec2Array[0];
            vec23.set(vec26).subLocal(vec25);
            vec24.set(vec27).subLocal(vec25);
            float f2 = Vec2.cross(vec23, vec24);
            float f3 = 0.5f * f2;
            f += f3;
            vec23.set(vec25).addLocal(vec26).addLocal(vec27).mulLocal(f3 * 0.33333334f);
            vec2.addLocal(vec23);
            ++n2;
        }
        assert (f > 1.1920929E-7f);
        vec2.mulLocal(1.0f / f);
    }

    @Override
    public void computeMass(MassData massData, float f) {
        assert (this.m_count >= 3);
        Vec2 vec2 = this.pool1;
        vec2.setZero();
        float f2 = 0.0f;
        float f3 = 0.0f;
        Vec2 vec22 = this.pool2;
        vec22.setZero();
        int n = 0;
        while (n < this.m_count) {
            vec22.addLocal(this.m_vertices[n]);
            ++n;
        }
        vec22.mulLocal(1.0f / (float)this.m_count);
        Vec2 vec23 = this.pool3;
        Vec2 vec24 = this.pool4;
        int n2 = 0;
        while (n2 < this.m_count) {
            vec23.set(this.m_vertices[n2]).subLocal(vec22);
            vec24.set(vec22).negateLocal().addLocal(n2 + 1 < this.m_count ? this.m_vertices[n2 + 1] : this.m_vertices[0]);
            float f4 = Vec2.cross(vec23, vec24);
            float f5 = 0.5f * f4;
            f2 += f5;
            vec2.x += f5 * 0.33333334f * (vec23.x + vec24.x);
            vec2.y += f5 * 0.33333334f * (vec23.y + vec24.y);
            float f6 = vec23.x;
            float f7 = vec23.y;
            float f8 = vec24.x;
            float f9 = vec24.y;
            float f10 = f6 * f6 + f8 * f6 + f8 * f8;
            float f11 = f7 * f7 + f9 * f7 + f9 * f9;
            f3 += 0.083333336f * f4 * (f10 + f11);
            ++n2;
        }
        massData.mass = f * f2;
        assert (f2 > 1.1920929E-7f);
        vec2.mulLocal(1.0f / f2);
        massData.center.set(vec2).addLocal(vec22);
        massData.I = f3 * f;
        massData.I += massData.mass * Vec2.dot(massData.center, massData.center);
    }

    public boolean validate() {
        int n = 0;
        while (n < this.m_count) {
            int n2 = n;
            int n3 = n < this.m_count - 1 ? n2 + 1 : 0;
            Vec2 vec2 = this.m_vertices[n2];
            Vec2 vec22 = this.pool1.set(this.m_vertices[n3]).subLocal(vec2);
            int n4 = 0;
            while (n4 < this.m_count) {
                Vec2 vec23;
                float f;
                if (n4 != n2 && n4 != n3 && (f = Vec2.cross(vec22, vec23 = this.pool2.set(this.m_vertices[n4]).subLocal(vec2))) < 0.0f) {
                    return false;
                }
                ++n4;
            }
            ++n;
        }
        return true;
    }

    public Vec2[] getVertices() {
        return this.m_vertices;
    }

    public Vec2[] getNormals() {
        return this.m_normals;
    }

    public Vec2 centroid(Transform transform) {
        return Transform.mul(transform, this.m_centroid);
    }

    public Vec2 centroidToOut(Transform transform, Vec2 vec2) {
        Transform.mulToOutUnsafe(transform, this.m_centroid, vec2);
        return vec2;
    }
}

