/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.WheelJointDef;
import org.jbox2d.pooling.IWorldPool;

public class WheelJoint
extends Joint {
    private float m_frequencyHz;
    private float m_dampingRatio;
    private final Vec2 m_localAnchorA = new Vec2();
    private final Vec2 m_localAnchorB = new Vec2();
    private final Vec2 m_localXAxisA = new Vec2();
    private final Vec2 m_localYAxisA = new Vec2();
    private float m_impulse;
    private float m_motorImpulse;
    private float m_springImpulse;
    private float m_maxMotorTorque;
    private float m_motorSpeed;
    private boolean m_enableMotor;
    private int m_indexA;
    private int m_indexB;
    private final Vec2 m_localCenterA = new Vec2();
    private final Vec2 m_localCenterB = new Vec2();
    private float m_invMassA;
    private float m_invMassB;
    private float m_invIA;
    private float m_invIB;
    private final Vec2 m_ax = new Vec2();
    private final Vec2 m_ay = new Vec2();
    private float m_sAx;
    private float m_sBx;
    private float m_sAy;
    private float m_sBy;
    private float m_mass;
    private float m_motorMass;
    private float m_springMass;
    private float m_bias;
    private float m_gamma;
    private final Vec2 rA = new Vec2();
    private final Vec2 rB = new Vec2();
    private final Vec2 d = new Vec2();

    protected WheelJoint(IWorldPool iWorldPool, WheelJointDef wheelJointDef) {
        super(iWorldPool, wheelJointDef);
        this.m_localAnchorA.set(wheelJointDef.localAnchorA);
        this.m_localAnchorB.set(wheelJointDef.localAnchorB);
        this.m_localXAxisA.set(wheelJointDef.localAxisA);
        Vec2.crossToOutUnsafe(1.0f, this.m_localXAxisA, this.m_localYAxisA);
        this.m_motorMass = 0.0f;
        this.m_motorImpulse = 0.0f;
        this.m_maxMotorTorque = wheelJointDef.maxMotorTorque;
        this.m_motorSpeed = wheelJointDef.motorSpeed;
        this.m_enableMotor = wheelJointDef.enableMotor;
        this.m_frequencyHz = wheelJointDef.frequencyHz;
        this.m_dampingRatio = wheelJointDef.dampingRatio;
    }

    public Vec2 getLocalAnchorA() {
        return this.m_localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.m_localAnchorB;
    }

    @Override
    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, vec2);
    }

    @Override
    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, vec2);
    }

    @Override
    public void getReactionForce(float f, Vec2 vec2) {
        Vec2 vec22 = this.pool.popVec2();
        vec22.set(this.m_ay).mulLocal(this.m_impulse);
        vec2.set(this.m_ax).mulLocal(this.m_springImpulse).addLocal(vec22).mulLocal(f);
        this.pool.pushVec2(1);
    }

    @Override
    public float getReactionTorque(float f) {
        return f * this.m_motorImpulse;
    }

    public float getJointTranslation() {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        Vec2 vec23 = this.pool.popVec2();
        body.getWorldPointToOut(this.m_localAnchorA, vec2);
        body2.getWorldPointToOut(this.m_localAnchorA, vec22);
        vec22.subLocal(vec2);
        body.getWorldVectorToOut(this.m_localXAxisA, vec23);
        float f = Vec2.dot(vec22, vec23);
        this.pool.pushVec2(3);
        return f;
    }

    public Vec2 getLocalAxisA() {
        return this.m_localXAxisA;
    }

    public float getJointSpeed() {
        return this.m_bodyA.m_angularVelocity - this.m_bodyB.m_angularVelocity;
    }

    public boolean isMotorEnabled() {
        return this.m_enableMotor;
    }

    public void enableMotor(boolean bl) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableMotor = bl;
    }

    public void setMotorSpeed(float f) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_motorSpeed = f;
    }

    public float getMotorSpeed() {
        return this.m_motorSpeed;
    }

    public float getMaxMotorTorque() {
        return this.m_maxMotorTorque;
    }

    public void setMaxMotorTorque(float f) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_maxMotorTorque = f;
    }

    public float getMotorTorque(float f) {
        return this.m_motorImpulse * f;
    }

    public void setSpringFrequencyHz(float f) {
        this.m_frequencyHz = f;
    }

    public float getSpringFrequencyHz() {
        return this.m_frequencyHz;
    }

    public void setSpringDampingRatio(float f) {
        this.m_dampingRatio = f;
    }

    public float getSpringDampingRatio() {
        return this.m_dampingRatio;
    }

    @Override
    public void initVelocityConstraints(SolverData solverData) {
        float f;
        float f2;
        this.m_indexA = this.m_bodyA.m_islandIndex;
        this.m_indexB = this.m_bodyB.m_islandIndex;
        this.m_localCenterA.set(this.m_bodyA.m_sweep.localCenter);
        this.m_localCenterB.set(this.m_bodyB.m_sweep.localCenter);
        this.m_invMassA = this.m_bodyA.m_invMass;
        this.m_invMassB = this.m_bodyB.m_invMass;
        this.m_invIA = this.m_bodyA.m_invI;
        this.m_invIB = this.m_bodyB.m_invI;
        float f3 = this.m_invMassA;
        float f4 = this.m_invMassB;
        float f5 = this.m_invIA;
        float f6 = this.m_invIB;
        Vec2 vec2 = solverData.positions[this.m_indexA].c;
        float f7 = solverData.positions[this.m_indexA].a;
        Vec2 vec22 = solverData.velocities[this.m_indexA].v;
        float f8 = solverData.velocities[this.m_indexA].w;
        Vec2 vec23 = solverData.positions[this.m_indexB].c;
        float f9 = solverData.positions[this.m_indexB].a;
        Vec2 vec24 = solverData.velocities[this.m_indexB].v;
        float f10 = solverData.velocities[this.m_indexB].w;
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Vec2 vec25 = this.pool.popVec2();
        rot.set(f7);
        rot2.set(f9);
        Rot.mulToOutUnsafe(rot, vec25.set(this.m_localAnchorA).subLocal(this.m_localCenterA), this.rA);
        Rot.mulToOutUnsafe(rot2, vec25.set(this.m_localAnchorB).subLocal(this.m_localCenterB), this.rB);
        this.d.set(vec23).addLocal(this.rB).subLocal(vec2).subLocal(this.rA);
        Rot.mulToOut(rot, this.m_localYAxisA, this.m_ay);
        this.m_sAy = Vec2.cross(vec25.set(this.d).addLocal(this.rA), this.m_ay);
        this.m_sBy = Vec2.cross(this.rB, this.m_ay);
        this.m_mass = f3 + f4 + f5 * this.m_sAy * this.m_sAy + f6 * this.m_sBy * this.m_sBy;
        if (this.m_mass > 0.0f) {
            this.m_mass = 1.0f / this.m_mass;
        }
        this.m_springMass = 0.0f;
        this.m_bias = 0.0f;
        this.m_gamma = 0.0f;
        if (this.m_frequencyHz > 0.0f) {
            Rot.mulToOut(rot, this.m_localXAxisA, this.m_ax);
            this.m_sAx = Vec2.cross(vec25.set(this.d).addLocal(this.rA), this.m_ax);
            this.m_sBx = Vec2.cross(this.rB, this.m_ax);
            float f11 = f3 + f4 + f5 * this.m_sAx * this.m_sAx + f6 * this.m_sBx * this.m_sBx;
            if (f11 > 0.0f) {
                this.m_springMass = 1.0f / f11;
                f2 = Vec2.dot(this.d, this.m_ax);
                f = (float)Math.PI * 2 * this.m_frequencyHz;
                float f12 = 2.0f * this.m_springMass * this.m_dampingRatio * f;
                float f13 = this.m_springMass * f * f;
                float f14 = solverData.step.dt;
                this.m_gamma = f14 * (f12 + f14 * f13);
                if (this.m_gamma > 0.0f) {
                    this.m_gamma = 1.0f / this.m_gamma;
                }
                this.m_bias = f2 * f14 * f13 * this.m_gamma;
                this.m_springMass = f11 + this.m_gamma;
                if (this.m_springMass > 0.0f) {
                    this.m_springMass = 1.0f / this.m_springMass;
                }
            }
        } else {
            this.m_springImpulse = 0.0f;
        }
        if (this.m_enableMotor) {
            this.m_motorMass = f5 + f6;
            if (this.m_motorMass > 0.0f) {
                this.m_motorMass = 1.0f / this.m_motorMass;
            }
        } else {
            this.m_motorMass = 0.0f;
            this.m_motorImpulse = 0.0f;
        }
        if (solverData.step.warmStarting) {
            Vec2 vec26 = this.pool.popVec2();
            this.m_impulse *= solverData.step.dtRatio;
            this.m_springImpulse *= solverData.step.dtRatio;
            this.m_motorImpulse *= solverData.step.dtRatio;
            vec26.x = this.m_impulse * this.m_ay.x + this.m_springImpulse * this.m_ax.x;
            vec26.y = this.m_impulse * this.m_ay.y + this.m_springImpulse * this.m_ax.y;
            f2 = this.m_impulse * this.m_sAy + this.m_springImpulse * this.m_sAx + this.m_motorImpulse;
            f = this.m_impulse * this.m_sBy + this.m_springImpulse * this.m_sBx + this.m_motorImpulse;
            vec22.x -= this.m_invMassA * vec26.x;
            vec22.y -= this.m_invMassA * vec26.y;
            f8 -= this.m_invIA * f2;
            vec24.x += this.m_invMassB * vec26.x;
            vec24.y += this.m_invMassB * vec26.y;
            f10 += this.m_invIB * f;
            this.pool.pushVec2(1);
        } else {
            this.m_impulse = 0.0f;
            this.m_springImpulse = 0.0f;
            this.m_motorImpulse = 0.0f;
        }
        this.pool.pushRot(2);
        this.pool.pushVec2(1);
        solverData.velocities[this.m_indexA].w = f8;
        solverData.velocities[this.m_indexB].w = f10;
    }

    @Override
    public void solveVelocityConstraints(SolverData solverData) {
        float f = this.m_invMassA;
        float f2 = this.m_invMassB;
        float f3 = this.m_invIA;
        float f4 = this.m_invIB;
        Vec2 vec2 = solverData.velocities[this.m_indexA].v;
        float f5 = solverData.velocities[this.m_indexA].w;
        Vec2 vec22 = solverData.velocities[this.m_indexB].v;
        float f6 = solverData.velocities[this.m_indexB].w;
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        float f7 = Vec2.dot(this.m_ax, vec23.set(vec22).subLocal(vec2)) + this.m_sBx * f6 - this.m_sAx * f5;
        float f8 = -this.m_springMass * (f7 + this.m_bias + this.m_gamma * this.m_springImpulse);
        this.m_springImpulse += f8;
        vec24.x = f8 * this.m_ax.x;
        vec24.y = f8 * this.m_ax.y;
        float f9 = f8 * this.m_sAx;
        float f10 = f8 * this.m_sBx;
        vec2.x -= f * vec24.x;
        vec2.y -= f * vec24.y;
        vec22.x += f2 * vec24.x;
        vec22.y += f2 * vec24.y;
        f7 = (f6 += f4 * f10) - (f5 -= f3 * f9) - this.m_motorSpeed;
        f8 = -this.m_motorMass * f7;
        f9 = this.m_motorImpulse;
        f10 = solverData.step.dt * this.m_maxMotorTorque;
        this.m_motorImpulse = MathUtils.clamp(this.m_motorImpulse + f8, -f10, f10);
        f8 = this.m_motorImpulse - f9;
        f7 = Vec2.dot(this.m_ay, vec23.set(vec22).subLocal(vec2)) + this.m_sBy * (f6 += f4 * f8) - this.m_sAy * (f5 -= f3 * f8);
        f8 = -this.m_mass * f7;
        this.m_impulse += f8;
        vec24.x = f8 * this.m_ay.x;
        vec24.y = f8 * this.m_ay.y;
        f9 = f8 * this.m_sAy;
        f10 = f8 * this.m_sBy;
        vec2.x -= f * vec24.x;
        vec2.y -= f * vec24.y;
        vec22.x += f2 * vec24.x;
        vec22.y += f2 * vec24.y;
        this.pool.pushVec2(2);
        solverData.velocities[this.m_indexA].w = f5 -= f3 * f9;
        solverData.velocities[this.m_indexB].w = f6 += f4 * f10;
    }

    @Override
    public boolean solvePositionConstraints(SolverData solverData) {
        Vec2 vec2 = solverData.positions[this.m_indexA].c;
        float f = solverData.positions[this.m_indexA].a;
        Vec2 vec22 = solverData.positions[this.m_indexB].c;
        float f2 = solverData.positions[this.m_indexB].a;
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Vec2 vec23 = this.pool.popVec2();
        rot.set(f);
        rot2.set(f2);
        Rot.mulToOut(rot, vec23.set(this.m_localAnchorA).subLocal(this.m_localCenterA), this.rA);
        Rot.mulToOut(rot2, vec23.set(this.m_localAnchorB).subLocal(this.m_localCenterB), this.rB);
        this.d.set(vec22).subLocal(vec2).addLocal(this.rB).subLocal(this.rA);
        Vec2 vec24 = this.pool.popVec2();
        Rot.mulToOut(rot, this.m_localYAxisA, vec24);
        float f3 = Vec2.cross(vec23.set(this.d).addLocal(this.rA), vec24);
        float f4 = Vec2.cross(this.rB, vec24);
        float f5 = Vec2.dot(this.d, vec24);
        float f6 = this.m_invMassA + this.m_invMassB + this.m_invIA * this.m_sAy * this.m_sAy + this.m_invIB * this.m_sBy * this.m_sBy;
        float f7 = f6 != 0.0f ? -f5 / f6 : 0.0f;
        Vec2 vec25 = this.pool.popVec2();
        vec25.x = f7 * vec24.x;
        vec25.y = f7 * vec24.y;
        float f8 = f7 * f3;
        float f9 = f7 * f4;
        vec2.x -= this.m_invMassA * vec25.x;
        vec2.y -= this.m_invMassA * vec25.y;
        vec22.x += this.m_invMassB * vec25.x;
        vec22.y += this.m_invMassB * vec25.y;
        this.pool.pushVec2(3);
        this.pool.pushRot(2);
        solverData.positions[this.m_indexA].a = f -= this.m_invIA * f8;
        solverData.positions[this.m_indexB].a = f2 += this.m_invIB * f9;
        return MathUtils.abs(f5) <= Settings.linearSlop;
    }
}

