/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.dispatch.CollisionWorld;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.StridingMeshInterface;
import com.bulletphysics.collision.shapes.TriangleCallback;
import com.bulletphysics.extras.gimpact.BoxCollision;
import com.bulletphysics.extras.gimpact.GImpactMeshShapePart;
import com.bulletphysics.extras.gimpact.GImpactShapeInterface;
import com.bulletphysics.extras.gimpact.PrimitiveManagerBase;
import com.bulletphysics.extras.gimpact.ShapeType;
import com.bulletphysics.extras.gimpact.TetrahedronShapeEx;
import com.bulletphysics.extras.gimpact.TriangleShapeEx;
import com.bulletphysics.linearmath.Transform;
import java.util.ArrayList;
import javax.vecmath.Vector3f;

public class GImpactMeshShape
extends GImpactShapeInterface {
    protected ArrayList<GImpactMeshShapePart> mesh_parts = new ArrayList();

    public GImpactMeshShape(StridingMeshInterface stridingMeshInterface) {
        this.buildMeshParts(stridingMeshInterface);
    }

    public int getMeshPartCount() {
        return this.mesh_parts.size();
    }

    public GImpactMeshShapePart getMeshPart(int n) {
        return this.mesh_parts.get(n);
    }

    @Override
    public void setLocalScaling(Vector3f vector3f) {
        this.localScaling.set(vector3f);
        int n = this.mesh_parts.size();
        while (n-- != 0) {
            GImpactMeshShapePart gImpactMeshShapePart = this.mesh_parts.get(n);
            gImpactMeshShapePart.setLocalScaling(vector3f);
        }
        this.needs_update = true;
    }

    @Override
    public void setMargin(float f) {
        this.collisionMargin = f;
        int n = this.mesh_parts.size();
        while (n-- != 0) {
            GImpactMeshShapePart gImpactMeshShapePart = this.mesh_parts.get(n);
            gImpactMeshShapePart.setMargin(f);
        }
        this.needs_update = true;
    }

    @Override
    public void postUpdate() {
        int n = this.mesh_parts.size();
        while (n-- != 0) {
            GImpactMeshShapePart gImpactMeshShapePart = this.mesh_parts.get(n);
            gImpactMeshShapePart.postUpdate();
        }
        this.needs_update = true;
    }

    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
        vector3f.set(0.0f, 0.0f, 0.0f);
        int n = this.getMeshPartCount();
        float f2 = f / (float)n;
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        while (n-- != 0) {
            this.getMeshPart(n).calculateLocalInertia(f2, vector3f2);
            vector3f.add(vector3f2);
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2});
    }

    @Override
    PrimitiveManagerBase getPrimitiveManager() {
        assert (false);
        return null;
    }

    @Override
    public int getNumChildShapes() {
        assert (false);
        return 0;
    }

    @Override
    public boolean childrenHasTransform() {
        assert (false);
        return false;
    }

    @Override
    public boolean needsRetrieveTriangles() {
        assert (false);
        return false;
    }

    @Override
    public boolean needsRetrieveTetrahedrons() {
        assert (false);
        return false;
    }

    @Override
    public void getBulletTriangle(int n, TriangleShapeEx triangleShapeEx) {
        assert (false);
    }

    @Override
    void getBulletTetrahedron(int n, TetrahedronShapeEx tetrahedronShapeEx) {
        assert (false);
    }

    @Override
    public void lockChildShapes() {
        assert (false);
    }

    @Override
    public void unlockChildShapes() {
        assert (false);
    }

    @Override
    public void getChildAabb(int n, Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        assert (false);
    }

    @Override
    public CollisionShape getChildShape(int n) {
        assert (false);
        return null;
    }

    @Override
    public Transform getChildTransform(int n) {
        assert (false);
        return null;
    }

    @Override
    public void setChildTransform(int n, Transform transform) {
        assert (false);
    }

    @Override
    ShapeType getGImpactShapeType() {
        return ShapeType.TRIMESH_SHAPE;
    }

    @Override
    public String getName() {
        return "GImpactMesh";
    }

    @Override
    public void rayTest(Vector3f vector3f, Vector3f vector3f2, CollisionWorld.RayResultCallback rayResultCallback) {
    }

    @Override
    public void processAllTriangles(TriangleCallback triangleCallback, Vector3f vector3f, Vector3f vector3f2) {
        int n = this.mesh_parts.size();
        while (n-- != 0) {
            this.mesh_parts.get(n).processAllTriangles(triangleCallback, vector3f, vector3f2);
        }
    }

    protected void buildMeshParts(StridingMeshInterface stridingMeshInterface) {
        int n = 0;
        while (n < stridingMeshInterface.getNumSubParts()) {
            GImpactMeshShapePart gImpactMeshShapePart = new GImpactMeshShapePart(stridingMeshInterface, n);
            this.mesh_parts.add(gImpactMeshShapePart);
            ++n;
        }
    }

    @Override
    protected void calcLocalAABB() {
        BoxCollision.AABB aABB = (BoxCollision.AABB)Pools.AABBS.get();
        this.localAABB.invalidate();
        int n = this.mesh_parts.size();
        while (n-- != 0) {
            this.mesh_parts.get(n).updateBound();
            this.localAABB.merge(this.mesh_parts.get(n).getLocalBox(aABB));
        }
    }
}

