/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.dispatch;

import com.bulletphysics.BulletGlobals;
import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.broadphase.BroadphaseProxy;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.broadphase.DispatcherInfo;
import com.bulletphysics.collision.broadphase.OverlappingPairCache;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.narrowphase.ConvexCast;
import com.bulletphysics.collision.narrowphase.GjkConvexCast;
import com.bulletphysics.collision.narrowphase.SubsimplexConvexCast;
import com.bulletphysics.collision.narrowphase.TriangleConvexcastCallback;
import com.bulletphysics.collision.narrowphase.TriangleRaycastCallback;
import com.bulletphysics.collision.narrowphase.VoronoiSimplexSolver;
import com.bulletphysics.collision.shapes.BvhTriangleMeshShape;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.CompoundShape;
import com.bulletphysics.collision.shapes.ConcaveShape;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.collision.shapes.SphereShape;
import com.bulletphysics.linearmath.AabbUtil2;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.TransformUtil;
import com.bulletphysics.linearmath.VectorUtil;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class CollisionWorld {
    protected List<CollisionObject> collisionObjects = new ArrayList<CollisionObject>();
    protected Dispatcher dispatcher1;
    protected DispatcherInfo dispatchInfo = new DispatcherInfo();
    protected BroadphaseInterface broadphasePairCache;
    private static boolean updateAabbs_reportMe = true;

    public CollisionWorld(Dispatcher dispatcher, BroadphaseInterface broadphaseInterface, CollisionConfiguration collisionConfiguration) {
        this.dispatcher1 = dispatcher;
        this.broadphasePairCache = broadphaseInterface;
    }

    public void destroy() {
        for (CollisionObject collisionObject : this.collisionObjects) {
            BroadphaseProxy broadphaseProxy = collisionObject.getBroadphaseHandle();
            if (broadphaseProxy == null) continue;
            this.getBroadphase().getOverlappingPairCache().cleanProxyFromPairs(broadphaseProxy, this.dispatcher1);
            this.getBroadphase().destroyProxy(broadphaseProxy, this.dispatcher1);
        }
    }

    public void addCollisionObject(CollisionObject collisionObject) {
        this.addCollisionObject(collisionObject, (short)1, (short)-1);
    }

    public void addCollisionObject(CollisionObject collisionObject, short s, short s2) {
        assert (!this.collisionObjects.contains(collisionObject));
        this.collisionObjects.add(collisionObject);
        Transform transform = collisionObject.getWorldTransform((Transform)Pools.TRANSFORMS.get());
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        collisionObject.getCollisionShape().getAabb(transform, vector3f, vector3f2);
        BroadphaseNativeType broadphaseNativeType = collisionObject.getCollisionShape().getShapeType();
        collisionObject.setBroadphaseHandle(this.getBroadphase().createProxy(vector3f, vector3f2, broadphaseNativeType, collisionObject, s, s2, this.dispatcher1, null));
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
    }

    public void performDiscreteCollisionDetection() {
        this.updateAabbs();
        this.broadphasePairCache.calculateOverlappingPairs(this.dispatcher1);
        Dispatcher dispatcher = this.getDispatcher();
        if (dispatcher != null) {
            dispatcher.dispatchAllCollisionPairs(this.broadphasePairCache.getOverlappingPairCache(), this.dispatchInfo, this.dispatcher1);
        }
    }

    public void removeCollisionObject(CollisionObject collisionObject) {
        BroadphaseProxy broadphaseProxy = collisionObject.getBroadphaseHandle();
        if (broadphaseProxy != null) {
            this.getBroadphase().getOverlappingPairCache().cleanProxyFromPairs(broadphaseProxy, this.dispatcher1);
            this.getBroadphase().destroyProxy(broadphaseProxy, this.dispatcher1);
            collisionObject.setBroadphaseHandle(null);
        }
        this.collisionObjects.remove(collisionObject);
    }

    public void setBroadphase(BroadphaseInterface broadphaseInterface) {
        this.broadphasePairCache = broadphaseInterface;
    }

    public BroadphaseInterface getBroadphase() {
        return this.broadphasePairCache;
    }

    public OverlappingPairCache getPairCache() {
        return this.broadphasePairCache.getOverlappingPairCache();
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher1;
    }

    public DispatcherInfo getDispatchInfo() {
        return this.dispatchInfo;
    }

    public void updateSingleAabb(CollisionObject collisionObject) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        collisionObject.getCollisionShape().getAabb(collisionObject.getWorldTransform(transform), vector3f, vector3f2);
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.set(BulletGlobals.getContactBreakingThreshold(), BulletGlobals.getContactBreakingThreshold(), BulletGlobals.getContactBreakingThreshold());
        vector3f.sub(vector3f4);
        vector3f2.add(vector3f4);
        BroadphaseInterface broadphaseInterface = this.broadphasePairCache;
        vector3f3.sub(vector3f2, vector3f);
        if (collisionObject.isStaticObject() || vector3f3.lengthSquared() < 1.0E12f) {
            broadphaseInterface.setAabb(collisionObject.getBroadphaseHandle(), vector3f, vector3f2, this.dispatcher1);
        } else {
            collisionObject.setActivationState(5);
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f, vector3f2, vector3f3});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
    }

    public void updateAabbs() {
        for (CollisionObject collisionObject : this.collisionObjects) {
            if (!collisionObject.isActive()) continue;
            this.updateSingleAabb(collisionObject);
        }
    }

    public int getNumCollisionObjects() {
        return this.collisionObjects.size();
    }

    public static void rayTestSingle(Transform transform, Transform transform2, CollisionObject collisionObject, CollisionShape collisionShape, Transform transform3, RayResultCallback rayResultCallback) {
        SphereShape sphereShape = new SphereShape(0.0f);
        sphereShape.setMargin(0.0f);
        SphereShape sphereShape2 = sphereShape;
        if (collisionShape.isConvex()) {
            ConvexCast.CastResult castResult = new ConvexCast.CastResult();
            castResult.fraction = rayResultCallback.closestHitFraction;
            ConvexShape convexShape = (ConvexShape)collisionShape;
            VoronoiSimplexSolver voronoiSimplexSolver = new VoronoiSimplexSolver();
            SubsimplexConvexCast subsimplexConvexCast = new SubsimplexConvexCast(sphereShape2, convexShape, voronoiSimplexSolver);
            if (subsimplexConvexCast.calcTimeOfImpact(transform, transform2, transform3, transform3, castResult) && castResult.normal.lengthSquared() > 1.0E-4f && castResult.fraction < rayResultCallback.closestHitFraction) {
                transform.basis.transform(castResult.normal);
                castResult.normal.normalize();
                LocalRayResult localRayResult = new LocalRayResult(collisionObject, null, castResult.normal, castResult.fraction);
                boolean bl = true;
                rayResultCallback.addSingleResult(localRayResult, bl);
            }
        } else if (collisionShape.isConcave()) {
            if (collisionShape.getShapeType() == BroadphaseNativeType.TRIANGLE_MESH_SHAPE_PROXYTYPE) {
                BvhTriangleMeshShape bvhTriangleMeshShape = (BvhTriangleMeshShape)collisionShape;
                Transform transform4 = (Transform)Pools.TRANSFORMS.get();
                transform4.inverse(transform3);
                Vector3f vector3f = (Vector3f)Pools.VECTORS.get((Object)transform.origin);
                transform4.transform(vector3f);
                Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get((Object)transform2.origin);
                transform4.transform(vector3f2);
                BridgeTriangleRaycastCallback bridgeTriangleRaycastCallback = new BridgeTriangleRaycastCallback(vector3f, vector3f2, rayResultCallback, collisionObject, bvhTriangleMeshShape);
                bridgeTriangleRaycastCallback.hitFraction = rayResultCallback.closestHitFraction;
                bvhTriangleMeshShape.performRaycast(bridgeTriangleRaycastCallback, vector3f, vector3f2);
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2});
                Pools.TRANSFORMS.release((Object[])new Transform[]{transform4});
            } else {
                ConcaveShape concaveShape = (ConcaveShape)collisionShape;
                Transform transform5 = (Transform)Pools.TRANSFORMS.get();
                transform5.inverse(transform3);
                Vector3f vector3f = (Vector3f)Pools.VECTORS.get((Object)transform.origin);
                transform5.transform(vector3f);
                Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get((Object)transform2.origin);
                transform5.transform(vector3f3);
                BridgeTriangleRaycastCallback bridgeTriangleRaycastCallback = new BridgeTriangleRaycastCallback(vector3f, vector3f3, rayResultCallback, collisionObject, concaveShape);
                bridgeTriangleRaycastCallback.hitFraction = rayResultCallback.closestHitFraction;
                Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
                VectorUtil.setMin(vector3f4, vector3f3);
                Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
                VectorUtil.setMax(vector3f5, vector3f3);
                concaveShape.processAllTriangles(bridgeTriangleRaycastCallback, vector3f4, vector3f5);
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f3, vector3f4, vector3f5});
                Pools.TRANSFORMS.release((Object[])new Transform[]{transform5});
            }
        } else if (collisionShape.isCompound()) {
            CompoundShape compoundShape = (CompoundShape)collisionShape;
            int n = 0;
            Transform transform6 = (Transform)Pools.TRANSFORMS.get();
            n = 0;
            while (n < compoundShape.getNumChildShapes()) {
                compoundShape.getChildTransform(n, transform6);
                CollisionShape collisionShape2 = compoundShape.getChildShape(n);
                Transform transform7 = (Transform)Pools.TRANSFORMS.get((Object)transform3);
                transform7.mul(transform6);
                CollisionShape collisionShape3 = collisionObject.getCollisionShape();
                collisionObject.internalSetTemporaryCollisionShape(collisionShape2);
                CollisionWorld.rayTestSingle(transform, transform2, collisionObject, collisionShape2, transform7, rayResultCallback);
                collisionObject.internalSetTemporaryCollisionShape(collisionShape3);
                Pools.TRANSFORMS.release((Object[])new Transform[]{transform7});
                ++n;
            }
            Pools.TRANSFORMS.release((Object[])new Transform[]{transform6});
        }
    }

    public static void objectQuerySingle(ConvexShape convexShape, Transform transform, Transform transform2, CollisionObject collisionObject, CollisionShape collisionShape, Transform transform3, ConvexResultCallback convexResultCallback, float f) {
        if (collisionShape.isConvex()) {
            ConvexCast.CastResult castResult = new ConvexCast.CastResult();
            castResult.allowedPenetration = f;
            castResult.fraction = 1.0f;
            ConvexShape convexShape2 = (ConvexShape)collisionShape;
            VoronoiSimplexSolver voronoiSimplexSolver = new VoronoiSimplexSolver();
            GjkConvexCast gjkConvexCast = new GjkConvexCast(convexShape, convexShape2, voronoiSimplexSolver);
            GjkConvexCast gjkConvexCast2 = gjkConvexCast;
            if (gjkConvexCast2.calcTimeOfImpact(transform, transform2, transform3, transform3, castResult) && castResult.normal.lengthSquared() > 1.0E-4f && castResult.fraction < convexResultCallback.closestHitFraction) {
                castResult.normal.normalize();
                LocalConvexResult localConvexResult = new LocalConvexResult(collisionObject, null, castResult.normal, castResult.hitPoint, castResult.fraction);
                boolean bl = true;
                convexResultCallback.addSingleResult(localConvexResult, bl);
            }
        } else if (collisionShape.isConcave()) {
            if (collisionShape.getShapeType() == BroadphaseNativeType.TRIANGLE_MESH_SHAPE_PROXYTYPE) {
                BvhTriangleMeshShape bvhTriangleMeshShape = (BvhTriangleMeshShape)collisionShape;
                Transform transform4 = (Transform)Pools.TRANSFORMS.get();
                transform4.inverse(transform3);
                Vector3f vector3f = (Vector3f)Pools.VECTORS.get((Object)transform.origin);
                transform4.transform(vector3f);
                Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get((Object)transform2.origin);
                transform4.transform(vector3f2);
                Transform transform5 = (Transform)Pools.TRANSFORMS.get();
                Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get();
                matrix3f.mul(transform4.basis, transform2.basis);
                transform5.set(matrix3f);
                BridgeTriangleConvexcastCallback bridgeTriangleConvexcastCallback = new BridgeTriangleConvexcastCallback(convexShape, transform, transform2, convexResultCallback, collisionObject, bvhTriangleMeshShape, transform3);
                bridgeTriangleConvexcastCallback.hitFraction = convexResultCallback.closestHitFraction;
                bridgeTriangleConvexcastCallback.normalInWorldSpace = true;
                Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
                Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
                convexShape.getAabb(transform5, vector3f3, vector3f4);
                bvhTriangleMeshShape.performConvexcast(bridgeTriangleConvexcastCallback, vector3f, vector3f2, vector3f3, vector3f4);
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f3, vector3f4});
                Pools.TRANSFORMS.release((Object[])new Transform[]{transform5, transform4});
                Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f});
            } else {
                ConcaveShape concaveShape = (ConcaveShape)collisionShape;
                Transform transform6 = (Transform)Pools.TRANSFORMS.get();
                transform6.inverse(transform3);
                Vector3f vector3f = (Vector3f)Pools.VECTORS.get((Object)transform.origin);
                transform6.transform(vector3f);
                Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get((Object)transform2.origin);
                transform6.transform(vector3f5);
                Transform transform7 = (Transform)Pools.TRANSFORMS.get();
                Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get();
                matrix3f.mul(transform6.basis, transform2.basis);
                transform7.set(matrix3f);
                BridgeTriangleConvexcastCallback bridgeTriangleConvexcastCallback = new BridgeTriangleConvexcastCallback(convexShape, transform, transform2, convexResultCallback, collisionObject, concaveShape, transform3);
                bridgeTriangleConvexcastCallback.hitFraction = convexResultCallback.closestHitFraction;
                bridgeTriangleConvexcastCallback.normalInWorldSpace = false;
                Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
                Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
                convexShape.getAabb(transform7, vector3f6, vector3f7);
                Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
                VectorUtil.setMin(vector3f8, vector3f5);
                Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
                VectorUtil.setMax(vector3f9, vector3f5);
                vector3f8.add(vector3f6);
                vector3f9.add(vector3f7);
                concaveShape.processAllTriangles(bridgeTriangleConvexcastCallback, vector3f8, vector3f9);
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f5, vector3f9, vector3f8, vector3f6, vector3f7});
                Pools.TRANSFORMS.release((Object[])new Transform[]{transform7, transform6});
                Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f});
            }
        } else if (collisionShape.isCompound()) {
            CompoundShape compoundShape = (CompoundShape)collisionShape;
            int n = 0;
            while (n < compoundShape.getNumChildShapes()) {
                Transform transform8 = compoundShape.getChildTransform(n, (Transform)Pools.TRANSFORMS.get());
                CollisionShape collisionShape2 = compoundShape.getChildShape(n);
                Transform transform9 = (Transform)Pools.TRANSFORMS.get();
                transform9.mul(transform3, transform8);
                CollisionShape collisionShape3 = collisionObject.getCollisionShape();
                collisionObject.internalSetTemporaryCollisionShape(collisionShape2);
                CollisionWorld.objectQuerySingle(convexShape, transform, transform2, collisionObject, collisionShape2, transform9, convexResultCallback, f);
                collisionObject.internalSetTemporaryCollisionShape(collisionShape3);
                Pools.TRANSFORMS.release((Object[])new Transform[]{transform8, transform9});
                ++n;
            }
        }
    }

    public void rayTest(Vector3f vector3f, Vector3f vector3f2, RayResultCallback rayResultCallback) {
        Transform transform = (Transform)Pools.TRANSFORMS.get();
        Transform transform2 = (Transform)Pools.TRANSFORMS.get();
        transform.setIdentity();
        transform.origin.set(vector3f);
        transform2.setIdentity();
        transform2.origin.set(vector3f2);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        float[] fArray = new float[1];
        Transform transform3 = (Transform)Pools.TRANSFORMS.get();
        for (CollisionObject collisionObject : this.collisionObjects) {
            if (rayResultCallback.closestHitFraction == 0.0f) break;
            if (!rayResultCallback.needsCollision(collisionObject.getBroadphaseHandle())) continue;
            collisionObject.getCollisionShape().getAabb(collisionObject.getWorldTransform(transform3), vector3f3, vector3f4);
            fArray[0] = rayResultCallback.closestHitFraction;
            Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
            if (AabbUtil2.rayAabb(vector3f, vector3f2, vector3f3, vector3f4, fArray, vector3f5)) {
                CollisionWorld.rayTestSingle(transform, transform2, collisionObject, collisionObject.getCollisionShape(), collisionObject.getWorldTransform(transform3), rayResultCallback);
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f5});
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f4});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform, transform2, transform3});
    }

    public void convexSweepTest(ConvexShape convexShape, Transform transform, Transform transform2, ConvexResultCallback convexResultCallback) {
        Transform transform3 = (Transform)Pools.TRANSFORMS.get();
        Transform transform4 = (Transform)Pools.TRANSFORMS.get();
        transform3.set(transform);
        transform4.set(transform2);
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Object object = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        TransformUtil.calculateVelocity(transform3, transform4, 1.0f, (Vector3f)object, vector3f3);
        Object object2 = (Transform)Pools.TRANSFORMS.get();
        ((Transform)object2).setIdentity();
        Object object3 = transform3.getRotation((Quat4f)Pools.QUATS.get());
        ((Transform)object2).setRotation((Quat4f)object3);
        convexShape.calculateTemporalAabb((Transform)object2, (Vector3f)object, vector3f3, 1.0f, vector3f, vector3f2);
        Pools.VECTORS.release((Object[])new Vector3f[]{object, vector3f3});
        Pools.QUATS.release((Object[])new Quat4f[]{object3});
        Pools.TRANSFORMS.release((Object[])new Transform[]{object2});
        object = (Transform)Pools.TRANSFORMS.get();
        vector3f3 = (Vector3f)Pools.VECTORS.get();
        object2 = (Vector3f)Pools.VECTORS.get();
        object3 = new float[1];
        for (CollisionObject collisionObject : this.collisionObjects) {
            if (!convexResultCallback.needsCollision(collisionObject.getBroadphaseHandle())) continue;
            collisionObject.getWorldTransform((Transform)object);
            collisionObject.getCollisionShape().getAabb((Transform)object, vector3f3, (Vector3f)object2);
            AabbUtil2.aabbExpand(vector3f3, (Vector3f)object2, vector3f, vector3f2);
            object3[0] = 1.0f;
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
            if (AabbUtil2.rayAabb(transform.origin, transform2.origin, vector3f3, (Vector3f)object2, (float[])object3, vector3f4)) {
                CollisionWorld.objectQuerySingle(convexShape, transform3, transform4, collisionObject, collisionObject.getCollisionShape(), (Transform)object, convexResultCallback, this.getDispatchInfo().allowedCcdPenetration);
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4});
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f3, object2});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform3, transform4, object});
    }

    public List<CollisionObject> getCollisionObjectArray() {
        return this.collisionObjects;
    }

    private static class BridgeTriangleConvexcastCallback
    extends TriangleConvexcastCallback {
        public ConvexResultCallback resultCallback;
        public CollisionObject collisionObject;
        public boolean normalInWorldSpace;

        public BridgeTriangleConvexcastCallback(ConvexShape convexShape, Transform transform, Transform transform2, ConvexResultCallback convexResultCallback, CollisionObject collisionObject, ConcaveShape concaveShape, Transform transform3) {
            super(convexShape, transform, transform2, transform3, concaveShape.getMargin());
            this.resultCallback = convexResultCallback;
            this.collisionObject = collisionObject;
        }

        @Override
        public float reportHit(Vector3f vector3f, Vector3f vector3f2, float f, int n, int n2) {
            LocalShapeInfo localShapeInfo = new LocalShapeInfo();
            localShapeInfo.shapePart = n;
            localShapeInfo.triangleIndex = n2;
            if (f <= this.resultCallback.closestHitFraction) {
                LocalConvexResult localConvexResult = new LocalConvexResult(this.collisionObject, localShapeInfo, vector3f, vector3f2, f);
                return this.resultCallback.addSingleResult(localConvexResult, this.normalInWorldSpace);
            }
            return f;
        }
    }

    private static class BridgeTriangleRaycastCallback
    extends TriangleRaycastCallback {
        public RayResultCallback resultCallback;
        public CollisionObject collisionObject;

        public BridgeTriangleRaycastCallback(Vector3f vector3f, Vector3f vector3f2, RayResultCallback rayResultCallback, CollisionObject collisionObject, ConcaveShape concaveShape) {
            super(vector3f, vector3f2);
            this.resultCallback = rayResultCallback;
            this.collisionObject = collisionObject;
        }

        @Override
        public float reportHit(Vector3f vector3f, float f, int n, int n2) {
            LocalShapeInfo localShapeInfo = new LocalShapeInfo();
            localShapeInfo.shapePart = n;
            localShapeInfo.triangleIndex = n2;
            LocalRayResult localRayResult = new LocalRayResult(this.collisionObject, localShapeInfo, vector3f, f);
            boolean bl = false;
            return this.resultCallback.addSingleResult(localRayResult, bl);
        }
    }

    public static class ClosestConvexResultCallback
    extends ConvexResultCallback {
        public final Vector3f convexFromWorld = new Vector3f();
        public final Vector3f convexToWorld = new Vector3f();
        public final Vector3f hitNormalWorld = new Vector3f();
        public final Vector3f hitPointWorld = new Vector3f();
        public CollisionObject hitCollisionObject;

        public ClosestConvexResultCallback(Vector3f vector3f, Vector3f vector3f2) {
            this.convexFromWorld.set(vector3f);
            this.convexToWorld.set(vector3f2);
            this.hitCollisionObject = null;
        }

        @Override
        public float addSingleResult(LocalConvexResult localConvexResult, boolean bl) {
            assert (localConvexResult.hitFraction <= this.closestHitFraction);
            this.closestHitFraction = localConvexResult.hitFraction;
            this.hitCollisionObject = localConvexResult.hitCollisionObject;
            if (bl) {
                this.hitNormalWorld.set(localConvexResult.hitNormalLocal);
                if (this.hitNormalWorld.length() > 2.0f) {
                    System.out.println("CollisionWorld.addSingleResult world " + String.valueOf(this.hitNormalWorld));
                }
            } else {
                this.hitNormalWorld.set(localConvexResult.hitNormalLocal);
                Transform transform = this.hitCollisionObject.getWorldTransform((Transform)Pools.TRANSFORMS.get());
                transform.basis.transform(this.hitNormalWorld);
                Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
                if (this.hitNormalWorld.length() > 2.0f) {
                    System.out.println("CollisionWorld.addSingleResult world " + String.valueOf(this.hitNormalWorld));
                }
            }
            this.hitPointWorld.set(localConvexResult.hitPointLocal);
            return localConvexResult.hitFraction;
        }
    }

    public static class ClosestRayResultCallback
    extends RayResultCallback {
        public final Vector3f rayFromWorld = new Vector3f();
        public final Vector3f rayToWorld = new Vector3f();
        public final Vector3f hitNormalWorld = new Vector3f();
        public final Vector3f hitPointWorld = new Vector3f();

        public ClosestRayResultCallback(Vector3f vector3f, Vector3f vector3f2) {
            this.rayFromWorld.set(vector3f);
            this.rayToWorld.set(vector3f2);
        }

        @Override
        public float addSingleResult(LocalRayResult localRayResult, boolean bl) {
            assert (localRayResult.hitFraction <= this.closestHitFraction);
            this.closestHitFraction = localRayResult.hitFraction;
            this.collisionObject = localRayResult.collisionObject;
            if (bl) {
                this.hitNormalWorld.set(localRayResult.hitNormalLocal);
            } else {
                this.hitNormalWorld.set(localRayResult.hitNormalLocal);
                Transform transform = this.collisionObject.getWorldTransform((Transform)Pools.TRANSFORMS.get());
                transform.basis.transform(this.hitNormalWorld);
                Pools.TRANSFORMS.release((Object[])new Transform[]{transform});
            }
            VectorUtil.setInterpolate3(this.hitPointWorld, this.rayFromWorld, this.rayToWorld, localRayResult.hitFraction);
            return localRayResult.hitFraction;
        }
    }

    public static abstract class ConvexResultCallback {
        public float closestHitFraction = 1.0f;
        public short collisionFilterGroup = 1;
        public short collisionFilterMask = (short)-1;

        public boolean hasHit() {
            return this.closestHitFraction < 1.0f;
        }

        public boolean needsCollision(BroadphaseProxy broadphaseProxy) {
            boolean bl = (broadphaseProxy.collisionFilterGroup & this.collisionFilterMask & 0xFFFF) != 0;
            bl = bl && (this.collisionFilterGroup & broadphaseProxy.collisionFilterMask & 0xFFFF) != 0;
            return bl;
        }

        public abstract float addSingleResult(LocalConvexResult var1, boolean var2);
    }

    public static class LocalConvexResult {
        public CollisionObject hitCollisionObject;
        public LocalShapeInfo localShapeInfo;
        public final Vector3f hitNormalLocal = new Vector3f();
        public final Vector3f hitPointLocal = new Vector3f();
        public float hitFraction;

        public LocalConvexResult(CollisionObject collisionObject, LocalShapeInfo localShapeInfo, Vector3f vector3f, Vector3f vector3f2, float f) {
            this.hitCollisionObject = collisionObject;
            this.localShapeInfo = localShapeInfo;
            this.hitNormalLocal.set(vector3f);
            this.hitPointLocal.set(vector3f2);
            this.hitFraction = f;
        }
    }

    public static class LocalRayResult {
        public CollisionObject collisionObject;
        public LocalShapeInfo localShapeInfo;
        public final Vector3f hitNormalLocal = new Vector3f();
        public float hitFraction;

        public LocalRayResult(CollisionObject collisionObject, LocalShapeInfo localShapeInfo, Vector3f vector3f, float f) {
            this.collisionObject = collisionObject;
            this.localShapeInfo = localShapeInfo;
            this.hitNormalLocal.set(vector3f);
            this.hitFraction = f;
        }
    }

    public static class LocalShapeInfo {
        public int shapePart;
        public int triangleIndex;
    }

    public static abstract class RayResultCallback {
        public float closestHitFraction = 1.0f;
        public CollisionObject collisionObject;
        public short collisionFilterGroup = 1;
        public short collisionFilterMask = (short)-1;

        public boolean hasHit() {
            return this.collisionObject != null;
        }

        public boolean needsCollision(BroadphaseProxy broadphaseProxy) {
            boolean bl = (broadphaseProxy.collisionFilterGroup & this.collisionFilterMask & 0xFFFF) != 0;
            bl = bl && (this.collisionFilterGroup & broadphaseProxy.collisionFilterMask & 0xFFFF) != 0;
            return bl;
        }

        public abstract float addSingleResult(LocalRayResult var1, boolean var2);
    }
}

