/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.dispatch;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.broadphase.CollisionAlgorithm;
import com.bulletphysics.collision.broadphase.CollisionAlgorithmConstructionInfo;
import com.bulletphysics.collision.dispatch.CollisionAlgorithmCreateFunc;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.ManifoldResult;
import com.bulletphysics.collision.narrowphase.ConvexCast;
import com.bulletphysics.collision.narrowphase.ConvexPenetrationDepthSolver;
import com.bulletphysics.collision.narrowphase.DiscreteCollisionDetectorInterface;
import com.bulletphysics.collision.narrowphase.GjkConvexCast;
import com.bulletphysics.collision.narrowphase.GjkPairDetector;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.collision.narrowphase.SimplexSolverInterface;
import com.bulletphysics.collision.narrowphase.VoronoiSimplexSolver;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.collision.shapes.SphereShape;
import com.bulletphysics.linearmath.Transform;
import java.util.ArrayList;
import javax.vecmath.Vector3f;

public class ConvexConvexAlgorithm
extends CollisionAlgorithm {
    private final GjkPairDetector gjkPairDetector = new GjkPairDetector();
    public boolean ownManifold;
    public PersistentManifold manifoldPtr;
    public boolean lowLevelOfDetail;

    public void init(PersistentManifold persistentManifold, CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo, CollisionObject collisionObject, CollisionObject collisionObject2, SimplexSolverInterface simplexSolverInterface, ConvexPenetrationDepthSolver convexPenetrationDepthSolver) {
        super.init(collisionAlgorithmConstructionInfo);
        this.gjkPairDetector.init(null, null, simplexSolverInterface, convexPenetrationDepthSolver);
        this.manifoldPtr = persistentManifold;
        this.ownManifold = false;
        this.lowLevelOfDetail = false;
    }

    @Override
    public void destroy() {
        if (this.ownManifold) {
            if (this.manifoldPtr != null) {
                this.dispatcher.releaseManifold(this.manifoldPtr);
            }
            this.manifoldPtr = null;
        }
    }

    public void setLowLevelOfDetail(boolean bl) {
        this.lowLevelOfDetail = bl;
    }

    @Override
    public void processCollision(CollisionObject collisionObject, CollisionObject collisionObject2, ManifoldResult manifoldResult) {
        if (this.manifoldPtr == null) {
            this.manifoldPtr = this.dispatcher.getNewManifold(collisionObject, collisionObject2);
            this.ownManifold = true;
        }
        manifoldResult.setPersistentManifold(this.manifoldPtr);
        ConvexShape convexShape = (ConvexShape)collisionObject.getCollisionShape();
        ConvexShape convexShape2 = (ConvexShape)collisionObject2.getCollisionShape();
        DiscreteCollisionDetectorInterface.ClosestPointInput closestPointInput = (DiscreteCollisionDetectorInterface.ClosestPointInput)Pools.CLOSEST_POINTS.get();
        closestPointInput.init();
        this.gjkPairDetector.setMinkowskiA(convexShape);
        this.gjkPairDetector.setMinkowskiB(convexShape2);
        closestPointInput.maximumDistanceSquared = convexShape.getMargin() + convexShape2.getMargin() + this.manifoldPtr.getContactBreakingThreshold();
        closestPointInput.maximumDistanceSquared *= closestPointInput.maximumDistanceSquared;
        collisionObject.getWorldTransform(closestPointInput.transformA);
        collisionObject2.getWorldTransform(closestPointInput.transformB);
        this.gjkPairDetector.getClosestPoints(closestPointInput, manifoldResult);
        Pools.CLOSEST_POINTS.release((Object[])new DiscreteCollisionDetectorInterface.ClosestPointInput[]{closestPointInput});
        if (this.ownManifold) {
            manifoldResult.refreshContactPoints();
        }
    }

    @Override
    public float calculateTimeOfImpact(CollisionObject collisionObject, CollisionObject collisionObject2, ManifoldResult manifoldResult) {
        float f;
        Transform transform;
        Transform transform2;
        Vector3f vector3f;
        block11: {
            float f2;
            vector3f = (Vector3f)Pools.VECTORS.get();
            transform2 = (Transform)Pools.TRANSFORMS.get();
            transform = (Transform)Pools.TRANSFORMS.get();
            try {
                f = 1.0f;
                vector3f.sub(collisionObject.getInterpolationWorldTransform((Transform)transform2).origin, collisionObject.getWorldTransform((Transform)transform).origin);
                float f3 = vector3f.lengthSquared();
                vector3f.sub(collisionObject2.getInterpolationWorldTransform((Transform)transform2).origin, collisionObject2.getWorldTransform((Transform)transform).origin);
                float f4 = vector3f.lengthSquared();
                if (!(f3 < collisionObject.getCcdSquareMotionThreshold()) || !(f4 < collisionObject2.getCcdSquareMotionThreshold())) break block11;
                f2 = f;
            }
            catch (Throwable throwable) {
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
                Pools.TRANSFORMS.release((Object[])new Transform[]{transform2, transform});
                throw throwable;
            }
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
            Pools.TRANSFORMS.release((Object[])new Transform[]{transform2, transform});
            return f2;
        }
        Transform transform3 = (Transform)Pools.TRANSFORMS.get();
        Transform transform4 = (Transform)Pools.TRANSFORMS.get();
        ConvexShape convexShape = (ConvexShape)collisionObject.getCollisionShape();
        SphereShape sphereShape = new SphereShape(collisionObject2.getCcdSweptSphereRadius());
        ConvexCast.CastResult castResult = new ConvexCast.CastResult();
        VoronoiSimplexSolver voronoiSimplexSolver = new VoronoiSimplexSolver();
        GjkConvexCast gjkConvexCast = new GjkConvexCast(convexShape, sphereShape, voronoiSimplexSolver);
        if (gjkConvexCast.calcTimeOfImpact(collisionObject.getWorldTransform(transform2), collisionObject.getInterpolationWorldTransform(transform), collisionObject2.getWorldTransform(transform3), collisionObject2.getInterpolationWorldTransform(transform4), castResult)) {
            if (collisionObject.getHitFraction() > castResult.fraction) {
                collisionObject.setHitFraction(castResult.fraction);
            }
            if (collisionObject2.getHitFraction() > castResult.fraction) {
                collisionObject2.setHitFraction(castResult.fraction);
            }
            if (f > castResult.fraction) {
                f = castResult.fraction;
            }
        }
        convexShape = (ConvexShape)collisionObject2.getCollisionShape();
        sphereShape = new SphereShape(collisionObject.getCcdSweptSphereRadius());
        castResult = new ConvexCast.CastResult();
        voronoiSimplexSolver = new VoronoiSimplexSolver();
        gjkConvexCast = new GjkConvexCast(sphereShape, convexShape, voronoiSimplexSolver);
        if (gjkConvexCast.calcTimeOfImpact(collisionObject.getWorldTransform(transform2), collisionObject.getInterpolationWorldTransform(transform), collisionObject2.getWorldTransform(transform3), collisionObject2.getInterpolationWorldTransform(transform4), castResult)) {
            if (collisionObject.getHitFraction() > castResult.fraction) {
                collisionObject.setHitFraction(castResult.fraction);
            }
            if (collisionObject2.getHitFraction() > castResult.fraction) {
                collisionObject2.setHitFraction(castResult.fraction);
            }
            if (f > castResult.fraction) {
                f = castResult.fraction;
            }
        }
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform3, transform4});
        float f5 = f;
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
        Pools.TRANSFORMS.release((Object[])new Transform[]{transform2, transform});
        return f5;
    }

    @Override
    public void getAllContactManifolds(ArrayList<PersistentManifold> arrayList) {
        if (this.manifoldPtr != null && this.ownManifold) {
            arrayList.add(this.manifoldPtr);
        }
    }

    public PersistentManifold getManifold() {
        return this.manifoldPtr;
    }

    public static class CreateFunc
    implements CollisionAlgorithmCreateFunc {
        public ConvexPenetrationDepthSolver pdSolver;
        public SimplexSolverInterface simplexSolver;

        public CreateFunc(SimplexSolverInterface simplexSolverInterface, ConvexPenetrationDepthSolver convexPenetrationDepthSolver) {
            this.simplexSolver = simplexSolverInterface;
            this.pdSolver = convexPenetrationDepthSolver;
        }

        @Override
        public CollisionAlgorithm createCollisionAlgorithm(CollisionAlgorithmConstructionInfo collisionAlgorithmConstructionInfo, CollisionObject collisionObject, CollisionObject collisionObject2) {
            ConvexConvexAlgorithm convexConvexAlgorithm = (ConvexConvexAlgorithm)Pools.CONVEX_CONVEX_COLLISIONS.get();
            convexConvexAlgorithm.init(collisionAlgorithmConstructionInfo.manifold, collisionAlgorithmConstructionInfo, collisionObject, collisionObject2, this.simplexSolver, this.pdSolver);
            return convexConvexAlgorithm;
        }

        @Override
        public void releaseCollisionAlgorithm(CollisionAlgorithm collisionAlgorithm) {
            Pools.CONVEX_CONVEX_COLLISIONS.release((Object[])new ConvexConvexAlgorithm[]{(ConvexConvexAlgorithm)collisionAlgorithm});
        }
    }
}

