/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.extras.gimpact;

import com.bulletphysics.Pools;
import com.bulletphysics.extras.gimpact.BoxCollision;
import com.bulletphysics.extras.gimpact.BvhDataArray;
import com.bulletphysics.extras.gimpact.BvhTreeNodeArray;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Vector3f;

class BvhTree {
    protected int num_nodes = 0;
    protected BvhTreeNodeArray node_array = new BvhTreeNodeArray();

    BvhTree() {
    }

    protected int _calc_splitting_axis(BvhDataArray bvhDataArray, int n, int n2) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        vector3f.set(0.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.set(0.0f, 0.0f, 0.0f);
        int n3 = n2 - n;
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        int n4 = n;
        while (n4 < n2) {
            bvhDataArray.getBoundMax(n4, vector3f5);
            bvhDataArray.getBoundMin(n4, vector3f6);
            vector3f3.add(vector3f5, vector3f6);
            vector3f3.scale(0.5f);
            vector3f.add(vector3f3);
            ++n4;
        }
        vector3f.scale(1.0f / (float)n3);
        n4 = n;
        while (n4 < n2) {
            bvhDataArray.getBoundMax(n4, vector3f5);
            bvhDataArray.getBoundMin(n4, vector3f6);
            vector3f3.add(vector3f5, vector3f6);
            vector3f3.scale(0.5f);
            vector3f4.sub(vector3f3, vector3f);
            VectorUtil.mul(vector3f4, vector3f4, vector3f4);
            vector3f2.add(vector3f4);
            ++n4;
        }
        vector3f2.scale(1.0f / (float)(n3 - 1));
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f5, vector3f6});
        return VectorUtil.maxAxis(vector3f2);
    }

    protected int _sort_and_calc_splitting_index(BvhDataArray bvhDataArray, int n, int n2, int n3) {
        boolean bl;
        boolean bl2;
        int n4 = n;
        int n5 = n2 - n;
        float f = 0.0f;
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        vector3f.set(0.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        int n6 = n;
        while (n6 < n2) {
            bvhDataArray.getBoundMax(n6, vector3f3);
            bvhDataArray.getBoundMin(n6, vector3f4);
            vector3f2.add(vector3f3, vector3f4);
            vector3f2.scale(0.5f);
            vector3f.add(vector3f2);
            ++n6;
        }
        vector3f.scale(1.0f / (float)n5);
        f = VectorUtil.getCoord(vector3f, n3);
        n6 = n;
        while (n6 < n2) {
            bvhDataArray.getBoundMax(n6, vector3f3);
            bvhDataArray.getBoundMin(n6, vector3f4);
            vector3f2.add(vector3f3, vector3f4);
            vector3f2.scale(0.5f);
            if (VectorUtil.getCoord(vector3f2, n3) > f) {
                bvhDataArray.swap(n6, n4);
                ++n4;
            }
            ++n6;
        }
        n6 = n5 / 3;
        boolean bl3 = bl2 = n4 <= n + n6 || n4 >= n2 - 1 - n6;
        if (bl2) {
            n4 = n + (n5 >> 1);
        }
        boolean bl4 = bl = n4 == n || n4 == n2;
        assert (!bl);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2, vector3f3, vector3f4});
        return n4;
    }

    protected void _build_sub_tree(BvhDataArray bvhDataArray, int n, int n2) {
        int n3 = this.num_nodes++;
        assert (n2 - n > 0);
        if (n2 - n == 1) {
            this.node_array.set(n3, bvhDataArray, n);
            return;
        }
        int n4 = this._calc_splitting_axis(bvhDataArray, n, n2);
        n4 = this._sort_and_calc_splitting_index(bvhDataArray, n, n2, n4);
        BoxCollision.AABB aABB = (BoxCollision.AABB)Pools.AABBS.get();
        BoxCollision.AABB aABB2 = (BoxCollision.AABB)Pools.AABBS.get();
        aABB.invalidate();
        int n5 = n;
        while (n5 < n2) {
            bvhDataArray.getBound(n5, aABB2);
            aABB.merge(aABB2);
            ++n5;
        }
        this.setNodeBound(n3, aABB);
        this._build_sub_tree(bvhDataArray, n, n4);
        this._build_sub_tree(bvhDataArray, n4, n2);
        this.node_array.setEscapeIndex(n3, this.num_nodes - n3);
    }

    public void build_tree(BvhDataArray bvhDataArray) {
        this.num_nodes = 0;
        this.node_array.resize(bvhDataArray.size() * 2);
        this._build_sub_tree(bvhDataArray, 0, bvhDataArray.size());
    }

    public void clearNodes() {
        this.node_array.clear();
        this.num_nodes = 0;
    }

    public int getNodeCount() {
        return this.num_nodes;
    }

    public boolean isLeafNode(int n) {
        return this.node_array.isLeafNode(n);
    }

    public int getNodeData(int n) {
        return this.node_array.getDataIndex(n);
    }

    public void getNodeBound(int n, BoxCollision.AABB aABB) {
        this.node_array.getBound(n, aABB);
    }

    public void setNodeBound(int n, BoxCollision.AABB aABB) {
        this.node_array.setBound(n, aABB);
    }

    public int getLeftNode(int n) {
        return n + 1;
    }

    public int getRightNode(int n) {
        if (this.node_array.isLeafNode(n + 1)) {
            return n + 2;
        }
        return n + 1 + this.node_array.getEscapeIndex(n + 1);
    }

    public int getEscapeNodeIndex(int n) {
        return this.node_array.getEscapeIndex(n);
    }

    public BvhTreeNodeArray get_node_pointer() {
        return this.node_array;
    }
}

