/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.broadphase;

import com.bulletphysics.Pools;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Vector3f;

public class DbvtAabbMm {
    private final Vector3f mi = new Vector3f();
    private final Vector3f mx = new Vector3f();

    public DbvtAabbMm() {
    }

    public DbvtAabbMm(DbvtAabbMm dbvtAabbMm) {
        this.set(dbvtAabbMm);
    }

    public void set(DbvtAabbMm dbvtAabbMm) {
        this.mi.set(dbvtAabbMm.mi);
        this.mx.set(dbvtAabbMm.mx);
    }

    public static void swap(DbvtAabbMm dbvtAabbMm, DbvtAabbMm dbvtAabbMm2) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        vector3f.set(dbvtAabbMm.mi);
        dbvtAabbMm.mi.set(dbvtAabbMm2.mi);
        dbvtAabbMm2.mi.set(vector3f);
        vector3f.set(dbvtAabbMm.mx);
        dbvtAabbMm.mx.set(dbvtAabbMm2.mx);
        dbvtAabbMm2.mx.set(vector3f);
    }

    public Vector3f Center(Vector3f vector3f) {
        vector3f.add(this.mi, this.mx);
        vector3f.scale(0.5f);
        return vector3f;
    }

    public Vector3f Lengths(Vector3f vector3f) {
        vector3f.sub(this.mx, this.mi);
        return vector3f;
    }

    public Vector3f Extents(Vector3f vector3f) {
        vector3f.sub(this.mx, this.mi);
        vector3f.scale(0.5f);
        return vector3f;
    }

    public Vector3f Mins() {
        return this.mi;
    }

    public Vector3f Maxs() {
        return this.mx;
    }

    public static DbvtAabbMm FromCE(Vector3f vector3f, Vector3f vector3f2, DbvtAabbMm dbvtAabbMm) {
        DbvtAabbMm dbvtAabbMm2 = dbvtAabbMm;
        dbvtAabbMm2.mi.sub(vector3f, vector3f2);
        dbvtAabbMm2.mx.add(vector3f, vector3f2);
        return dbvtAabbMm2;
    }

    public static DbvtAabbMm FromCR(Vector3f vector3f, float f, DbvtAabbMm dbvtAabbMm) {
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.set(f, f, f);
        return DbvtAabbMm.FromCE(vector3f, vector3f2, dbvtAabbMm);
    }

    public static DbvtAabbMm FromMM(Vector3f vector3f, Vector3f vector3f2, DbvtAabbMm dbvtAabbMm) {
        DbvtAabbMm dbvtAabbMm2 = dbvtAabbMm;
        dbvtAabbMm2.mi.set(vector3f);
        dbvtAabbMm2.mx.set(vector3f2);
        return dbvtAabbMm2;
    }

    public void Expand(Vector3f vector3f) {
        this.mi.sub(vector3f);
        this.mx.add(vector3f);
    }

    public void SignedExpand(Vector3f vector3f) {
        if (vector3f.x > 0.0f) {
            this.mx.x += vector3f.x;
        } else {
            this.mi.x += vector3f.x;
        }
        if (vector3f.y > 0.0f) {
            this.mx.y += vector3f.y;
        } else {
            this.mi.y += vector3f.y;
        }
        if (vector3f.z > 0.0f) {
            this.mx.z += vector3f.z;
        } else {
            this.mi.z += vector3f.z;
        }
    }

    public boolean Contain(DbvtAabbMm dbvtAabbMm) {
        return this.mi.x <= dbvtAabbMm.mi.x && this.mi.y <= dbvtAabbMm.mi.y && this.mi.z <= dbvtAabbMm.mi.z && this.mx.x >= dbvtAabbMm.mx.x && this.mx.y >= dbvtAabbMm.mx.y && this.mx.z >= dbvtAabbMm.mx.z;
    }

    public int Classify(Vector3f vector3f, float f, int n) {
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        switch (n) {
            case 0: {
                vector3f3.set(this.mi.x, this.mi.y, this.mi.z);
                vector3f2.set(this.mx.x, this.mx.y, this.mx.z);
                break;
            }
            case 1: {
                vector3f3.set(this.mx.x, this.mi.y, this.mi.z);
                vector3f2.set(this.mi.x, this.mx.y, this.mx.z);
                break;
            }
            case 2: {
                vector3f3.set(this.mi.x, this.mx.y, this.mi.z);
                vector3f2.set(this.mx.x, this.mi.y, this.mx.z);
                break;
            }
            case 3: {
                vector3f3.set(this.mx.x, this.mx.y, this.mi.z);
                vector3f2.set(this.mi.x, this.mi.y, this.mx.z);
                break;
            }
            case 4: {
                vector3f3.set(this.mi.x, this.mi.y, this.mx.z);
                vector3f2.set(this.mx.x, this.mx.y, this.mi.z);
                break;
            }
            case 5: {
                vector3f3.set(this.mx.x, this.mi.y, this.mx.z);
                vector3f2.set(this.mi.x, this.mx.y, this.mi.z);
                break;
            }
            case 6: {
                vector3f3.set(this.mi.x, this.mx.y, this.mx.z);
                vector3f2.set(this.mx.x, this.mi.y, this.mi.z);
                break;
            }
            case 7: {
                vector3f3.set(this.mx.x, this.mx.y, this.mx.z);
                vector3f2.set(this.mi.x, this.mi.y, this.mi.z);
            }
        }
        if (vector3f.dot(vector3f3) + f < 0.0f) {
            return -1;
        }
        if (vector3f.dot(vector3f2) + f >= 0.0f) {
            return 1;
        }
        return 0;
    }

    public float ProjectMinimum(Vector3f vector3f, int n) {
        Vector3f[] vector3fArray = new Vector3f[]{this.mx, this.mi};
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.set(vector3fArray[n >> 0 & 1].x, vector3fArray[n >> 1 & 1].y, vector3fArray[n >> 2 & 1].z);
        return vector3f2.dot(vector3f);
    }

    public static boolean Intersect(DbvtAabbMm dbvtAabbMm, DbvtAabbMm dbvtAabbMm2) {
        return dbvtAabbMm.mi.x <= dbvtAabbMm2.mx.x && dbvtAabbMm.mx.x >= dbvtAabbMm2.mi.x && dbvtAabbMm.mi.y <= dbvtAabbMm2.mx.y && dbvtAabbMm.mx.y >= dbvtAabbMm2.mi.y && dbvtAabbMm.mi.z <= dbvtAabbMm2.mx.z && dbvtAabbMm.mx.z >= dbvtAabbMm2.mi.z;
    }

    public static boolean Intersect(DbvtAabbMm dbvtAabbMm, DbvtAabbMm dbvtAabbMm2, Transform transform) {
        float[] fArray;
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        dbvtAabbMm2.Center(vector3f);
        transform.transform(vector3f);
        vector3f.sub(dbvtAabbMm.Center(vector3f3));
        MatrixUtil.transposeTransform(vector3f2, vector3f, transform.basis);
        float[] fArray2 = new float[]{0.0f, 0.0f};
        fArray = new float[]{transform.origin.dot(vector3f), fArray[0]};
        dbvtAabbMm.AddSpan(vector3f, fArray2, 0, fArray2, 1);
        dbvtAabbMm2.AddSpan(vector3f2, fArray, 0, fArray, 1);
        return !(fArray2[0] > fArray[1]) && !(fArray2[1] < fArray[0]);
    }

    public static boolean Intersect(DbvtAabbMm dbvtAabbMm, Vector3f vector3f) {
        return vector3f.x >= dbvtAabbMm.mi.x && vector3f.y >= dbvtAabbMm.mi.y && vector3f.z >= dbvtAabbMm.mi.z && vector3f.x <= dbvtAabbMm.mx.x && vector3f.y <= dbvtAabbMm.mx.y && vector3f.z <= dbvtAabbMm.mx.z;
    }

    public static boolean Intersect(DbvtAabbMm dbvtAabbMm, Vector3f vector3f, Vector3f vector3f2, int[] nArray) {
        Vector3f[] vector3fArray = new Vector3f[]{dbvtAabbMm.mi, dbvtAabbMm.mx};
        float f = (vector3fArray[nArray[0]].x - vector3f.x) * vector3f2.x;
        float f2 = (vector3fArray[1 - nArray[0]].x - vector3f.x) * vector3f2.x;
        float f3 = (vector3fArray[nArray[1]].y - vector3f.y) * vector3f2.y;
        float f4 = (vector3fArray[1 - nArray[1]].y - vector3f.y) * vector3f2.y;
        if (f > f4 || f3 > f2) {
            return false;
        }
        if (f3 > f) {
            f = f3;
        }
        if (f4 < f2) {
            f2 = f4;
        }
        float f5 = (vector3fArray[nArray[2]].z - vector3f.z) * vector3f2.z;
        float f6 = (vector3fArray[1 - nArray[2]].z - vector3f.z) * vector3f2.z;
        if (f > f6 || f5 > f2) {
            return false;
        }
        if (f5 > f) {
            f = f5;
        }
        if (f6 < f2) {
            f2 = f6;
        }
        return f2 > 0.0f;
    }

    public static float Proximity(DbvtAabbMm dbvtAabbMm, DbvtAabbMm dbvtAabbMm2) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f.add(dbvtAabbMm.mi, dbvtAabbMm.mx);
        vector3f2.add(dbvtAabbMm2.mi, dbvtAabbMm2.mx);
        vector3f.sub(vector3f2);
        return Math.abs(vector3f.x) + Math.abs(vector3f.y) + Math.abs(vector3f.z);
    }

    public static void Merge(DbvtAabbMm dbvtAabbMm, DbvtAabbMm dbvtAabbMm2, DbvtAabbMm dbvtAabbMm3) {
        int n = 0;
        while (n < 3) {
            if (VectorUtil.getCoord(dbvtAabbMm.mi, n) < VectorUtil.getCoord(dbvtAabbMm2.mi, n)) {
                VectorUtil.setCoord(dbvtAabbMm3.mi, n, VectorUtil.getCoord(dbvtAabbMm.mi, n));
            } else {
                VectorUtil.setCoord(dbvtAabbMm3.mi, n, VectorUtil.getCoord(dbvtAabbMm2.mi, n));
            }
            if (VectorUtil.getCoord(dbvtAabbMm.mx, n) > VectorUtil.getCoord(dbvtAabbMm2.mx, n)) {
                VectorUtil.setCoord(dbvtAabbMm3.mx, n, VectorUtil.getCoord(dbvtAabbMm.mx, n));
            } else {
                VectorUtil.setCoord(dbvtAabbMm3.mx, n, VectorUtil.getCoord(dbvtAabbMm2.mx, n));
            }
            ++n;
        }
    }

    public static boolean NotEqual(DbvtAabbMm dbvtAabbMm, DbvtAabbMm dbvtAabbMm2) {
        return dbvtAabbMm.mi.x != dbvtAabbMm2.mi.x || dbvtAabbMm.mi.y != dbvtAabbMm2.mi.y || dbvtAabbMm.mi.z != dbvtAabbMm2.mi.z || dbvtAabbMm.mx.x != dbvtAabbMm2.mx.x || dbvtAabbMm.mx.y != dbvtAabbMm2.mx.y || dbvtAabbMm.mx.z != dbvtAabbMm2.mx.z;
    }

    private void AddSpan(Vector3f vector3f, float[] fArray, int n, float[] fArray2, int n2) {
        int n3 = 0;
        while (n3 < 3) {
            if (VectorUtil.getCoord(vector3f, n3) < 0.0f) {
                int n4 = n;
                fArray[n4] = fArray[n4] + VectorUtil.getCoord(this.mx, n3) * VectorUtil.getCoord(vector3f, n3);
                int n5 = n2;
                fArray2[n5] = fArray2[n5] + VectorUtil.getCoord(this.mi, n3) * VectorUtil.getCoord(vector3f, n3);
            } else {
                int n6 = n;
                fArray[n6] = fArray[n6] + VectorUtil.getCoord(this.mi, n3) * VectorUtil.getCoord(vector3f, n3);
                int n7 = n2;
                fArray2[n7] = fArray2[n7] + VectorUtil.getCoord(this.mx, n3) * VectorUtil.getCoord(vector3f, n3);
            }
            ++n3;
        }
    }
}

