/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.constraintsolver;

import com.bulletphysics.Pools;
import com.bulletphysics.dynamics.RigidBody;
import javax.vecmath.Vector3f;

public class RotationalLimitMotor {
    public float loLimit;
    public float hiLimit;
    public float targetVelocity;
    public float maxMotorForce;
    public float maxLimitForce;
    public float damping;
    public float limitSoftness;
    public float ERP;
    public float bounce;
    public boolean enableMotor;
    public float currentLimitError;
    public int currentLimit;
    public float accumulatedImpulse;

    public RotationalLimitMotor() {
        this.accumulatedImpulse = 0.0f;
        this.targetVelocity = 0.0f;
        this.maxMotorForce = 0.1f;
        this.maxLimitForce = 300.0f;
        this.loLimit = -3.4028235E38f;
        this.hiLimit = Float.MAX_VALUE;
        this.ERP = 0.5f;
        this.bounce = 0.0f;
        this.damping = 1.0f;
        this.limitSoftness = 0.5f;
        this.currentLimit = 0;
        this.currentLimitError = 0.0f;
        this.enableMotor = false;
    }

    public RotationalLimitMotor(RotationalLimitMotor rotationalLimitMotor) {
        this.targetVelocity = rotationalLimitMotor.targetVelocity;
        this.maxMotorForce = rotationalLimitMotor.maxMotorForce;
        this.limitSoftness = rotationalLimitMotor.limitSoftness;
        this.loLimit = rotationalLimitMotor.loLimit;
        this.hiLimit = rotationalLimitMotor.hiLimit;
        this.ERP = rotationalLimitMotor.ERP;
        this.bounce = rotationalLimitMotor.bounce;
        this.currentLimit = rotationalLimitMotor.currentLimit;
        this.currentLimitError = rotationalLimitMotor.currentLimitError;
        this.enableMotor = rotationalLimitMotor.enableMotor;
    }

    public boolean isLimited() {
        return !(this.loLimit >= this.hiLimit);
    }

    public boolean needApplyTorques() {
        return this.currentLimit != 0 || this.enableMotor;
    }

    public int testLimitValue(float f) {
        if (this.loLimit > this.hiLimit) {
            this.currentLimit = 0;
            return 0;
        }
        if (f < this.loLimit) {
            this.currentLimit = 1;
            this.currentLimitError = f - this.loLimit;
            return 1;
        }
        if (f > this.hiLimit) {
            this.currentLimit = 2;
            this.currentLimitError = f - this.hiLimit;
            return 2;
        }
        this.currentLimit = 0;
        return 0;
    }

    public float solveAngularLimits(float f, Vector3f vector3f, float f2, RigidBody rigidBody, RigidBody rigidBody2) {
        float f3;
        float f4;
        if (!this.needApplyTorques()) {
            return 0.0f;
        }
        float f5 = this.targetVelocity;
        float f6 = this.maxMotorForce;
        if (this.currentLimit != 0) {
            f5 = -this.ERP * this.currentLimitError / f;
            f6 = this.maxLimitForce;
        }
        f6 *= f;
        Vector3f vector3f2 = rigidBody.getAngularVelocity((Vector3f)Pools.VECTORS.get());
        if (rigidBody2 != null) {
            vector3f2.sub(rigidBody2.getAngularVelocity((Vector3f)Pools.VECTORS.get()));
        }
        if ((f4 = this.limitSoftness * (f5 - this.damping * (f3 = vector3f.dot(vector3f2)))) < 1.1920929E-7f && f4 > -1.1920929E-7f) {
            return 0.0f;
        }
        float f7 = (1.0f + this.bounce) * f4 * f2;
        float f8 = f7 > 0.0f ? (f7 > f6 ? f6 : f7) : (f7 < -f6 ? -f6 : f7);
        float f9 = -1.0E30f;
        float f10 = 1.0E30f;
        float f11 = this.accumulatedImpulse;
        float f12 = f11 + f8;
        this.accumulatedImpulse = f12 > f10 ? 0.0f : (f12 < f9 ? 0.0f : f12);
        f8 = this.accumulatedImpulse - f11;
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.scale(f8, vector3f);
        rigidBody.applyTorqueImpulse(vector3f3);
        if (rigidBody2 != null) {
            vector3f3.negate();
            rigidBody2.applyTorqueImpulse(vector3f3);
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3, vector3f2});
        return f8;
    }
}

