/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.linearmath;

import com.bulletphysics.Pools;
import com.bulletphysics.linearmath.MatrixUtil;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class Transform {
    public final Matrix3f basis = new Matrix3f();
    public final Vector3f origin = new Vector3f();
    private final Vector3f tmp = new Vector3f();

    public Transform() {
    }

    public Transform(Matrix3f matrix3f) {
        this.basis.set(matrix3f);
    }

    public Transform(Matrix4f matrix4f) {
        this.set(matrix4f);
    }

    public Transform(Transform transform) {
        this.set(transform);
    }

    public void set(Transform transform) {
        this.basis.set(transform.basis);
        this.origin.set(transform.origin);
    }

    public void set(Matrix3f matrix3f) {
        this.basis.set(matrix3f);
        this.origin.set(0.0f, 0.0f, 0.0f);
    }

    public void set(Matrix4f matrix4f) {
        matrix4f.getRotationScale(this.basis);
        this.origin.set(matrix4f.m03, matrix4f.m13, matrix4f.m23);
    }

    public void transform(Vector3f vector3f) {
        this.basis.transform(vector3f);
        vector3f.add(this.origin);
    }

    public void setIdentity() {
        this.basis.setIdentity();
        this.origin.set(0.0f, 0.0f, 0.0f);
    }

    public void inverse() {
        this.basis.transpose();
        this.origin.scale(-1.0f);
        this.basis.transform(this.origin);
    }

    public void inverse(Transform transform) {
        this.set(transform);
        this.inverse();
    }

    public void mul(Transform transform) {
        this.tmp.set(transform.origin);
        this.transform(this.tmp);
        this.basis.mul(transform.basis);
        this.origin.set(this.tmp);
    }

    public void mul(Transform transform, Transform transform2) {
        this.tmp.set(transform2.origin);
        transform.transform(this.tmp);
        this.basis.mul(transform.basis, transform2.basis);
        this.origin.set(this.tmp);
    }

    public void invXform(Vector3f vector3f, Vector3f vector3f2) {
        vector3f2.sub(vector3f, this.origin);
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get((Object)this.basis);
        matrix3f.transpose();
        matrix3f.transform(vector3f2);
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f});
    }

    public Quat4f getRotation(Quat4f quat4f) {
        MatrixUtil.getRotation(this.basis, quat4f);
        return quat4f;
    }

    public void setRotation(Quat4f quat4f) {
        MatrixUtil.setRotation(this.basis, quat4f);
    }

    public void setFromOpenGLMatrix(float[] fArray) {
        MatrixUtil.setFromOpenGLSubMatrix(this.basis, fArray);
        this.origin.set(fArray[12], fArray[13], fArray[14]);
    }

    public void getOpenGLMatrix(float[] fArray) {
        MatrixUtil.getOpenGLSubMatrix(this.basis, fArray);
        fArray[12] = this.origin.x;
        fArray[13] = this.origin.y;
        fArray[14] = this.origin.z;
        fArray[15] = 1.0f;
    }

    public Matrix4f getMatrix(Matrix4f matrix4f) {
        matrix4f.set(this.basis);
        matrix4f.m03 = this.origin.x;
        matrix4f.m13 = this.origin.y;
        matrix4f.m23 = this.origin.z;
        return matrix4f;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Transform)) {
            return false;
        }
        Transform transform = (Transform)object;
        return this.basis.equals(transform.basis) && this.origin.equals(transform.origin);
    }

    public int hashCode() {
        int n = 3;
        n = 41 * n + this.basis.hashCode();
        n = 41 * n + this.origin.hashCode();
        return n;
    }
}

