/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.physics.common;

import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.grid.IGridAgent;
import gama.core.runtime.IScope;
import gama.core.util.matrix.IField;
import gama.extension.physics.common.IPhysicalEntity;
import gama.extension.physics.gaml.PhysicalSimulationAgent;

public interface IShapeConverter<ShapeType, VectorType>
extends IPhysicalEntity<VectorType> {
    default public float[] toFloats(double[] dArray) {
        float[] fArray = new float[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            fArray[n] = (float)dArray[n];
            ++n;
        }
        return fArray;
    }

    default public float computeDepth(IAgent iAgent) {
        Double d;
        float f = 0.0f;
        f = iAgent.getSpecies().isGrid() ? (float)((IGridAgent)iAgent).getValue() : ((d = iAgent.getDepth()) == null ? 0.0f : d.floatValue());
        return f < 0.0f ? 0.0f : f;
    }

    default public IShape.Type computeType(IAgent iAgent) {
        if (iAgent.getSpecies().isGrid()) {
            return IShape.Type.BOX;
        }
        return iAgent.getGeometricalType();
    }

    default public ShapeType convertAndTranslate(IAgent iAgent, VectorType VectorType, VectorType VectorType2) {
        IField iField;
        IShape.Type type = this.computeType(iAgent);
        float f = this.computeDepth(iAgent);
        this.computeTranslation(iAgent, type, f, VectorType, VectorType2);
        if (iAgent instanceof PhysicalSimulationAgent && (iField = ((PhysicalSimulationAgent)iAgent).getTerrain()) != null) {
            return this.convertTerrain(iAgent.getScope(), iField, iAgent.getWidth(), iAgent.getHeight(), f);
        }
        return this.convertShape(iAgent.getGeometry(), type, f);
    }

    public void computeTranslation(IAgent var1, IShape.Type var2, float var3, VectorType var4, VectorType var5);

    public ShapeType convertShape(IShape var1, IShape.Type var2, float var3);

    public ShapeType convertTerrain(IScope var1, IField var2, Double var3, Double var4, float var5);
}

