/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import java.io.Serializable;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Mat33;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.Vec3;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.pooling.IWorldPool;

public class PrismaticJoint
extends Joint {
    protected final Vec2 m_localAnchorA;
    protected final Vec2 m_localAnchorB;
    protected final Vec2 m_localXAxisA;
    protected final Vec2 m_localYAxisA;
    protected float m_referenceAngle;
    private final Vec3 m_impulse;
    private float m_motorImpulse;
    private float m_lowerTranslation;
    private float m_upperTranslation;
    private float m_maxMotorForce;
    private float m_motorSpeed;
    private boolean m_enableLimit;
    private boolean m_enableMotor;
    private LimitState m_limitState;
    private int m_indexA;
    private int m_indexB;
    private final Vec2 m_localCenterA = new Vec2();
    private final Vec2 m_localCenterB = new Vec2();
    private float m_invMassA;
    private float m_invMassB;
    private float m_invIA;
    private float m_invIB;
    private final Vec2 m_axis;
    private final Vec2 m_perp;
    private float m_s1;
    private float m_s2;
    private float m_a1;
    private float m_a2;
    private final Mat33 m_K;
    private float m_motorMass;

    protected PrismaticJoint(IWorldPool iWorldPool, PrismaticJointDef prismaticJointDef) {
        super(iWorldPool, prismaticJointDef);
        this.m_localAnchorA = new Vec2(prismaticJointDef.localAnchorA);
        this.m_localAnchorB = new Vec2(prismaticJointDef.localAnchorB);
        this.m_localXAxisA = new Vec2(prismaticJointDef.localAxisA);
        this.m_localXAxisA.normalize();
        this.m_localYAxisA = new Vec2();
        Vec2.crossToOutUnsafe(1.0f, this.m_localXAxisA, this.m_localYAxisA);
        this.m_referenceAngle = prismaticJointDef.referenceAngle;
        this.m_impulse = new Vec3();
        this.m_motorMass = 0.0f;
        this.m_motorImpulse = 0.0f;
        this.m_lowerTranslation = prismaticJointDef.lowerTranslation;
        this.m_upperTranslation = prismaticJointDef.upperTranslation;
        this.m_maxMotorForce = prismaticJointDef.maxMotorForce;
        this.m_motorSpeed = prismaticJointDef.motorSpeed;
        this.m_enableLimit = prismaticJointDef.enableLimit;
        this.m_enableMotor = prismaticJointDef.enableMotor;
        this.m_limitState = LimitState.INACTIVE;
        this.m_K = new Mat33();
        this.m_axis = new Vec2();
        this.m_perp = new Vec2();
    }

    public Vec2 getLocalAnchorA() {
        return this.m_localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.m_localAnchorB;
    }

    @Override
    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, vec2);
    }

    @Override
    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, vec2);
    }

    @Override
    public void getReactionForce(float f, Vec2 vec2) {
        Vec2 vec22 = this.pool.popVec2();
        vec22.set(this.m_axis).mulLocal(this.m_motorImpulse + this.m_impulse.z);
        vec2.set(this.m_perp).mulLocal(this.m_impulse.x).addLocal(vec22).mulLocal(f);
        this.pool.pushVec2(1);
    }

    @Override
    public float getReactionTorque(float f) {
        return f * this.m_impulse.y;
    }

    public float getJointSpeed() {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2 vec25 = this.pool.popVec2();
        Vec2 vec26 = this.pool.popVec2();
        Vec2 vec27 = this.pool.popVec2();
        Vec2 vec28 = this.pool.popVec2();
        Vec2 vec29 = this.pool.popVec2();
        vec2.set(this.m_localAnchorA).subLocal(body.m_sweep.localCenter);
        Rot.mulToOutUnsafe(body.m_xf.q, vec2, vec22);
        vec2.set(this.m_localAnchorB).subLocal(body2.m_sweep.localCenter);
        Rot.mulToOutUnsafe(body2.m_xf.q, vec2, vec23);
        vec24.set(body.m_sweep.c).addLocal(vec22);
        vec25.set(body2.m_sweep.c).addLocal(vec23);
        vec26.set(vec25).subLocal(vec24);
        Rot.mulToOutUnsafe(body.m_xf.q, this.m_localXAxisA, vec27);
        Vec2 vec210 = body.m_linearVelocity;
        Vec2 vec211 = body2.m_linearVelocity;
        float f = body.m_angularVelocity;
        float f2 = body2.m_angularVelocity;
        Vec2.crossToOutUnsafe(f, vec27, vec2);
        Vec2.crossToOutUnsafe(f2, vec23, vec28);
        Vec2.crossToOutUnsafe(f, vec22, vec29);
        vec28.addLocal(vec211).subLocal(vec210).subLocal(vec29);
        float f3 = Vec2.dot(vec26, vec2) + Vec2.dot(vec27, vec28);
        this.pool.pushVec2(9);
        return f3;
    }

    public float getJointTranslation() {
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        Vec2 vec23 = this.pool.popVec2();
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, vec2);
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, vec22);
        this.m_bodyA.getWorldVectorToOutUnsafe(this.m_localXAxisA, vec23);
        vec22.subLocal(vec2);
        float f = Vec2.dot(vec22, vec23);
        this.pool.pushVec2(3);
        return f;
    }

    public boolean isLimitEnabled() {
        return this.m_enableLimit;
    }

    public void enableLimit(boolean bl) {
        if (bl != this.m_enableLimit) {
            this.m_bodyA.setAwake(true);
            this.m_bodyB.setAwake(true);
            this.m_enableLimit = bl;
            this.m_impulse.z = 0.0f;
        }
    }

    public float getLowerLimit() {
        return this.m_lowerTranslation;
    }

    public float getUpperLimit() {
        return this.m_upperTranslation;
    }

    public void setLimits(float f, float f2) {
        assert (f <= f2);
        if (f != this.m_lowerTranslation || f2 != this.m_upperTranslation) {
            this.m_bodyA.setAwake(true);
            this.m_bodyB.setAwake(true);
            this.m_lowerTranslation = f;
            this.m_upperTranslation = f2;
            this.m_impulse.z = 0.0f;
        }
    }

    public boolean isMotorEnabled() {
        return this.m_enableMotor;
    }

    public void enableMotor(boolean bl) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableMotor = bl;
    }

    public void setMotorSpeed(float f) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_motorSpeed = f;
    }

    public float getMotorSpeed() {
        return this.m_motorSpeed;
    }

    public void setMaxMotorForce(float f) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_maxMotorForce = f;
    }

    public float getMotorForce(float f) {
        return this.m_motorImpulse * f;
    }

    public float getMaxMotorForce() {
        return this.m_maxMotorForce;
    }

    public float getReferenceAngle() {
        return this.m_referenceAngle;
    }

    public Vec2 getLocalAxisA() {
        return this.m_localXAxisA;
    }

    @Override
    public void initVelocityConstraints(SolverData solverData) {
        this.m_indexA = this.m_bodyA.m_islandIndex;
        this.m_indexB = this.m_bodyB.m_islandIndex;
        this.m_localCenterA.set(this.m_bodyA.m_sweep.localCenter);
        this.m_localCenterB.set(this.m_bodyB.m_sweep.localCenter);
        this.m_invMassA = this.m_bodyA.m_invMass;
        this.m_invMassB = this.m_bodyB.m_invMass;
        this.m_invIA = this.m_bodyA.m_invI;
        this.m_invIB = this.m_bodyB.m_invI;
        Vec2 vec2 = solverData.positions[this.m_indexA].c;
        float f = solverData.positions[this.m_indexA].a;
        Vec2 vec22 = solverData.velocities[this.m_indexA].v;
        float f2 = solverData.velocities[this.m_indexA].w;
        Vec2 vec23 = solverData.positions[this.m_indexB].c;
        float f3 = solverData.positions[this.m_indexB].a;
        Vec2 vec24 = solverData.velocities[this.m_indexB].v;
        float f4 = solverData.velocities[this.m_indexB].w;
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Vec2 vec25 = this.pool.popVec2();
        Vec2 vec26 = this.pool.popVec2();
        Vec2 vec27 = this.pool.popVec2();
        Vec2 vec28 = this.pool.popVec2();
        rot.set(f);
        rot2.set(f3);
        Rot.mulToOutUnsafe(rot, vec25.set(this.m_localAnchorA).subLocal(this.m_localCenterA), vec27);
        Rot.mulToOutUnsafe(rot2, vec25.set(this.m_localAnchorB).subLocal(this.m_localCenterB), vec28);
        vec25.set(vec23).subLocal(vec2).addLocal(vec28).subLocal(vec27);
        float f5 = this.m_invMassA;
        float f6 = this.m_invMassB;
        float f7 = this.m_invIA;
        float f8 = this.m_invIB;
        Rot.mulToOutUnsafe(rot, this.m_localXAxisA, this.m_axis);
        vec26.set(vec25).addLocal(vec27);
        this.m_a1 = Vec2.cross(vec26, this.m_axis);
        this.m_a2 = Vec2.cross(vec28, this.m_axis);
        this.m_motorMass = f5 + f6 + f7 * this.m_a1 * this.m_a1 + f8 * this.m_a2 * this.m_a2;
        if (this.m_motorMass > 0.0f) {
            this.m_motorMass = 1.0f / this.m_motorMass;
        }
        Rot.mulToOutUnsafe(rot, this.m_localYAxisA, this.m_perp);
        vec26.set(vec25).addLocal(vec27);
        this.m_s1 = Vec2.cross(vec26, this.m_perp);
        this.m_s2 = Vec2.cross(vec28, this.m_perp);
        float f9 = f5 + f6 + f7 * this.m_s1 * this.m_s1 + f8 * this.m_s2 * this.m_s2;
        float f10 = f7 * this.m_s1 + f8 * this.m_s2;
        float f11 = f7 * this.m_s1 * this.m_a1 + f8 * this.m_s2 * this.m_a2;
        float f12 = f7 + f8;
        if (f12 == 0.0f) {
            f12 = 1.0f;
        }
        float f13 = f7 * this.m_a1 + f8 * this.m_a2;
        float f14 = f5 + f6 + f7 * this.m_a1 * this.m_a1 + f8 * this.m_a2 * this.m_a2;
        this.m_K.ex.set(f9, f10, f11);
        this.m_K.ey.set(f10, f12, f13);
        this.m_K.ez.set(f11, f13, f14);
        if (this.m_enableLimit) {
            f9 = Vec2.dot(this.m_axis, vec25);
            if (MathUtils.abs(this.m_upperTranslation - this.m_lowerTranslation) < 2.0f * Settings.linearSlop) {
                this.m_limitState = LimitState.EQUAL;
            } else if (f9 <= this.m_lowerTranslation) {
                if (this.m_limitState != LimitState.AT_LOWER) {
                    this.m_limitState = LimitState.AT_LOWER;
                    this.m_impulse.z = 0.0f;
                }
            } else if (f9 >= this.m_upperTranslation) {
                if (this.m_limitState != LimitState.AT_UPPER) {
                    this.m_limitState = LimitState.AT_UPPER;
                    this.m_impulse.z = 0.0f;
                }
            } else {
                this.m_limitState = LimitState.INACTIVE;
                this.m_impulse.z = 0.0f;
            }
        } else {
            this.m_limitState = LimitState.INACTIVE;
            this.m_impulse.z = 0.0f;
        }
        if (!this.m_enableMotor) {
            this.m_motorImpulse = 0.0f;
        }
        if (solverData.step.warmStarting) {
            this.m_impulse.mulLocal(solverData.step.dtRatio);
            this.m_motorImpulse *= solverData.step.dtRatio;
            Vec2 vec29 = this.pool.popVec2();
            vec26.set(this.m_axis).mulLocal(this.m_motorImpulse + this.m_impulse.z);
            vec29.set(this.m_perp).mulLocal(this.m_impulse.x).addLocal(vec26);
            f10 = this.m_impulse.x * this.m_s1 + this.m_impulse.y + (this.m_motorImpulse + this.m_impulse.z) * this.m_a1;
            f11 = this.m_impulse.x * this.m_s2 + this.m_impulse.y + (this.m_motorImpulse + this.m_impulse.z) * this.m_a2;
            vec22.x -= f5 * vec29.x;
            vec22.y -= f5 * vec29.y;
            f2 -= f7 * f10;
            vec24.x += f6 * vec29.x;
            vec24.y += f6 * vec29.y;
            f4 += f8 * f11;
            this.pool.pushVec2(1);
        } else {
            this.m_impulse.setZero();
            this.m_motorImpulse = 0.0f;
        }
        solverData.velocities[this.m_indexA].w = f2;
        solverData.velocities[this.m_indexB].w = f4;
        this.pool.pushRot(2);
        this.pool.pushVec2(4);
    }

    @Override
    public void solveVelocityConstraints(SolverData solverData) {
        Serializable serializable;
        float f;
        float f2;
        Vec2 vec2 = solverData.velocities[this.m_indexA].v;
        float f3 = solverData.velocities[this.m_indexA].w;
        Vec2 vec22 = solverData.velocities[this.m_indexB].v;
        float f4 = solverData.velocities[this.m_indexB].w;
        float f5 = this.m_invMassA;
        float f6 = this.m_invMassB;
        float f7 = this.m_invIA;
        float f8 = this.m_invIB;
        Vec2 vec23 = this.pool.popVec2();
        if (this.m_enableMotor && this.m_limitState != LimitState.EQUAL) {
            vec23.set(vec22).subLocal(vec2);
            float f9 = Vec2.dot(this.m_axis, vec23) + this.m_a2 * f4 - this.m_a1 * f3;
            f2 = this.m_motorMass * (this.m_motorSpeed - f9);
            float f10 = this.m_motorImpulse;
            f = solverData.step.dt * this.m_maxMotorForce;
            this.m_motorImpulse = MathUtils.clamp(this.m_motorImpulse + f2, -f, f);
            f2 = this.m_motorImpulse - f10;
            serializable = this.pool.popVec2();
            ((Vec2)serializable).set(this.m_axis).mulLocal(f2);
            float f11 = f2 * this.m_a1;
            float f12 = f2 * this.m_a2;
            vec2.x -= f5 * ((Vec2)serializable).x;
            vec2.y -= f5 * ((Vec2)serializable).y;
            f3 -= f7 * f11;
            vec22.x += f6 * ((Vec2)serializable).x;
            vec22.y += f6 * ((Vec2)serializable).y;
            f4 += f8 * f12;
            this.pool.pushVec2(1);
        }
        Vec2 vec24 = this.pool.popVec2();
        vec23.set(vec22).subLocal(vec2);
        vec24.x = Vec2.dot(this.m_perp, vec23) + this.m_s2 * f4 - this.m_s1 * f3;
        vec24.y = f4 - f3;
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE) {
            vec23.set(vec22).subLocal(vec2);
            f2 = Vec2.dot(this.m_axis, vec23) + this.m_a2 * f4 - this.m_a1 * f3;
            Vec3 vec3 = this.pool.popVec3();
            vec3.set(vec24.x, vec24.y, f2);
            Vec3 vec32 = this.pool.popVec3();
            serializable = this.pool.popVec3();
            vec32.set(this.m_impulse);
            this.m_K.solve33ToOut(vec3.negateLocal(), (Vec3)serializable);
            this.m_impulse.addLocal((Vec3)serializable);
            if (this.m_limitState == LimitState.AT_LOWER) {
                this.m_impulse.z = MathUtils.max(this.m_impulse.z, 0.0f);
            } else if (this.m_limitState == LimitState.AT_UPPER) {
                this.m_impulse.z = MathUtils.min(this.m_impulse.z, 0.0f);
            }
            Vec2 vec25 = this.pool.popVec2();
            Vec2 vec26 = this.pool.popVec2();
            vec23.set(this.m_K.ez.x, this.m_K.ez.y).mulLocal(this.m_impulse.z - vec32.z);
            vec25.set(vec24).negateLocal().subLocal(vec23);
            this.m_K.solve22ToOut(vec25, vec26);
            vec26.addLocal(vec32.x, vec32.y);
            this.m_impulse.x = vec26.x;
            this.m_impulse.y = vec26.y;
            ((Vec3)serializable).set(this.m_impulse).subLocal(vec32);
            Vec2 vec27 = this.pool.popVec2();
            vec23.set(this.m_axis).mulLocal(((Vec3)serializable).z);
            vec27.set(this.m_perp).mulLocal(((Vec3)serializable).x).addLocal(vec23);
            float f13 = ((Vec3)serializable).x * this.m_s1 + ((Vec3)serializable).y + ((Vec3)serializable).z * this.m_a1;
            float f14 = ((Vec3)serializable).x * this.m_s2 + ((Vec3)serializable).y + ((Vec3)serializable).z * this.m_a2;
            vec2.x -= f5 * vec27.x;
            vec2.y -= f5 * vec27.y;
            f3 -= f7 * f13;
            vec22.x += f6 * vec27.x;
            vec22.y += f6 * vec27.y;
            f4 += f8 * f14;
            this.pool.pushVec2(3);
            this.pool.pushVec3(3);
        } else {
            Vec2 vec28 = this.pool.popVec2();
            this.m_K.solve22ToOut(vec24.negateLocal(), vec28);
            vec24.negateLocal();
            this.m_impulse.x += vec28.x;
            this.m_impulse.y += vec28.y;
            Vec2 vec29 = this.pool.popVec2();
            vec29.set(this.m_perp).mulLocal(vec28.x);
            f = vec28.x * this.m_s1 + vec28.y;
            float f15 = vec28.x * this.m_s2 + vec28.y;
            vec2.x -= f5 * vec29.x;
            vec2.y -= f5 * vec29.y;
            f3 -= f7 * f;
            vec22.x += f6 * vec29.x;
            vec22.y += f6 * vec29.y;
            f4 += f8 * f15;
            this.pool.pushVec2(2);
        }
        solverData.velocities[this.m_indexA].w = f3;
        solverData.velocities[this.m_indexB].w = f4;
        this.pool.pushVec2(2);
    }

    @Override
    public boolean solvePositionConstraints(SolverData solverData) {
        float f;
        float f2;
        float f3;
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        Vec2 vec25 = this.pool.popVec2();
        Vec2 vec26 = this.pool.popVec2();
        Vec2 vec27 = this.pool.popVec2();
        Vec3 vec3 = this.pool.popVec3();
        Vec2 vec28 = solverData.positions[this.m_indexA].c;
        float f4 = solverData.positions[this.m_indexA].a;
        Vec2 vec29 = solverData.positions[this.m_indexB].c;
        float f5 = solverData.positions[this.m_indexB].a;
        rot.set(f4);
        rot2.set(f5);
        float f6 = this.m_invMassA;
        float f7 = this.m_invMassB;
        float f8 = this.m_invIA;
        float f9 = this.m_invIB;
        Rot.mulToOutUnsafe(rot, vec26.set(this.m_localAnchorA).subLocal(this.m_localCenterA), vec2);
        Rot.mulToOutUnsafe(rot2, vec26.set(this.m_localAnchorB).subLocal(this.m_localCenterB), vec22);
        vec23.set(vec29).addLocal(vec22).subLocal(vec28).subLocal(vec2);
        Rot.mulToOutUnsafe(rot, this.m_localXAxisA, vec24);
        float f10 = Vec2.cross(vec26.set(vec23).addLocal(vec2), vec24);
        float f11 = Vec2.cross(vec22, vec24);
        Rot.mulToOutUnsafe(rot, this.m_localYAxisA, vec25);
        float f12 = Vec2.cross(vec26.set(vec23).addLocal(vec2), vec25);
        float f13 = Vec2.cross(vec22, vec25);
        vec27.x = Vec2.dot(vec25, vec23);
        vec27.y = f5 - f4 - this.m_referenceAngle;
        float f14 = MathUtils.abs(vec27.x);
        float f15 = MathUtils.abs(vec27.y);
        boolean bl = false;
        float f16 = 0.0f;
        if (this.m_enableLimit) {
            f3 = Vec2.dot(vec24, vec23);
            if (MathUtils.abs(this.m_upperTranslation - this.m_lowerTranslation) < 2.0f * Settings.linearSlop) {
                f16 = MathUtils.clamp(f3, -Settings.maxLinearCorrection, Settings.maxLinearCorrection);
                f14 = MathUtils.max(f14, MathUtils.abs(f3));
                bl = true;
            } else if (f3 <= this.m_lowerTranslation) {
                f16 = MathUtils.clamp(f3 - this.m_lowerTranslation + Settings.linearSlop, -Settings.maxLinearCorrection, 0.0f);
                f14 = MathUtils.max(f14, this.m_lowerTranslation - f3);
                bl = true;
            } else if (f3 >= this.m_upperTranslation) {
                f16 = MathUtils.clamp(f3 - this.m_upperTranslation - Settings.linearSlop, 0.0f, Settings.maxLinearCorrection);
                f14 = MathUtils.max(f14, f3 - this.m_upperTranslation);
                bl = true;
            }
        }
        if (bl) {
            f3 = f6 + f7 + f8 * f12 * f12 + f9 * f13 * f13;
            f2 = f8 * f12 + f9 * f13;
            f = f8 * f12 * f10 + f9 * f13 * f11;
            float f17 = f8 + f9;
            if (f17 == 0.0f) {
                f17 = 1.0f;
            }
            float f18 = f8 * f10 + f9 * f11;
            float f19 = f6 + f7 + f8 * f10 * f10 + f9 * f11 * f11;
            Mat33 mat33 = this.pool.popMat33();
            mat33.ex.set(f3, f2, f);
            mat33.ey.set(f2, f17, f18);
            mat33.ez.set(f, f18, f19);
            Vec3 vec32 = this.pool.popVec3();
            vec32.x = vec27.x;
            vec32.y = vec27.y;
            vec32.z = f16;
            mat33.solve33ToOut(vec32.negateLocal(), vec3);
            this.pool.pushVec3(1);
            this.pool.pushMat33(1);
        } else {
            f3 = f6 + f7 + f8 * f12 * f12 + f9 * f13 * f13;
            f2 = f8 * f12 + f9 * f13;
            f = f8 + f9;
            if (f == 0.0f) {
                f = 1.0f;
            }
            Mat22 mat22 = this.pool.popMat22();
            mat22.ex.set(f3, f2);
            mat22.ey.set(f2, f);
            mat22.solveToOut(vec27.negateLocal(), vec26);
            vec27.negateLocal();
            vec3.x = vec26.x;
            vec3.y = vec26.y;
            vec3.z = 0.0f;
            this.pool.pushMat22(1);
        }
        f3 = vec3.x * vec25.x + vec3.z * vec24.x;
        f2 = vec3.x * vec25.y + vec3.z * vec24.y;
        f = vec3.x * f12 + vec3.y + vec3.z * f10;
        float f20 = vec3.x * f13 + vec3.y + vec3.z * f11;
        vec28.x -= f6 * f3;
        vec28.y -= f6 * f2;
        vec29.x += f7 * f3;
        vec29.y += f7 * f2;
        solverData.positions[this.m_indexA].a = f4 -= f8 * f;
        solverData.positions[this.m_indexB].a = f5 += f9 * f20;
        this.pool.pushVec2(7);
        this.pool.pushVec3(1);
        this.pool.pushRot(2);
        return f14 <= Settings.linearSlop && f15 <= Settings.angularSlop;
    }
}

