/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.Pools;
import com.bulletphysics.collision.shapes.BvhSubtreeInfo;
import com.bulletphysics.collision.shapes.InternalTriangleIndexCallback;
import com.bulletphysics.collision.shapes.NodeOverlapCallback;
import com.bulletphysics.collision.shapes.OptimizedBvhNode;
import com.bulletphysics.collision.shapes.QuantizedBvhNodes;
import com.bulletphysics.collision.shapes.StridingMeshInterface;
import com.bulletphysics.collision.shapes.TraversalMode;
import com.bulletphysics.collision.shapes.VertexData;
import com.bulletphysics.linearmath.AabbUtil2;
import com.bulletphysics.linearmath.MiscUtil;
import com.bulletphysics.linearmath.VectorUtil;
import java.io.Serializable;
import java.util.ArrayList;
import javax.vecmath.Vector3f;

public class OptimizedBvh
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG_TREE_BUILDING = false;
    private static int gStackDepth = 0;
    private static int gMaxStackDepth = 0;
    private static int maxIterations = 0;
    public static final int MAX_SUBTREE_SIZE_IN_BYTES = 2048;
    public static final int MAX_NUM_PARTS_IN_BITS = 10;
    private final ArrayList<OptimizedBvhNode> leafNodes = new ArrayList();
    private final ArrayList<OptimizedBvhNode> contiguousNodes = new ArrayList();
    private final QuantizedBvhNodes quantizedLeafNodes = new QuantizedBvhNodes();
    private final QuantizedBvhNodes quantizedContiguousNodes = new QuantizedBvhNodes();
    private int curNodeIndex;
    private boolean useQuantization;
    private final Vector3f bvhAabbMin = new Vector3f();
    private final Vector3f bvhAabbMax = new Vector3f();
    private final Vector3f bvhQuantization = new Vector3f();
    protected TraversalMode traversalMode = TraversalMode.STACKLESS;
    protected final ArrayList<BvhSubtreeInfo> SubtreeHeaders = new ArrayList();
    protected int subtreeHeaderCount;

    public void setInternalNodeAabbMin(int n, Vector3f vector3f) {
        if (this.useQuantization) {
            this.quantizedContiguousNodes.setQuantizedAabbMin(n, this.quantizeWithClamp(vector3f));
        } else {
            this.contiguousNodes.get((int)n).aabbMinOrg.set(vector3f);
        }
    }

    public void setInternalNodeAabbMax(int n, Vector3f vector3f) {
        if (this.useQuantization) {
            this.quantizedContiguousNodes.setQuantizedAabbMax(n, this.quantizeWithClamp(vector3f));
        } else {
            this.contiguousNodes.get((int)n).aabbMaxOrg.set(vector3f);
        }
    }

    public Vector3f getAabbMin(int n) {
        if (this.useQuantization) {
            Vector3f vector3f = new Vector3f();
            this.unQuantize(vector3f, this.quantizedLeafNodes.getQuantizedAabbMin(n));
            return vector3f;
        }
        return this.leafNodes.get((int)n).aabbMinOrg;
    }

    public Vector3f getAabbMax(int n) {
        if (this.useQuantization) {
            Vector3f vector3f = new Vector3f();
            this.unQuantize(vector3f, this.quantizedLeafNodes.getQuantizedAabbMax(n));
            return vector3f;
        }
        return this.leafNodes.get((int)n).aabbMaxOrg;
    }

    public void setQuantizationValues(Vector3f vector3f, Vector3f vector3f2) {
        this.setQuantizationValues(vector3f, vector3f2, 1.0f);
    }

    public void setQuantizationValues(Vector3f vector3f, Vector3f vector3f2, float f) {
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.set(f, f, f);
        this.bvhAabbMin.sub(vector3f, vector3f3);
        this.bvhAabbMax.add(vector3f2, vector3f3);
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.sub(this.bvhAabbMax, this.bvhAabbMin);
        this.bvhQuantization.set(65535.0f, 65535.0f, 65535.0f);
        VectorUtil.div(this.bvhQuantization, this.bvhQuantization, vector3f4);
    }

    public void setInternalNodeEscapeIndex(int n, int n2) {
        if (this.useQuantization) {
            this.quantizedContiguousNodes.setEscapeIndexOrTriangleIndex(n, -n2);
        } else {
            this.contiguousNodes.get((int)n).escapeIndex = n2;
        }
    }

    public void mergeInternalNodeAabb(int n, Vector3f vector3f, Vector3f vector3f2) {
        if (this.useQuantization) {
            long l = this.quantizeWithClamp(vector3f);
            long l2 = this.quantizeWithClamp(vector3f2);
            int n2 = 0;
            while (n2 < 3) {
                if (this.quantizedContiguousNodes.getQuantizedAabbMin(n, n2) > QuantizedBvhNodes.getCoord(l, n2)) {
                    this.quantizedContiguousNodes.setQuantizedAabbMin(n, n2, QuantizedBvhNodes.getCoord(l, n2));
                }
                if (this.quantizedContiguousNodes.getQuantizedAabbMax(n, n2) < QuantizedBvhNodes.getCoord(l2, n2)) {
                    this.quantizedContiguousNodes.setQuantizedAabbMax(n, n2, QuantizedBvhNodes.getCoord(l2, n2));
                }
                ++n2;
            }
        } else {
            VectorUtil.setMin(this.contiguousNodes.get((int)n).aabbMinOrg, vector3f);
            VectorUtil.setMax(this.contiguousNodes.get((int)n).aabbMaxOrg, vector3f2);
        }
    }

    public void swapLeafNodes(int n, int n2) {
        if (this.useQuantization) {
            this.quantizedLeafNodes.swap(n, n2);
        } else {
            OptimizedBvhNode optimizedBvhNode = this.leafNodes.get(n);
            this.leafNodes.set(n, this.leafNodes.get(n2));
            this.leafNodes.set(n2, optimizedBvhNode);
        }
    }

    public void assignInternalNodeFromLeafNode(int n, int n2) {
        if (this.useQuantization) {
            this.quantizedContiguousNodes.set(n, this.quantizedLeafNodes, n2);
        } else {
            this.contiguousNodes.get(n).set(this.leafNodes.get(n2));
        }
    }

    public void build(StridingMeshInterface stridingMeshInterface, boolean bl, Vector3f vector3f, Vector3f vector3f2) {
        Object object;
        this.useQuantization = bl;
        int n = 0;
        if (this.useQuantization) {
            this.setQuantizationValues(vector3f, vector3f2);
            object = new QuantizedNodeTriangleCallback(this.quantizedLeafNodes, this);
            stridingMeshInterface.internalProcessAllTriangles((InternalTriangleIndexCallback)object, this.bvhAabbMin, this.bvhAabbMax);
            n = this.quantizedLeafNodes.size();
            this.quantizedContiguousNodes.resize(2 * n);
        } else {
            object = new NodeTriangleCallback(this.leafNodes);
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            vector3f3.set(-1.0E30f, -1.0E30f, -1.0E30f);
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
            vector3f4.set(1.0E30f, 1.0E30f, 1.0E30f);
            stridingMeshInterface.internalProcessAllTriangles((InternalTriangleIndexCallback)object, vector3f3, vector3f4);
            n = this.leafNodes.size();
            MiscUtil.resize(this.contiguousNodes, 2 * n, OptimizedBvhNode.class);
        }
        this.curNodeIndex = 0;
        this.buildTree(0, n);
        if (this.useQuantization && this.SubtreeHeaders.size() == 0) {
            object = new BvhSubtreeInfo();
            this.SubtreeHeaders.add((BvhSubtreeInfo)object);
            ((BvhSubtreeInfo)object).setAabbFromQuantizeNode(this.quantizedContiguousNodes, 0);
            ((BvhSubtreeInfo)object).rootNodeIndex = 0;
            ((BvhSubtreeInfo)object).subtreeSize = this.quantizedContiguousNodes.isLeafNode(0) ? 1 : this.quantizedContiguousNodes.getEscapeIndex(0);
        }
        this.subtreeHeaderCount = this.SubtreeHeaders.size();
        this.quantizedLeafNodes.clear();
        this.leafNodes.clear();
    }

    public void refit(StridingMeshInterface stridingMeshInterface) {
        if (this.useQuantization) {
            Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
            stridingMeshInterface.calculateAabbBruteForce(vector3f, vector3f2);
            this.setQuantizationValues(vector3f, vector3f2);
            this.updateBvhNodes(stridingMeshInterface, 0, this.curNodeIndex, 0);
            int n = 0;
            while (n < this.SubtreeHeaders.size()) {
                BvhSubtreeInfo bvhSubtreeInfo = this.SubtreeHeaders.get(n);
                bvhSubtreeInfo.setAabbFromQuantizeNode(this.quantizedContiguousNodes, bvhSubtreeInfo.rootNodeIndex);
                ++n;
            }
        } else {
            this.build(stridingMeshInterface, false, null, null);
        }
    }

    public void refitPartial(StridingMeshInterface stridingMeshInterface, Vector3f vector3f, Vector3f vector3f2) {
        throw new UnsupportedOperationException();
    }

    public void updateBvhNodes(StridingMeshInterface stridingMeshInterface, int n, int n2, int n3) {
        assert (this.useQuantization);
        int n4 = -1;
        Vector3f[] vector3fArray = new Vector3f[]{(Vector3f)Pools.VECTORS.get(), (Vector3f)Pools.VECTORS.get(), (Vector3f)Pools.VECTORS.get()};
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f3 = stridingMeshInterface.getScaling((Vector3f)Pools.VECTORS.get());
        VertexData vertexData = null;
        int n5 = n2 - 1;
        while (n5 >= n) {
            QuantizedBvhNodes quantizedBvhNodes = this.quantizedContiguousNodes;
            int n6 = n5;
            if (quantizedBvhNodes.isLeafNode(n6)) {
                var14_14 = quantizedBvhNodes.getPartId(n6);
                var15_15 = quantizedBvhNodes.getTriangleIndex(n6);
                if (var14_14 != n4) {
                    if (n4 >= 0) {
                        stridingMeshInterface.unLockReadOnlyVertexBase(n4);
                    }
                    vertexData = stridingMeshInterface.getLockedReadOnlyVertexIndexBase(var14_14);
                    vertexData.getTriangle(var15_15 * 3, vector3f3, vector3fArray);
                }
                vector3f.set(1.0E30f, 1.0E30f, 1.0E30f);
                vector3f2.set(-1.0E30f, -1.0E30f, -1.0E30f);
                VectorUtil.setMin(vector3f, vector3fArray[0]);
                VectorUtil.setMax(vector3f2, vector3fArray[0]);
                VectorUtil.setMin(vector3f, vector3fArray[1]);
                VectorUtil.setMax(vector3f2, vector3fArray[1]);
                VectorUtil.setMin(vector3f, vector3fArray[2]);
                VectorUtil.setMax(vector3f2, vector3fArray[2]);
                quantizedBvhNodes.setQuantizedAabbMin(n6, this.quantizeWithClamp(vector3f));
                quantizedBvhNodes.setQuantizedAabbMax(n6, this.quantizeWithClamp(vector3f2));
            } else {
                var14_14 = n5 + 1;
                var15_15 = this.quantizedContiguousNodes.isLeafNode(var14_14) ? n5 + 2 : n5 + 1 + this.quantizedContiguousNodes.getEscapeIndex(var14_14);
                int n7 = 0;
                while (n7 < 3) {
                    quantizedBvhNodes.setQuantizedAabbMin(n6, n7, this.quantizedContiguousNodes.getQuantizedAabbMin(var14_14, n7));
                    if (quantizedBvhNodes.getQuantizedAabbMin(n6, n7) > this.quantizedContiguousNodes.getQuantizedAabbMin(var15_15, n7)) {
                        quantizedBvhNodes.setQuantizedAabbMin(n6, n7, this.quantizedContiguousNodes.getQuantizedAabbMin(var15_15, n7));
                    }
                    quantizedBvhNodes.setQuantizedAabbMax(n6, n7, this.quantizedContiguousNodes.getQuantizedAabbMax(var14_14, n7));
                    if (quantizedBvhNodes.getQuantizedAabbMax(n6, n7) < this.quantizedContiguousNodes.getQuantizedAabbMax(var15_15, n7)) {
                        quantizedBvhNodes.setQuantizedAabbMax(n6, n7, this.quantizedContiguousNodes.getQuantizedAabbMax(var15_15, n7));
                    }
                    ++n7;
                }
            }
            --n5;
        }
        if (n4 >= 0) {
            stridingMeshInterface.unLockReadOnlyVertexBase(n4);
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3fArray[0], vector3fArray[1], vector3fArray[2], vector3f, vector3f2, vector3f3});
    }

    protected void buildTree(int n, int n2) {
        int n3;
        int n4;
        int n5 = n2 - n;
        int n6 = this.curNodeIndex;
        assert (n5 > 0);
        if (n5 == 1) {
            this.assignInternalNodeFromLeafNode(this.curNodeIndex, n);
            ++this.curNodeIndex;
            return;
        }
        int n7 = this.calcSplittingAxis(n, n2);
        int n8 = this.sortAndCalcSplittingIndex(n, n2, n7);
        int n9 = this.curNodeIndex;
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        vector3f.set(-1.0E30f, -1.0E30f, -1.0E30f);
        this.setInternalNodeAabbMax(this.curNodeIndex, vector3f);
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.set(1.0E30f, 1.0E30f, 1.0E30f);
        this.setInternalNodeAabbMin(this.curNodeIndex, vector3f2);
        int n10 = n;
        while (n10 < n2) {
            this.mergeInternalNodeAabb(this.curNodeIndex, this.getAabbMin(n10), this.getAabbMax(n10));
            ++n10;
        }
        ++this.curNodeIndex;
        int n11 = this.curNodeIndex;
        this.buildTree(n, n8);
        int n12 = this.curNodeIndex;
        this.buildTree(n8, n2);
        int n13 = this.curNodeIndex - n6;
        if (this.useQuantization && (n4 = n13 * (n3 = QuantizedBvhNodes.getNodeSize())) > 2048) {
            this.updateSubtreeHeaders(n11, n12);
        }
        this.setInternalNodeEscapeIndex(n9, n13);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2});
    }

    protected boolean testQuantizedAabbAgainstQuantizedAabb(long l, long l2, long l3, long l4) {
        int n = QuantizedBvhNodes.getCoord(l, 0);
        int n2 = QuantizedBvhNodes.getCoord(l, 1);
        int n3 = QuantizedBvhNodes.getCoord(l, 2);
        int n4 = QuantizedBvhNodes.getCoord(l2, 0);
        int n5 = QuantizedBvhNodes.getCoord(l2, 1);
        int n6 = QuantizedBvhNodes.getCoord(l2, 2);
        int n7 = QuantizedBvhNodes.getCoord(l3, 0);
        int n8 = QuantizedBvhNodes.getCoord(l3, 1);
        int n9 = QuantizedBvhNodes.getCoord(l3, 2);
        int n10 = QuantizedBvhNodes.getCoord(l4, 0);
        int n11 = QuantizedBvhNodes.getCoord(l4, 1);
        int n12 = QuantizedBvhNodes.getCoord(l4, 2);
        boolean bl = true;
        bl = n > n10 || n4 < n7 ? false : bl;
        bl = n3 > n12 || n6 < n9 ? false : bl;
        return n2 > n11 || n5 < n8 ? false : bl;
    }

    protected void updateSubtreeHeaders(int n, int n2) {
        BvhSubtreeInfo bvhSubtreeInfo;
        assert (this.useQuantization);
        int n3 = this.quantizedContiguousNodes.isLeafNode(n) ? 1 : this.quantizedContiguousNodes.getEscapeIndex(n);
        int n4 = n3 * QuantizedBvhNodes.getNodeSize();
        int n5 = this.quantizedContiguousNodes.isLeafNode(n2) ? 1 : this.quantizedContiguousNodes.getEscapeIndex(n2);
        int n6 = n5 * QuantizedBvhNodes.getNodeSize();
        if (n4 <= 2048) {
            bvhSubtreeInfo = new BvhSubtreeInfo();
            this.SubtreeHeaders.add(bvhSubtreeInfo);
            bvhSubtreeInfo.setAabbFromQuantizeNode(this.quantizedContiguousNodes, n);
            bvhSubtreeInfo.rootNodeIndex = n;
            bvhSubtreeInfo.subtreeSize = n3;
        }
        if (n6 <= 2048) {
            bvhSubtreeInfo = new BvhSubtreeInfo();
            this.SubtreeHeaders.add(bvhSubtreeInfo);
            bvhSubtreeInfo.setAabbFromQuantizeNode(this.quantizedContiguousNodes, n2);
            bvhSubtreeInfo.rootNodeIndex = n2;
            bvhSubtreeInfo.subtreeSize = n5;
        }
        this.subtreeHeaderCount = this.SubtreeHeaders.size();
    }

    protected int sortAndCalcSplittingIndex(int n, int n2, int n3) {
        boolean bl;
        boolean bl2;
        int n4 = n;
        int n5 = n2 - n;
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        vector3f.set(0.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        int n6 = n;
        while (n6 < n2) {
            vector3f2.add(this.getAabbMax(n6), this.getAabbMin(n6));
            vector3f2.scale(0.5f);
            vector3f.add(vector3f2);
            ++n6;
        }
        vector3f.scale(1.0f / (float)n5);
        float f = VectorUtil.getCoord(vector3f, n3);
        n6 = n;
        while (n6 < n2) {
            vector3f2.add(this.getAabbMax(n6), this.getAabbMin(n6));
            vector3f2.scale(0.5f);
            if (VectorUtil.getCoord(vector3f2, n3) > f) {
                this.swapLeafNodes(n6, n4);
                ++n4;
            }
            ++n6;
        }
        int n7 = n5 / 3;
        boolean bl3 = bl2 = n4 <= n + n7 || n4 >= n2 - 1 - n7;
        if (bl2) {
            n4 = n + (n5 >> 1);
        }
        boolean bl4 = bl = n4 == n || n4 == n2;
        assert (!bl);
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f2});
        return n4;
    }

    protected int calcSplittingAxis(int n, int n2) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        vector3f.set(0.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
        vector3f2.set(0.0f, 0.0f, 0.0f);
        int n3 = n2 - n;
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        int n4 = n;
        while (n4 < n2) {
            vector3f3.add(this.getAabbMax(n4), this.getAabbMin(n4));
            vector3f3.scale(0.5f);
            vector3f.add(vector3f3);
            ++n4;
        }
        vector3f.scale(1.0f / (float)n3);
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        n4 = n;
        while (n4 < n2) {
            vector3f3.add(this.getAabbMax(n4), this.getAabbMin(n4));
            vector3f3.scale(0.5f);
            vector3f4.sub(vector3f3, vector3f);
            VectorUtil.mul(vector3f4, vector3f4, vector3f4);
            vector3f2.add(vector3f4);
            ++n4;
        }
        vector3f2.scale(1.0f / ((float)n3 - 1.0f));
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f, vector3f3, vector3f4, vector3f2});
        return VectorUtil.maxAxis(vector3f2);
    }

    public void reportAabbOverlappingNodex(NodeOverlapCallback nodeOverlapCallback, Vector3f vector3f, Vector3f vector3f2) {
        block6: {
            block5: {
                if (!this.useQuantization) break block5;
                long l = this.quantizeWithClamp(vector3f);
                long l2 = this.quantizeWithClamp(vector3f2);
                switch (this.traversalMode) {
                    case STACKLESS: {
                        this.walkStacklessQuantizedTree(nodeOverlapCallback, l, l2, 0, this.curNodeIndex);
                        break block6;
                    }
                    case RECURSIVE: {
                        this.walkRecursiveQuantizedTreeAgainstQueryAabb(this.quantizedContiguousNodes, 0, nodeOverlapCallback, l, l2);
                        break block6;
                    }
                    default: {
                        assert (false);
                        break block6;
                    }
                }
            }
            this.walkStacklessTree(nodeOverlapCallback, vector3f, vector3f2);
        }
    }

    protected void walkStacklessTree(NodeOverlapCallback nodeOverlapCallback, Vector3f vector3f, Vector3f vector3f2) {
        assert (!this.useQuantization);
        OptimizedBvhNode optimizedBvhNode = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.curNodeIndex) {
            boolean bl;
            assert (n3 < this.curNodeIndex);
            ++n3;
            optimizedBvhNode = this.contiguousNodes.get(n);
            boolean bl2 = AabbUtil2.testAabbAgainstAabb2(vector3f, vector3f2, optimizedBvhNode.aabbMinOrg, optimizedBvhNode.aabbMaxOrg);
            boolean bl3 = bl = optimizedBvhNode.escapeIndex == -1;
            if (bl && bl2) {
                nodeOverlapCallback.processNode(optimizedBvhNode.subPart, optimizedBvhNode.triangleIndex);
            }
            optimizedBvhNode = null;
            if (bl2 || bl) {
                ++n;
                ++n2;
                continue;
            }
            int n4 = this.contiguousNodes.get((int)n).escapeIndex;
            n += n4;
            n2 += n4;
        }
        if (maxIterations < n3) {
            maxIterations = n3;
        }
    }

    protected void walkRecursiveQuantizedTreeAgainstQueryAabb(QuantizedBvhNodes quantizedBvhNodes, int n, NodeOverlapCallback nodeOverlapCallback, long l, long l2) {
        assert (this.useQuantization);
        boolean bl = this.testQuantizedAabbAgainstQuantizedAabb(l, l2, quantizedBvhNodes.getQuantizedAabbMin(n), quantizedBvhNodes.getQuantizedAabbMax(n));
        boolean bl2 = quantizedBvhNodes.isLeafNode(n);
        if (bl) {
            if (bl2) {
                nodeOverlapCallback.processNode(quantizedBvhNodes.getPartId(n), quantizedBvhNodes.getTriangleIndex(n));
            } else {
                int n2 = n + 1;
                this.walkRecursiveQuantizedTreeAgainstQueryAabb(quantizedBvhNodes, n2, nodeOverlapCallback, l, l2);
                int n3 = quantizedBvhNodes.isLeafNode(n2) ? n2 + 1 : n2 + quantizedBvhNodes.getEscapeIndex(n2);
                this.walkRecursiveQuantizedTreeAgainstQueryAabb(quantizedBvhNodes, n3, nodeOverlapCallback, l, l2);
            }
        }
    }

    protected void walkStacklessQuantizedTreeAgainstRay(NodeOverlapCallback nodeOverlapCallback, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, int n, int n2) {
        assert (this.useQuantization);
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        int n3 = n;
        int n4 = 0;
        int n5 = n2 - n;
        QuantizedBvhNodes quantizedBvhNodes = this.quantizedContiguousNodes;
        int n6 = n;
        boolean bl = false;
        boolean bl2 = false;
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        vector3f5.sub(vector3f2, vector3f);
        vector3f6.normalize(vector3f5);
        vector3f6.x = 1.0f / vector3f6.x;
        vector3f6.y = 1.0f / vector3f6.y;
        vector3f6.z = 1.0f / vector3f6.z;
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
        Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
        VectorUtil.setMin(vector3f7, vector3f2);
        VectorUtil.setMax(vector3f8, vector3f2);
        vector3f7.add(vector3f3);
        vector3f8.add(vector3f4);
        long l = this.quantizeWithClamp(vector3f7);
        long l2 = this.quantizeWithClamp(vector3f8);
        Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f11 = (Vector3f)Pools.VECTORS.get();
        float[] fArray = new float[1];
        while (n3 < n2) {
            assert (n4 < n5);
            ++n4;
            fArray[0] = 1.0f;
            bl2 = false;
            bl = this.testQuantizedAabbAgainstQuantizedAabb(l, l2, quantizedBvhNodes.getQuantizedAabbMin(n6), quantizedBvhNodes.getQuantizedAabbMax(n6));
            boolean bl3 = quantizedBvhNodes.isLeafNode(n6);
            if (bl) {
                this.unQuantize(vector3f9, quantizedBvhNodes.getQuantizedAabbMin(n6));
                this.unQuantize(vector3f10, quantizedBvhNodes.getQuantizedAabbMax(n6));
                vector3f9.add(vector3f3);
                vector3f10.add(vector3f4);
                bl2 = AabbUtil2.rayAabb(vector3f, vector3f2, vector3f9, vector3f10, fArray, vector3f11);
            }
            if (bl3 && bl2) {
                nodeOverlapCallback.processNode(quantizedBvhNodes.getPartId(n6), quantizedBvhNodes.getTriangleIndex(n6));
            }
            if (bl2 || bl3) {
                ++n6;
                ++n3;
                continue;
            }
            int n7 = quantizedBvhNodes.getEscapeIndex(n6);
            n6 += n7;
            n3 += n7;
        }
        if (maxIterations < n4) {
            maxIterations = n4;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f11, vector3f10, vector3f9, vector3f7, vector3f8, vector3f6, vector3f5});
    }

    protected void walkStacklessQuantizedTree(NodeOverlapCallback nodeOverlapCallback, long l, long l2, int n, int n2) {
        assert (this.useQuantization);
        int n3 = n;
        int n4 = 0;
        int n5 = n2 - n;
        QuantizedBvhNodes quantizedBvhNodes = this.quantizedContiguousNodes;
        int n6 = n;
        while (n3 < n2) {
            assert (n4 < n5);
            ++n4;
            boolean bl = this.testQuantizedAabbAgainstQuantizedAabb(l, l2, quantizedBvhNodes.getQuantizedAabbMin(n6), quantizedBvhNodes.getQuantizedAabbMax(n6));
            boolean bl2 = quantizedBvhNodes.isLeafNode(n6);
            if (bl2 && bl) {
                nodeOverlapCallback.processNode(quantizedBvhNodes.getPartId(n6), quantizedBvhNodes.getTriangleIndex(n6));
            }
            if (bl || bl2) {
                ++n6;
                ++n3;
                continue;
            }
            int n7 = quantizedBvhNodes.getEscapeIndex(n6);
            n6 += n7;
            n3 += n7;
        }
        if (maxIterations < n4) {
            maxIterations = n4;
        }
    }

    public void reportRayOverlappingNodex(NodeOverlapCallback nodeOverlapCallback, Vector3f vector3f, Vector3f vector3f2) {
        boolean bl;
        boolean bl2 = bl = this.useQuantization && this.traversalMode == TraversalMode.STACKLESS;
        if (bl) {
            Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
            vector3f3.set(0.0f, 0.0f, 0.0f);
            this.walkStacklessQuantizedTreeAgainstRay(nodeOverlapCallback, vector3f, vector3f2, vector3f3, vector3f3, 0, this.curNodeIndex);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f3});
        } else {
            Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
            Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
            VectorUtil.setMin(vector3f4, vector3f2);
            VectorUtil.setMax(vector3f5, vector3f2);
            this.reportAabbOverlappingNodex(nodeOverlapCallback, vector3f4, vector3f5);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f4, vector3f5});
        }
    }

    public void reportBoxCastOverlappingNodex(NodeOverlapCallback nodeOverlapCallback, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        boolean bl;
        boolean bl2 = bl = this.useQuantization && this.traversalMode == TraversalMode.STACKLESS;
        if (bl) {
            this.walkStacklessQuantizedTreeAgainstRay(nodeOverlapCallback, vector3f, vector3f2, vector3f3, vector3f4, 0, this.curNodeIndex);
        } else {
            Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
            Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
            VectorUtil.setMin(vector3f5, vector3f2);
            VectorUtil.setMax(vector3f6, vector3f2);
            vector3f5.add(vector3f3);
            vector3f6.add(vector3f4);
            this.reportAabbOverlappingNodex(nodeOverlapCallback, vector3f5, vector3f6);
            Pools.VECTORS.release((Object[])new Vector3f[]{vector3f5, vector3f6});
        }
    }

    public long quantizeWithClamp(Vector3f vector3f) {
        assert (this.useQuantization);
        Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get((Object)vector3f);
        VectorUtil.setMax(vector3f2, this.bvhAabbMin);
        VectorUtil.setMin(vector3f2, this.bvhAabbMax);
        Vector3f vector3f3 = (Vector3f)Pools.VECTORS.get();
        vector3f3.sub(vector3f2, this.bvhAabbMin);
        VectorUtil.mul(vector3f3, vector3f3, this.bvhQuantization);
        int n = (int)(vector3f3.x + 0.5f) & 0xFFFF;
        int n2 = (int)(vector3f3.y + 0.5f) & 0xFFFF;
        int n3 = (int)(vector3f3.z + 0.5f) & 0xFFFF;
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f2, vector3f3});
        return (long)n | (long)n2 << 16 | (long)n3 << 32;
    }

    public void unQuantize(Vector3f vector3f, long l) {
        int n = (int)(l & 0xFFFFL);
        int n2 = (int)((l & 0xFFFF0000L) >>> 16);
        int n3 = (int)((l & 0xFFFF00000000L) >>> 32);
        vector3f.x = (float)n / this.bvhQuantization.x;
        vector3f.y = (float)n2 / this.bvhQuantization.y;
        vector3f.z = (float)n3 / this.bvhQuantization.z;
        vector3f.add(this.bvhAabbMin);
    }

    private static class NodeTriangleCallback
    implements InternalTriangleIndexCallback {
        public ArrayList<OptimizedBvhNode> triangleNodes;
        private final Vector3f aabbMin = new Vector3f();
        private final Vector3f aabbMax = new Vector3f();

        public NodeTriangleCallback(ArrayList<OptimizedBvhNode> arrayList) {
            this.triangleNodes = arrayList;
        }

        @Override
        public void internalProcessTriangleIndex(Vector3f[] vector3fArray, int n, int n2) {
            OptimizedBvhNode optimizedBvhNode = new OptimizedBvhNode();
            this.aabbMin.set(1.0E30f, 1.0E30f, 1.0E30f);
            this.aabbMax.set(-1.0E30f, -1.0E30f, -1.0E30f);
            VectorUtil.setMin(this.aabbMin, vector3fArray[0]);
            VectorUtil.setMax(this.aabbMax, vector3fArray[0]);
            VectorUtil.setMin(this.aabbMin, vector3fArray[1]);
            VectorUtil.setMax(this.aabbMax, vector3fArray[1]);
            VectorUtil.setMin(this.aabbMin, vector3fArray[2]);
            VectorUtil.setMax(this.aabbMax, vector3fArray[2]);
            optimizedBvhNode.aabbMinOrg.set(this.aabbMin);
            optimizedBvhNode.aabbMaxOrg.set(this.aabbMax);
            optimizedBvhNode.escapeIndex = -1;
            optimizedBvhNode.subPart = n;
            optimizedBvhNode.triangleIndex = n2;
            this.triangleNodes.add(optimizedBvhNode);
        }
    }

    private static class QuantizedNodeTriangleCallback
    implements InternalTriangleIndexCallback {
        public QuantizedBvhNodes triangleNodes;
        public OptimizedBvh optimizedTree;

        public QuantizedNodeTriangleCallback(QuantizedBvhNodes quantizedBvhNodes, OptimizedBvh optimizedBvh) {
            this.triangleNodes = quantizedBvhNodes;
            this.optimizedTree = optimizedBvh;
        }

        @Override
        public void internalProcessTriangleIndex(Vector3f[] vector3fArray, int n, int n2) {
            assert (n < 1024);
            assert (n2 < 0x200000);
            assert (n2 >= 0);
            int n3 = this.triangleNodes.add();
            Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
            Vector3f vector3f2 = (Vector3f)Pools.VECTORS.get();
            vector3f.set(1.0E30f, 1.0E30f, 1.0E30f);
            vector3f2.set(-1.0E30f, -1.0E30f, -1.0E30f);
            VectorUtil.setMin(vector3f, vector3fArray[0]);
            VectorUtil.setMax(vector3f2, vector3fArray[0]);
            VectorUtil.setMin(vector3f, vector3fArray[1]);
            VectorUtil.setMax(vector3f2, vector3fArray[1]);
            VectorUtil.setMin(vector3f, vector3fArray[2]);
            VectorUtil.setMax(vector3f2, vector3fArray[2]);
            if (vector3f2.x - vector3f.x < 0.002f) {
                vector3f2.x += 0.001f;
                vector3f.x -= 0.001f;
            }
            if (vector3f2.y - vector3f.y < 0.002f) {
                vector3f2.y += 0.001f;
                vector3f.y -= 0.001f;
            }
            if (vector3f2.z - vector3f.z < 0.002f) {
                vector3f2.z += 0.001f;
                vector3f.z -= 0.001f;
            }
            this.triangleNodes.setQuantizedAabbMin(n3, this.optimizedTree.quantizeWithClamp(vector3f));
            this.triangleNodes.setQuantizedAabbMax(n3, this.optimizedTree.quantizeWithClamp(vector3f2));
            this.triangleNodes.setEscapeIndexOrTriangleIndex(n3, n << 21 | n2);
        }
    }
}

