/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.linearmath;

import com.bulletphysics.Pools;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public class AabbUtil2 {
    public static void aabbExpand(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        vector3f.add(vector3f3);
        vector3f2.add(vector3f4);
    }

    public static int outcode(Vector3f vector3f, Vector3f vector3f2) {
        return (vector3f.x < -vector3f2.x ? 1 : 0) | (vector3f.x > vector3f2.x ? 8 : 0) | (vector3f.y < -vector3f2.y ? 2 : 0) | (vector3f.y > vector3f2.y ? 16 : 0) | (vector3f.z < -vector3f2.z ? 4 : 0) | (vector3f.z > vector3f2.z ? 32 : 0);
    }

    public static boolean rayAabb(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, float[] fArray, Vector3f vector3f5) {
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f10 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f11 = (Vector3f)Pools.VECTORS.get();
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6, vector3f8, vector3f9, vector3f10, vector3f11});
        vector3f6.sub(vector3f4, vector3f3);
        vector3f6.scale(0.5f);
        vector3f7.add(vector3f4, vector3f3);
        vector3f7.scale(0.5f);
        vector3f8.sub(vector3f, vector3f7);
        vector3f9.sub(vector3f2, vector3f7);
        int n = AabbUtil2.outcode(vector3f8, vector3f6);
        int n2 = AabbUtil2.outcode(vector3f9, vector3f6);
        if ((n & n2) == 0) {
            float f = 0.0f;
            float f2 = fArray[0];
            vector3f10.sub(vector3f9, vector3f8);
            float f3 = 1.0f;
            vector3f11.set(0.0f, 0.0f, 0.0f);
            int n3 = 1;
            int n4 = 0;
            while (n4 < 2) {
                int n5 = 0;
                while (n5 != 3) {
                    if ((n & n3) != 0) {
                        var20_20 = (-VectorUtil.getCoord(vector3f8, n5) - VectorUtil.getCoord(vector3f6, n5) * f3) / VectorUtil.getCoord(vector3f10, n5);
                        if (f <= var20_20) {
                            f = var20_20;
                            vector3f11.set(0.0f, 0.0f, 0.0f);
                            VectorUtil.setCoord(vector3f11, n5, f3);
                        }
                    } else if ((n2 & n3) != 0) {
                        var20_20 = (-VectorUtil.getCoord(vector3f8, n5) - VectorUtil.getCoord(vector3f6, n5) * f3) / VectorUtil.getCoord(vector3f10, n5);
                        f2 = Math.min(f2, var20_20);
                    }
                    n3 <<= 1;
                    ++n5;
                }
                f3 = -1.0f;
                ++n4;
            }
            if (f <= f2) {
                fArray[0] = f;
                vector3f5.set(vector3f11);
                Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6, vector3f8, vector3f9, vector3f10, vector3f11});
                return true;
            }
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f7, vector3f6, vector3f8, vector3f9, vector3f10, vector3f11});
        return false;
    }

    public static boolean testAabbAgainstAabb2(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        boolean bl = true;
        bl = vector3f.x > vector3f4.x || vector3f2.x < vector3f3.x ? false : bl;
        bl = vector3f.z > vector3f4.z || vector3f2.z < vector3f3.z ? false : bl;
        bl = vector3f.y > vector3f4.y || vector3f2.y < vector3f3.y ? false : bl;
        return bl;
    }

    public static boolean testTriangleAgainstAabb2(Vector3f[] vector3fArray, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = vector3fArray[0];
        Vector3f vector3f4 = vector3fArray[1];
        Vector3f vector3f5 = vector3fArray[2];
        if (Math.min(Math.min(vector3f3.x, vector3f4.x), vector3f5.x) > vector3f2.x) {
            return false;
        }
        if (Math.max(Math.max(vector3f3.x, vector3f4.x), vector3f5.x) < vector3f.x) {
            return false;
        }
        if (Math.min(Math.min(vector3f3.z, vector3f4.z), vector3f5.z) > vector3f2.z) {
            return false;
        }
        if (Math.max(Math.max(vector3f3.z, vector3f4.z), vector3f5.z) < vector3f.z) {
            return false;
        }
        if (Math.min(Math.min(vector3f3.y, vector3f4.y), vector3f5.y) > vector3f2.y) {
            return false;
        }
        return !(Math.max(Math.max(vector3f3.y, vector3f4.y), vector3f5.y) < vector3f.y);
    }

    public static void transformAabb(Vector3f vector3f, float f, Transform transform, Vector3f vector3f2, Vector3f vector3f3) {
        Vector3f vector3f4 = (Vector3f)Pools.VECTORS.get();
        vector3f4.x = vector3f.x + f;
        vector3f4.y = vector3f.y + f;
        vector3f4.z = vector3f.z + f;
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get((Object)transform.basis);
        MatrixUtil.absolute(matrix3f);
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get((Object)transform.origin);
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get();
        matrix3f.getRow(0, vector3f5);
        vector3f7.x = vector3f5.dot(vector3f4);
        matrix3f.getRow(1, vector3f5);
        vector3f7.y = vector3f5.dot(vector3f4);
        matrix3f.getRow(2, vector3f5);
        vector3f7.z = vector3f5.dot(vector3f4);
        vector3f2.sub(vector3f6, vector3f7);
        vector3f3.add(vector3f6, vector3f7);
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f5, vector3f6, vector3f7, vector3f4});
    }

    public static void transformAabb(Vector3f vector3f, Vector3f vector3f2, float f, Transform transform, Vector3f vector3f3, Vector3f vector3f4) {
        assert (vector3f.x <= vector3f2.x);
        assert (vector3f.y <= vector3f2.y);
        assert (vector3f.z <= vector3f2.z);
        Vector3f vector3f5 = (Vector3f)Pools.VECTORS.get();
        vector3f5.sub(vector3f2, vector3f);
        vector3f5.scale(0.5f);
        vector3f5.x += f;
        vector3f5.y += f;
        vector3f5.z += f;
        Vector3f vector3f6 = (Vector3f)Pools.VECTORS.get();
        vector3f6.add(vector3f2, vector3f);
        vector3f6.scale(0.5f);
        Matrix3f matrix3f = (Matrix3f)Pools.MATRICES.get((Object)transform.basis);
        MatrixUtil.absolute(matrix3f);
        Vector3f vector3f7 = (Vector3f)Pools.VECTORS.get((Object)vector3f6);
        transform.transform(vector3f7);
        Vector3f vector3f8 = (Vector3f)Pools.VECTORS.get();
        Vector3f vector3f9 = (Vector3f)Pools.VECTORS.get();
        matrix3f.getRow(0, vector3f9);
        vector3f8.x = vector3f9.dot(vector3f5);
        matrix3f.getRow(1, vector3f9);
        vector3f8.y = vector3f9.dot(vector3f5);
        matrix3f.getRow(2, vector3f9);
        vector3f8.z = vector3f9.dot(vector3f5);
        vector3f3.sub(vector3f7, vector3f8);
        vector3f4.add(vector3f7, vector3f8);
        Pools.MATRICES.release((Object[])new Matrix3f[]{matrix3f});
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f9, vector3f7, vector3f8, vector3f5});
    }
}

