/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.linearmath;

import com.bulletphysics.Pools;
import com.bulletphysics.linearmath.VectorUtil;
import com.bulletphysics.util.ArrayPool;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class MatrixUtil {
    public static void scale(Matrix3f matrix3f, Matrix3f matrix3f2, Vector3f vector3f) {
        matrix3f.m00 = matrix3f2.m00 * vector3f.x;
        matrix3f.m01 = matrix3f2.m01 * vector3f.y;
        matrix3f.m02 = matrix3f2.m02 * vector3f.z;
        matrix3f.m10 = matrix3f2.m10 * vector3f.x;
        matrix3f.m11 = matrix3f2.m11 * vector3f.y;
        matrix3f.m12 = matrix3f2.m12 * vector3f.z;
        matrix3f.m20 = matrix3f2.m20 * vector3f.x;
        matrix3f.m21 = matrix3f2.m21 * vector3f.y;
        matrix3f.m22 = matrix3f2.m22 * vector3f.z;
    }

    public static void absolute(Matrix3f matrix3f) {
        matrix3f.m00 = Math.abs(matrix3f.m00);
        matrix3f.m01 = Math.abs(matrix3f.m01);
        matrix3f.m02 = Math.abs(matrix3f.m02);
        matrix3f.m10 = Math.abs(matrix3f.m10);
        matrix3f.m11 = Math.abs(matrix3f.m11);
        matrix3f.m12 = Math.abs(matrix3f.m12);
        matrix3f.m20 = Math.abs(matrix3f.m20);
        matrix3f.m21 = Math.abs(matrix3f.m21);
        matrix3f.m22 = Math.abs(matrix3f.m22);
    }

    public static void setFromOpenGLSubMatrix(Matrix3f matrix3f, float[] fArray) {
        matrix3f.m00 = fArray[0];
        matrix3f.m01 = fArray[4];
        matrix3f.m02 = fArray[8];
        matrix3f.m10 = fArray[1];
        matrix3f.m11 = fArray[5];
        matrix3f.m12 = fArray[9];
        matrix3f.m20 = fArray[2];
        matrix3f.m21 = fArray[6];
        matrix3f.m22 = fArray[10];
    }

    public static void getOpenGLSubMatrix(Matrix3f matrix3f, float[] fArray) {
        fArray[0] = matrix3f.m00;
        fArray[1] = matrix3f.m10;
        fArray[2] = matrix3f.m20;
        fArray[3] = 0.0f;
        fArray[4] = matrix3f.m01;
        fArray[5] = matrix3f.m11;
        fArray[6] = matrix3f.m21;
        fArray[7] = 0.0f;
        fArray[8] = matrix3f.m02;
        fArray[9] = matrix3f.m12;
        fArray[10] = matrix3f.m22;
        fArray[11] = 0.0f;
    }

    public static void setEulerZYX(Matrix3f matrix3f, float f, float f2, float f3) {
        float f4 = (float)Math.cos(f);
        float f5 = (float)Math.cos(f2);
        float f6 = (float)Math.cos(f3);
        float f7 = (float)Math.sin(f);
        float f8 = (float)Math.sin(f2);
        float f9 = (float)Math.sin(f3);
        float f10 = f4 * f6;
        float f11 = f4 * f9;
        float f12 = f7 * f6;
        float f13 = f7 * f9;
        matrix3f.setRow(0, f5 * f6, f8 * f12 - f11, f8 * f10 + f13);
        matrix3f.setRow(1, f5 * f9, f8 * f13 + f10, f8 * f11 - f12);
        matrix3f.setRow(2, -f8, f5 * f7, f5 * f4);
    }

    private static float tdotx(Matrix3f matrix3f, Vector3f vector3f) {
        return matrix3f.m00 * vector3f.x + matrix3f.m10 * vector3f.y + matrix3f.m20 * vector3f.z;
    }

    private static float tdoty(Matrix3f matrix3f, Vector3f vector3f) {
        return matrix3f.m01 * vector3f.x + matrix3f.m11 * vector3f.y + matrix3f.m21 * vector3f.z;
    }

    private static float tdotz(Matrix3f matrix3f, Vector3f vector3f) {
        return matrix3f.m02 * vector3f.x + matrix3f.m12 * vector3f.y + matrix3f.m22 * vector3f.z;
    }

    public static void transposeTransform(Vector3f vector3f, Vector3f vector3f2, Matrix3f matrix3f) {
        float f = MatrixUtil.tdotx(matrix3f, vector3f2);
        float f2 = MatrixUtil.tdoty(matrix3f, vector3f2);
        float f3 = MatrixUtil.tdotz(matrix3f, vector3f2);
        vector3f.x = f;
        vector3f.y = f2;
        vector3f.z = f3;
    }

    public static void setRotation(Matrix3f matrix3f, Quat4f quat4f) {
        float f = quat4f.x * quat4f.x + quat4f.y * quat4f.y + quat4f.z * quat4f.z + quat4f.w * quat4f.w;
        assert (f != 0.0f);
        float f2 = 2.0f / f;
        float f3 = quat4f.x * f2;
        float f4 = quat4f.y * f2;
        float f5 = quat4f.z * f2;
        float f6 = quat4f.w * f3;
        float f7 = quat4f.w * f4;
        float f8 = quat4f.w * f5;
        float f9 = quat4f.x * f3;
        float f10 = quat4f.x * f4;
        float f11 = quat4f.x * f5;
        float f12 = quat4f.y * f4;
        float f13 = quat4f.y * f5;
        float f14 = quat4f.z * f5;
        matrix3f.m00 = 1.0f - (f12 + f14);
        matrix3f.m01 = f10 - f8;
        matrix3f.m02 = f11 + f7;
        matrix3f.m10 = f10 + f8;
        matrix3f.m11 = 1.0f - (f9 + f14);
        matrix3f.m12 = f13 - f6;
        matrix3f.m20 = f11 - f7;
        matrix3f.m21 = f13 + f6;
        matrix3f.m22 = 1.0f - (f9 + f12);
    }

    public static void getRotation(Matrix3f matrix3f, Quat4f quat4f) {
        ArrayPool<float[]> arrayPool = ArrayPool.get(Float.TYPE);
        float f = matrix3f.m00 + matrix3f.m11 + matrix3f.m22;
        float[] fArray = (float[])arrayPool.getFixed(4);
        if (f > 0.0f) {
            float f2 = (float)Math.sqrt(f + 1.0f);
            fArray[3] = f2 * 0.5f;
            f2 = 0.5f / f2;
            fArray[0] = (matrix3f.m21 - matrix3f.m12) * f2;
            fArray[1] = (matrix3f.m02 - matrix3f.m20) * f2;
            fArray[2] = (matrix3f.m10 - matrix3f.m01) * f2;
        } else {
            int n = matrix3f.m00 < matrix3f.m11 ? (matrix3f.m11 < matrix3f.m22 ? 2 : 1) : (matrix3f.m00 < matrix3f.m22 ? 2 : 0);
            int n2 = (n + 1) % 3;
            int n3 = (n + 2) % 3;
            float f3 = (float)Math.sqrt(matrix3f.getElement(n, n) - matrix3f.getElement(n2, n2) - matrix3f.getElement(n3, n3) + 1.0f);
            fArray[n] = f3 * 0.5f;
            f3 = 0.5f / f3;
            fArray[3] = (matrix3f.getElement(n3, n2) - matrix3f.getElement(n2, n3)) * f3;
            fArray[n2] = (matrix3f.getElement(n2, n) + matrix3f.getElement(n, n2)) * f3;
            fArray[n3] = (matrix3f.getElement(n3, n) + matrix3f.getElement(n, n3)) * f3;
        }
        quat4f.set(fArray[0], fArray[1], fArray[2], fArray[3]);
        arrayPool.release(fArray);
    }

    private static float cofac(Matrix3f matrix3f, int n, int n2, int n3, int n4) {
        return matrix3f.getElement(n, n2) * matrix3f.getElement(n3, n4) - matrix3f.getElement(n, n4) * matrix3f.getElement(n3, n2);
    }

    public static void invert(Matrix3f matrix3f) {
        float f = MatrixUtil.cofac(matrix3f, 1, 1, 2, 2);
        float f2 = MatrixUtil.cofac(matrix3f, 1, 2, 2, 0);
        float f3 = MatrixUtil.cofac(matrix3f, 1, 0, 2, 1);
        float f4 = matrix3f.m00 * f + matrix3f.m01 * f2 + matrix3f.m02 * f3;
        assert (f4 != 0.0f);
        float f5 = 1.0f / f4;
        float f6 = f * f5;
        float f7 = MatrixUtil.cofac(matrix3f, 0, 2, 2, 1) * f5;
        float f8 = MatrixUtil.cofac(matrix3f, 0, 1, 1, 2) * f5;
        float f9 = f2 * f5;
        float f10 = MatrixUtil.cofac(matrix3f, 0, 0, 2, 2) * f5;
        float f11 = MatrixUtil.cofac(matrix3f, 0, 2, 1, 0) * f5;
        float f12 = f3 * f5;
        float f13 = MatrixUtil.cofac(matrix3f, 0, 1, 2, 0) * f5;
        float f14 = MatrixUtil.cofac(matrix3f, 0, 0, 1, 1) * f5;
        matrix3f.m00 = f6;
        matrix3f.m01 = f7;
        matrix3f.m02 = f8;
        matrix3f.m10 = f9;
        matrix3f.m11 = f10;
        matrix3f.m12 = f11;
        matrix3f.m20 = f12;
        matrix3f.m21 = f13;
        matrix3f.m22 = f14;
    }

    public static void diagonalize(Matrix3f matrix3f, Matrix3f matrix3f2, float f, int n) {
        Vector3f vector3f = (Vector3f)Pools.VECTORS.get();
        matrix3f2.setIdentity();
        int n2 = n;
        while (n2 > 0) {
            float f2;
            float f3;
            float f4;
            int n3 = 0;
            int n4 = 1;
            int n5 = 2;
            float f5 = Math.abs(matrix3f.m01);
            float f6 = Math.abs(matrix3f.m02);
            if (f6 > f5) {
                n4 = 2;
                n5 = 1;
                f5 = f6;
            }
            if ((f6 = Math.abs(matrix3f.m12)) > f5) {
                n3 = 1;
                n4 = 2;
                n5 = 0;
                f5 = f6;
            }
            if (f5 <= (f4 = f * (Math.abs(matrix3f.m00) + Math.abs(matrix3f.m11) + Math.abs(matrix3f.m22)))) {
                if (f5 <= 1.1920929E-7f * f4) {
                    return;
                }
                n2 = 1;
            }
            float f7 = matrix3f.getElement(n3, n4);
            float f8 = (matrix3f.getElement(n4, n4) - matrix3f.getElement(n3, n3)) / (2.0f * f7);
            float f9 = f8 * f8;
            if (f9 * f9 < 8.388608E7f) {
                f4 = f8 >= 0.0f ? 1.0f / (f8 + (float)Math.sqrt(1.0f + f9)) : 1.0f / (f8 - (float)Math.sqrt(1.0f + f9));
                f3 = 1.0f / (float)Math.sqrt(1.0f + f4 * f4);
                f2 = f3 * f4;
            } else {
                f4 = 1.0f / (f8 * (2.0f + 0.5f / f9));
                f3 = 1.0f - 0.5f * f4 * f4;
                f2 = f3 * f4;
            }
            matrix3f.setElement(n3, n4, 0.0f);
            matrix3f.setElement(n4, n3, 0.0f);
            matrix3f.setElement(n3, n3, matrix3f.getElement(n3, n3) - f4 * f7);
            matrix3f.setElement(n4, n4, matrix3f.getElement(n4, n4) + f4 * f7);
            float f10 = matrix3f.getElement(n5, n3);
            float f11 = matrix3f.getElement(n5, n4);
            matrix3f.setElement(n5, n3, f3 * f10 - f2 * f11);
            matrix3f.setElement(n3, n5, f3 * f10 - f2 * f11);
            matrix3f.setElement(n5, n4, f3 * f11 + f2 * f10);
            matrix3f.setElement(n4, n5, f3 * f11 + f2 * f10);
            int n6 = 0;
            while (n6 < 3) {
                matrix3f2.getRow(n6, vector3f);
                f10 = VectorUtil.getCoord(vector3f, n3);
                f11 = VectorUtil.getCoord(vector3f, n4);
                VectorUtil.setCoord(vector3f, n3, f3 * f10 - f2 * f11);
                VectorUtil.setCoord(vector3f, n4, f3 * f11 + f2 * f10);
                matrix3f2.setRow(n6, vector3f);
                ++n6;
            }
            --n2;
        }
        Pools.VECTORS.release((Object[])new Vector3f[]{vector3f});
    }
}

