/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Rot;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.SolverData;
import org.jbox2d.dynamics.joints.GearJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointType;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.pooling.IWorldPool;

public class GearJoint
extends Joint {
    private final Joint m_joint1;
    private final Joint m_joint2;
    private final JointType m_typeA;
    private final JointType m_typeB;
    private final Body m_bodyC;
    private final Body m_bodyD;
    private final Vec2 m_localAnchorA = new Vec2();
    private final Vec2 m_localAnchorB = new Vec2();
    private final Vec2 m_localAnchorC = new Vec2();
    private final Vec2 m_localAnchorD = new Vec2();
    private final Vec2 m_localAxisC = new Vec2();
    private final Vec2 m_localAxisD = new Vec2();
    private float m_referenceAngleA;
    private float m_referenceAngleB;
    private float m_constant;
    private float m_ratio;
    private float m_impulse;
    private int m_indexA;
    private int m_indexB;
    private int m_indexC;
    private int m_indexD;
    private final Vec2 m_lcA = new Vec2();
    private final Vec2 m_lcB = new Vec2();
    private final Vec2 m_lcC = new Vec2();
    private final Vec2 m_lcD = new Vec2();
    private float m_mA;
    private float m_mB;
    private float m_mC;
    private float m_mD;
    private float m_iA;
    private float m_iB;
    private float m_iC;
    private float m_iD;
    private final Vec2 m_JvAC = new Vec2();
    private final Vec2 m_JvBD = new Vec2();
    private float m_JwA;
    private float m_JwB;
    private float m_JwC;
    private float m_JwD;
    private float m_mass;

    protected GearJoint(IWorldPool iWorldPool, GearJointDef gearJointDef) {
        super(iWorldPool, gearJointDef);
        float f;
        Object object;
        float f2;
        Object object2;
        this.m_joint1 = gearJointDef.joint1;
        this.m_joint2 = gearJointDef.joint2;
        this.m_typeA = this.m_joint1.getType();
        this.m_typeB = this.m_joint2.getType();
        assert (this.m_typeA == JointType.REVOLUTE || this.m_typeA == JointType.PRISMATIC);
        assert (this.m_typeB == JointType.REVOLUTE || this.m_typeB == JointType.PRISMATIC);
        this.m_bodyC = this.m_joint1.getBodyA();
        this.m_bodyA = this.m_joint1.getBodyB();
        Transform transform = this.m_bodyA.m_xf;
        float f3 = this.m_bodyA.m_sweep.a;
        Transform transform2 = this.m_bodyC.m_xf;
        float f4 = this.m_bodyC.m_sweep.a;
        if (this.m_typeA == JointType.REVOLUTE) {
            object2 = (RevoluteJoint)gearJointDef.joint1;
            this.m_localAnchorC.set(((RevoluteJoint)object2).m_localAnchorA);
            this.m_localAnchorA.set(((RevoluteJoint)object2).m_localAnchorB);
            this.m_referenceAngleA = ((RevoluteJoint)object2).m_referenceAngle;
            this.m_localAxisC.setZero();
            f2 = f3 - f4 - this.m_referenceAngleA;
        } else {
            object2 = this.pool.popVec2();
            Vec2 vec2 = this.pool.popVec2();
            object = (PrismaticJoint)gearJointDef.joint1;
            this.m_localAnchorC.set(((PrismaticJoint)object).m_localAnchorA);
            this.m_localAnchorA.set(((PrismaticJoint)object).m_localAnchorB);
            this.m_referenceAngleA = ((PrismaticJoint)object).m_referenceAngle;
            this.m_localAxisC.set(((PrismaticJoint)object).m_localXAxisA);
            Vec2 vec22 = this.m_localAnchorC;
            Rot.mulToOutUnsafe(transform.q, this.m_localAnchorA, vec2);
            vec2.addLocal(transform.p).subLocal(transform2.p);
            Rot.mulTransUnsafe(transform2.q, vec2, (Vec2)object2);
            f2 = Vec2.dot(((Vec2)object2).subLocal(vec22), this.m_localAxisC);
            this.pool.pushVec2(2);
        }
        this.m_bodyD = this.m_joint2.getBodyA();
        this.m_bodyB = this.m_joint2.getBodyB();
        object2 = this.m_bodyB.m_xf;
        float f5 = this.m_bodyB.m_sweep.a;
        object = this.m_bodyD.m_xf;
        float f6 = this.m_bodyD.m_sweep.a;
        if (this.m_typeB == JointType.REVOLUTE) {
            RevoluteJoint revoluteJoint = (RevoluteJoint)gearJointDef.joint2;
            this.m_localAnchorD.set(revoluteJoint.m_localAnchorA);
            this.m_localAnchorB.set(revoluteJoint.m_localAnchorB);
            this.m_referenceAngleB = revoluteJoint.m_referenceAngle;
            this.m_localAxisD.setZero();
            f = f5 - f6 - this.m_referenceAngleB;
        } else {
            Vec2 vec2 = this.pool.popVec2();
            Vec2 vec23 = this.pool.popVec2();
            PrismaticJoint prismaticJoint = (PrismaticJoint)gearJointDef.joint2;
            this.m_localAnchorD.set(prismaticJoint.m_localAnchorA);
            this.m_localAnchorB.set(prismaticJoint.m_localAnchorB);
            this.m_referenceAngleB = prismaticJoint.m_referenceAngle;
            this.m_localAxisD.set(prismaticJoint.m_localXAxisA);
            Vec2 vec24 = this.m_localAnchorD;
            Rot.mulToOutUnsafe(((Transform)object2).q, this.m_localAnchorB, vec23);
            vec23.addLocal(((Transform)object2).p).subLocal(((Transform)object).p);
            Rot.mulTransUnsafe(((Transform)object).q, vec23, vec2);
            f = Vec2.dot(vec2.subLocal(vec24), this.m_localAxisD);
            this.pool.pushVec2(2);
        }
        this.m_ratio = gearJointDef.ratio;
        this.m_constant = f2 + this.m_ratio * f;
        this.m_impulse = 0.0f;
    }

    @Override
    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, vec2);
    }

    @Override
    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, vec2);
    }

    @Override
    public void getReactionForce(float f, Vec2 vec2) {
        vec2.set(this.m_JvAC).mulLocal(this.m_impulse);
        vec2.mulLocal(f);
    }

    @Override
    public float getReactionTorque(float f) {
        float f2 = this.m_impulse * this.m_JwA;
        return f * f2;
    }

    public void setRatio(float f) {
        this.m_ratio = f;
    }

    public float getRatio() {
        return this.m_ratio;
    }

    @Override
    public void initVelocityConstraints(SolverData solverData) {
        Vec2 vec2;
        Vec2 vec22;
        this.m_indexA = this.m_bodyA.m_islandIndex;
        this.m_indexB = this.m_bodyB.m_islandIndex;
        this.m_indexC = this.m_bodyC.m_islandIndex;
        this.m_indexD = this.m_bodyD.m_islandIndex;
        this.m_lcA.set(this.m_bodyA.m_sweep.localCenter);
        this.m_lcB.set(this.m_bodyB.m_sweep.localCenter);
        this.m_lcC.set(this.m_bodyC.m_sweep.localCenter);
        this.m_lcD.set(this.m_bodyD.m_sweep.localCenter);
        this.m_mA = this.m_bodyA.m_invMass;
        this.m_mB = this.m_bodyB.m_invMass;
        this.m_mC = this.m_bodyC.m_invMass;
        this.m_mD = this.m_bodyD.m_invMass;
        this.m_iA = this.m_bodyA.m_invI;
        this.m_iB = this.m_bodyB.m_invI;
        this.m_iC = this.m_bodyC.m_invI;
        this.m_iD = this.m_bodyD.m_invI;
        float f = solverData.positions[this.m_indexA].a;
        Vec2 vec23 = solverData.velocities[this.m_indexA].v;
        float f2 = solverData.velocities[this.m_indexA].w;
        float f3 = solverData.positions[this.m_indexB].a;
        Vec2 vec24 = solverData.velocities[this.m_indexB].v;
        float f4 = solverData.velocities[this.m_indexB].w;
        float f5 = solverData.positions[this.m_indexC].a;
        Vec2 vec25 = solverData.velocities[this.m_indexC].v;
        float f6 = solverData.velocities[this.m_indexC].w;
        float f7 = solverData.positions[this.m_indexD].a;
        Vec2 vec26 = solverData.velocities[this.m_indexD].v;
        float f8 = solverData.velocities[this.m_indexD].w;
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Rot rot3 = this.pool.popRot();
        Rot rot4 = this.pool.popRot();
        rot.set(f);
        rot2.set(f3);
        rot3.set(f5);
        rot4.set(f7);
        this.m_mass = 0.0f;
        Vec2 vec27 = this.pool.popVec2();
        if (this.m_typeA == JointType.REVOLUTE) {
            this.m_JvAC.setZero();
            this.m_JwA = 1.0f;
            this.m_JwC = 1.0f;
            this.m_mass += this.m_iA + this.m_iC;
        } else {
            vec22 = this.pool.popVec2();
            vec2 = this.pool.popVec2();
            Rot.mulToOutUnsafe(rot3, this.m_localAxisC, this.m_JvAC);
            Rot.mulToOutUnsafe(rot3, vec27.set(this.m_localAnchorC).subLocal(this.m_lcC), vec22);
            Rot.mulToOutUnsafe(rot, vec27.set(this.m_localAnchorA).subLocal(this.m_lcA), vec2);
            this.m_JwC = Vec2.cross(vec22, this.m_JvAC);
            this.m_JwA = Vec2.cross(vec2, this.m_JvAC);
            this.m_mass += this.m_mC + this.m_mA + this.m_iC * this.m_JwC * this.m_JwC + this.m_iA * this.m_JwA * this.m_JwA;
            this.pool.pushVec2(2);
        }
        if (this.m_typeB == JointType.REVOLUTE) {
            this.m_JvBD.setZero();
            this.m_JwB = this.m_ratio;
            this.m_JwD = this.m_ratio;
            this.m_mass += this.m_ratio * this.m_ratio * (this.m_iB + this.m_iD);
        } else {
            vec22 = this.pool.popVec2();
            vec2 = this.pool.popVec2();
            Vec2 vec28 = this.pool.popVec2();
            Rot.mulToOutUnsafe(rot4, this.m_localAxisD, vec22);
            Rot.mulToOutUnsafe(rot4, vec27.set(this.m_localAnchorD).subLocal(this.m_lcD), vec2);
            Rot.mulToOutUnsafe(rot2, vec27.set(this.m_localAnchorB).subLocal(this.m_lcB), vec28);
            this.m_JvBD.set(vec22).mulLocal(this.m_ratio);
            this.m_JwD = this.m_ratio * Vec2.cross(vec2, vec22);
            this.m_JwB = this.m_ratio * Vec2.cross(vec28, vec22);
            this.m_mass += this.m_ratio * this.m_ratio * (this.m_mD + this.m_mB) + this.m_iD * this.m_JwD * this.m_JwD + this.m_iB * this.m_JwB * this.m_JwB;
            this.pool.pushVec2(3);
        }
        float f9 = this.m_mass = this.m_mass > 0.0f ? 1.0f / this.m_mass : 0.0f;
        if (solverData.step.warmStarting) {
            vec23.x += this.m_mA * this.m_impulse * this.m_JvAC.x;
            vec23.y += this.m_mA * this.m_impulse * this.m_JvAC.y;
            f2 += this.m_iA * this.m_impulse * this.m_JwA;
            vec24.x += this.m_mB * this.m_impulse * this.m_JvBD.x;
            vec24.y += this.m_mB * this.m_impulse * this.m_JvBD.y;
            f4 += this.m_iB * this.m_impulse * this.m_JwB;
            vec25.x -= this.m_mC * this.m_impulse * this.m_JvAC.x;
            vec25.y -= this.m_mC * this.m_impulse * this.m_JvAC.y;
            f6 -= this.m_iC * this.m_impulse * this.m_JwC;
            vec26.x -= this.m_mD * this.m_impulse * this.m_JvBD.x;
            vec26.y -= this.m_mD * this.m_impulse * this.m_JvBD.y;
            f8 -= this.m_iD * this.m_impulse * this.m_JwD;
        } else {
            this.m_impulse = 0.0f;
        }
        this.pool.pushVec2(1);
        this.pool.pushRot(4);
        solverData.velocities[this.m_indexA].w = f2;
        solverData.velocities[this.m_indexB].w = f4;
        solverData.velocities[this.m_indexC].w = f6;
        solverData.velocities[this.m_indexD].w = f8;
    }

    @Override
    public void solveVelocityConstraints(SolverData solverData) {
        Vec2 vec2 = solverData.velocities[this.m_indexA].v;
        float f = solverData.velocities[this.m_indexA].w;
        Vec2 vec22 = solverData.velocities[this.m_indexB].v;
        float f2 = solverData.velocities[this.m_indexB].w;
        Vec2 vec23 = solverData.velocities[this.m_indexC].v;
        float f3 = solverData.velocities[this.m_indexC].w;
        Vec2 vec24 = solverData.velocities[this.m_indexD].v;
        float f4 = solverData.velocities[this.m_indexD].w;
        Vec2 vec25 = this.pool.popVec2();
        Vec2 vec26 = this.pool.popVec2();
        float f5 = Vec2.dot(this.m_JvAC, vec25.set(vec2).subLocal(vec23)) + Vec2.dot(this.m_JvBD, vec26.set(vec22).subLocal(vec24));
        this.pool.pushVec2(2);
        float f6 = -this.m_mass * (f5 += this.m_JwA * f - this.m_JwC * f3 + (this.m_JwB * f2 - this.m_JwD * f4));
        this.m_impulse += f6;
        vec2.x += this.m_mA * f6 * this.m_JvAC.x;
        vec2.y += this.m_mA * f6 * this.m_JvAC.y;
        f += this.m_iA * f6 * this.m_JwA;
        vec22.x += this.m_mB * f6 * this.m_JvBD.x;
        vec22.y += this.m_mB * f6 * this.m_JvBD.y;
        f2 += this.m_iB * f6 * this.m_JwB;
        vec23.x -= this.m_mC * f6 * this.m_JvAC.x;
        vec23.y -= this.m_mC * f6 * this.m_JvAC.y;
        vec24.x -= this.m_mD * f6 * this.m_JvBD.x;
        vec24.y -= this.m_mD * f6 * this.m_JvBD.y;
        solverData.velocities[this.m_indexA].w = f;
        solverData.velocities[this.m_indexB].w = f2;
        solverData.velocities[this.m_indexC].w = f3 -= this.m_iC * f6 * this.m_JwC;
        solverData.velocities[this.m_indexD].w = f4 -= this.m_iD * f6 * this.m_JwD;
    }

    public Joint getJoint1() {
        return this.m_joint1;
    }

    public Joint getJoint2() {
        return this.m_joint2;
    }

    @Override
    public boolean solvePositionConstraints(SolverData solverData) {
        float f;
        float f2;
        float f3;
        Vec2 vec2;
        Vec2 vec22;
        Vec2 vec23;
        Vec2 vec24;
        float f4;
        float f5;
        float f6;
        Vec2 vec25 = solverData.positions[this.m_indexA].c;
        float f7 = solverData.positions[this.m_indexA].a;
        Vec2 vec26 = solverData.positions[this.m_indexB].c;
        float f8 = solverData.positions[this.m_indexB].a;
        Vec2 vec27 = solverData.positions[this.m_indexC].c;
        float f9 = solverData.positions[this.m_indexC].a;
        Vec2 vec28 = solverData.positions[this.m_indexD].c;
        float f10 = solverData.positions[this.m_indexD].a;
        Rot rot = this.pool.popRot();
        Rot rot2 = this.pool.popRot();
        Rot rot3 = this.pool.popRot();
        Rot rot4 = this.pool.popRot();
        rot.set(f7);
        rot2.set(f8);
        rot3.set(f9);
        rot4.set(f10);
        float f11 = 0.0f;
        Vec2 vec29 = this.pool.popVec2();
        Vec2 vec210 = this.pool.popVec2();
        Vec2 vec211 = this.pool.popVec2();
        float f12 = 0.0f;
        if (this.m_typeA == JointType.REVOLUTE) {
            vec210.setZero();
            f6 = 1.0f;
            f5 = 1.0f;
            f12 += this.m_iA + this.m_iC;
            f4 = f7 - f9 - this.m_referenceAngleA;
        } else {
            vec24 = this.pool.popVec2();
            vec23 = this.pool.popVec2();
            vec22 = this.pool.popVec2();
            vec2 = this.pool.popVec2();
            Rot.mulToOutUnsafe(rot3, this.m_localAxisC, vec210);
            Rot.mulToOutUnsafe(rot3, vec29.set(this.m_localAnchorC).subLocal(this.m_lcC), vec24);
            Rot.mulToOutUnsafe(rot, vec29.set(this.m_localAnchorA).subLocal(this.m_lcA), vec23);
            f5 = Vec2.cross(vec24, vec210);
            f6 = Vec2.cross(vec23, vec210);
            f12 += this.m_mC + this.m_mA + this.m_iC * f5 * f5 + this.m_iA * f6 * f6;
            vec22.set(this.m_localAnchorC).subLocal(this.m_lcC);
            Rot.mulTransUnsafe(rot3, vec29.set(vec23).addLocal(vec25).subLocal(vec27), vec2);
            f4 = Vec2.dot(vec2.subLocal(vec22), this.m_localAxisC);
            this.pool.pushVec2(4);
        }
        if (this.m_typeB == JointType.REVOLUTE) {
            vec211.setZero();
            f3 = this.m_ratio;
            f2 = this.m_ratio;
            f12 += this.m_ratio * this.m_ratio * (this.m_iB + this.m_iD);
            f = f8 - f10 - this.m_referenceAngleB;
        } else {
            vec24 = this.pool.popVec2();
            vec23 = this.pool.popVec2();
            vec22 = this.pool.popVec2();
            vec2 = this.pool.popVec2();
            Vec2 vec212 = this.pool.popVec2();
            Rot.mulToOutUnsafe(rot4, this.m_localAxisD, vec24);
            Rot.mulToOutUnsafe(rot4, vec29.set(this.m_localAnchorD).subLocal(this.m_lcD), vec23);
            Rot.mulToOutUnsafe(rot2, vec29.set(this.m_localAnchorB).subLocal(this.m_lcB), vec22);
            vec211.set(vec24).mulLocal(this.m_ratio);
            f2 = Vec2.cross(vec23, vec24);
            f3 = Vec2.cross(vec22, vec24);
            f12 += this.m_ratio * this.m_ratio * (this.m_mD + this.m_mB) + this.m_iD * f2 * f2 + this.m_iB * f3 * f3;
            vec2.set(this.m_localAnchorD).subLocal(this.m_lcD);
            Rot.mulTransUnsafe(rot4, vec29.set(vec22).addLocal(vec26).subLocal(vec28), vec212);
            f = Vec2.dot(vec212.subLocal(vec2), this.m_localAxisD);
            this.pool.pushVec2(5);
        }
        float f13 = f4 + this.m_ratio * f - this.m_constant;
        float f14 = 0.0f;
        if (f12 > 0.0f) {
            f14 = -f13 / f12;
        }
        this.pool.pushVec2(3);
        this.pool.pushRot(4);
        vec25.x += this.m_mA * f14 * vec210.x;
        vec25.y += this.m_mA * f14 * vec210.y;
        f7 += this.m_iA * f14 * f6;
        vec26.x += this.m_mB * f14 * vec211.x;
        vec26.y += this.m_mB * f14 * vec211.y;
        f8 += this.m_iB * f14 * f3;
        vec27.x -= this.m_mC * f14 * vec210.x;
        vec27.y -= this.m_mC * f14 * vec210.y;
        vec28.x -= this.m_mD * f14 * vec211.x;
        vec28.y -= this.m_mD * f14 * vec211.y;
        solverData.positions[this.m_indexA].a = f7;
        solverData.positions[this.m_indexB].a = f8;
        solverData.positions[this.m_indexC].a = f9 -= this.m_iC * f14 * f5;
        solverData.positions[this.m_indexD].a = f10 -= this.m_iD * f14 * f2;
        return f11 < Settings.linearSlop;
    }
}

