/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import gama.core.util.ByteArrayZipper;
import gama.gaml.compilation.kernel.GamaClassLoader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nustaq.serialization.FSTClassInstantiator;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzInfoRegistry;
import org.nustaq.serialization.FSTClazzNameRegistry;
import org.nustaq.serialization.FSTDecoder;
import org.nustaq.serialization.FSTDefaultClassInstantiator;
import org.nustaq.serialization.FSTEncoder;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.FSTSerializerRegistry;
import org.nustaq.serialization.coders.FSTStreamDecoder;
import org.nustaq.serialization.coders.FSTStreamEncoder;
import org.nustaq.serialization.serializers.FSTArrayListSerializer;
import org.nustaq.serialization.serializers.FSTBigIntegerSerializer;
import org.nustaq.serialization.serializers.FSTBigNumberSerializers;
import org.nustaq.serialization.serializers.FSTBitSetSerializer;
import org.nustaq.serialization.serializers.FSTClassSerializer;
import org.nustaq.serialization.serializers.FSTCollectionSerializer;
import org.nustaq.serialization.serializers.FSTDateSerializer;
import org.nustaq.serialization.serializers.FSTEnumSetSerializer;
import org.nustaq.serialization.serializers.FSTMapSerializer;
import org.nustaq.serialization.serializers.FSTStringBufferSerializer;
import org.nustaq.serialization.serializers.FSTStringBuilderSerializer;
import org.nustaq.serialization.serializers.FSTStringSerializer;
import org.nustaq.serialization.serializers.FSTThrowableSerializer;
import org.nustaq.serialization.serializers.FSTTimestampSerializer;
import org.nustaq.serialization.util.DefaultFSTInt2ObjectMapFactory;
import org.nustaq.serialization.util.FSTInt2ObjectMapFactory;
import org.nustaq.serialization.util.FSTUtil;

public class FSTConfiguration {
    private final StreamCoderFactory streamCoderFactory = new FSTDefaultStreamCoderFactory(this);
    private String name;
    private final FSTClazzInfoRegistry serializationInfoRegistry = new FSTClazzInfoRegistry();
    private final HashMap<Class, List<SoftReference>> cachedObjects = new HashMap(97);
    FSTInt2ObjectMapFactory intToObjectMapFactory = new DefaultFSTInt2ObjectMapFactory();
    private final FSTClazzNameRegistry classRegistry = new FSTClazzNameRegistry(null);
    private final ClassLoader classLoader = GamaClassLoader.getInstance();
    private final FSTClassInstantiator instantiator = new FSTDefaultClassInstantiator();
    final ConcurrentHashMap<FieldKey, FSTClazzInfo.FSTFieldInfo> fieldInfoCache;
    AtomicBoolean cacheLock = new AtomicBoolean(false);

    public FSTInt2ObjectMapFactory getIntToObjectMapFactory() {
        return this.intToObjectMapFactory;
    }

    public static FSTConfiguration createDefaultConfiguration() {
        FSTConfiguration fSTConfiguration = new FSTConfiguration();
        fSTConfiguration.registerIntToObjectMapFactory(new DefaultFSTInt2ObjectMapFactory());
        fSTConfiguration.addDefaultClazzes();
        FSTSerializerRegistry fSTSerializerRegistry = fSTConfiguration.getCLInfoRegistry().getSerializerRegistry();
        fSTSerializerRegistry.putSerializer(Class.class, new FSTClassSerializer(), false);
        fSTSerializerRegistry.putSerializer(String.class, new FSTStringSerializer(), false);
        fSTSerializerRegistry.putSerializer(Byte.class, new FSTBigNumberSerializers.FSTByteSerializer(), false);
        fSTSerializerRegistry.putSerializer(Character.class, new FSTBigNumberSerializers.FSTCharSerializer(), false);
        fSTSerializerRegistry.putSerializer(Short.class, new FSTBigNumberSerializers.FSTShortSerializer(), false);
        fSTSerializerRegistry.putSerializer(Float.class, new FSTBigNumberSerializers.FSTFloatSerializer(), false);
        fSTSerializerRegistry.putSerializer(Double.class, new FSTBigNumberSerializers.FSTDoubleSerializer(), false);
        fSTSerializerRegistry.putSerializer(java.util.Date.class, new FSTDateSerializer(), false);
        fSTSerializerRegistry.putSerializer(StringBuffer.class, new FSTStringBufferSerializer(), true);
        fSTSerializerRegistry.putSerializer(StringBuilder.class, new FSTStringBuilderSerializer(), true);
        fSTSerializerRegistry.putSerializer(EnumSet.class, new FSTEnumSetSerializer(), true);
        fSTSerializerRegistry.putSerializer(ArrayList.class, new FSTArrayListSerializer(), false);
        fSTSerializerRegistry.putSerializer(Vector.class, new FSTCollectionSerializer(), true);
        fSTSerializerRegistry.putSerializer(LinkedList.class, new FSTCollectionSerializer(), false);
        fSTSerializerRegistry.putSerializer(HashSet.class, new FSTCollectionSerializer(), false);
        fSTSerializerRegistry.putSerializer(HashMap.class, new FSTMapSerializer(), false);
        fSTSerializerRegistry.putSerializer(LinkedHashMap.class, new FSTMapSerializer(), false);
        fSTSerializerRegistry.putSerializer(Hashtable.class, new FSTMapSerializer(), true);
        fSTSerializerRegistry.putSerializer(ConcurrentHashMap.class, new FSTMapSerializer(), true);
        fSTSerializerRegistry.putSerializer(Throwable.class, new FSTThrowableSerializer(), true);
        fSTSerializerRegistry.putSerializer(BitSet.class, new FSTBitSetSerializer(), true);
        fSTSerializerRegistry.putSerializer(Timestamp.class, new FSTTimestampSerializer(), true);
        fSTSerializerRegistry.putSerializer(BigInteger.class, new FSTBigIntegerSerializer(), true);
        return fSTConfiguration;
    }

    void registerIntToObjectMapFactory(FSTInt2ObjectMapFactory fSTInt2ObjectMapFactory) {
        if (fSTInt2ObjectMapFactory != null) {
            this.intToObjectMapFactory = fSTInt2ObjectMapFactory;
        }
    }

    public void registerSerializer(Class<?> clazz, FSTObjectSerializer fSTObjectSerializer, boolean bl) {
        this.serializationInfoRegistry.getSerializerRegistry().putSerializer(clazz, fSTObjectSerializer, bl);
    }

    FSTClassInstantiator getInstantiator(Class<?> clazz) {
        return this.instantiator;
    }

    FSTConfiguration() {
        this.fieldInfoCache = new ConcurrentHashMap();
    }

    public void returnObject(Object object) {
        try {
            while (!this.cacheLock.compareAndSet(false, true)) {
            }
            List<SoftReference> list = this.cachedObjects.get(object.getClass());
            if (list == null) {
                list = new ArrayList<SoftReference>();
                this.cachedObjects.put(object.getClass(), list);
            }
            if (list.size() < 5) {
                list.add(new SoftReference<Object>(object));
            }
        }
        finally {
            this.cacheLock.set(false);
        }
    }

    public Object getCachedObject(Class<?> clazz) {
        try {
            while (!this.cacheLock.compareAndSet(false, true)) {
            }
            List<SoftReference> list = this.cachedObjects.get(clazz);
            if (list == null) {
                return null;
            }
            int n = list.size() - 1;
            while (n >= 0) {
                SoftReference softReference = list.get(n);
                Object t = softReference.get();
                list.remove(n);
                if (t != null) {
                    Object t2 = t;
                    return t2;
                }
                --n;
            }
        }
        finally {
            this.cacheLock.set(false);
        }
        return null;
    }

    public boolean isForceSerializable() {
        return true;
    }

    public boolean isShareReferences() {
        return true;
    }

    public void registerClass(Class<?> ... classArray) {
        Class<?>[] classArray2 = classArray;
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray2[n2];
            this.classRegistry.registerClass(clazz, this);
            try {
                Class<?> clazz2 = Class.forName("[L" + clazz.getName() + ";");
                this.classRegistry.registerClass(clazz2, this);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            ++n2;
        }
    }

    void addDefaultClazzes() {
        this.classRegistry.registerClass(String.class, this);
        this.classRegistry.registerClass(Byte.class, this);
        this.classRegistry.registerClass(Short.class, this);
        this.classRegistry.registerClass(Integer.class, this);
        this.classRegistry.registerClass(Long.class, this);
        this.classRegistry.registerClass(Float.class, this);
        this.classRegistry.registerClass(Double.class, this);
        this.classRegistry.registerClass(BigDecimal.class, this);
        this.classRegistry.registerClass(BigInteger.class, this);
        this.classRegistry.registerClass(Character.class, this);
        this.classRegistry.registerClass(Boolean.class, this);
        this.classRegistry.registerClass(TreeMap.class, this);
        this.classRegistry.registerClass(HashMap.class, this);
        this.classRegistry.registerClass(ArrayList.class, this);
        this.classRegistry.registerClass(ConcurrentHashMap.class, this);
        this.classRegistry.registerClass(URL.class, this);
        this.classRegistry.registerClass(java.util.Date.class, this);
        this.classRegistry.registerClass(Date.class, this);
        this.classRegistry.registerClass(SimpleDateFormat.class, this);
        this.classRegistry.registerClass(TreeSet.class, this);
        this.classRegistry.registerClass(LinkedList.class, this);
        this.classRegistry.registerClass(SimpleTimeZone.class, this);
        this.classRegistry.registerClass(GregorianCalendar.class, this);
        this.classRegistry.registerClass(Vector.class, this);
        this.classRegistry.registerClass(Hashtable.class, this);
        this.classRegistry.registerClass(BitSet.class, this);
        this.classRegistry.registerClass(Timestamp.class, this);
        this.classRegistry.registerClass(Locale.class, this);
        this.classRegistry.registerClass(StringBuffer.class, this);
        this.classRegistry.registerClass(StringBuilder.class, this);
        this.classRegistry.registerClass(Object.class, this);
        this.classRegistry.registerClass(Object[].class, this);
        this.classRegistry.registerClass(Object[][].class, this);
        this.classRegistry.registerClass(Object[][][].class, this);
        this.classRegistry.registerClass(byte[].class, this);
        this.classRegistry.registerClass(byte[][].class, this);
        this.classRegistry.registerClass(char[].class, this);
        this.classRegistry.registerClass(char[][].class, this);
        this.classRegistry.registerClass(short[].class, this);
        this.classRegistry.registerClass(short[][].class, this);
        this.classRegistry.registerClass(int[].class, this);
        this.classRegistry.registerClass(int[][].class, this);
        this.classRegistry.registerClass(float[].class, this);
        this.classRegistry.registerClass(float[][].class, this);
        this.classRegistry.registerClass(double[].class, this);
        this.classRegistry.registerClass(double[][].class, this);
        this.classRegistry.registerClass(long[].class, this);
        this.classRegistry.registerClass(long[][].class, this);
    }

    public FSTClazzNameRegistry getClassRegistry() {
        return this.classRegistry;
    }

    public FSTClazzInfoRegistry getCLInfoRegistry() {
        return this.serializationInfoRegistry;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public FSTClazzInfo getClassInfo(Class<?> clazz) {
        return this.serializationInfoRegistry.getCLInfo(clazz, this);
    }

    public FSTObjectInput getObjectInput(byte[] byArray) {
        return this.getObjectInput(byArray, byArray.length);
    }

    public FSTObjectInput getObjectInput(byte[] byArray, int n) {
        FSTObjectInput fSTObjectInput = this.getIn();
        try {
            fSTObjectInput.resetForReuseUseArray(byArray, n);
            return fSTObjectInput;
        }
        catch (IOException iOException) {
            FSTUtil.rethrow(iOException);
            return null;
        }
    }

    protected FSTObjectInput getIn() {
        FSTObjectInput fSTObjectInput = this.streamCoderFactory.getInput().get();
        if (fSTObjectInput != null && fSTObjectInput.isClosed()) {
            fSTObjectInput = null;
        }
        if (fSTObjectInput == null) {
            this.streamCoderFactory.getInput().set(new FSTObjectInput(this));
            return this.getIn();
        }
        fSTObjectInput.conf = this;
        fSTObjectInput.getCodec().setConf(this);
        return fSTObjectInput;
    }

    protected FSTObjectOutput getOut() {
        FSTObjectOutput fSTObjectOutput = this.streamCoderFactory.getOutput().get();
        if (fSTObjectOutput == null || fSTObjectOutput.closed) {
            this.streamCoderFactory.getOutput().set(new FSTObjectOutput(this));
            return this.getOut();
        }
        fSTObjectOutput.conf = this;
        fSTObjectOutput.getCodec().setConf(this);
        return fSTObjectOutput;
    }

    public FSTObjectOutput getObjectOutput(OutputStream outputStream) {
        FSTObjectOutput fSTObjectOutput = this.getOut();
        fSTObjectOutput.resetForReUse(outputStream);
        return fSTObjectOutput;
    }

    public FSTObjectOutput getObjectOutput() {
        return this.getObjectOutput(null);
    }

    public void setStructMode(boolean bl) {
        this.serializationInfoRegistry.setStructMode(bl);
    }

    public boolean isStructMode() {
        return this.serializationInfoRegistry.isStructMode();
    }

    public FSTClazzInfo getClazzInfo(Class<?> clazz) {
        return this.getCLInfoRegistry().getCLInfo(clazz, this);
    }

    public boolean isCrossPlatform() {
        return false;
    }

    public FSTEncoder createStreamEncoder() {
        return this.streamCoderFactory.createStreamEncoder();
    }

    public FSTDecoder createStreamDecoder() {
        return this.streamCoderFactory.createStreamDecoder();
    }

    public Object asObject(byte[] byArray) {
        try {
            byte[] byArray2 = ByteArrayZipper.unzip((byte[])byArray);
            return this.getObjectInput(byArray2).readObject();
        }
        catch (Exception exception) {
            System.out.println("unable to decode:" + new String(byArray, 0, 0, Math.min(byArray.length, 100)));
            FSTUtil.rethrow(exception);
            return null;
        }
    }

    public byte[] asByteArray(Object object) {
        FSTObjectOutput fSTObjectOutput = this.getObjectOutput();
        try {
            fSTObjectOutput.writeObject(object);
            return ByteArrayZipper.zip((byte[])fSTObjectOutput.getCopyOfWrittenBuffer());
        }
        catch (IOException iOException) {
            FSTUtil.rethrow(iOException);
            return null;
        }
    }

    public String toString() {
        return "FSTConfiguration{name='" + this.name + "'}";
    }

    protected static class FSTDefaultStreamCoderFactory
    implements StreamCoderFactory {
        private final FSTConfiguration fstConfiguration;
        static ThreadLocal<FSTObjectInput> input = new ThreadLocal();
        static ThreadLocal<FSTObjectOutput> output = new ThreadLocal();

        public FSTDefaultStreamCoderFactory(FSTConfiguration fSTConfiguration) {
            this.fstConfiguration = fSTConfiguration;
        }

        @Override
        public FSTEncoder createStreamEncoder() {
            return new FSTStreamEncoder(this.fstConfiguration);
        }

        @Override
        public FSTDecoder createStreamDecoder() {
            return new FSTStreamDecoder(this.fstConfiguration);
        }

        @Override
        public ThreadLocal<FSTObjectInput> getInput() {
            return input;
        }

        @Override
        public ThreadLocal<FSTObjectOutput> getOutput() {
            return output;
        }
    }

    static class FieldKey {
        Class<?> clazz;
        String fieldName;

        public FieldKey(Class<?> clazz, String string) {
            this.clazz = clazz;
            this.fieldName = string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            FieldKey fieldKey = (FieldKey)object;
            if (!this.clazz.equals(fieldKey.clazz)) {
                return false;
            }
            return this.fieldName.equals(fieldKey.fieldName);
        }

        public int hashCode() {
            int n = this.clazz.hashCode();
            n = 31 * n + this.fieldName.hashCode();
            return n;
        }
    }

    public static interface StreamCoderFactory {
        public FSTEncoder createStreamEncoder();

        public FSTDecoder createStreamDecoder();

        public ThreadLocal<FSTObjectInput> getInput();

        public ThreadLocal<FSTObjectOutput> getOutput();
    }
}

