/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.util.FSTIdentity2IdMap;
import org.nustaq.serialization.util.FSTInt2ObjectMap;
import org.nustaq.serialization.util.FSTUtil;

public final class FSTObjectRegistry {
    public static final int OBJ_DIVISOR = 16;
    public static int POS_MAP_SIZE = 1000;
    boolean disabled = false;
    FSTIdentity2IdMap objects = new FSTIdentity2IdMap(11);
    FSTInt2ObjectMap<Object> idToObject;
    Object[] reuseMap = new Object[POS_MAP_SIZE];
    private int highestPos = -1;

    public FSTObjectRegistry(FSTConfiguration fSTConfiguration) {
        this.disabled = !fSTConfiguration.isShareReferences();
        this.idToObject = fSTConfiguration.intToObjectMapFactory.createMap(11);
    }

    public void clearForRead(FSTConfiguration fSTConfiguration) {
        boolean bl = this.disabled = !fSTConfiguration.isShareReferences();
        if (!this.disabled) {
            this.idToObject.clear();
            if (this.highestPos > -1) {
                FSTUtil.clear(this.reuseMap, this.highestPos + 1);
            }
        }
        this.highestPos = -1;
    }

    public void clearForWrite(FSTConfiguration fSTConfiguration) {
        boolean bl = this.disabled = !fSTConfiguration.isShareReferences();
        if (!this.disabled) {
            if (this.objects.size() > 0 && this.objects.keysLength() > 6 * this.objects.size()) {
                this.objects = new FSTIdentity2IdMap(this.objects.size());
            } else {
                this.objects.clear();
            }
        }
    }

    public Object getReadRegisteredObject(int n) {
        if (this.disabled) {
            return null;
        }
        int n2 = n / 16;
        if (n2 < this.reuseMap.length) {
            if (this.reuseMap[n2] == null) {
                return null;
            }
            Object object = this.idToObject.get(n);
            if (object == null) {
                return this.reuseMap[n2];
            }
            return object;
        }
        return this.idToObject.get(n);
    }

    public void replace(Object object, Object object2, int n) {
        int n2 = n / 16;
        if (n2 < this.reuseMap.length && (this.reuseMap[n2] == object || this.reuseMap[n2] == null || this.reuseMap[n2] == object)) {
            this.reuseMap[n2] = object2;
        } else {
            this.idToObject.put(n, object2);
        }
    }

    public void registerObjectForRead(Object object, int n) {
        if (this.disabled) {
            return;
        }
        int n2 = n / 16;
        if (n2 < this.reuseMap.length) {
            int n3 = this.highestPos = n2 > this.highestPos ? n2 : this.highestPos;
            if (this.reuseMap[n2] == null) {
                this.reuseMap[n2] = object;
            } else {
                this.idToObject.put(n, object);
            }
        } else {
            this.idToObject.put(n, object);
        }
    }

    public int registerObjectForWrite(Object object, int n, FSTClazzInfo fSTClazzInfo, int[] nArray) {
        if (this.disabled) {
            return Integer.MIN_VALUE;
        }
        if (fSTClazzInfo != null && fSTClazzInfo.isFlat()) {
            return Integer.MIN_VALUE;
        }
        int n2 = this.objects.putOrGet(object, n);
        if (n2 >= 0) {
            nArray[0] = 0;
            return n2;
        }
        return Integer.MIN_VALUE;
    }

    public int getObjectSize() {
        return this.objects.size();
    }
}

